/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.communicate.client;

import com.swimap.iview.communicate.CommHandle;
import com.swimap.iview.communicate.server.CommandResult;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;

public class CommandConnector {
    private Socket socket = null;
    private String hostname = "127.0.0.1";
    private BufferedInputStream in = null;
    private BufferedOutputStream out = null;

    public CommandConnector(int n) throws Exception {
        String string = System.getProperty("USED_LOCAL_IP_ENV");
        if (null == string || string.trim().equals("")) {
            this.socket = new Socket(this.hostname, n);
            InetAddress inetAddress = this.socket.getLocalAddress();
            string = inetAddress.getHostAddress();
            System.setProperty("USED_LOCAL_IP_ENV", string);
        } else {
            InetAddress inetAddress = InetAddress.getByName(string);
            this.socket = new Socket(this.hostname, n, inetAddress, 0);
        }
        this.out = new BufferedOutputStream(this.socket.getOutputStream());
        this.in = new BufferedInputStream(this.socket.getInputStream());
    }

    public CommandConnector(String string, int n) throws Exception {
        String string2 = System.getProperty("USED_LOCAL_IP_ENV");
        if (null == string2 || string2.trim().equals("")) {
            this.socket = new Socket(string, n);
            InetAddress inetAddress = this.socket.getLocalAddress();
            string2 = inetAddress.getHostAddress();
            System.setProperty("USED_LOCAL_IP_ENV", string2);
        } else {
            InetAddress inetAddress = InetAddress.getByName(string2);
            this.socket = new Socket(string, n, inetAddress, 0);
        }
        this.out = new BufferedOutputStream(this.socket.getOutputStream());
        this.in = new BufferedInputStream(this.socket.getInputStream());
        this.hostname = string;
    }

    public CommandResult sendCommand(String string) {
        if (string != null && this.out != null) {
            try {
                byte[] byArray = string.getBytes();
                this.out.write(byArray);
                this.out.flush();
            }
            catch (Exception exception) {
                CommHandle.logException(exception);
            }
        }
        return null;
    }

    public void close() {
        try {
            this.in.close();
            this.in = null;
        }
        catch (IOException iOException) {
            CommHandle.logException(iOException);
        }
        try {
            this.out.close();
            this.out = null;
        }
        catch (IOException iOException) {
            CommHandle.logException(iOException);
        }
        try {
            this.socket.close();
            this.socket = null;
        }
        catch (IOException iOException) {
            CommHandle.logException(iOException);
        }
    }

    public void test() {
        CommandResult commandResult = this.sendCommand("This is a \u6d4b\u8bd5");
        if (commandResult != null) {
            System.out.println("\u7ed3\u679c\uff1d" + commandResult.toString());
        } else {
            System.out.println("\u53d1\u9001\u5931\u8d25");
        }
    }
}

