/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.communicate;

import com.swimap.iview.communicate.CommHandle;
import com.swimap.iview.util.CommonUtil;
import com.swimap.iview.util.adapter.ResourceMngHelper;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.KeyStore;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;

public class SSLConnector {
    private String sslCert = null;
    private String ksCnts = null;
    private SSLSocketFactory socketFactory = null;

    public SSLConnector() {
        this(null, null);
    }

    public SSLConnector(String string, String string2) {
        this.sslCert = string;
        this.ksCnts = string2;
    }

    public void setSSLCert(String string) {
        this.sslCert = string;
    }

    public String getSSLCert() {
        return this.sslCert;
    }

    public void setKeyStorePassword(String string) {
        this.ksCnts = string;
    }

    public String getKeyStorePassword() {
        return this.ksCnts;
    }

    public void setSocketFactory(SSLSocketFactory sSLSocketFactory) {
        this.socketFactory = sSLSocketFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Socket createSSLSocket(String string, int n) {
        if (null != this.socketFactory) {
            CommHandle.logTrace("Creating Socket from business module Factory implemention");
            return this.bindSocketWithLocal(this.socketFactory, string, n);
        }
        if (null == this.ksCnts || null == this.sslCert) {
            CommHandle.logError("Create SSL Socket failed: ksCnts or sslCert is null.");
            return null;
        }
        CommHandle.logTrace(new StringBuffer(16).append("Create SSL Socket with ").append(string).append(":").append(n).toString());
        Socket socket = null;
        char[] cArray = null;
        InputStream inputStream = null;
        try {
            Object object;
            cArray = this.ksCnts.toCharArray();
            if (null == cArray) {
                Socket socket2 = null;
                return socket2;
            }
            KeyStore keyStore = KeyStore.getInstance("JKS");
            try {
                inputStream = new FileInputStream(CommonUtil.getAbsolutePath(this.sslCert));
            }
            catch (IOException iOException) {
                CommHandle.logTrace("Create SSL Socket failed from folder. ");
                CommHandle.logException(3, iOException);
            }
            if (inputStream == null && null != (object = ResourceMngHelper.getURLFromJar(this.sslCert))) {
                inputStream = ((URL)object).openStream();
            }
            if (inputStream != null) {
                keyStore.load(inputStream, cArray);
                object = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                ((KeyManagerFactory)object).init(keyStore, cArray);
                KeyManager[] keyManagerArray = ((KeyManagerFactory)object).getKeyManagers();
                TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance("SunX509");
                trustManagerFactory.init(keyStore);
                TrustManager[] trustManagerArray = trustManagerFactory.getTrustManagers();
                SSLContext sSLContext = SSLContext.getInstance("TLS");
                sSLContext.init(keyManagerArray, trustManagerArray, null);
                SSLSocketFactory sSLSocketFactory = sSLContext.getSocketFactory();
                socket = this.bindSocketWithLocal(sSLSocketFactory, string, n);
                if (socket != null) {
                    CommHandle.logTrace("Create SSL Socket success:" + socket.toString());
                }
            }
        }
        catch (Exception exception) {
            CommHandle.logTrace("Create SSL Socket failed. ");
            CommHandle.logException(3, exception);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    CommHandle.logTrace("IOException on closing the Stream" + iOException);
                }
            }
        }
        return socket;
    }

    private Socket bindSocketWithLocal(SSLSocketFactory sSLSocketFactory, String string, int n) {
        Socket socket = null;
        try {
            String string2 = System.getProperty("USED_LOCAL_IP_ENV");
            if (null == string2 || string2.trim().equals("")) {
                socket = sSLSocketFactory.createSocket(string, n);
                InetAddress inetAddress = socket.getLocalAddress();
                string2 = inetAddress.getHostAddress();
                CommHandle.logTrace("System Property USED_LOCAL_IP_ENV is set:" + string2);
                System.setProperty("USED_LOCAL_IP_ENV", string2);
            } else {
                InetAddress inetAddress = InetAddress.getByName(string2);
                socket = sSLSocketFactory.createSocket(string, n, inetAddress, 0);
            }
        }
        catch (UnknownHostException unknownHostException) {
            CommHandle.logException(unknownHostException);
            CommHandle.logError("Not able to connect to Host: " + string + " Port:" + n);
        }
        catch (IOException iOException) {
            CommHandle.logException(iOException);
            CommHandle.logError("IOError: Host " + string + " Port " + n);
        }
        return socket;
    }
}

