/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.communicate;

import com.swimap.iview.communicate.CommHandle;
import com.swimap.iview.communicate.CommStateEvent;
import java.util.Properties;

public class Reconnector {
    public static final int MAX_INTERVAL = 60;
    public static final int MAX_TIMES = 100000;
    public static final int DEFAULT_INTERVAL = 1;
    public static final int DEFAULT_TIMES = 5;
    protected int m_interval = 1;
    protected int m_maxtimes = 5;
    private static final String PARA_RECCONECT_PROPERTIES_INTERVAL = "interval";
    private static final String PARA_RECCONECT_PROPERTIES_MAXTIMES = "maxtimes";
    private static final int ONE_SECOND = 1000;

    public Reconnector(Properties properties) {
        String string;
        String string2 = properties.getProperty(PARA_RECCONECT_PROPERTIES_INTERVAL);
        if (string2 != null) {
            try {
                this.m_interval = Integer.parseInt(string2);
                this.m_interval = this.m_interval > 60 || this.m_interval < 1 ? 1 : this.m_interval;
            }
            catch (NumberFormatException numberFormatException) {
                this.m_interval = 1;
                CommHandle.logException(2, numberFormatException);
            }
        }
        if ((string = properties.getProperty(PARA_RECCONECT_PROPERTIES_MAXTIMES)) != null) {
            try {
                this.m_maxtimes = Integer.parseInt(string);
                this.m_maxtimes = this.m_maxtimes > 100000 || this.m_maxtimes < 1 ? 5 : this.m_maxtimes;
            }
            catch (NumberFormatException numberFormatException) {
                this.m_maxtimes = 5;
                CommHandle.logException(2, numberFormatException);
            }
        }
    }

    public boolean reconnect(CommHandle commHandle) {
        int n = 0;
        CommHandle.logTrace("Trying to Reconnect: Interval=" + this.m_interval + " MaxRetries=" + this.m_maxtimes);
        try {
            while (!commHandle.isClosed()) {
                commHandle.stateChanged(CommStateEvent.RECONNECT_RUN);
                ++n;
                if (commHandle.reconnect()) {
                    commHandle.stateChanged(CommStateEvent.RECONNECT_SUCCESS);
                    return true;
                }
                commHandle.stateChanged(CommStateEvent.RECONNECT_FAILED);
                if (!this.isContinue(n)) {
                    commHandle.stateChanged(CommStateEvent.RECONNECT_ABORT);
                    return false;
                }
                int n2 = n * this.m_interval;
                if (n2 > 60) {
                    n2 = 60;
                }
                commHandle.stateChanged(CommStateEvent.RECONNECT_WAIT);
                Thread.sleep(n2 * 1000);
            }
        }
        catch (InterruptedException interruptedException) {
            CommHandle.logException(4, interruptedException);
        }
        commHandle.stateChanged(CommStateEvent.RECONNECT_EXIT);
        CommHandle.logTrace("Unable to Reconnect");
        return false;
    }

    protected boolean isContinue(int n) {
        return n < this.m_maxtimes;
    }
}

