/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.communicate;

import com.swimap.iview.communicate.AppAidedMsgListener;
import com.swimap.iview.communicate.AppAidedMsgSyncReceiver;
import com.swimap.iview.communicate.CommHandle;
import com.swimap.iview.communicate.CommTimeoutChecker;
import com.swimap.iview.communicate.DataAccepter;
import com.swimap.iview.communicate.MSGListener;
import com.swimap.iview.communicate.MSGPacketExt;
import com.swimap.iview.communicate.MSGSyncReceiver;
import com.swimap.iview.util.log.IviewLogger;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

final class MsgDispatcher
extends Thread {
    private static IviewLogger logger = IviewLogger.getLogger(CommHandle.class, "IVIEW");
    private volatile boolean running = true;
    private CommHandle m_Handle = null;
    private DataAccepter accepter = null;
    private CommTimeoutChecker checker = null;
    private Hashtable listenTable = new Hashtable(11);
    private Hashtable receivers = new Hashtable(11);

    MsgDispatcher(CommHandle commHandle, DataAccepter dataAccepter) {
        CommHandle.logTrace("Init MsgDispatcher.");
        this.m_Handle = commHandle;
        this.accepter = dataAccepter;
        if (null != this.checker) {
            this.checker.close();
            this.checker = null;
        }
        this.checker = new CommTimeoutChecker(this);
        this.checker.setName("CommTimeoutChecker-" + CommHandle.instanceCount);
        this.checker.start();
    }

    public void addMessageReceiver(Character c, MSGListener mSGListener, int n, int n2) {
        this.receivers.put(c, mSGListener);
        if (n2 >= 1000) {
            this.checker.addItem(c, n, n2);
        } else {
            this.checker.addItem(c, n, this.m_Handle.timeout);
        }
    }

    public void addMessageListener(int n, MSGListener mSGListener) {
        Integer n2 = n;
        Vector<MSGListener> vector = (Vector<MSGListener>)this.listenTable.get(n2);
        logger.debug(" Adding MSGListener cmdCode " + n + " listener " + mSGListener);
        if (null == vector) {
            vector = new Vector<MSGListener>(10);
            vector.addElement(mSGListener);
            this.listenTable.put(n2, vector);
        } else if (!vector.contains(mSGListener)) {
            vector.addElement(mSGListener);
        }
        logger.debug(this.getName() + " Current listeners are " + this.listenTable.entrySet());
    }

    public void removeMessageListener(int n, MSGListener mSGListener) {
        logger.debug(" Removing MSGListener cmdCode " + n + " listener " + mSGListener);
        Integer n2 = n;
        Vector vector = (Vector)this.listenTable.get(n2);
        if (null != vector) {
            vector.removeElement(mSGListener);
            if (vector.size() == 0) {
                this.listenTable.remove(n2);
            }
        }
        logger.debug(this.getName() + " Current listeners are " + this.listenTable.entrySet());
    }

    public void removeMessageListener(int n) {
        logger.debug(" Removing MSGListener cmdCode " + n);
        Integer n2 = n;
        Vector vector = (Vector)this.listenTable.get(n2);
        if (null != vector) {
            vector.removeAllElements();
            this.listenTable.remove(n2);
        }
        logger.debug(" Current listeners are " + this.listenTable.entrySet());
    }

    public void removeReceiver(Character c) {
        this.receivers.remove(c);
    }

    final void removeReceiver(MSGListener mSGListener) {
        if (null == mSGListener) {
            CommHandle.logTrace("MSGListener is null");
            return;
        }
        Enumeration enumeration = this.receivers.keys();
        Character c = null;
        while (enumeration.hasMoreElements()) {
            c = (Character)enumeration.nextElement();
            if (!this.receivers.get(c).equals(mSGListener)) continue;
            this.removeReceiver(c);
            this.removeTimeoutItem(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelReceivers() {
        CommHandle.logTrace("invoke cancel receivers!");
        Enumeration enumeration = this.receivers.keys();
        Object var2_2 = null;
        MSGListener mSGListener = null;
        while (enumeration.hasMoreElements()) {
            MSGListener mSGListener2;
            var2_2 = enumeration.nextElement();
            mSGListener = (MSGListener)this.receivers.get(var2_2);
            if (mSGListener instanceof MSGSyncReceiver) {
                ((MSGSyncReceiver)mSGListener).setFlag(-3);
                mSGListener2 = mSGListener;
                synchronized (mSGListener2) {
                    mSGListener.notifyAll();
                }
                this.receivers.remove(var2_2);
                continue;
            }
            if (!(mSGListener instanceof AppAidedMsgSyncReceiver)) continue;
            ((AppAidedMsgSyncReceiver)mSGListener).setFlag(-3);
            mSGListener2 = mSGListener;
            synchronized (mSGListener2) {
                mSGListener.notifyAll();
            }
            this.receivers.remove(var2_2);
        }
        if (null != this.m_Handle && this.m_Handle.isClosed()) {
            this.receivers.clear();
        }
    }

    final void removeTimeoutItem(Character c) {
        this.checker.removeItem(c);
    }

    final void refreshTimeoutValue(int n, Character c) {
        this.checker.refreshTimeoutValue(n, c);
    }

    final boolean checkTimeout(Character c) {
        MSGListener mSGListener = null;
        mSGListener = (MSGListener)this.receivers.get(c);
        if (mSGListener instanceof AppAidedMsgListener) {
            ((AppAidedMsgListener)mSGListener).addTimeoutPacket();
            return false;
        }
        return true;
    }

    @Override
    public void run() {
        MSGPacketExt mSGPacketExt = null;
        block5: while (this.running) {
            mSGPacketExt = this.accepter.getMessage();
            if (null == mSGPacketExt) {
                CommHandle.logTrace("MsgDispatcher(): MSGPacketExt is NULL");
                continue;
            }
            switch (mSGPacketExt.mheader.msgType) {
                case 1: 
                case 6: 
                case 9: 
                case 21: {
                    this.m_Handle.refresh();
                    CommHandle.logTrace(this.getName() + "dispatchListener() in: ", mSGPacketExt, 1);
                    this.dispatchListener(mSGPacketExt);
                    CommHandle.logTrace("dispatchListener() out: ", mSGPacketExt, 1);
                    continue block5;
                }
                case 2: 
                case 3: 
                case 7: 
                case 17: 
                case 27: 
                case 28: {
                    this.m_Handle.refresh();
                    CommHandle.logTrace(1, "dispatchReceiver() in: ", mSGPacketExt);
                    this.dispatchReceiver(mSGPacketExt);
                    CommHandle.logTrace(1, "dispatchReceiver() out: ", mSGPacketExt);
                    continue block5;
                }
                case 5: {
                    if (mSGPacketExt.mheader.cmdCode != 0) continue block5;
                    this.m_Handle.refresh();
                    continue block5;
                }
            }
        }
        this.m_Handle = null;
        this.accepter = null;
        this.checker = null;
        CommHandle.logTrace("MsgDispatcher exited.");
    }

    private void dispatchListener(MSGPacketExt mSGPacketExt) {
        Integer n = mSGPacketExt.mheader.cmdCode;
        Vector vector = (Vector)this.listenTable.get(n);
        if (null == vector || vector.isEmpty()) {
            CommHandle.logTrace(this.getName() + "listeners are null. code=" + n);
        } else {
            try {
                Object[] objectArray = vector.toArray();
                MSGListener mSGListener = null;
                int n2 = 0;
                for (n2 = 0; n2 < objectArray.length; ++n2) {
                    mSGListener = (MSGListener)objectArray[n2];
                    mSGListener.receiveMessage(mSGPacketExt);
                }
            }
            catch (Exception exception) {
                CommHandle.logException(exception);
            }
        }
    }

    private void dispatchReceiver(MSGPacketExt mSGPacketExt) {
        char c = mSGPacketExt.mheader.cmdHandle;
        Character c2 = Character.valueOf(c);
        MSGListener mSGListener = (MSGListener)this.receivers.get(c2);
        if (null != mSGListener) {
            if (mSGListener instanceof AppAidedMsgListener) {
                if (mSGListener.receiveMessage(mSGPacketExt)) {
                    this.receivers.remove(c2);
                    this.checker.removeItem(c2);
                }
            } else {
                int n = this.checker.removeItem(c2);
                CommHandle.logTrace(0, "invoke MSGListener's receiveMessage() method.", mSGPacketExt);
                if (mSGListener.receiveMessage(mSGPacketExt)) {
                    this.receivers.remove(c2);
                } else if (n > 0) {
                    this.checker.addItem(c2, mSGPacketExt.mheader.cmdCode, n);
                }
            }
        } else {
            CommHandle.logTrace("The receiver had been removed, cmdHandle=" + c);
        }
    }

    final void timeout(int n, Character c) {
        MSGListener mSGListener = null;
        mSGListener = (MSGListener)this.receivers.remove(c);
        if (null != mSGListener) {
            CommHandle.logTrace(1, "MsgDispatcher timeout in: ", n, c.charValue());
            mSGListener.timeout(n, c);
            CommHandle.logTrace(1, "MsgDispatcher timeout out: ", n, c.charValue());
        }
    }

    public void cancelListeners() {
        CommHandle.logTrace("invoke cancel listeners");
        this.listenTable.clear();
    }

    public void close() {
        CommHandle.logTrace("Close MsgDispatcher.");
        this.running = false;
        if (null != this.checker) {
            this.checker.close();
        }
        this.cancelReceivers();
        this.cancelListeners();
    }
}

