/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.communicate;

import com.swimap.iview.communicate.CommUtil;
import com.swimap.iview.communicate.MSGListener;
import com.swimap.iview.communicate.MSGPacketExt;
import java.util.Vector;

public class MSGSyncReceiver
implements MSGListener {
    private Vector m_packets = new Vector(10);
    private int flag = 1;

    @Override
    public final boolean receiveMessage(MSGPacketExt mSGPacketExt) {
        if (!this.isValidPacket(mSGPacketExt)) {
            return true;
        }
        this.m_packets.addElement(mSGPacketExt);
        if (this.isFinish(mSGPacketExt)) {
            this.notifyReceiver(0);
            return true;
        }
        return false;
    }

    private boolean isFinish(MSGPacketExt mSGPacketExt) {
        return (mSGPacketExt.mheader.commFlag & 0x80) == 0;
    }

    @Override
    public final void timeout(int n, Character c) {
        this.notifyReceiver(-1);
    }

    public final MSGPacketExt[] getResults() {
        int n = this.m_packets.size();
        if (n > 0) {
            MSGPacketExt[] mSGPacketExtArray = new MSGPacketExt[n];
            this.m_packets.toArray(mSGPacketExtArray);
            return mSGPacketExtArray;
        }
        return null;
    }

    public final MSGPacketExt getResult() {
        if (this.m_packets.size() > 0) {
            return (MSGPacketExt)this.m_packets.elementAt(0);
        }
        return null;
    }

    public void setFlag(int n) {
        this.flag = n;
    }

    public int getFlag() {
        return this.flag;
    }

    public void reset() {
        this.notifyReceiver(1);
        this.m_packets.clear();
    }

    final void cancel() {
        if (this.flag != 2) {
            return;
        }
        this.notifyReceiver(3);
        this.m_packets.clear();
    }

    private synchronized void notifyReceiver(int n) {
        this.flag = n;
        this.notifyAll();
    }

    private boolean isValidPacket(MSGPacketExt mSGPacketExt) {
        int n = CommUtil.checkValidPacket(mSGPacketExt);
        if (n == Integer.MIN_VALUE) {
            return true;
        }
        this.notifyReceiver(n);
        return false;
    }
}

