/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.communicate;

import com.swimap.iview.communicate.CommHandle;
import com.swimap.iview.communicate.CommUtil;
import com.swimap.iview.communicate.MSGListener;
import com.swimap.iview.communicate.MSGPacketExt;
import java.util.ArrayList;

public abstract class MSGReceiver
extends Thread
implements MSGListener {
    private ArrayList buf = new ArrayList(10);
    private volatile boolean running = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean receiveMessage(MSGPacketExt mSGPacketExt) {
        boolean bl = true;
        if (mSGPacketExt != null && this.running) {
            CommHandle.logTrace(0, "MSGReceiver.receiveMessage", mSGPacketExt);
            if (this.isValidPacket(mSGPacketExt) || this.isDispatchInvalidPacket()) {
                ArrayList arrayList = this.buf;
                synchronized (arrayList) {
                    this.buf.add(mSGPacketExt);
                    this.buf.notifyAll();
                }
                bl = this.isFinish(mSGPacketExt);
            } else {
                bl = false;
            }
        } else {
            CommHandle.logTrace(1, "MSGReceiver.receiveMessage, msg or buf is null");
        }
        return bl;
    }

    protected boolean isFinish(MSGPacketExt mSGPacketExt) {
        return (mSGPacketExt.mheader.commFlag & 0x80) == 0;
    }

    public MSGReceiver() {
        String string = this.getClass().getSimpleName();
        if (string == null || string.length() == 0) {
            this.setName("MSGReceiver " + this.getName());
        } else {
            this.setName(string + ' ' + this.getName());
        }
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        try {
            while (this.running) {
                MSGPacketExt mSGPacketExt = null;
                ArrayList arrayList = this.buf;
                synchronized (arrayList) {
                    while (this.buf.isEmpty()) {
                        if (!this.running) {
                            throw new InterruptedException("Interrupting the receiver thread");
                        }
                        this.buf.wait();
                    }
                    mSGPacketExt = (MSGPacketExt)this.buf.remove(0);
                }
                CommHandle.logTrace(0, "MSGReceiver processMessage in: ", mSGPacketExt);
                try {
                    this.processMessage(mSGPacketExt);
                }
                catch (Exception exception) {
                    CommHandle.logTrace("Exception during processMessage(msg)");
                    CommHandle.logException(exception);
                }
                CommHandle.logTrace(0, "MSGReceiver processMessage out:", mSGPacketExt);
            }
        }
        catch (InterruptedException interruptedException) {
            CommHandle.logTrace(this.getClass().getName() + " is interrupted.");
        }
        this.buf.clear();
        this.buf = null;
    }

    public final void close() {
        this.running = false;
        this.interrupt();
        CommHandle.logTrace("MSGReceiver thread closed: " + this);
    }

    private boolean isValidPacket(MSGPacketExt mSGPacketExt) {
        int n = CommUtil.checkValidPacket(mSGPacketExt);
        return n == Integer.MIN_VALUE;
    }

    protected abstract void processMessage(MSGPacketExt var1);

    protected boolean isDispatchInvalidPacket() {
        return false;
    }
}

