/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.communicate;

import com.swimap.iview.communicate.MSGHead;
import com.swimap.iview.communicate.MSGPacket;

public class MSGPacketExt {
    public MSGHead mheader;
    public int dataLength;
    private byte[] data;
    public static final int MAX_CONTENT_LENGTH = 65510;
    public static final int EXT_HEAD_LENGTH = 2;
    public static final int MAX_DATA_LENGTH = 4127128;

    public MSGPacketExt() {
        this.mheader = new MSGHead();
        this.dataLength = 0;
    }

    public MSGPacketExt(MSGPacket mSGPacket) {
        this.mheader = mSGPacket.getMSGHead();
        this.dataLength = this.mheader.contentLength;
        this.data = mSGPacket.frameContent;
    }

    public MSGPacketExt(MSGPacket[] mSGPacketArray) {
        if (mSGPacketArray == null || mSGPacketArray.length == 0) {
            throw new IllegalArgumentException("packets is null or packets.length = 0");
        }
        this.mheader = mSGPacketArray[0].getMSGHead();
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < mSGPacketArray.length; ++i) {
            n2 = mSGPacketArray[i].getMSGHead().contentLength;
            this.dataLength += n2;
            System.arraycopy(mSGPacketArray[i].frameContent, 0, this.data, n, n2);
            n += n2;
        }
    }

    public MSGPacketExt(MSGHead mSGHead, byte[] byArray) {
        this(mSGHead, byArray, byArray != null ? byArray.length : 0);
    }

    public MSGPacketExt(MSGHead mSGHead, byte[] byArray, int n) {
        if (mSGHead == null) {
            throw new IllegalArgumentException("MSGHead is null.");
        }
        this.mheader = mSGHead;
        if (byArray != null && n > 0) {
            int n2;
            this.mheader.contentLength = n2 = n > byArray.length ? byArray.length : n;
            this.data = new byte[n2];
            this.dataLength = n2;
            System.arraycopy(byArray, 0, this.data, 0, n2);
        } else {
            this.mheader.contentLength = 0;
            this.data = null;
            this.dataLength = 0;
        }
    }

    public byte[] toByte() {
        byte[] byArray = new byte[this.mheader.contentLength + 43];
        System.arraycopy(this.mheader.toByte(), 0, byArray, 0, 43);
        if (this.data != null && this.data.length > 0) {
            System.arraycopy(this.data, 0, byArray, 43, this.data.length);
        }
        return byArray;
    }

    public MSGPacket[] parseMSGPacketExt() {
        return null;
    }

    public byte[] getData() {
        return this.data;
    }

    public void clearData() {
        this.data = null;
        this.dataLength = 0;
    }

    public int length() {
        if (this.data != null) {
            return 43 + this.data.length;
        }
        return 43;
    }

    public int getCmdCode() {
        if (this.mheader == null) {
            return 0;
        }
        return this.mheader.cmdCode;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(16);
        stringBuffer.append(this.mheader.toString());
        stringBuffer.append("dataLength=");
        stringBuffer.append(this.dataLength);
        return stringBuffer.toString();
    }
}

