/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.communicate;

import com.swimap.iview.communicate.CommUtil;
import java.util.Arrays;

public class MSGHead {
    public static final int HEAD_LEN = 43;
    public byte protocolVer = (byte)10;
    public int senderProcIP = 0;
    public char senderDeskID = '\u0000';
    public char receiverDeskID = '\u0000';
    public char senderProcHandle = '\u0000';
    public char receiverProcHandle = '\u0000';
    public char senderProcID = '\u0000';
    public char receiverProcID = '\u0000';
    public int cmdCode = 0;
    public byte msgType = 0;
    public char errCode = '\u0000';
    public byte commFlag = 0;
    public byte[] reserved = new byte[8];
    public char senderCmdHandle = '\u0000';
    public char cmdHandle = '\u0000';
    public int contentLength = 0;
    public byte senderModule = 0;
    public byte receiverModule = 0;
    static final int PROTOCOL_COMMON = 10;
    static final int PROTOCOL_EXT = 11;
    static final int RESERVED_LEN = 8;
    static final int MODULE_LEN = 2;
    static final String LINE_SEPARATOR = System.getProperty("line.separator");

    public byte[] toByte() {
        byte[] byArray = new byte[43];
        byArray[0] = this.protocolVer;
        byte[] byArray2 = CommUtil.intToBytes(this.senderProcIP);
        byArray[1] = byArray2[0];
        byArray[2] = byArray2[1];
        byArray[3] = byArray2[2];
        byArray[4] = byArray2[3];
        byArray2 = CommUtil.charToBytes(this.senderDeskID);
        byArray[5] = byArray2[0];
        byArray[6] = byArray2[1];
        byArray2 = CommUtil.charToBytes(this.receiverDeskID);
        byArray[7] = byArray2[0];
        byArray[8] = byArray2[1];
        byArray2 = CommUtil.charToBytes(this.senderProcHandle);
        byArray[9] = byArray2[0];
        byArray[10] = byArray2[1];
        byArray2 = CommUtil.charToBytes(this.receiverProcHandle);
        byArray[11] = byArray2[0];
        byArray[12] = byArray2[1];
        byArray2 = CommUtil.charToBytes(this.senderProcID);
        byArray[13] = byArray2[0];
        byArray[14] = byArray2[1];
        byArray2 = CommUtil.charToBytes(this.receiverProcID);
        byArray[15] = byArray2[0];
        byArray[16] = byArray2[1];
        byArray2 = CommUtil.intToBytes(this.cmdCode);
        byArray[17] = byArray2[0];
        byArray[18] = byArray2[1];
        byArray[19] = byArray2[2];
        byArray[20] = byArray2[3];
        byArray[21] = this.msgType;
        byArray2 = CommUtil.charToBytes(this.errCode);
        byArray[22] = byArray2[0];
        byArray[23] = byArray2[1];
        byArray[24] = this.commFlag;
        System.arraycopy(this.reserved, 0, byArray, 25, 8);
        byArray2 = CommUtil.charToBytes(this.senderCmdHandle);
        byArray[33] = byArray2[0];
        byArray[34] = byArray2[1];
        byArray2 = CommUtil.charToBytes(this.cmdHandle);
        byArray[35] = byArray2[0];
        byArray[36] = byArray2[1];
        byArray2 = CommUtil.intToBytes(this.contentLength + 2);
        byArray[37] = byArray2[0];
        byArray[38] = byArray2[1];
        byArray[39] = byArray2[2];
        byArray[40] = byArray2[3];
        byArray[41] = this.senderModule;
        byArray[42] = this.receiverModule;
        return byArray;
    }

    public void fromByte(byte[] byArray) throws Exception {
        if (byArray.length < 43) {
            throw new Exception("invalid length of MSG:" + Arrays.toString(byArray));
        }
        this.protocolVer = byArray[0];
        byte[] byArray2 = new byte[4];
        System.arraycopy(byArray, 1, byArray2, 0, 4);
        this.senderProcIP = CommUtil.bytesToInt(byArray2);
        this.senderDeskID = CommUtil.bytesToChar(byArray[5], byArray[6]);
        this.receiverDeskID = CommUtil.bytesToChar(byArray[7], byArray[8]);
        this.senderProcHandle = CommUtil.bytesToChar(byArray[9], byArray[10]);
        this.receiverProcHandle = CommUtil.bytesToChar(byArray[11], byArray[12]);
        this.senderProcID = CommUtil.bytesToChar(byArray[13], byArray[14]);
        this.receiverProcID = CommUtil.bytesToChar(byArray[15], byArray[16]);
        System.arraycopy(byArray, 17, byArray2, 0, 4);
        this.cmdCode = CommUtil.bytesToInt(byArray2);
        this.msgType = byArray[21];
        this.errCode = CommUtil.bytesToChar(byArray[22], byArray[23]);
        this.commFlag = byArray[24];
        System.arraycopy(byArray, 25, this.reserved, 0, 8);
        this.senderCmdHandle = CommUtil.bytesToChar(byArray[33], byArray[34]);
        this.cmdHandle = CommUtil.bytesToChar(byArray[35], byArray[36]);
        System.arraycopy(byArray, 37, byArray2, 0, 4);
        this.contentLength = CommUtil.bytesToInt(byArray2) - 2;
        this.senderModule = byArray[41];
        this.receiverModule = byArray[42];
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(16);
        stringBuffer.append("protocolVer=");
        stringBuffer.append(this.protocolVer).append(LINE_SEPARATOR);
        stringBuffer.append("senderProcIP=");
        stringBuffer.append(this.senderProcIP).append(LINE_SEPARATOR);
        stringBuffer.append("senderDeskID=");
        stringBuffer.append((int)this.senderDeskID).append(LINE_SEPARATOR);
        stringBuffer.append("receiverDeskID=");
        stringBuffer.append((int)this.receiverDeskID).append(LINE_SEPARATOR);
        stringBuffer.append("senderProcHandle=");
        stringBuffer.append((int)this.senderProcHandle).append(LINE_SEPARATOR);
        stringBuffer.append("receiverProcHandle=");
        stringBuffer.append((int)this.receiverProcHandle).append(LINE_SEPARATOR);
        stringBuffer.append("senderProcID=");
        stringBuffer.append((int)this.senderProcID).append(LINE_SEPARATOR);
        stringBuffer.append("receiverProcID=");
        stringBuffer.append((int)this.receiverProcID).append(LINE_SEPARATOR);
        stringBuffer.append("cmdCode=");
        stringBuffer.append(this.cmdCode).append(LINE_SEPARATOR);
        stringBuffer.append("msgType=");
        stringBuffer.append(this.msgType).append(LINE_SEPARATOR);
        stringBuffer.append("reserved=");
        for (int i = 0; i < this.reserved.length; ++i) {
            stringBuffer.append(this.reserved[i]).append(' ');
        }
        stringBuffer.append(LINE_SEPARATOR);
        stringBuffer.append("senderCmdHandle=");
        stringBuffer.append((int)this.senderCmdHandle).append(LINE_SEPARATOR);
        stringBuffer.append("cmdHandle=");
        stringBuffer.append((int)this.cmdHandle).append(LINE_SEPARATOR);
        stringBuffer.append("contentLength=");
        stringBuffer.append(this.contentLength).append(LINE_SEPARATOR);
        stringBuffer.append("senderModule=");
        stringBuffer.append(this.senderModule).append(LINE_SEPARATOR);
        stringBuffer.append("receiverModule=");
        stringBuffer.append(this.receiverModule).append(LINE_SEPARATOR);
        return stringBuffer.toString();
    }
}

