/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.communicate;

import com.swimap.iview.communicate.ICompressStrategy;
import com.swimap.iview.util.log.IviewLogger;
import java.util.Arrays;
import java.util.zip.Inflater;

public class DefaultCompressStrategy
implements ICompressStrategy {
    private static IviewLogger logger = IviewLogger.getLogger(DefaultCompressStrategy.class, "IVIEW");

    @Override
    public byte[] compress(byte[] byArray) {
        return byArray;
    }

    @Override
    public boolean compressCondition(byte[] byArray) {
        return false;
    }

    @Override
    public byte[] decompress(byte[] byArray) {
        byte[] byArray2 = new byte[]{};
        if (null != byArray) {
            int n = byArray.length * 20;
            Inflater inflater = null;
            try {
                while (true) {
                    inflater = new Inflater();
                    inflater.setInput(byArray);
                    byArray2 = new byte[n];
                    int n2 = inflater.inflate(byArray2);
                    logger.trace("Actual number of bytes uncompressed : " + n2);
                    boolean bl = inflater.finished();
                    if (bl) {
                        inflater.end();
                        byte[] byArray3 = Arrays.copyOf(byArray2, n2);
                        return byArray3;
                    }
                    n <<= 1;
                }
            }
            catch (Exception exception) {
                logger.error(exception.toString(), exception);
                byArray2 = new byte[]{};
            }
        }
        return byArray2;
    }

    @Override
    public boolean decompressCondition(byte[] byArray) {
        if (byArray.length < 24) {
            return false;
        }
        byte by = byArray[24];
        return (by & 8) == 8;
    }
}

