/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.communicate;

import com.swimap.iview.communicate.CommHandle;
import com.swimap.iview.communicate.CommManageService;
import com.swimap.iview.communicate.CommRegisterException;
import com.swimap.iview.communicate.CommService;
import com.swimap.iview.communicate.MSGListener;
import com.swimap.iview.communicate.MSGPacketExt;
import com.swimap.iview.communicate.PermanentReconnector;
import com.swimap.iview.communicate.Reconnector;
import com.swimap.iview.communicate.SSLConnector;
import com.swimap.iview.util.ReflectionUtilities;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Properties;

public class Communicator
implements CommManageService,
MSGListener {
    private static final int SIZE = 10;
    private ArrayList arrays = new ArrayList(10);
    private CommHandle comm = null;
    private String proxyServer = null;
    private int proxyPort = -1;
    private String mdpServer = null;
    private int mdpPort = -1;
    private char proccessID = '\u0000';
    private char deskID = '\u0000';
    private static final int MDP_PARAM_NUM = 2;
    private static final String PARAM_IP_NAME = "proxyip";
    private static final String PARAM_PORT_NAME = "proxyport";
    private static final int ONE_SECOND = 1000;
    private static final int DEFAULT_TIMEOUT = 9;
    private static final int MAX_TIMEOUT = 2147483;
    private int timeOutInSec = 9000;
    private SSLConnector sslConnect = null;
    private Object[] securityInfo = null;
    private String commConfigFile = "conf/mainfrm/communicate";
    private static final String DESC_PROCID = "ProcID";
    private static final String PARA_PROCID_DEFAULT = "default";
    private static final String DESC_DEBUG = "Debug";
    private static final String PARA_DEBUG_ENABLE = "DebugEnable";
    private static final String PARA_DEBUG_LEVEL = "DebugLevel";
    private static final String PARA_DEBUG_NO_TRACE_CMD = "NoTraceCommands";
    private static final String DESC_RECCONECT = "Reconnect";
    private static final String PARA_RECCONECT_LIMITED = "Limited";
    private static final String PARA_RECCONECT_TIMEOUT = "timeOut";
    private static final String DESC_RECCONECT_PROPERTIES = "Properties";
    static final String PARA_RECCONECT_PROPERTIES_INTERVAL = "interval";
    static final String PARA_RECCONECT_PROPERTIES_MAXTIMES = "maxtimes";
    private static final String DESC_SEND = "Send";
    private static final String PARA_SEND_TIMEOUT = "timeOut";

    public void initialize() {
        this.readConfig(this.commConfigFile);
    }

    private void readConfig(String string) {
        Object object;
        Object object2 = ReflectionUtilities.callStaticMethod("com.swimap.iview.commstyle.commini.CommStyleManager", "getInstance", null, null);
        if (null == object2) {
            CommHandle.logTrace("CommStyleManager is not selected. Please set the default values using API.");
            return;
        }
        Object object3 = ReflectionUtilities.callTheMethod(object2, "getCommonStyleFile", new Class[]{String.class}, new Object[]{string});
        if (object3 != null && (object = ReflectionUtilities.callTheMethod(object3, "getAreaDescContainer", new Class[]{Integer.TYPE}, new Object[]{0})) != null) {
            this.readAndSetAreaDesc(object);
        }
    }

    private void readAndSetAreaDesc(Object object) {
        Object object2;
        Object object3 = ReflectionUtilities.callTheMethod(object, "getDescContainer", new Class[]{String.class}, new Object[]{DESC_PROCID});
        if (null != object3 && null != (object2 = (String)ReflectionUtilities.callTheMethod(object3, "getParasItemValue", new Class[]{String.class}, new Object[]{PARA_PROCID_DEFAULT}))) {
            this.proccessID = (char)Integer.decode((String)object2).intValue();
        }
        if ((object2 = ReflectionUtilities.callTheMethod(object, "getDescContainer", new Class[]{String.class}, new Object[]{DESC_DEBUG})) != null) {
            this.readDebugInfo(object2);
        }
        if ((object2 = ReflectionUtilities.callTheMethod(object, "getDescContainer", new Class[]{String.class}, new Object[]{DESC_RECCONECT})) != null) {
            this.readReconnect(object2);
        }
        if ((object2 = ReflectionUtilities.callTheMethod(object, "getDescContainer", new Class[]{String.class}, new Object[]{DESC_SEND})) != null) {
            this.readAndSetTimeout(object2);
        }
    }

    private void readDebugInfo(Object object) {
        Object object2;
        String string = (String)ReflectionUtilities.callTheMethod(object, "getParasItemValue", new Class[]{String.class}, new Object[]{PARA_DEBUG_ENABLE});
        CommHandle.debug = "true".equalsIgnoreCase(string);
        String string2 = (String)ReflectionUtilities.callTheMethod(object, "getParasItemValue", new Class[]{String.class}, new Object[]{PARA_DEBUG_LEVEL});
        CommHandle.setDebugLevel(string2);
        Object object3 = ReflectionUtilities.callTheMethod(object, "getParasItem", new Class[]{String.class}, new Object[]{PARA_DEBUG_NO_TRACE_CMD});
        if (object3 != null && null != (object2 = ReflectionUtilities.callTheMethod(object3, "getVALUE", null, null))) {
            this.setTraceCommands(object2);
        }
    }

    private void setTraceCommands(Object object) {
        int n = 0;
        Object[] objectArray = (Object[])object;
        String string = null;
        for (int i = 0; i < objectArray.length; ++i) {
            string = (String)ReflectionUtilities.callTheMethod(objectArray[i], "getValue", null, null);
            if (string == null || string.trim().length() <= 0) continue;
            ++n;
        }
        if (n > 0) {
            int[] nArray = new int[n];
            int n2 = 0;
            String string2 = null;
            for (int i = 0; i < objectArray.length; ++i) {
                string2 = (String)ReflectionUtilities.callTheMethod(objectArray[i], "getValue", null, null);
                if (string2 != null && string2.trim().length() > 0) {
                    nArray[n2] = Integer.decode(string2.trim());
                    ++n2;
                }
                if (n2 >= n) break;
            }
            CommHandle.setNoTraceCommands(nArray);
        }
    }

    private void readReconnect(Object object) {
        String string = (String)ReflectionUtilities.callTheMethod(object, "getParasItemValue", new Class[]{String.class}, new Object[]{PARA_RECCONECT_LIMITED});
        boolean bl = "true".equalsIgnoreCase(string);
        String string2 = (String)ReflectionUtilities.callTheMethod(object, "getParasItemValue", new Class[]{String.class}, new Object[]{"timeOut"});
        if (null != string2) {
            int n = Integer.parseInt(string2);
            CommHandle.setShakeHandTimeout(n);
            CommHandle.logTrace("handshake timeout(s)=" + n);
        }
        this.readAndSetReconnector(object, bl);
    }

    private void readAndSetReconnector(Object object, boolean bl) {
        Object object2 = ReflectionUtilities.callTheMethod(object, "getDescContainer", new Class[]{String.class}, new Object[]{DESC_RECCONECT_PROPERTIES});
        Properties properties = new Properties();
        if (object2 != null) {
            int n = (Integer)ReflectionUtilities.callTheMethod(object2, "getParasItemCount", null, null);
            Object object3 = null;
            for (int i = n - 1; i >= 0; --i) {
                object3 = ReflectionUtilities.callTheMethod(object2, "getParasItem", new Class[]{Integer.TYPE}, new Object[]{i});
                if (null == object3) continue;
                String string = (String)ReflectionUtilities.callTheMethod(object3, "getName", null, null);
                String string2 = (String)ReflectionUtilities.callTheMethod(object3, "getValue", null, null);
                properties.setProperty(string, string2);
            }
        }
        if (bl) {
            CommHandle.setReconnector(new Reconnector(properties));
        } else {
            CommHandle.setReconnector(new PermanentReconnector(properties));
        }
    }

    private void readAndSetTimeout(Object object) {
        String string = (String)ReflectionUtilities.callTheMethod(object, "getParasItemValue", new Class[]{String.class}, new Object[]{"timeOut"});
        if (null == string) {
            return;
        }
        int n = Integer.parseInt(string);
        if (n > 0 && n <= 2147483) {
            this.timeOutInSec = n * 1000;
            CommHandle.logTrace("send timeout(s)=" + n);
        } else {
            this.timeOutInSec = 9000;
            StringBuffer stringBuffer = new StringBuffer(10);
            stringBuffer.append("Set send timeout(s) out of range{1 ~ ");
            stringBuffer.append(2147483);
            stringBuffer.append("}: ");
            stringBuffer.append(n);
            stringBuffer.append(", use default value instead: ");
            stringBuffer.append(9);
            CommHandle.logTrace(stringBuffer.toString());
            stringBuffer = null;
        }
    }

    @Override
    public CommService getCommService() {
        CommHandle.logTrace("Getting default CommService: ProcID=" + this.proccessID);
        Object[] objectArray = null;
        objectArray = null != this.mdpServer && -1 != this.mdpPort ? new Object[]{this.mdpServer, this.mdpPort} : this.securityInfo;
        return this.defaultMDPProxyConnect(objectArray);
    }

    final CommService defaultMDPProxyConnect(Object[] objectArray) {
        try {
            if (null != objectArray && objectArray.length >= 2) {
                String string = System.getProperty(PARAM_IP_NAME);
                String string2 = System.getProperty(PARAM_PORT_NAME);
                if (string != null && string2 != null) {
                    if (this.comm != null) {
                        if (this.mdpServer.equals(objectArray[0].toString()) && this.mdpPort == (Integer)objectArray[1] && this.proxyServer.equals(string) && this.proxyPort == Integer.parseInt(string2)) {
                            return this.comm;
                        }
                        this.comm.closeCommHandle();
                        this.comm = null;
                        this.deskID = '\u0000';
                    }
                    this.connectProxy(objectArray, string, string2);
                } else {
                    if (this.comm != null) {
                        if (this.mdpServer.equals(objectArray[0].toString()) && this.mdpPort == (Integer)objectArray[1]) {
                            return this.comm;
                        }
                        this.comm.closeCommHandle();
                        this.comm = null;
                        this.deskID = '\u0000';
                    }
                    this.connectMDP(objectArray);
                }
            }
        }
        catch (Exception exception) {
            CommHandle.logException(exception);
            this.comm = null;
        }
        CommHandle.logTrace("Get default CommService Success: ProcID=" + this.proccessID);
        return this.comm;
    }

    private void connectProxy(Object[] objectArray, String string, String string2) throws IOException, CommRegisterException {
        this.mdpServer = objectArray[0].toString();
        this.mdpPort = (Integer)objectArray[1];
        this.proxyServer = string;
        this.proxyPort = Integer.parseInt(string2);
        this.comm = new CommHandle();
        this.comm.setTimeout(this.timeOutInSec);
        if (this.sslConnect != null) {
            this.comm.setSSLConnector(this.sslConnect);
        }
        this.comm.connect(this.proxyServer, this.proxyPort, this.mdpServer, this.mdpPort, this.deskID, this.proccessID, this);
        this.deskID = this.comm.getDesktopID();
        CommHandle.logTrace(new StringBuffer(10).append("Proxy server proxyServer[").append(this.proxyServer).append("],proxyPort[").append(this.proxyPort).append("]").toString());
    }

    private void connectMDP(Object[] objectArray) throws IOException, CommRegisterException {
        this.mdpServer = objectArray[0].toString();
        this.mdpPort = (Integer)objectArray[1];
        this.comm = new CommHandle();
        this.comm.setTimeout(this.timeOutInSec);
        if (this.sslConnect != null) {
            this.comm.setSSLConnector(this.sslConnect);
        }
        this.comm.connect(this.mdpServer, this.mdpPort, this.deskID, this.proccessID, this);
        this.deskID = this.comm.getDesktopID();
    }

    @Override
    public CommService newCommService(char c, MSGListener mSGListener) {
        CommHandle.logTrace("Creating new CommService: ProcID=" + c);
        Object[] objectArray = null;
        objectArray = null != this.mdpServer && -1 != this.mdpPort ? new Object[]{this.mdpServer, this.mdpPort} : this.securityInfo;
        return this.newMDPProxyConnect(objectArray, c, mSGListener);
    }

    final CommService newMDPProxyConnect(Object[] objectArray, char c, MSGListener mSGListener) {
        CommHandle commHandle = null;
        try {
            if (objectArray != null && objectArray.length >= 2) {
                String string = System.getProperty(PARAM_IP_NAME);
                String string2 = System.getProperty(PARAM_PORT_NAME);
                if (string != null && string2 != null) {
                    this.mdpServer = objectArray[0].toString();
                    this.mdpPort = (Integer)objectArray[1];
                    this.proxyServer = string;
                    this.proxyPort = Integer.parseInt(string2);
                    commHandle = new CommHandle();
                    commHandle.setTimeout(this.timeOutInSec);
                    if (this.sslConnect != null) {
                        commHandle.setSSLConnector(this.sslConnect);
                    }
                    commHandle.connect(this.proxyServer, this.proxyPort, this.mdpServer, this.mdpPort, this.deskID, c, mSGListener);
                    this.deskID = commHandle.getDesktopID();
                    CommHandle.logTrace(new StringBuffer(10).append("Proxy server proxyServer[").append(this.proxyServer).append("],proxyPort[").append(this.proxyPort).append("]").toString());
                } else {
                    this.mdpServer = objectArray[0].toString();
                    this.mdpPort = (Integer)objectArray[1];
                    commHandle = new CommHandle();
                    commHandle.setTimeout(this.timeOutInSec);
                    if (this.sslConnect != null) {
                        commHandle.setSSLConnector(this.sslConnect);
                    }
                    commHandle.connect(this.mdpServer, this.mdpPort, this.deskID, c, mSGListener);
                    this.deskID = commHandle.getDesktopID();
                }
            }
        }
        catch (Exception exception) {
            CommHandle.logException(exception);
            commHandle = null;
        }
        if (null != commHandle) {
            CommHandle.logTrace("Create CommService Success: Proc ID=" + c);
        }
        return commHandle;
    }

    @Override
    public void deleteCommService(CommService commService) {
        if (commService != this.comm) {
            ((CommHandle)commService).closeCommHandle();
        }
    }

    @Override
    public void addCommListener(MSGListener mSGListener) {
        this.arrays.add(mSGListener);
    }

    @Override
    public void removeCommListener(MSGListener mSGListener) {
        this.arrays.remove(mSGListener);
    }

    @Override
    public boolean receiveMessage(MSGPacketExt mSGPacketExt) {
        switch (mSGPacketExt.mheader.cmdCode) {
            case 1: {
                int n = this.arrays.size();
                for (int i = 0; i < n; ++i) {
                    ((MSGListener)this.arrays.get(i)).receiveMessage(mSGPacketExt);
                }
                break;
            }
        }
        return true;
    }

    @Override
    public void timeout(int n, Character c) {
    }

    public void clear() {
        this.arrays.clear();
        if (this.comm != null) {
            this.comm.close();
            this.comm = null;
            this.deskID = '\u0000';
            this.sslConnect = null;
        }
    }

    public void stop() {
        this.clear();
    }

    public void setSSLConnector(SSLConnector sSLConnector) {
        this.sslConnect = sSLConnector;
    }

    public SSLConnector getSSLConnector() {
        return this.sslConnect;
    }

    public int getServerPort() {
        return this.mdpPort;
    }

    public void setServerIPAndPort(String string, int n) {
        this.mdpServer = string;
        this.mdpPort = n;
    }

    public String getServerIP() {
        return this.mdpServer;
    }

    public void setProcId(char c) {
        this.proccessID = c;
    }

    public char getProcId() {
        return this.proccessID;
    }

    public void setDebugEnable(boolean bl) {
        CommHandle.debug = bl;
    }

    public boolean isDebugEnable() {
        return CommHandle.debug;
    }

    public void setDebugLevel(String string) {
        CommHandle.setDebugLevel(string);
    }

    public int getDebugLevel() {
        return CommHandle.getDebugLevel();
    }

    public void setNoTraceCommands(int[] nArray) {
        CommHandle.setNoTraceCommands(nArray);
    }

    public boolean isNoTraceCommands(int n) {
        return CommHandle.isNoTraceCommands(n);
    }

    public void setShakeHandTimeout(int n) {
        CommHandle.setShakeHandTimeout(n);
        CommHandle.logTrace("handshake timeout(s)=" + n);
    }

    public void setReconnector(Properties properties, boolean bl) {
        CommHandle.setReconnector(new Reconnector(properties));
        if (bl) {
            CommHandle.setReconnector(new Reconnector(properties));
        } else {
            CommHandle.setReconnector(new PermanentReconnector(properties));
        }
    }

    public void setTimeOut(int n) {
        if (n > 0 && n <= 2147483) {
            this.timeOutInSec = n * 1000;
            CommHandle.logTrace("send timeout(s)=" + n);
        } else {
            this.timeOutInSec = 9000;
            StringBuffer stringBuffer = new StringBuffer(10);
            stringBuffer.append("Set send timeout(s) out of range{1 ~ ");
            stringBuffer.append(2147483);
            stringBuffer.append("}: ");
            stringBuffer.append(n);
            stringBuffer.append(", use default value instead: ");
            stringBuffer.append(9);
            CommHandle.logTrace(stringBuffer.toString());
            stringBuffer = null;
        }
    }

    public void setSecurityInfo(Object[] objectArray) {
        this.securityInfo = objectArray;
    }

    public void setCommunicateFileName(String string) {
        this.commConfigFile = string;
    }

    public String getCommunicateFileName() {
        return this.commConfigFile;
    }
}

