/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.communicate;

import com.swimap.iview.communicate.CommHandle;
import com.swimap.iview.communicate.MSGPacketExt;
import com.swimap.iview.util.log.IviewLogger;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class CommUtil {
    private static IviewLogger logger = IviewLogger.getLogger(CommUtil.class, "IVIEW");
    private static final int MAX_UNSIGNED_BYTE = 255;
    private static final int CHAR_BYTES_NUM = 2;
    private static final int INT_BYTES_NUM = 4;
    private static final int ONE_BYTE_BITS = 8;
    private static final int TWO_BYTES_BITS = 16;
    private static final int THREE_BYTES_BITS = 24;
    static final int VALID_PACKET = Integer.MIN_VALUE;

    public static byte[] charToBytes(char c) {
        byte[] byArray = new byte[]{(byte)(c >> 8), (byte)c};
        return byArray;
    }

    public static char bytesToChar(byte by, byte by2) {
        return (char)(((by & 0xFF) << 8) + (by2 & 0xFF));
    }

    public static byte charToUnsignedByte(char c) {
        if (c > '\u00ff') {
            Exception exception = new Exception("Char:" + c + " > 255");
            CommHandle.logException(4, exception);
            return (byte)c;
        }
        return (byte)c;
    }

    public static char unsignedByteToChar(byte by) {
        return (char)(by & 0xFF);
    }

    public static byte[] intToBytes(int n) {
        byte[] byArray = new byte[]{(byte)(n >> 24), (byte)(n >> 16), (byte)(n >> 8), (byte)n};
        return byArray;
    }

    public static int bytesToInt(byte[] byArray) {
        if (byArray.length != 4) {
            throw new IllegalArgumentException("bytesToInt(): bytes.length != 4");
        }
        int n = 0;
        n = ((byArray[0] & 0xFF) << 24) + ((byArray[1] & 0xFF) << 16) + ((byArray[2] & 0xFF) << 8) + (byArray[3] & 0xFF);
        return n;
    }

    static final int checkValidPacket(MSGPacketExt mSGPacketExt) {
        if (mSGPacketExt.mheader.errCode == '\u0003') {
            CommHandle.logErrCode(1, "Invalid msg with errCode, ", mSGPacketExt);
            return -4;
        }
        if (mSGPacketExt.mheader.errCode == '\u0004') {
            CommHandle.logErrCode(1, "Invalid msg with errCode, ", mSGPacketExt);
            return -5;
        }
        return Integer.MIN_VALUE;
    }

    public static final boolean isLastPacket(MSGPacketExt mSGPacketExt) {
        return (mSGPacketExt.mheader.commFlag & 0x80) == 0;
    }

    public static String getLocalHostAddress() {
        InetAddress inetAddress = null;
        try {
            inetAddress = InetAddress.getLocalHost();
        }
        catch (UnknownHostException unknownHostException) {
            logger.trace(unknownHostException.getMessage());
            return null;
        }
        return inetAddress.getHostAddress();
    }

    public static interface ErrorCode {
        public static final char IMAP_MDP_DISP_ERROR = '\u0003';
        public static final char IMAP_TMGR_DISP_ERROR = '\u0004';
    }

    public static class MessageType {
        public static final byte REQUESTBROADCAST = 1;
        public static final byte RESPONSEBROADCAST = 2;
        public static final byte REGISTER = 3;
        public static final byte RESTART = 4;
        public static final byte SENDANSWERFRAME = 5;
        public static final byte REQUESTNOTBROADCAST = 6;
        public static final byte RESPONSENOTBROADCAST = 7;
        public static final byte TIMER = 8;
        public static final byte EXIT = 9;
        public static final byte SHAKEHAND = 16;
        public static final byte RECONNECT = 17;
        public static final byte MSG_DISPFAIL_RSP = 27;
        public static final byte MSG_GETRESOURCE = 28;
        public static final byte MSG_SERVER_STATE = 21;

        static String getMsgTypeString(byte by) {
            switch (by) {
                case 1: {
                    return "REQ_BC";
                }
                case 2: {
                    return "RSP_BC";
                }
                case 3: {
                    return "REG";
                }
                case 4: {
                    return "RESTART";
                }
                case 5: {
                    return "HAND_RSP";
                }
                case 6: {
                    return "REQ_NBC";
                }
                case 7: {
                    return "RSP_NBC";
                }
                case 8: {
                    return "TIMER";
                }
                case 9: {
                    return "EXIT";
                }
                case 16: {
                    return "SHAKEHAND";
                }
                case 17: {
                    return "RECONNECT";
                }
                case 27: {
                    return "MSG_DISPFAIL_RSP";
                }
                case 28: {
                    return "MSG_GETRESOURCE";
                }
                case 21: {
                    return "MSG_SERVER_STATE";
                }
            }
            return "Not_Define";
        }
    }

    public static interface SendState {
        public static final int TMGR_DISPATCH_ERROR = -5;
        public static final int MDP_DISPATCH_ERROR = -4;
        public static final int SOCKET_ERROR = -3;
        public static final int DATA_ERROR = -2;
        public static final int TIMEOUT = -1;
        public static final int SURCCESS = 0;
        public static final int SUCCESS = 0;
        public static final int INITIAL = 1;
        public static final int WAITING = 2;
        public static final int CANCEL = 3;
    }

    public static class CommState {
        public static final byte SOCKET_FAIL = -1;
        public static final byte NOT_REGISTERL = -2;
        public static final byte NOT_REGISTER = -2;
        public static final byte SOCKET_ERROR = -3;
        public static final byte NOT_CONNECT = -3;
        public static final byte NORMAL = 1;
        public static final byte CLOSED = 2;
    }

    public static interface ProcessID {
        public static final char MDP_PROCESSID = '\u0002';
    }

    public static interface CommNotify {
        public static final char UNCONNECTED = '\u0001';
    }
}

