/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.communicate;

import com.swimap.iview.communicate.CommHandle;
import com.swimap.iview.communicate.MsgDispatcher;
import java.util.HashMap;
import java.util.Iterator;

final class CommTimeoutChecker
extends Thread {
    private static final int REMOVE_ITEM_FAILED = -1;
    private static final int CHECK_INTERVAL = 1000;
    private static final int ONE_SECOND = 1000;
    private MsgDispatcher dispatcher = null;
    private volatile boolean running = true;
    private HashMap itemMap = new HashMap(16);

    CommTimeoutChecker(MsgDispatcher msgDispatcher) {
        this.dispatcher = msgDispatcher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addItem(Character c, int n, int n2) {
        if (null == this.itemMap) {
            return;
        }
        CheckItem checkItem = new CheckItem();
        checkItem.cmdHandle = c;
        checkItem.cmdCode = n;
        checkItem.timeout = n2;
        HashMap hashMap = this.itemMap;
        synchronized (hashMap) {
            this.itemMap.put(c, checkItem);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int removeItem(Character c) {
        if (null == this.itemMap) {
            return -1;
        }
        CheckItem checkItem = null;
        HashMap hashMap = this.itemMap;
        synchronized (hashMap) {
            checkItem = (CheckItem)this.itemMap.remove(c);
        }
        if (null == checkItem) {
            return -1;
        }
        return checkItem.timeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void refreshTimeoutValue(int n, Character c) {
        if (null == this.itemMap) {
            return;
        }
        CheckItem checkItem = null;
        HashMap hashMap = this.itemMap;
        synchronized (hashMap) {
            checkItem = (CheckItem)this.itemMap.get(c);
        }
        if (null != checkItem && n > 0) {
            checkItem.timeout = n * 1000;
            CommHandle.logTrace("Refresh timeout value, cmdHandle=" + c.charValue() + ", newValue=" + n);
        } else {
            if (null == checkItem) {
                CommHandle.logError("CommTimeoutChecker refreshTimeoutValue failed: CheckItem is null, cmdHandle=" + c.charValue());
            }
            if (n <= 0) {
                CommHandle.logError("CommTimeoutChecker refreshTimeoutValue failed: newValue=" + n);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        CommHandle.logTrace("CommTimeoutChecker started!");
        try {
            while (this.running) {
                Object object = this;
                synchronized (object) {
                    this.wait(1000L);
                }
                object = this.itemMap;
                synchronized (object) {
                    if (this.itemMap.size() > 0) {
                        Iterator iterator = this.itemMap.values().iterator();
                        CheckItem checkItem = null;
                        boolean bl = false;
                        while (iterator.hasNext()) {
                            checkItem = (CheckItem)iterator.next();
                            ++checkItem.count;
                            if (checkItem.count * 1000 < checkItem.timeout + 1000) continue;
                            bl = this.dispatcher.checkTimeout(checkItem.cmdHandle);
                            if (bl) {
                                this.dispatcher.timeout(checkItem.cmdCode, checkItem.cmdHandle);
                                iterator.remove();
                                continue;
                            }
                            checkItem.count = 0;
                        }
                    }
                }
            }
        }
        catch (InterruptedException interruptedException) {
            CommHandle.logException(interruptedException);
        }
        this.dispatcher = null;
        this.itemMap.clear();
        CommHandle.logTrace("CommTimeoutChecker exited!");
    }

    public void close() {
        this.running = false;
        this.interrupt();
    }

    private static class CheckItem {
        Character cmdHandle = null;
        int cmdCode = 0;
        int timeout = 0;
        int count = 0;

        private CheckItem() {
        }
    }
}

