/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.communicate;

import com.swimap.iview.communicate.CommHandle;
import com.swimap.iview.communicate.CompressStrategyFactory;
import com.swimap.iview.communicate.DataAccepter;
import com.swimap.iview.communicate.ICompressStrategy;
import com.swimap.iview.communicate.MSGHead;
import com.swimap.iview.communicate.MSGPacketExt;
import java.io.BufferedInputStream;

final class CommReader
extends Thread {
    private static final int DEFAULT_BUF_LEN = 66560;
    private static final int UPPER_LIMIT_BUF_LEN = 0x400000;
    private CommHandle m_Handle = null;
    private BufferedInputStream in = null;
    private DataAccepter m_Accepter = null;
    private byte[] byteBuffer = new byte[66560];
    private boolean normalClose = false;
    private volatile boolean exitReading = false;

    CommReader(CommHandle commHandle, BufferedInputStream bufferedInputStream, DataAccepter dataAccepter) {
        this.m_Handle = commHandle;
        this.in = bufferedInputStream;
        this.m_Accepter = dataAccepter;
    }

    void setAccepter(DataAccepter dataAccepter) {
        this.m_Accepter = dataAccepter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        CommHandle.logTrace("Initializing and Starting CommReader Thread ");
        MSGHead mSGHead = null;
        boolean bl = true;
        int n = 43;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        try {
            while (!this.exitReading) {
                n4 = this.in.read(this.byteBuffer, n3, n);
                if (n4 <= 0) {
                    CommHandle.logError("|CommReader|run()|Read Error, len=" + n4);
                    break;
                }
                if (n4 < n) {
                    n -= n4;
                    n3 += n4;
                    continue;
                }
                n3 = 0;
                if (bl) {
                    mSGHead = new MSGHead();
                    mSGHead.fromByte(this.byteBuffer);
                    CommHandle.logTrace(1, "From socket;", mSGHead);
                    n2 = mSGHead.contentLength;
                    if (n2 > 0) {
                        if (n2 > this.m_Handle.getMsgMaxLength()) {
                            CommHandle.logTrace(1, "Receive failed: Response too big! len= " + n2);
                            break;
                        }
                        bl = false;
                        n = n2;
                        if (null == this.byteBuffer || n2 <= this.byteBuffer.length) continue;
                        this.byteBuffer = null;
                        this.byteBuffer = new byte[n2];
                        continue;
                    }
                }
                if (null != this.m_Accepter) {
                    MSGPacketExt mSGPacketExt = new MSGPacketExt(mSGHead, this.byteBuffer, n2);
                    mSGPacketExt = this.deCompressData(mSGPacketExt);
                    this.m_Accepter.sendToDispatch(mSGPacketExt);
                }
                if (this.byteBuffer.length > 0x400000) {
                    this.byteBuffer = null;
                    this.byteBuffer = new byte[66560];
                }
                bl = true;
                n = 43;
                n2 = 0;
            }
        }
        catch (Exception exception) {
            if (!this.normalClose) {
                CommHandle.logException(3, exception);
            }
        }
        finally {
            this.abort();
            try {
                if (null != this.in) {
                    this.in.close();
                }
            }
            catch (Exception exception) {
                CommHandle.logException(3, exception);
            }
        }
        this.m_Accepter = null;
        this.in = null;
        this.byteBuffer = null;
        this.m_Handle = null;
        CommHandle.logTrace("CommReader exited");
    }

    private void abort() {
        CommHandle.logError("come in abort normalClose = " + this.normalClose);
        if (!this.normalClose) {
            CommHandle.logError("come in abort");
            this.normalClose = true;
            this.m_Handle.handleError();
        }
    }

    private MSGPacketExt deCompressData(MSGPacketExt mSGPacketExt) {
        if (null == mSGPacketExt) {
            return null;
        }
        ICompressStrategy iCompressStrategy = CompressStrategyFactory.getCompressStrategy();
        MSGPacketExt mSGPacketExt2 = mSGPacketExt;
        if (iCompressStrategy.decompressCondition(mSGPacketExt.mheader.toByte())) {
            int n;
            CommHandle.logTrace(1, "Decompressing data started ", mSGPacketExt2.mheader);
            byte[] byArray = iCompressStrategy.decompress(mSGPacketExt.getData());
            mSGPacketExt.mheader.contentLength = n = byArray.length;
            mSGPacketExt2 = new MSGPacketExt(mSGPacketExt.mheader, byArray);
            CommHandle.logTrace(1, "Decompressing data end ", mSGPacketExt2.mheader);
        }
        return mSGPacketExt2;
    }

    final void close() {
        this.normalClose = true;
    }

    void exit() {
        this.exitReading = true;
    }
}

