/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.communicate;

import com.swimap.iview.communicate.CommHandle;
import com.swimap.iview.communicate.CommManageService;
import com.swimap.iview.communicate.CommService;
import com.swimap.iview.communicate.Communicator;
import com.swimap.iview.communicate.MSGListener;
import com.swimap.iview.communicate.MSGPacketExt;
import com.swimap.iview.communicate.SSLConnector;
import com.swimap.iview.framework.modulemanagement.BaseModule;
import com.swimap.iview.framework.modulemanagement.ModuleManagementException;
import com.swimap.iview.framework.modulemanagement.ModuleManager;
import com.swimap.iview.framework.securitymanagement.SecurityService;
import com.swimap.iview.framework.util.FrameworkGlobalInfo;

public class CommManager
extends BaseModule
implements CommManageService,
MSGListener {
    private Communicator communicator = new Communicator();

    public CommManager(ModuleManager moduleManager) {
        super(moduleManager);
    }

    @Override
    public void initialize() {
        this.communicator.initialize();
    }

    @Override
    public void reinitialize() {
        this.communicator.initialize();
    }

    @Override
    public String getModuleName() {
        return "communicateservice";
    }

    @Override
    public synchronized CommService getCommService() {
        return this.communicator.defaultMDPProxyConnect(this.getSecurityInfo());
    }

    private Object[] getSecurityInfo() {
        Object[] objectArray = null;
        String string = this.communicator.getServerIP();
        int n = this.communicator.getServerPort();
        if (null != string && -1 != n) {
            objectArray = new Object[]{string, n};
        } else {
            SecurityService securityService = null;
            try {
                securityService = (SecurityService)((Object)this.getLocalReference(FrameworkGlobalInfo.ModuleName.SECURITY_MANAGER_NAME));
                objectArray = securityService.getSecurityInfo();
            }
            catch (ModuleManagementException moduleManagementException) {
                CommHandle.logTrace("Failed to get security module : " + moduleManagementException);
            }
        }
        return objectArray;
    }

    @Override
    public synchronized CommService newCommService(char c, MSGListener mSGListener) {
        return this.communicator.newMDPProxyConnect(this.getSecurityInfo(), c, mSGListener);
    }

    @Override
    public synchronized void deleteCommService(CommService commService) {
        this.communicator.deleteCommService(commService);
    }

    @Override
    public void addCommListener(MSGListener mSGListener) {
        this.communicator.addCommListener(mSGListener);
    }

    @Override
    public void removeCommListener(MSGListener mSGListener) {
        this.communicator.removeCommListener(mSGListener);
    }

    @Override
    public boolean receiveMessage(MSGPacketExt mSGPacketExt) {
        return this.communicator.receiveMessage(mSGPacketExt);
    }

    @Override
    public void timeout(int n, Character c) {
        this.communicator.timeout(n, c);
    }

    @Override
    public void clear() {
        this.communicator.clear();
    }

    @Override
    public void stop() {
        this.communicator.stop();
    }

    public void setSSLConnector(SSLConnector sSLConnector) {
        this.communicator.setSSLConnector(sSLConnector);
    }

    public SSLConnector getSSLConnector() {
        return this.communicator.getSSLConnector();
    }

    public int getServerPort() {
        return this.communicator.getServerPort();
    }

    public void setServerIPAndPort(String string, int n) {
        this.communicator.setServerIPAndPort(string, n);
    }

    public String getServerIP() {
        return this.communicator.getServerIP();
    }
}

