/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.communicate;

import com.swimap.iview.communicate.AppAidedMsgListener;
import com.swimap.iview.communicate.AppAidedMsgSyncReceiver;
import com.swimap.iview.communicate.CommReader;
import com.swimap.iview.communicate.CommRegisterException;
import com.swimap.iview.communicate.CommService;
import com.swimap.iview.communicate.CommStateEvent;
import com.swimap.iview.communicate.CommStateListener;
import com.swimap.iview.communicate.CommUtil;
import com.swimap.iview.communicate.DataAccepter;
import com.swimap.iview.communicate.HandShakeTask;
import com.swimap.iview.communicate.MSGHead;
import com.swimap.iview.communicate.MSGListener;
import com.swimap.iview.communicate.MSGPacket;
import com.swimap.iview.communicate.MSGPacketExt;
import com.swimap.iview.communicate.MSGSyncReceiver;
import com.swimap.iview.communicate.MsgDispatcher;
import com.swimap.iview.communicate.Reconnector;
import com.swimap.iview.communicate.SSLConnector;
import com.swimap.iview.communicate.Sock5MethodRequest;
import com.swimap.iview.communicate.Sock5MethodResponse;
import com.swimap.iview.communicate.Sock5Request;
import com.swimap.iview.util.log.IviewLogger;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicInteger;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruEncoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;

public class CommHandle
implements CommService {
    private static IviewLogger logger = IviewLogger.getLogger(CommHandle.class, "IVIEW");
    private static final int HAND_INTERVAL = 10000;
    private static final int MIN_HANDSHAKE_INTERVAL = 20000;
    private static final int REGISTER_DATA_LEN = 15;
    private static final int MDP_DATA_LEN = 4;
    private static final int MDP_MSGLEN_OFFSET = 5;
    private static final int REGISTER_TIMEOUT = 40000;
    private static final int MIN_CMDHANDLE = 1;
    private static final int MAX_CMDHANDLE = 65530;
    static final int MIN_TIMEOUT = 1000;
    private static final int DEFAULT_TIMEOUT = 9000;
    private static final int DEFAULT_HANDSHAKE_TIMEOUT = 60000;
    private static final int ONE_SECOND = 1000;
    private static final int MSG_SIZE_OVERFLOW = -1;
    private String hostName = null;
    private int hostPort = -1;
    private String remoteIP = null;
    private int remotePort = -1;
    private boolean isProxy = false;
    private Socket socket = null;
    private BufferedInputStream in = null;
    private BufferedOutputStream out = null;
    private AtomicInteger cmdHandle = new AtomicInteger(1);
    private DataAccepter dataAccepter = null;
    private CommReader reader = null;
    private MsgDispatcher dispatcher = null;
    int timeout = 9000;
    private Timer shakeTimer = null;
    private HandShakeTask shakeTask = null;
    private char desktopID = '\u0000';
    private char procID = '\u0000';
    private char procHandle = '\u0000';
    private byte state = (byte)-3;
    private MSGListener commListener = null;
    private static int shakeHandTimeOut = 60000;
    private SSLConnector sslConnector = null;
    private volatile boolean isRegistered = false;
    private MSGPacketExt handShakeMsg = null;
    private long lastEchoTime = 0L;
    private CommStateListener stateListener = null;
    private static Reconnector reconnetor = null;
    private int msgMaxLength = 0x400000;
    private static int[] noTraceCommands = null;
    public static boolean debug = true;
    private static final String LEVEL_ALL = "All";
    private static final String LEVEL_TRACE = "Trace";
    private static final String LEVEL_WARNING = "Warning";
    private static final String LEVEL_ERROR = "Error";
    public static final int ALL = 0;
    public static final int TRACE = 1;
    public static final int WARNING = 2;
    public static final int ERROR = 3;
    public static int debug_level = 1;
    private static final int RETRY_COUNT = 3;
    private boolean closed = false;
    protected static int instanceCount = 0;
    private int regCount = 0;
    private static final byte MAGIC_EB = -21;
    private static final byte MAGIC_ED = -19;
    private static final byte FRAMECONTENT_FLAG = 4;
    private static final byte SECURITY_TOKEN = 1;
    private static final byte HEX_FF = -1;
    private static final int COMMFLAG_POSITION = 24;
    private static final int RESV_BYTES_LEN_00 = 27;
    private static final int RESV_BYTES_LEN_01 = 28;
    private static final int MAX_BYTE_RANGE = 255;
    private static final int EIGHT = 8;
    private static final int SIXTEEN = 16;
    private static final int THOUSAND = 1000;
    private static ArrayList<ContentBlock> contentBlocks = new ArrayList(1);
    private static byte[] tokenBytes = null;
    private volatile boolean handleErrorStarted = false;
    private ReconnectCloseLock closeReconnectLock = new ReconnectCloseLock();

    public CommHandle() {
        ++instanceCount;
    }

    private static byte[] getTwoBytes(int n) {
        byte[] byArray = new byte[]{0, 0};
        byArray = new byte[]{(byte)(n >> 8 & 0xFFFFFFFF), (byte)(n & 0xFFFFFFFF)};
        if (n > 255) {
            CommHandle.logTrace("The input is larger than max-value of a byte:" + n);
        }
        return byArray;
    }

    private static boolean isFrameContentRequired(int n) {
        boolean bl = false;
        switch (n) {
            case 1: {
                bl = true;
                break;
            }
            case 2: {
                bl = true;
                break;
            }
            case 6: {
                bl = true;
                break;
            }
            case 7: {
                bl = true;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl && contentBlocks.size() > 0;
    }

    private static byte[] getFrameContentBytes() throws IOException {
        int n = contentBlocks.size();
        byte[] byArray = null;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byteArrayOutputStream.write(-21);
        for (int i = 0; i < n; ++i) {
            byteArrayOutputStream.write(contentBlocks.get(i).toBytes());
        }
        byteArrayOutputStream.write(n);
        byteArrayOutputStream.write(-19);
        byArray = byteArrayOutputStream.toByteArray();
        return byArray;
    }

    private MSGPacketExt checkAndAddFrameContent(MSGPacketExt mSGPacketExt) throws Exception {
        if (null == mSGPacketExt || null == mSGPacketExt.mheader || !CommHandle.isFrameContentRequired(mSGPacketExt.mheader.msgType)) {
            CommHandle.logTrace("No frame-contents to add to packet.");
            return mSGPacketExt;
        }
        byte[] byArray = CommHandle.getFrameContentBytes();
        int n = 0;
        byte[] byArray2 = CommHandle.getTwoBytes(byArray.length);
        MSGPacketExt mSGPacketExt2 = mSGPacketExt;
        byte[] byArray3 = mSGPacketExt.getData();
        byte[] byArray4 = null;
        if (null != byArray3) {
            int n2 = byArray3.length;
            n = n2 + byArray.length;
            byArray4 = new byte[n];
            System.arraycopy(byArray3, 0, byArray4, 0, byArray3.length);
            System.arraycopy(byArray, 0, byArray4, byArray3.length, byArray.length);
        } else {
            CommHandle.logTrace("Packet data is null.");
            byArray4 = CommHandle.getFrameContentBytes();
            n = byArray4.length;
        }
        byte[] byArray5 = mSGPacketExt.mheader.toByte();
        byArray5[24] = (byte)(byArray5[24] | 4);
        byArray5[27] = byArray2[0];
        byArray5[28] = byArray2[1];
        MSGHead mSGHead = new MSGHead();
        mSGHead.fromByte(byArray5);
        mSGHead.contentLength = n;
        mSGPacketExt2 = new MSGPacketExt(mSGHead, byArray4);
        CommHandle.logTrace("Frame-content appended to packet. contentLength=" + n);
        return mSGPacketExt2;
    }

    public static void setCurrentSession(byte[] byArray) {
        logger.debug("ContentBlocks will be changed.");
        if (null == byArray) {
            CommHandle.logTrace("Method called with null. contentBlocks will be cleared.");
            tokenBytes = null;
            contentBlocks.clear();
        } else {
            int n = byArray.length;
            if (n > 255) {
                CommHandle.logError("Token is longer than 255 bytes. Extra bytes will be truncated.");
                n = 255;
            }
            tokenBytes = new byte[n];
            System.arraycopy(byArray, 0, tokenBytes, 0, n);
            contentBlocks.clear();
            contentBlocks.add(new ContentBlock(tokenBytes, 1));
            CommHandle.logTrace("Session-token added. contentBlocks.size=" + contentBlocks.size());
        }
    }

    public void connect(String string, int n, String string2, int n2, char c, char c2, MSGListener mSGListener) throws IOException, CommRegisterException {
        this.commListener = mSGListener;
        this.isProxy = true;
        this.remoteIP = string2;
        this.remotePort = n2;
        this.connect(string, n, c, c2);
    }

    public void connect(String string, int n, char c, char c2, MSGListener mSGListener) throws IOException, CommRegisterException {
        this.commListener = mSGListener;
        this.isProxy = false;
        this.connect(string, n, c, c2);
    }

    public void connect(String string, int n, char c, char c2) throws IOException, CommRegisterException {
        this.isRegistered = false;
        int n2 = 0;
        try {
            while (!this.openSocket(string, n) && 3 > n2++) {
                Thread.sleep(1000L);
                if (3 == n2) {
                    throw new IOException("Can't open socket or I/O stream");
                }
                CommHandle.logTrace("Failed to connect to MDP, remaining retry count: " + (3 - n2));
            }
        }
        catch (InterruptedException interruptedException) {
            CommHandle.logException(interruptedException);
        }
        this.desktopID = c;
        this.procID = c2;
        this.dataAccepter = new DataAccepter();
        this.reader.setAccepter(this.dataAccepter);
        this.dispatcher = new MsgDispatcher(this, this.dataAccepter);
        this.dispatcher.setName("MsgDispatcher-" + instanceCount);
        this.dispatcher.start();
        this.state = 1;
        int n3 = this.registProcess();
        if (n3 != 0 && 3 > this.regCount++) {
            this.closeCommHandle();
            CommHandle.logTrace("Failed to register to MDP, remaining retry count: " + (3 - this.regCount));
            if (3 == this.regCount) {
                throw new CommRegisterException();
            }
            this.connect(string, n, c, c2);
            return;
        }
        this.regCount = 0;
        this.isRegistered = true;
        this.startHandShake();
        this.hostName = string;
        this.hostPort = n;
    }

    private boolean openSocket(String string, int n) {
        try {
            StringBuffer stringBuffer = new StringBuffer(16);
            stringBuffer.append("Open socket with ");
            stringBuffer.append(string);
            stringBuffer.append(':');
            stringBuffer.append(n);
            CommHandle.logTrace(stringBuffer.toString());
            if (null != this.sslConnector) {
                CommHandle.logTrace("Creating SSL Socket");
                this.socket = this.sslConnector.createSSLSocket(string, n);
            } else {
                CommHandle.logTrace("Creating Non-SSL Socket");
                this.socket = null;
                String string2 = System.getProperty("USED_LOCAL_IP_ENV");
                if (null == string2 || string2.trim().equals("")) {
                    this.socket = new Socket(string, n);
                    InetAddress inetAddress = this.socket.getLocalAddress();
                    string2 = inetAddress.getHostAddress();
                    logger.debug("System Property USED_LOCAL_IP_ENV is set:" + string2);
                    System.setProperty("USED_LOCAL_IP_ENV", string2);
                } else {
                    InetAddress inetAddress = InetAddress.getByName(string2);
                    this.socket = new Socket(string, n, inetAddress, 0);
                }
            }
            if (this.socket == null) {
                CommHandle.logTrace("Open socket failed! ");
                return false;
            }
            this.socket.setTcpNoDelay(true);
        }
        catch (IOException iOException) {
            CommHandle.logException(iOException);
            return false;
        }
        catch (Exception exception) {
            CommHandle.logException(exception);
            return false;
        }
        try {
            this.out = new BufferedOutputStream(this.socket.getOutputStream());
            this.in = new BufferedInputStream(this.socket.getInputStream());
        }
        catch (Exception exception) {
            try {
                if (null != this.out) {
                    this.out.close();
                    this.out = null;
                }
            }
            catch (Exception exception2) {
                CommHandle.logException(exception2);
            }
            try {
                this.socket.close();
                this.socket = null;
            }
            catch (Exception exception3) {
                CommHandle.logException(exception3);
            }
            return false;
        }
        if (this.isProxy && !this.handShakeWithProxy()) {
            this.closeSocket();
            return false;
        }
        if (null != this.reader) {
            this.reader.close();
        }
        this.reader = new CommReader(this, this.in, this.dataAccepter);
        this.reader.setName("CommReader-" + instanceCount);
        this.reader.start();
        return true;
    }

    private boolean handShakeWithProxy() {
        Sock5MethodRequest sock5MethodRequest = null;
        Sock5MethodResponse sock5MethodResponse = null;
        Sock5Request sock5Request = null;
        Sock5Request sock5Request2 = null;
        int n = 10;
        byte[] byArray = new byte[n];
        try {
            sock5MethodRequest = new Sock5MethodRequest();
            this.out.write(sock5MethodRequest.toByte());
            this.out.flush();
            int n2 = this.in.read(byArray, 0, 2);
            sock5MethodResponse = new Sock5MethodResponse();
            if (n2 < 2) {
                throw new Exception("request authentic method error!");
            }
            sock5MethodResponse.fromByte(byArray);
            if (sock5MethodResponse.method == '\u00ff') {
                throw new Exception("request authentic method error!");
            }
            sock5Request = new Sock5Request();
            sock5Request.remoteIp = this.remoteIP;
            sock5Request.port = (short)this.remotePort;
            this.out.write(sock5Request.toByte());
            this.out.flush();
            n2 = this.in.read(byArray, 0, 10);
            sock5Request2 = new Sock5Request();
            if (n2 < 10) {
                throw new Exception("request  connect from proxy error!");
            }
            sock5Request2.fromByte(byArray);
            if (sock5Request2.command != 0) {
                throw new Exception("request  connect from proxy error!");
            }
        }
        catch (Exception exception) {
            CommHandle.logException(exception);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int registProcess() {
        Object object;
        CommHandle.logTrace("Initializing Register Process");
        MSGHead mSGHead = new MSGHead();
        mSGHead.senderDeskID = this.desktopID;
        mSGHead.receiverDeskID = '\u0000';
        mSGHead.senderProcHandle = this.procHandle;
        mSGHead.receiverProcHandle = '\u0000';
        mSGHead.senderProcID = this.procID;
        mSGHead.receiverProcID = (char)2;
        mSGHead.msgType = this.procHandle == '\u0000' ? (byte)3 : (byte)17;
        mSGHead.cmdCode = 0;
        mSGHead.contentLength = 15;
        byte[] byArray = new byte[15];
        byte[] byArray2 = CommUtil.charToBytes(this.procID);
        byArray[0] = byArray2[0];
        byArray[1] = byArray2[1];
        try {
            object = InetAddress.getLocalHost();
            byArray2 = ((InetAddress)object).getAddress();
            for (int i = 0; i < byArray2.length; ++i) {
                byArray[2 + i] = byArray2[i];
            }
        }
        catch (UnknownHostException unknownHostException) {
            CommHandle.logException(unknownHostException);
        }
        object = new MSGPacketExt(mSGHead, byArray);
        MSGSyncReceiver mSGSyncReceiver = new MSGSyncReceiver();
        this.sendRegisterMessage((MSGPacketExt)object, mSGSyncReceiver);
        MSGSyncReceiver mSGSyncReceiver2 = mSGSyncReceiver;
        synchronized (mSGSyncReceiver2) {
            if (mSGSyncReceiver.getFlag() == 1) {
                mSGSyncReceiver.setFlag(2);
                try {
                    mSGSyncReceiver.wait();
                }
                catch (InterruptedException interruptedException) {
                    CommHandle.logException(interruptedException);
                    mSGSyncReceiver.setFlag(3);
                }
            }
        }
        int n = mSGSyncReceiver.getFlag();
        if (n == 0) {
            MSGPacketExt mSGPacketExt = mSGSyncReceiver.getResult();
            this.procHandle = mSGPacketExt.mheader.receiverProcHandle;
            this.desktopID = mSGPacketExt.mheader.receiverDeskID;
            byte[] byArray3 = new byte[4];
            System.arraycopy(mSGPacketExt.getData(), 5, byArray3, 0, 4);
            this.msgMaxLength = CommUtil.bytesToInt(byArray3);
            CommHandle.logTrace("Max length of message:" + this.msgMaxLength);
            StringBuffer stringBuffer = new StringBuffer(16);
            stringBuffer.append("Register to MDP success: procID = " + this.procID);
            stringBuffer.append(", procHandle = " + this.procHandle);
            CommHandle.logTrace(stringBuffer.toString());
            stringBuffer = null;
            return 0;
        }
        CommHandle.logError("Register to MDP failed:" + n);
        return n;
    }

    private void sendRegisterMessage(final MSGPacketExt mSGPacketExt, final MSGSyncReceiver mSGSyncReceiver) {
        Thread thread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    CommHandle.this.sendAsyncMessage(mSGPacketExt, (MSGListener)mSGSyncReceiver, 40000);
                }
                catch (IOException iOException) {
                    CommHandle.logException(iOException);
                    MSGSyncReceiver mSGSyncReceiver2 = mSGSyncReceiver;
                    synchronized (mSGSyncReceiver2) {
                        mSGSyncReceiver.setFlag(-3);
                        mSGSyncReceiver.notifyAll();
                    }
                }
                catch (Exception exception) {
                    CommHandle.logException(exception);
                    MSGSyncReceiver mSGSyncReceiver3 = mSGSyncReceiver;
                    synchronized (mSGSyncReceiver3) {
                        mSGSyncReceiver.setFlag(-2);
                        mSGSyncReceiver.notifyAll();
                    }
                }
            }
        };
        thread.setName("Register-" + instanceCount);
        thread.start();
    }

    private void startHandShake() {
        this.shakeTimer = new Timer();
        this.shakeTask = new HandShakeTask(this);
        this.shakeTimer.schedule((TimerTask)this.shakeTask, 10000L, 10000L);
        CommHandle.logTrace("HandShake thread started successfully  ProcID=" + this.procID + "procHandle: " + this.procHandle);
    }

    public int sendMessage(MSGPacket mSGPacket, MSGSyncReceiver mSGSyncReceiver) {
        return this.sendMessage(mSGPacket, mSGSyncReceiver, this.timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int sendMessage(MSGPacket mSGPacket, MSGSyncReceiver mSGSyncReceiver, int n) {
        MSGSyncReceiver mSGSyncReceiver2 = mSGSyncReceiver;
        synchronized (mSGSyncReceiver2) {
            int n2 = -1;
            try {
                n2 = this.sendAsyncMessage(mSGPacket, (MSGListener)mSGSyncReceiver, n);
                mSGSyncReceiver.setFlag(2);
                mSGSyncReceiver.wait();
            }
            catch (IOException iOException) {
                CommHandle.logException(4, iOException);
                if (null != this.dispatcher) {
                    this.dispatcher.removeReceiver(Character.valueOf((char)n2));
                } else {
                    logger.debug("dispatcher is null");
                }
                return -3;
            }
            catch (InterruptedException interruptedException) {
                CommHandle.logException(4, interruptedException);
            }
            if (null != this.dispatcher) {
                this.dispatcher.removeReceiver(Character.valueOf((char)n2));
            } else {
                logger.debug("dispatcher is null");
            }
        }
        return mSGSyncReceiver.getFlag();
    }

    public int sendMessage(MSGPacketExt mSGPacketExt, MSGSyncReceiver mSGSyncReceiver) {
        return this.sendMessage(mSGPacketExt, mSGSyncReceiver, this.timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int sendMessage(MSGPacketExt mSGPacketExt, MSGSyncReceiver mSGSyncReceiver, int n) {
        if (null == mSGSyncReceiver) {
            throw new IllegalArgumentException("MSGSyncReceiver is null.");
        }
        MSGSyncReceiver mSGSyncReceiver2 = mSGSyncReceiver;
        synchronized (mSGSyncReceiver2) {
            int n2 = -1;
            try {
                n2 = this.sendAsyncMessage(mSGPacketExt, (MSGListener)mSGSyncReceiver, n);
                if (n2 == -1) {
                    return -2;
                }
                mSGSyncReceiver.setFlag(2);
                mSGSyncReceiver.wait();
            }
            catch (IOException iOException) {
                CommHandle.logException(4, iOException);
                if (null != this.dispatcher) {
                    this.dispatcher.removeReceiver(Character.valueOf((char)n2));
                } else {
                    logger.debug("dispatcher is null");
                }
                return -3;
            }
            catch (InterruptedException interruptedException) {
                CommHandle.logException(4, interruptedException);
            }
            if (null != this.dispatcher) {
                this.dispatcher.removeReceiver(Character.valueOf((char)n2));
            } else {
                logger.debug("dispatcher is null");
            }
        }
        return mSGSyncReceiver.getFlag();
    }

    public int sendMessage(MSGPacketExt mSGPacketExt, AppAidedMsgSyncReceiver appAidedMsgSyncReceiver) {
        return this.sendMessage(mSGPacketExt, appAidedMsgSyncReceiver, this.timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int sendMessage(MSGPacketExt mSGPacketExt, AppAidedMsgSyncReceiver appAidedMsgSyncReceiver, int n) {
        if (null == appAidedMsgSyncReceiver) {
            throw new IllegalArgumentException("AppAidedMsgSyncReceiver is null.");
        }
        AppAidedMsgSyncReceiver appAidedMsgSyncReceiver2 = appAidedMsgSyncReceiver;
        synchronized (appAidedMsgSyncReceiver2) {
            int n2 = -1;
            try {
                n2 = this.sendAsyncMessage(mSGPacketExt, (MSGListener)appAidedMsgSyncReceiver, n);
                if (n2 == -1) {
                    return -2;
                }
                appAidedMsgSyncReceiver.setFlag(2);
                appAidedMsgSyncReceiver.wait();
            }
            catch (IOException iOException) {
                CommHandle.logException(4, iOException);
                if (null != this.dispatcher) {
                    this.dispatcher.removeReceiver(Character.valueOf((char)n2));
                } else {
                    logger.debug("dispatcher is null");
                }
                return -3;
            }
            catch (InterruptedException interruptedException) {
                CommHandle.logException(4, interruptedException);
            }
            if (null != this.dispatcher) {
                this.dispatcher.removeReceiver(Character.valueOf((char)n2));
            } else {
                logger.debug("dispatcher is null");
            }
        }
        return appAidedMsgSyncReceiver.getFlag();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int sendMessage(MSGPacketExt[] mSGPacketExtArray, AppAidedMsgSyncReceiver appAidedMsgSyncReceiver, int n) {
        if (null == appAidedMsgSyncReceiver) {
            throw new IllegalArgumentException("AppAidedMsgSyncReceiver is null.");
        }
        AppAidedMsgSyncReceiver appAidedMsgSyncReceiver2 = appAidedMsgSyncReceiver;
        synchronized (appAidedMsgSyncReceiver2) {
            int n2 = -1;
            try {
                n2 = this.sendAsyncMessage(mSGPacketExtArray, appAidedMsgSyncReceiver, n);
                if (n2 == -1) {
                    return -2;
                }
                appAidedMsgSyncReceiver.setFlag(2);
                appAidedMsgSyncReceiver.wait();
            }
            catch (IOException iOException) {
                CommHandle.logException(4, iOException);
                if (null != this.dispatcher) {
                    this.dispatcher.removeReceiver(Character.valueOf((char)n2));
                } else {
                    logger.debug("dispatcher is null");
                }
                return -3;
            }
            catch (InterruptedException interruptedException) {
                CommHandle.logException(4, interruptedException);
            }
            if (null != this.dispatcher) {
                this.dispatcher.removeReceiver(Character.valueOf((char)n2));
            } else {
                logger.debug("dispatcher is null");
            }
        }
        return appAidedMsgSyncReceiver.getFlag();
    }

    @Override
    public int sendMessage(MSGHead mSGHead, FStruct fStruct, MSGSyncReceiver mSGSyncReceiver) {
        return this.sendMessage(mSGHead, fStruct, mSGSyncReceiver, this.timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int sendMessage(MSGHead mSGHead, FStruct fStruct, MSGSyncReceiver mSGSyncReceiver, int n) {
        if (null == mSGSyncReceiver) {
            throw new IllegalArgumentException("MSGSyncReceiver is null.");
        }
        MSGSyncReceiver mSGSyncReceiver2 = mSGSyncReceiver;
        synchronized (mSGSyncReceiver2) {
            int n2 = -1;
            try {
                n2 = this.sendAsyncMessage(mSGHead, fStruct, mSGSyncReceiver, n);
                if (n2 == -1) {
                    return -2;
                }
                mSGSyncReceiver.setFlag(2);
                mSGSyncReceiver.wait();
            }
            catch (FStruException fStruException) {
                CommHandle.logException(4, (Exception)((Object)fStruException));
                if (null != this.dispatcher) {
                    this.dispatcher.removeReceiver(Character.valueOf((char)n2));
                } else {
                    logger.debug("dispatcher is null");
                }
                return -2;
            }
            catch (IOException iOException) {
                CommHandle.logException(4, iOException);
                if (null != this.dispatcher) {
                    this.dispatcher.removeReceiver(Character.valueOf((char)n2));
                } else {
                    logger.debug("dispatcher is null");
                }
                return -3;
            }
            catch (InterruptedException interruptedException) {
                CommHandle.logException(4, interruptedException);
            }
            if (null != this.dispatcher) {
                this.dispatcher.removeReceiver(Character.valueOf((char)n2));
            } else {
                logger.debug("dispatcher is null");
            }
        }
        return mSGSyncReceiver.getFlag();
    }

    public int sendMessage(MSGHead mSGHead, FStruct fStruct, AppAidedMsgSyncReceiver appAidedMsgSyncReceiver) {
        return this.sendMessage(mSGHead, fStruct, appAidedMsgSyncReceiver, this.timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int sendMessage(MSGHead mSGHead, FStruct fStruct, AppAidedMsgSyncReceiver appAidedMsgSyncReceiver, int n) {
        if (null == appAidedMsgSyncReceiver) {
            throw new IllegalArgumentException("AppAidedMsgSyncReceiver is null.");
        }
        AppAidedMsgSyncReceiver appAidedMsgSyncReceiver2 = appAidedMsgSyncReceiver;
        synchronized (appAidedMsgSyncReceiver2) {
            int n2 = -1;
            try {
                n2 = this.sendAsyncMessage(mSGHead, fStruct, appAidedMsgSyncReceiver, n);
                if (n2 == -1) {
                    return -2;
                }
                appAidedMsgSyncReceiver.setFlag(2);
                appAidedMsgSyncReceiver.wait();
            }
            catch (FStruException fStruException) {
                CommHandle.logException(4, (Exception)((Object)fStruException));
                return -2;
            }
            catch (IOException iOException) {
                CommHandle.logException(4, iOException);
                if (null != this.dispatcher) {
                    this.dispatcher.removeReceiver(Character.valueOf((char)n2));
                } else {
                    logger.debug("dispatcher is null");
                }
                return -3;
            }
            catch (InterruptedException interruptedException) {
                CommHandle.logException(4, interruptedException);
            }
        }
        return appAidedMsgSyncReceiver.getFlag();
    }

    public short sendAsyncMessage(MSGPacket mSGPacket, MSGListener mSGListener) throws IOException {
        return this.sendAsyncMessage(mSGPacket, mSGListener, this.timeout);
    }

    public short sendAsyncMessage(MSGPacket mSGPacket, MSGListener mSGListener, int n) throws IOException {
        return this.sendAsyncMessage(new MSGPacketExt(mSGPacket), mSGListener, n);
    }

    public short sendAsyncMessage(MSGPacketExt mSGPacketExt, MSGListener mSGListener) throws IOException {
        return this.sendAsyncMessage(mSGPacketExt, mSGListener, this.timeout);
    }

    public synchronized short sendAsyncMessage(MSGPacketExt mSGPacketExt, MSGListener mSGListener, int n) throws IOException {
        if (this.state != 1 && (mSGPacketExt.mheader.msgType != 17 || mSGPacketExt.mheader.receiverProcID != '\u0002')) {
            CommHandle.logError("CommState is abnormal, state=" + this.state);
            throw new IOException();
        }
        if (null == mSGPacketExt) {
            throw new IllegalArgumentException("MSGPacketExt is null.");
        }
        MSGPacketExt mSGPacketExt2 = null;
        try {
            mSGPacketExt2 = this.checkAndAddFrameContent(mSGPacketExt);
        }
        catch (Exception exception) {
            mSGPacketExt2 = mSGPacketExt;
            CommHandle.logException(exception);
        }
        if (mSGPacketExt2.length() > this.getMsgMaxLength()) {
            CommHandle.logError("Send failed: message too big! len=" + mSGPacketExt2.length());
            return -1;
        }
        if (this.cmdHandle.get() == 65530) {
            this.cmdHandle.set(1);
        } else {
            this.cmdHandle.getAndAdd(1);
        }
        char c = (char)this.cmdHandle.get();
        Character c2 = Character.valueOf(c);
        if (null != mSGListener) {
            if (this.dispatcher != null) {
                this.dispatcher.addMessageReceiver(c2, mSGListener, mSGPacketExt2.mheader.cmdCode, n);
            } else {
                logger.debug("dispatcher is null");
            }
            if (mSGListener instanceof AppAidedMsgListener) {
                ((AppAidedMsgListener)mSGListener).setCmdHandle(c);
                ((AppAidedMsgListener)mSGListener).setCommHandle(this);
            }
        }
        mSGPacketExt2.mheader.senderCmdHandle = c;
        mSGPacketExt2.mheader.senderDeskID = this.desktopID;
        mSGPacketExt2.mheader.senderProcID = this.procID;
        mSGPacketExt2.mheader.senderProcHandle = this.procHandle;
        CommHandle.logTrace(1, "To socket; Timeout: " + n, mSGPacketExt2.mheader);
        this.out.write(mSGPacketExt2.toByte());
        this.out.flush();
        return (short)c;
    }

    public synchronized short sendAsyncMessage(MSGPacketExt[] mSGPacketExtArray, AppAidedMsgListener appAidedMsgListener, int n) throws IOException {
        char c;
        if (this.state != 1) {
            CommHandle.logError("CommState is abnormal, state=" + this.state);
            throw new IOException();
        }
        if (null == mSGPacketExtArray) {
            throw new IllegalArgumentException("MSGPacketExt is null.");
        }
        MSGPacketExt[] mSGPacketExtArray2 = new MSGPacketExt[mSGPacketExtArray.length];
        for (c = '\u0000'; c < mSGPacketExtArray.length; ++c) {
            try {
                mSGPacketExtArray2[c] = this.checkAndAddFrameContent(mSGPacketExtArray[c]);
            }
            catch (Exception exception) {
                CommHandle.logException(exception);
                mSGPacketExtArray2[c] = mSGPacketExtArray[c];
            }
            if (mSGPacketExtArray2[c].length() <= this.getMsgMaxLength()) continue;
            CommHandle.logError("Send failed: message too big! len=" + mSGPacketExtArray2[c].length());
            return -1;
        }
        if (this.cmdHandle.get() == 65530) {
            this.cmdHandle.set(1);
        } else {
            this.cmdHandle.getAndAdd(1);
        }
        c = (char)this.cmdHandle.get();
        Character c2 = Character.valueOf(c);
        if (null != appAidedMsgListener) {
            if (null != this.dispatcher) {
                this.dispatcher.addMessageReceiver(c2, appAidedMsgListener, 0, n);
            } else {
                logger.debug("dispatcher is null");
            }
            appAidedMsgListener.setCmdHandle(c);
            appAidedMsgListener.setCommHandle(this);
        }
        StringBuffer stringBuffer = null;
        for (int i = 0; i < mSGPacketExtArray2.length; ++i) {
            mSGPacketExtArray2[i].mheader.senderCmdHandle = c;
            mSGPacketExtArray2[i].mheader.senderDeskID = this.desktopID;
            mSGPacketExtArray2[i].mheader.senderProcID = this.procID;
            mSGPacketExtArray2[i].mheader.senderProcHandle = this.procHandle;
            stringBuffer = new StringBuffer("Write multi messages to socket; the number is: ");
            stringBuffer.append(i).append(" of ").append(mSGPacketExtArray2.length).append("Timeout:" + n);
            CommHandle.logTrace(1, stringBuffer.toString(), mSGPacketExtArray2[i].mheader.cmdCode, (short)c);
            this.out.write(mSGPacketExtArray2[i].toByte());
            this.out.flush();
        }
        return (short)c;
    }

    @Override
    public short sendAsyncMessage(MSGHead mSGHead, FStruct fStruct, MSGListener mSGListener) throws FStruException, IOException {
        return this.sendAsyncMessage(mSGHead, fStruct, mSGListener, this.timeout);
    }

    @Override
    public short sendAsyncMessage(MSGHead mSGHead, FStruct fStruct, MSGListener mSGListener, int n) throws FStruException, IOException {
        if (this.state != 1) {
            CommHandle.logError("CommState is abnormal, state=" + this.state);
            throw new IOException();
        }
        MSGPacketExt mSGPacketExt = null;
        try {
            if (null != fStruct) {
                FStruEncoder fStruEncoder = new FStruEncoder();
                fStruct.serialize((Encoder)fStruEncoder);
                fStruEncoder.finish();
                byte[] byArray = fStruEncoder.toByteArray();
                mSGPacketExt = new MSGPacketExt(mSGHead, byArray);
            } else {
                mSGPacketExt = new MSGPacketExt(mSGHead, null);
            }
        }
        catch (FStruException fStruException) {
            CommHandle.logException((Exception)((Object)fStruException));
            return -2;
        }
        return this.sendAsyncMessage(mSGPacketExt, mSGListener, n);
    }

    final void handshake() {
        long l;
        long l2;
        long l3;
        if (null == this.handShakeMsg) {
            this.handShakeMsg = new MSGPacketExt();
            this.handShakeMsg.mheader.senderDeskID = this.desktopID;
            this.handShakeMsg.mheader.receiverDeskID = '\u0000';
            this.handShakeMsg.mheader.senderProcHandle = this.procHandle;
            this.handShakeMsg.mheader.receiverProcHandle = '\u0000';
            this.handShakeMsg.mheader.senderProcID = this.procID;
            this.handShakeMsg.mheader.receiverProcID = (char)2;
            this.handShakeMsg.mheader.msgType = (byte)16;
            this.handShakeMsg.mheader.cmdCode = 0;
            this.handShakeMsg.mheader.senderModule = 0;
            this.handShakeMsg.mheader.receiverModule = 0;
            this.handShakeMsg.mheader.contentLength = 0;
        }
        if ((l3 = (l2 = System.currentTimeMillis()) - (l = this.lastEchoTime)) > 20000L && l3 <= (long)shakeHandTimeOut) {
            try {
                this.sendAsyncMessage(this.handShakeMsg, null);
            }
            catch (IOException iOException) {
                CommHandle.logException(iOException);
                CommHandle.logError("Failed to send shakehand command to server!");
                this.handleError();
            }
        } else if (l3 > (long)shakeHandTimeOut) {
            CommHandle.logError("send shakehand command to server timeout! subTime =" + l3);
            this.handleError();
        }
        if (null != this.handShakeMsg) {
            this.handShakeMsg.mheader = null;
            this.handShakeMsg.clearData();
            this.handShakeMsg = null;
        }
    }

    final void refresh() {
        this.lastEchoTime = System.currentTimeMillis();
    }

    public void handleError() {
        if (this.handleErrorStarted) {
            CommHandle.logTrace("come in handleError, but another thread already start a handleError, here just return.");
            return;
        }
        this.handleErrorStarted = true;
        CommHandle.logTrace("come in handleError, procID = " + this.procID);
        this.state = (byte)-3;
        if (null != this.dispatcher) {
            this.dispatcher.cancelReceivers();
        }
        if (!this.isRegistered) {
            CommHandle.logTrace("The CommHandle isn't registered to mdp yet: " + this);
            this.handleErrorStarted = false;
            return;
        }
        if (!reconnetor.reconnect(this)) {
            CommHandle.logError("Recconnect failed in handleError.");
            this.closeCommHandle();
        } else {
            CommHandle.logTrace("Reconnect success!");
        }
        this.handleErrorStarted = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean reconnect() {
        CommHandle.logError("Initializing reconnet");
        ReconnectCloseLock reconnectCloseLock = this.closeReconnectLock;
        synchronized (reconnectCloseLock) {
            if (this.closed) {
                return false;
            }
        }
        this.stopHandShake();
        this.closeSocket();
        this.isRegistered = false;
        int n = 0;
        ReconnectCloseLock reconnectCloseLock2 = this.closeReconnectLock;
        synchronized (reconnectCloseLock2) {
            if (this.isClosed()) {
                return false;
            }
            if (!this.openSocket(this.hostName, this.hostPort)) {
                return false;
            }
            n = this.registProcess();
            if (n == 0) {
                this.state = 1;
            }
        }
        if (n != 0) {
            this.closeSocket();
            return false;
        }
        this.isRegistered = true;
        this.startHandShake();
        return true;
    }

    public void close() {
        try {
            this.closeCommHandle();
        }
        catch (Exception exception) {
            logger.debug("exception during closeCommHandle");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeCommHandle() {
        CommHandle.logTrace("Initializing close on CommHandle, Proc ID:" + this.procID + ' ' + "ProcHandle:" + this.procHandle + " Desk ID:" + this.desktopID);
        ReconnectCloseLock reconnectCloseLock = this.closeReconnectLock;
        synchronized (reconnectCloseLock) {
            this.closed = true;
            if (this.state == 2) {
                CommHandle.logTrace("CommHandle had been closed");
                return;
            }
            this.state = (byte)2;
            this.stopHandShake();
            this.closeSocket();
            if (null != this.dispatcher) {
                this.dispatcher.close();
                this.dispatcher = null;
            }
            if (null != this.dataAccepter) {
                this.dataAccepter.close();
                this.dataAccepter = null;
            }
            if (null != this.commListener) {
                MSGPacketExt mSGPacketExt = new MSGPacketExt();
                mSGPacketExt.mheader.msgType = (byte)6;
                mSGPacketExt.mheader.cmdCode = 1;
                this.commListener.receiveMessage(mSGPacketExt);
                this.commListener = null;
            }
            this.cmdHandle.set(1);
            if (this.regCount == 0) {
                this.sslConnector = null;
            }
            CommHandle.logTrace("Commhandle Closed successfully!!! Proc ID:" + this.procID);
        }
    }

    public boolean isClosed() {
        return this.state == 2;
    }

    private void stopHandShake() {
        CommHandle.logTrace("Initializing stopHandShake Proc ID:" + this.procID + " ProcHandle:" + this.procHandle + " Desk ID:" + this.desktopID);
        if (null != this.shakeTask && null != this.shakeTimer) {
            this.shakeTask.cancel();
            this.shakeTimer.cancel();
            this.shakeTask.comm = null;
            this.shakeTask = null;
            this.shakeTimer = null;
        }
        CommHandle.logTrace("ShakeHand stopped successfully Proc ID:" + this.procID);
    }

    private void closeSocket() {
        if (null != this.reader) {
            this.reader.close();
            this.reader.exit();
            this.reader = null;
        }
        if (null == this.sslConnector && null != this.socket) {
            try {
                this.socket.shutdownInput();
            }
            catch (IOException iOException) {
                CommHandle.logTrace(iOException.getMessage());
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                CommHandle.logTrace(unsupportedOperationException.getMessage());
            }
            try {
                this.socket.shutdownOutput();
            }
            catch (IOException iOException) {
                CommHandle.logTrace(iOException.getMessage());
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                CommHandle.logTrace(unsupportedOperationException.getMessage());
            }
        }
        if (null != this.socket) {
            try {
                this.socket.close();
            }
            catch (IOException iOException) {
                CommHandle.logTrace(iOException.getMessage());
            }
            this.socket = null;
        }
    }

    public void cancelMessage(MSGSyncReceiver mSGSyncReceiver) {
        if (null == mSGSyncReceiver) {
            throw new IllegalArgumentException("recv is null.");
        }
        mSGSyncReceiver.cancel();
    }

    public void cancelMessage(AppAidedMsgSyncReceiver appAidedMsgSyncReceiver) {
        if (null == appAidedMsgSyncReceiver) {
            throw new IllegalArgumentException("recv is null.");
        }
        appAidedMsgSyncReceiver.cancel();
    }

    @Override
    public void cancelMessageSend(char c) {
        this.cancelAsyncMessage(c);
        CommHandle.logTrace("CommHandle cancelMessageSend, cmdHandle=" + c);
    }

    public void cancelAsyncMessage(char c) {
        if (null != this.dispatcher) {
            this.dispatcher.removeReceiver(Character.valueOf(c));
            this.dispatcher.removeTimeoutItem(Character.valueOf(c));
        } else {
            logger.debug("dispatcher is null");
        }
        CommHandle.logTrace("CommHandle cancelAsyncMessage, cmdHandle=" + c);
    }

    public void cancelAsyncMessage(MSGListener mSGListener) {
        if (null == mSGListener) {
            throw new IllegalArgumentException("listener is null.");
        }
        if (null != this.dispatcher) {
            this.dispatcher.removeReceiver(mSGListener);
        } else {
            logger.debug("dispatcher is null");
        }
        CommHandle.logTrace("CommHandle cancelAsyncMessage, listener:" + mSGListener);
    }

    @Override
    public void removeMessageListener(int n) {
        if (null != this.dispatcher) {
            this.dispatcher.removeMessageListener(n);
        } else {
            logger.debug("dispatcher is null");
        }
    }

    @Override
    public void removeMessageListener(int n, MSGListener mSGListener) {
        if (null != this.dispatcher) {
            this.dispatcher.removeMessageListener(n, mSGListener);
        } else {
            logger.debug("dispatcher is null");
        }
    }

    @Override
    public void addMessageListener(int n, MSGListener mSGListener) {
        if (null != this.dispatcher) {
            this.dispatcher.addMessageListener(n, mSGListener);
        } else {
            logger.debug("dispatcher is null");
        }
    }

    @Override
    public boolean setTimeout(int n) {
        if (n >= 1000) {
            this.timeout = n;
            return true;
        }
        CommHandle.logTrace("Set timeout failed(time<1000): time=" + n);
        return false;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public static void setShakeHandTimeout(int n) {
        shakeHandTimeOut = n * 1000;
    }

    public void setSSLConnector(SSLConnector sSLConnector) {
        if (null == sSLConnector) {
            CommHandle.logTrace(1, "SSLConnector is null.");
            return;
        }
        this.sslConnector = sSLConnector;
        CommHandle.logTrace(1, "SSLConnector is " + sSLConnector.toString());
    }

    public SSLConnector getSSLConnector() {
        return this.sslConnector;
    }

    @Override
    public void setStateListener(CommStateListener commStateListener) {
        this.stateListener = commStateListener;
    }

    public void stateChanged(CommStateEvent commStateEvent) {
        if (null != this.stateListener) {
            this.stateListener.stateChanged(commStateEvent);
        }
    }

    public static void setReconnector(Reconnector reconnector) {
        reconnetor = reconnector;
    }

    public char getDesktopID() {
        return this.desktopID;
    }

    public char getProcHandle() {
        return this.procHandle;
    }

    public int getLastCmdHandle() {
        return this.cmdHandle.get();
    }

    @Override
    public char getNextCommandHandle() {
        return (char)this.cmdHandle.addAndGet(1);
    }

    public int getMsgMaxLength() {
        return this.msgMaxLength;
    }

    final MsgDispatcher getMsgDispatcher() {
        return this.dispatcher;
    }

    static final void setNoTraceCommands(int[] nArray) {
        if (null != nArray && nArray.length > 0) {
            nArray = CommHandle.removeDuplicateFromArray(nArray);
            StringBuffer stringBuffer = new StringBuffer(16);
            stringBuffer.append("User set NoTraceCommands: {");
            for (int i = 0; i < nArray.length; ++i) {
                stringBuffer.append(nArray[i]);
                if (i >= nArray.length - 1) continue;
                stringBuffer.append(", ");
            }
            stringBuffer.append("}");
            CommHandle.logTrace(stringBuffer.toString());
            stringBuffer = null;
        }
        noTraceCommands = nArray;
    }

    static final boolean isNoTraceCommands(int n) {
        if (null != noTraceCommands && noTraceCommands.length > 0) {
            for (int i = 0; i < noTraceCommands.length; ++i) {
                if (noTraceCommands[i] != n) continue;
                return true;
            }
        }
        return false;
    }

    public static void addNoTraceCommands(int[] nArray) {
        if (null != nArray && nArray.length > 0) {
            int[] nArray2 = null;
            if (null != noTraceCommands && noTraceCommands.length > 0) {
                nArray2 = new int[noTraceCommands.length + nArray.length];
                System.arraycopy(noTraceCommands, 0, nArray2, 0, noTraceCommands.length);
                System.arraycopy(nArray, 0, nArray2, noTraceCommands.length, nArray.length);
            } else {
                nArray2 = new int[nArray.length];
                System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
            }
            nArray2 = CommHandle.removeDuplicateFromArray(nArray2);
            StringBuffer stringBuffer = new StringBuffer(16);
            stringBuffer.append("User add NoTraceCommands: {");
            for (int i = 0; i < nArray2.length; ++i) {
                stringBuffer.append(nArray2[i]);
                if (i >= nArray2.length - 1) continue;
                stringBuffer.append(", ");
            }
            stringBuffer.append("}");
            CommHandle.logTrace(stringBuffer.toString());
            stringBuffer = null;
            noTraceCommands = nArray2;
        }
    }

    private static int[] removeDuplicateFromArray(int[] nArray) {
        int n;
        HashSet<Integer> hashSet = new HashSet<Integer>(10);
        int n2 = nArray.length;
        for (n = 0; n < n2; ++n) {
            hashSet.add(nArray[n]);
        }
        Iterator iterator = hashSet.iterator();
        int n3 = hashSet.size();
        int[] nArray2 = new int[n3];
        n = 0;
        while (iterator.hasNext()) {
            nArray2[n++] = (Integer)iterator.next();
        }
        hashSet = null;
        return nArray2;
    }

    public static void setDebugLevel(String string) {
        if (null != string) {
            if (LEVEL_ALL.equalsIgnoreCase(string)) {
                debug_level = 0;
            } else if (LEVEL_TRACE.equalsIgnoreCase(string)) {
                debug_level = 1;
            } else if (LEVEL_WARNING.equalsIgnoreCase(string)) {
                debug_level = 2;
            } else if (LEVEL_ERROR.equalsIgnoreCase(string)) {
                debug_level = 3;
            }
        }
    }

    public static int getDebugLevel() {
        return debug_level;
    }

    public static void logTrace(String string) {
        if (debug && debug_level <= 1) {
            logger.debug(string);
        }
    }

    public static void logTrace(int n, String string) {
        if (debug && debug_level <= n) {
            logger.debug(string);
        }
    }

    static final void logTrace(int n, String string, MSGHead mSGHead) {
        if (debug && debug_level <= n) {
            if (CommHandle.isNoTraceCommands(mSGHead.cmdCode)) {
                return;
            }
            StringBuffer stringBuffer = new StringBuffer(16);
            stringBuffer.append(string);
            stringBuffer.append(" CMD=");
            stringBuffer.append(mSGHead.cmdCode);
            stringBuffer.append("; VER=");
            stringBuffer.append(mSGHead.protocolVer);
            stringBuffer.append("; MSGType= ");
            stringBuffer.append(CommUtil.MessageType.getMsgTypeString(mSGHead.msgType));
            stringBuffer.append("; LEN=");
            stringBuffer.append(mSGHead.contentLength);
            stringBuffer.append("; ERR=");
            stringBuffer.append((int)mSGHead.errCode);
            stringBuffer.append("; FLG=");
            stringBuffer.append(mSGHead.commFlag);
            stringBuffer.append(" [");
            stringBuffer.append("SPID=");
            stringBuffer.append((int)mSGHead.senderProcID);
            stringBuffer.append("; SCH=");
            stringBuffer.append((int)mSGHead.senderCmdHandle);
            stringBuffer.append("; SPH=");
            stringBuffer.append((int)mSGHead.senderProcHandle);
            stringBuffer.append("; SM=");
            stringBuffer.append(mSGHead.senderModule);
            stringBuffer.append("]");
            stringBuffer.append(" [");
            stringBuffer.append("RPID=");
            stringBuffer.append((int)mSGHead.receiverProcID);
            stringBuffer.append("; RCH=");
            stringBuffer.append((int)mSGHead.cmdHandle);
            stringBuffer.append("; RPH=");
            stringBuffer.append((int)mSGHead.receiverProcHandle);
            stringBuffer.append("; RM=");
            stringBuffer.append(mSGHead.receiverModule);
            stringBuffer.append("]");
            logger.debug(stringBuffer.toString());
        }
    }

    public static void logError(String string) {
        if (debug && debug_level <= 3) {
            logger.error(string);
        }
    }

    public static void logException(Exception exception) {
        CommHandle.logException(4, exception);
    }

    public static void logException(int n, Exception exception) {
        if (debug && debug_level <= n) {
            logger.debug(exception);
        }
    }

    static final void logTrace(int n, String string, MSGPacketExt mSGPacketExt) {
        if (debug && debug_level <= n) {
            if (CommHandle.isNoTraceCommands(mSGPacketExt.mheader.cmdCode)) {
                return;
            }
            StringBuffer stringBuffer = new StringBuffer(16);
            stringBuffer.append(string);
            stringBuffer.append(" cmdCode=");
            stringBuffer.append(mSGPacketExt.mheader.cmdCode);
            stringBuffer.append("; cmdHandle=");
            stringBuffer.append((int)mSGPacketExt.mheader.cmdHandle);
            stringBuffer.append("; msgType=");
            stringBuffer.append(mSGPacketExt.mheader.msgType);
            stringBuffer.append("; contentLength=");
            stringBuffer.append(mSGPacketExt.dataLength);
            logger.debug(stringBuffer.toString());
        }
    }

    static final void logTrace(String string, MSGPacketExt mSGPacketExt, int n) {
        if (debug && debug_level <= n) {
            if (CommHandle.isNoTraceCommands(mSGPacketExt.mheader.cmdCode)) {
                return;
            }
            StringBuffer stringBuffer = new StringBuffer(16);
            stringBuffer.append(string);
            stringBuffer.append(" cmdCode=");
            stringBuffer.append(mSGPacketExt.mheader.cmdCode);
            stringBuffer.append("; cmdHandle=");
            stringBuffer.append((int)mSGPacketExt.mheader.cmdHandle);
            stringBuffer.append("; msgType=");
            stringBuffer.append(mSGPacketExt.mheader.msgType);
            stringBuffer.append("; contentLength=");
            stringBuffer.append(mSGPacketExt.dataLength);
            logger.debug(stringBuffer.toString());
        }
    }

    static final void logTrace(int n, String string, int n2, int n3) {
        if (debug && debug_level <= n) {
            if (CommHandle.isNoTraceCommands(n2)) {
                return;
            }
            StringBuffer stringBuffer = new StringBuffer(16);
            stringBuffer.append(string);
            stringBuffer.append(" cmdCode=");
            stringBuffer.append(n2);
            stringBuffer.append(", cmdHandle=");
            stringBuffer.append(n3);
            logger.debug(stringBuffer.toString());
        }
    }

    static final void logErrCode(int n, String string, MSGPacketExt mSGPacketExt) {
        if (debug && debug_level <= n) {
            StringBuffer stringBuffer = new StringBuffer(16);
            stringBuffer.append(string);
            stringBuffer.append(" errCode=");
            stringBuffer.append((int)mSGPacketExt.mheader.errCode);
            stringBuffer.append(", cmdHandle=");
            stringBuffer.append((int)mSGPacketExt.mheader.cmdHandle);
            logger.debug(stringBuffer.toString());
        }
    }

    private class ReconnectCloseLock {
        private ReconnectCloseLock() {
        }
    }

    private static class ContentBlock {
        private byte[] contentBytes = null;
        private byte type = 0;

        ContentBlock(byte[] byArray, byte by) {
            if (byArray != null) {
                this.contentBytes = new byte[byArray.length];
                System.arraycopy(byArray, 0, this.contentBytes, 0, byArray.length);
                this.type = by;
            }
        }

        public byte[] toBytes() {
            byte[] byArray = new byte[this.contentBytes.length + 2];
            System.arraycopy(this.contentBytes, 0, byArray, 0, this.contentBytes.length);
            byArray[this.contentBytes.length] = (byte)(this.contentBytes.length & 0xFFFFFFFF);
            byArray[this.contentBytes.length + 1] = this.type;
            return byArray;
        }
    }
}

