/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.communicate;

import com.swimap.iview.communicate.AppAidedMsgListener;
import com.swimap.iview.communicate.CommHandle;
import com.swimap.iview.communicate.CommUtil;
import com.swimap.iview.communicate.MSGPacketExt;
import com.swimap.iview.communicate.TimeoutPacket;
import java.util.ArrayList;

public class AppAidedMsgSyncReceiver
extends AppAidedMsgListener
implements Runnable {
    private Thread thread = null;
    private ArrayList buf = new ArrayList(10);
    private volatile boolean running = true;
    private int flag = 1;
    private int msgProcessed = 0;

    public AppAidedMsgSyncReceiver() {
        this.thread = new Thread(this);
        this.thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        Object var1_1 = null;
        try {
            while (this.running) {
                ArrayList arrayList = this.buf;
                synchronized (arrayList) {
                    while (this.buf.size() <= this.msgProcessed) {
                        if (!this.running) {
                            throw new InterruptedException("Interrupting the receiver thread");
                        }
                        this.buf.wait();
                    }
                    var1_1 = this.buf.get(this.msgProcessed);
                }
                if (!this.processPacket(var1_1)) continue;
                break;
            }
        }
        catch (InterruptedException interruptedException) {
            CommHandle.logTrace(this.getClass().getName() + " is interrupted.");
            CommHandle.logException(interruptedException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void close() {
        this.running = false;
        if (this.buf != null) {
            ArrayList arrayList = this.buf;
            synchronized (arrayList) {
                this.buf.clear();
                this.buf.notifyAll();
            }
        }
        this.thread.interrupt();
        this.thread = null;
        CommHandle.logTrace("AppAidedMsgSyncReceiver thread closed: " + this);
    }

    public void reset() {
        this.notifyReceiver(1);
        this.buf.clear();
        this.msgProcessed = 0;
        CommHandle.logTrace("AppAidedMsgSyncReceiver is reset: " + this);
    }

    final void cancel() {
        if (this.flag != 2) {
            CommHandle.logTrace("AppAidedMsgSyncReceiver cancel failed! flag=" + this.flag);
            return;
        }
        this.notifyReceiver(3);
        this.buf.clear();
        this.msgProcessed = 0;
        CommHandle.logTrace("AppAidedMsgSyncReceiver is canceled: " + this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean receiveMessage(MSGPacketExt mSGPacketExt) {
        if (mSGPacketExt != null && this.buf != null) {
            CommHandle.logTrace(0, "AppAidedMsgSyncReceiver.receiveMessage", mSGPacketExt);
            if (this.isValidPacket(mSGPacketExt)) {
                ArrayList arrayList = this.buf;
                synchronized (arrayList) {
                    this.buf.add(mSGPacketExt);
                    this.buf.notifyAll();
                }
                return false;
            }
            return true;
        }
        CommHandle.logTrace(1, "AppAidedMsgSyncReceiver.receiveMessage, msg or buf is null");
        return true;
    }

    private boolean isValidPacket(MSGPacketExt mSGPacketExt) {
        int n = CommUtil.checkValidPacket(mSGPacketExt);
        if (n == Integer.MIN_VALUE) {
            return true;
        }
        this.notifyReceiver(n);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processPacket(Object object) {
        if (object instanceof MSGPacketExt) {
            MSGPacketExt mSGPacketExt = (MSGPacketExt)object;
            CommHandle.logTrace(1, "AppAidedMsgSyncReceiver processMessage in: ", mSGPacketExt);
            boolean bl = this.processMessage(mSGPacketExt);
            CommHandle.logTrace(1, "AppAidedMsgSyncReceiver processMessage out: isProcessFinish = " + bl, mSGPacketExt);
            ++this.msgProcessed;
            if (bl) {
                this.notifyFinish();
                this.clearTimeoutPacket();
                this.notifyReceiver(0);
                return true;
            }
        } else if (object == TimeoutPacket.FLAG) {
            ArrayList arrayList = this.buf;
            synchronized (arrayList) {
                this.buf.remove(this.msgProcessed);
            }
            CommHandle.logTrace(1, "AppAidedMsgSyncReceiver handleTimeout in");
            int n = this.handleTimeout();
            CommHandle.logTrace(1, "AppAidedMsgSyncReceiver handleTimeout out: result = " + n);
            if (n < 0) {
                this.notifyFinish();
                this.notifyReceiver(-1);
                return true;
            }
            if (n > 0) {
                this.refreshTimeoutValue(n);
            }
        }
        return false;
    }

    private synchronized void notifyReceiver(int n) {
        this.flag = n;
        this.notifyAll();
    }

    @Override
    protected boolean processMessage(MSGPacketExt mSGPacketExt) {
        return true;
    }

    @Override
    protected int handleTimeout() {
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final void addTimeoutPacket() {
        if (this.buf != null) {
            ArrayList arrayList = this.buf;
            synchronized (arrayList) {
                this.buf.add(TimeoutPacket.FLAG);
                this.buf.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearTimeoutPacket() {
        if (this.buf == null) {
            return;
        }
        int n = this.buf.size();
        if (this.msgProcessed < n) {
            ArrayList arrayList = this.buf;
            synchronized (arrayList) {
                for (int i = this.msgProcessed; i < n; ++i) {
                    this.buf.remove(i);
                }
            }
        }
    }

    public final MSGPacketExt[] getResults() {
        int n;
        if (this.buf != null && (n = this.buf.size()) > 0) {
            MSGPacketExt[] mSGPacketExtArray = new MSGPacketExt[n];
            this.buf.toArray(mSGPacketExtArray);
            return mSGPacketExtArray;
        }
        return null;
    }

    public final MSGPacketExt getResult() {
        if (this.buf != null && this.buf.size() > 0) {
            return (MSGPacketExt)this.buf.get(0);
        }
        return null;
    }

    public void setFlag(int n) {
        this.flag = n;
    }

    public int getFlag() {
        return this.flag;
    }
}

