/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.communicate;

import com.swimap.iview.communicate.AppAidedMsgListener;
import com.swimap.iview.communicate.CommHandle;
import com.swimap.iview.communicate.CommUtil;
import com.swimap.iview.communicate.MSGPacketExt;
import com.swimap.iview.communicate.TimeoutPacket;
import java.util.ArrayList;

public abstract class AppAidedMsgReceiver
extends AppAidedMsgListener
implements Runnable {
    private Thread thread = null;
    private ArrayList buf = new ArrayList(10);
    private volatile boolean running = true;

    public AppAidedMsgReceiver() {
        this.thread = new Thread(this);
        this.thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        Object var1_1 = null;
        try {
            while (this.running) {
                ArrayList arrayList = this.buf;
                synchronized (arrayList) {
                    while (this.buf.isEmpty()) {
                        if (!this.running) {
                            throw new InterruptedException("Interrupting the receiver thread");
                        }
                        this.buf.wait();
                    }
                    var1_1 = this.buf.remove(0);
                }
                if (!this.processPacket(var1_1)) continue;
                this.notifyFinish();
                var1_1 = null;
                this.close();
                break;
            }
        }
        catch (InterruptedException interruptedException) {
            CommHandle.logTrace(this.getClass().getName() + " is interrupted.");
            CommHandle.logException(interruptedException);
        }
        if (this.buf != null) {
            this.buf.clear();
            this.buf = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void close() {
        this.running = false;
        if (this.buf != null) {
            ArrayList arrayList = this.buf;
            synchronized (arrayList) {
                this.buf.clear();
                this.buf.notifyAll();
            }
        }
        this.thread.interrupt();
        this.thread = null;
        CommHandle.logTrace("AppAidedMsgReceiver thread closed: " + this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean receiveMessage(MSGPacketExt mSGPacketExt) {
        if (mSGPacketExt != null && this.buf != null) {
            CommHandle.logTrace(0, "AppAidedMsgReceiver.receiveMessage", mSGPacketExt);
            if (this.isValidPacket(mSGPacketExt) || this.isDispatchInvalidPacket()) {
                ArrayList arrayList = this.buf;
                synchronized (arrayList) {
                    this.buf.add(mSGPacketExt);
                    this.buf.notifyAll();
                }
            }
            return false;
        }
        CommHandle.logTrace(1, "AppAidedMsgReceiver.receiveMessage, msg or buf is null");
        return true;
    }

    private boolean isValidPacket(MSGPacketExt mSGPacketExt) {
        int n = CommUtil.checkValidPacket(mSGPacketExt);
        return n == Integer.MIN_VALUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final void addTimeoutPacket() {
        if (this.buf != null) {
            ArrayList arrayList = this.buf;
            synchronized (arrayList) {
                this.buf.add(TimeoutPacket.FLAG);
                this.buf.notifyAll();
            }
        }
    }

    private boolean processPacket(Object object) {
        if (object instanceof MSGPacketExt) {
            MSGPacketExt mSGPacketExt = (MSGPacketExt)object;
            CommHandle.logTrace(1, "AppAidedMsgReceiver processMessage in: ", mSGPacketExt);
            boolean bl = this.processMessage(mSGPacketExt);
            CommHandle.logTrace(1, "AppAidedMsgReceiver processMessage out: isProcessFinish = " + bl, mSGPacketExt);
            if (bl) {
                return true;
            }
        } else if (object == TimeoutPacket.FLAG) {
            CommHandle.logTrace(1, "AppAidedMsgReceiver handleTimeout in");
            int n = this.handleTimeout();
            CommHandle.logTrace(1, "AppAidedMsgReceiver.handleTimeout out: result = " + n);
            if (n < 0) {
                return true;
            }
            if (n > 0) {
                this.refreshTimeoutValue(n);
            }
        }
        return false;
    }

    protected boolean isDispatchInvalidPacket() {
        return false;
    }
}

