/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.commstyle.utils;

import com.swimap.iview.commstyle.commini.CommStyleManager;
import com.swimap.iview.commstyle.utils.UpdateInformation;
import com.swimap.iview.commstyle.utils.UpdateList;
import com.swimap.iview.framework.pluginmanagement.PluginUtil;
import com.swimap.iview.util.CommonUtil;
import com.swimap.iview.util.DebugTracer;
import com.swimap.iview.util.log.IviewLogger;
import com.swimap.startup.StartupClassLoader;
import java.io.File;
import java.io.FileFilter;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.util.Arrays;
import java.util.Vector;

public class UpdateTool {
    private static IviewLogger logger = IviewLogger.getLogger(UpdateTool.class, "IVIEW");
    public static String[] extPaths = UpdateTool.getExtPath();
    private static final String FRAMEWORK_UPDATE_FILE = "conf/mainfrm/updateclient";
    private static String _oldWorkingDir = null;
    private static String _newWorkingDir = null;
    private static FileFilter pathFilter = new FileFilter(){

        @Override
        public boolean accept(File file) {
            return file.isDirectory() && file.getName().indexOf("ext_") == 0;
        }
    };
    private static FileFilter pluginFilter = new FileFilter(){

        @Override
        public boolean accept(File file) {
            return file.isDirectory() || file.getName().endsWith(".jar");
        }
    };

    public static String getOldWorkingDir() {
        return _oldWorkingDir;
    }

    public static String getNewWorkingDir() {
        return _newWorkingDir;
    }

    private static void deleteSerializableFiles(String string) {
        String string2 = string + "/configuration/Serializable";
        File file = new File(string2);
        if (file.exists() && file.isDirectory()) {
            File[] fileArray;
            for (File file2 : fileArray = file.listFiles()) {
                file2.delete();
            }
            file.delete();
        }
    }

    public static void startUpdate(String string, String string2) {
        UpdateTool.deleteSerializableFiles(string2);
        UpdateTool.deleteGuisavedInforamtion(string);
        UpdateTool.loadJars();
        String[] stringArray = new String[]{"-debuglevel", "1", "-showtrace", "false", "-enabledebug", "true", "-tracefile", "UpdateTrace.txt"};
        DebugTracer.identifyDebugParam(stringArray);
        logger.trace("old working dir:" + string);
        logger.trace("new working dir:" + string2);
        _oldWorkingDir = string.endsWith("/") || string.endsWith("\\") ? string : string + '/';
        _newWorkingDir = string2.endsWith("/") || string2.endsWith("\\") ? string2 : string2 + '/';
        UpdateTool.loadUpdateFiles();
    }

    public static String getOldFileName() {
        return _oldWorkingDir;
    }

    private static void loadUpdateFiles() {
        Vector vector;
        String[] stringArray;
        UpdateList updateList = UpdateList.loadUpdateList(FRAMEWORK_UPDATE_FILE, false);
        if (null == updateList) {
            updateList = new UpdateList();
        }
        if (null != extPaths && extPaths.length > 0) {
            for (int i = 0; i < extPaths.length; ++i) {
                updateList.loadExtUpdateList("conf/" + extPaths[i] + "/updateclient", false);
            }
        }
        if (null != (stringArray = UpdateTool.getPluginPath()) && stringArray.length > 0) {
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                updateList.loadExtUpdateList(stringArray[i], true);
            }
        }
        if ((vector = updateList.getUpdateList()) != null && vector.size() > 0) {
            UpdateInformation updateInformation = null;
            String string = null;
            String string2 = null;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                updateInformation = (UpdateInformation)vector.elementAt(i);
                string = updateInformation.getClassName();
                string2 = updateInformation.getMethodName();
                UpdateTool.update(string, string2);
            }
        }
    }

    private static void update(String string, String string2) {
        logger.trace("Start to invoke: " + string + '.' + string2);
        try {
            Class<?> clazz = Class.forName(string);
            Object obj = clazz.newInstance();
            Method method = clazz.getMethod(string2, null);
            method.invoke(obj, null);
        }
        catch (Exception exception) {
            logger.trace(exception.getMessage(), exception);
            logger.trace("Failed to invoke: " + string + '.' + string2);
            return;
        }
        logger.trace("Succeed to invoke: " + string + '.' + string2);
    }

    public static String[] getExtPath() {
        File[] fileArray;
        File file = CommonUtil.getAbsoluteFile("style/defaultstyle/conf/");
        if (file.exists() && (fileArray = file.listFiles(pathFilter)) != null && fileArray.length > 0) {
            Object[] objectArray = new String[fileArray.length];
            for (int i = 0; i < fileArray.length; ++i) {
                objectArray[i] = fileArray[i].getName();
            }
            Arrays.sort(objectArray);
            return objectArray;
        }
        return new String[0];
    }

    private static String[] getPluginPath() {
        File[] fileArray;
        File file = CommonUtil.getAbsoluteFile(UpdateTool.getNewWorkingDir() + "/plugins");
        String[] stringArray = new String[]{};
        if (file.exists() && null != (fileArray = file.listFiles(pluginFilter)) && fileArray.length > 0) {
            int n = fileArray.length;
            stringArray = new String[n];
            for (int i = 0; i < n; ++i) {
                try {
                    String string = fileArray[i].toURL().toString();
                    if (string.endsWith(".jar")) {
                        stringArray[i] = PluginUtil.jarPathToJarURL(string, "style/conf/updateclient.xml").toString();
                        continue;
                    }
                    stringArray[i] = string.concat("style/conf/updateclient.xml");
                    continue;
                }
                catch (MalformedURLException malformedURLException) {
                    logger.trace("MalformedURLException in getPluginPath :" + fileArray[i]);
                }
            }
        }
        return stringArray;
    }

    private static void loadJars() {
        File[] fileArray;
        StartupClassLoader startupClassLoader = StartupClassLoader.createInstance();
        File file = CommonUtil.getAbsoluteFile(UpdateTool.getNewWorkingDir() + "/plugins");
        if (file.exists() && null != (fileArray = file.listFiles(pluginFilter)) && fileArray.length > 0) {
            startupClassLoader.installPlugins(fileArray, false);
        }
    }

    private static void deleteGuisavedInforamtion(String string) {
        String string2 = string + CommStyleManager.getInstance().getUserDir() + "GUIstyle/";
        File file = new File(string2);
        if (null == file) {
            return;
        }
        UpdateTool.deleteRecursive(file);
        boolean bl = file.mkdir();
        if (!bl) {
            logger.trace("GUI directory is not cretaed");
        }
    }

    private static void deleteRecursive(File file) {
        File[] fileArray = file.listFiles();
        if (null == fileArray) {
            return;
        }
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        for (File file2 : fileArray) {
            if (file2.isDirectory()) {
                UpdateTool.deleteRecursive(file2);
                bl2 = file2.delete();
                if (bl2) continue;
                logger.trace("GUI saveInformation is not deleted");
                continue;
            }
            bl = file2.delete();
            if (bl) continue;
            logger.trace("GUI saveInformation is not deleted");
        }
        bl3 = file.delete();
        if (!bl3) {
            logger.trace("GUI directory is not deleted");
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray.length < 2) {
            logger.trace("java com.swimap.iview.commstyle.utils.UpdateTool <oldWorkingDir> <newWorkingDir>");
            return;
        }
        UpdateTool.startUpdate(stringArray[0], stringArray[1]);
    }
}

