/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.commstyle.utils;

import com.swimap.iview.commstyle.commini.AreaDescContainer;
import com.swimap.iview.commstyle.commini.CommStyleInfo;
import com.swimap.iview.commstyle.commini.CommStyleManager;
import com.swimap.iview.commstyle.commini.DescContainer;
import com.swimap.iview.commstyle.utils.UpdateInformation;
import com.swimap.iview.util.log.IviewLogger;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Vector;

public class UpdateList {
    private static IviewLogger logger = IviewLogger.getLogger(UpdateList.class, "IVIEW");
    public static final String UPDATELIST_DESC = "updatelist";
    private static ArrayList updateClassNameList = new ArrayList(20);
    private Vector updateInformations = new Vector();

    public Vector getUpdateList() {
        return this.updateInformations;
    }

    static UpdateList loadUpdateList(String string, boolean bl) {
        CommStyleInfo commStyleInfo = null;
        if (bl) {
            try {
                commStyleInfo = CommStyleManager.getInstance().getStyleInfoFromURL(new URL(string));
            }
            catch (MalformedURLException malformedURLException) {
                logger.trace("MalformedURLException in loadUpdateList :" + string);
            }
        } else {
            commStyleInfo = CommStyleManager.getInstance().getCommonStyleFile(string);
        }
        if (null == commStyleInfo) {
            return null;
        }
        logger.trace("Start to load update file:" + string);
        AreaDescContainer areaDescContainer = commStyleInfo.getAreaDescContainer(UPDATELIST_DESC);
        if (null == areaDescContainer) {
            logger.trace(" The update list area no be found in style file.");
            return null;
        }
        UpdateInformation updateInformation = null;
        UpdateList updateList = new UpdateList();
        int n = areaDescContainer.getDescCount();
        DescContainer descContainer = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        for (int i = 0; i < n; ++i) {
            descContainer = areaDescContainer.getDescContainer(i);
            string2 = descContainer.getParasItem("ClassName").getValue();
            if (updateClassNameList.contains(string2)) {
                logger.trace("Class " + string2 + " has been loaded.");
                continue;
            }
            string3 = descContainer.getParasItem("MethodName").getValue();
            int n2 = -1;
            string4 = descContainer.getParasItemValue("serialnumber");
            if (string4 != null && string4.length() > 0) {
                try {
                    n2 = Integer.parseInt(string4);
                }
                catch (Exception exception) {
                    logger.trace("The update desc in style file is error, the desc name is :" + descContainer.getDescName());
                }
            }
            updateInformation = new UpdateInformation(string2, string3, n2);
            updateList.addUpdateInformation(updateInformation);
            updateClassNameList.add(string2);
        }
        logger.trace("Succeed to load update file:" + string);
        return updateList;
    }

    void loadExtUpdateList(String string, boolean bl) {
        UpdateList updateList = UpdateList.loadUpdateList(string, bl);
        if (updateList != null) {
            Vector vector = updateList.getUpdateList();
            this.addAllUpdateInformation(vector);
        }
    }

    private void addUpdateInformation(UpdateInformation updateInformation) {
        int n = this.getInsertPos(updateInformation);
        if (n < this.updateInformations.size()) {
            this.updateInformations.insertElementAt(updateInformation, n);
        } else {
            this.updateInformations.add(updateInformation);
        }
    }

    void addAllUpdateInformation(Vector vector) {
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            this.addUpdateInformation((UpdateInformation)vector.elementAt(i));
        }
    }

    private int getInsertPos(UpdateInformation updateInformation) {
        int n = updateInformation.getSerialNo();
        if (n == -1) {
            return this.updateInformations.size();
        }
        int n2 = 0;
        UpdateInformation updateInformation2 = null;
        int n3 = this.updateInformations.size();
        for (n2 = 0; n2 < n3; ++n2) {
            updateInformation2 = (UpdateInformation)this.updateInformations.elementAt(n2);
            if (updateInformation2.getSerialNo() <= n) continue;
            return n2;
        }
        return n2;
    }
}

