/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.commstyle.utils;

import com.swimap.iview.commstyle.commini.CommStyleInfo;
import com.swimap.iview.commstyle.commini.CommStyleManager;
import com.swimap.iview.commstyle.resource.i18n.ResourceUtil;
import com.swimap.iview.commstyle.utils.MergeUtil;
import com.swimap.iview.commstyle.utils.UpdateTool;
import com.swimap.iview.util.CommonUtil;
import com.swimap.iview.util.log.IviewLogger;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class PluginMergeHandler {
    private static IviewLogger logger = IviewLogger.getLogger(PluginMergeHandler.class, "IVIEW");
    private String pluginFolderName = null;
    private String userFolderName = null;
    private static final String SEPARATOR = File.separator;
    private static final String CONF = "conf/";
    private static final String INTEGRATE = "integrate/";
    private static final String JAR = "jar:file:/";
    private static final String PRODUCT_STYLE = "/style/productstyle/";
    private static final String PLUGIN = "/plugins";
    private boolean isR9Updation = false;
    private static FileFilter filter = new FileFilter(){

        @Override
        public boolean accept(File file) {
            return file.isDirectory() || file.getName().endsWith(".jar");
        }
    };

    public PluginMergeHandler(String string) {
        this(string, string);
        this.isR9Updation = true;
    }

    public PluginMergeHandler(String string, String string2) {
        this.pluginFolderName = string;
        this.userFolderName = string2;
    }

    public void mergeToUser(String string) {
        this.mergeUser(string, CONF);
    }

    public void mergeToAllUser(String string) {
        this.mergeAllUser(string, CONF);
    }

    public void mergeToUser(String string, String string2) {
        String string3 = string2;
        string3 = INTEGRATE + string3 + SEPARATOR;
        this.mergeUser(string, string3);
    }

    public void mergeToAllUser(String string, String string2) {
        String string3 = string2;
        string3 = INTEGRATE + string3 + SEPARATOR;
        this.mergeAllUser(string, string3);
    }

    private void mergeUser(String string, String string2) {
        File file = CommonUtil.getAbsoluteFile(MergeUtil._oldUserAbsDir);
        File[] fileArray = file.listFiles(filter);
        if (null == fileArray || fileArray.length == 0) {
            return;
        }
        String string3 = null;
        File file2 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        File file3 = null;
        File file4 = null;
        CommStyleInfo commStyleInfo = null;
        String string7 = null;
        int n = fileArray.length;
        for (int i = 0; i < n; ++i) {
            CommStyleInfo commStyleInfo2;
            int n2;
            string3 = MergeUtil.filterPath(fileArray[i].getAbsolutePath());
            file2 = CommonUtil.getAbsoluteFile(string3);
            string4 = MergeUtil.filterPath(file2.getAbsolutePath()) + string;
            string5 = MergeUtil.getUserName(string4);
            string6 = this.isR9Updation ? MergeUtil._oldUserAbsDir + string5 + string2 + this.userFolderName + SEPARATOR + string : MergeUtil._oldUserAbsDir + string5 + CONF + this.userFolderName + SEPARATOR + string;
            file3 = CommonUtil.getAbsoluteFile(string6);
            if (!file3.exists() || null == (commStyleInfo = CommStyleManager.getInstance().getAbsCommStyleFile(string6))) continue;
            string7 = MergeUtil._newUserAbsDir + string5 + string2 + this.pluginFolderName + SEPARATOR + string;
            file4 = CommonUtil.getAbsoluteFile(string7);
            if (!file4.exists() && !(file4 = new File(string7)).getParentFile().exists()) {
                file4.getParentFile().mkdirs();
            }
            if ((n2 = this.checkJarFile()) != 0 && null != (commStyleInfo2 = this.mergeProductWithDefault(string2, string, n2))) {
                commStyleInfo = MergeUtil.merge(commStyleInfo2, commStyleInfo, false);
            }
            commStyleInfo.writeStyle(string7, false);
        }
    }

    private void mergeAllUser(String string, String string2) {
        CommStyleInfo commStyleInfo;
        int n;
        File file = CommonUtil.getAbsoluteFile(MergeUtil._oldAllUserAbsDir);
        File[] fileArray = file.listFiles(filter);
        if (null == fileArray || fileArray.length == 0) {
            return;
        }
        String string3 = null;
        string3 = this.isR9Updation ? MergeUtil._oldAllUserAbsDir + string2 + this.userFolderName + SEPARATOR + string : MergeUtil._oldAllUserAbsDir + CONF + this.userFolderName + SEPARATOR + string;
        File file2 = CommonUtil.getAbsoluteFile(string3);
        if (!file2.exists()) {
            return;
        }
        CommStyleInfo commStyleInfo2 = CommStyleManager.getInstance().getAbsCommStyleFile(string3);
        if (null == commStyleInfo2) {
            return;
        }
        String string4 = MergeUtil._newAllUserAbsDir + string2 + this.pluginFolderName + SEPARATOR + string;
        File file3 = CommonUtil.getAbsoluteFile(string4);
        if (!file3.exists() && !(file3 = new File(string4)).getParentFile().exists()) {
            file3.getParentFile().mkdirs();
        }
        if ((n = this.checkJarFile()) != 0 && null != (commStyleInfo = this.mergeProductWithDefault(string2, string, n))) {
            commStyleInfo2 = MergeUtil.merge(commStyleInfo, commStyleInfo2, false);
        }
        commStyleInfo2.writeStyle(string4, false);
    }

    private CommStyleInfo checkMergeProductMode(String string, String string2) {
        CommStyleInfo commStyleInfo = null;
        String[] stringArray = PluginMergeHandler.getPlugins();
        int n = stringArray.length;
        CommStyleInfo commStyleInfo2 = null;
        String string3 = null;
        for (int i = 0; i < n; ++i) {
            if (stringArray[i].endsWith(".jar")) {
                commStyleInfo2 = this.getProductStyleFromJar(stringArray[i], string, string2);
            } else {
                string3 = UpdateTool.getNewWorkingDir() + PLUGIN + SEPARATOR + stringArray[i] + PRODUCT_STYLE;
                File file = new File(string3);
                if (file.exists()) {
                    String[] stringArray2 = file.list();
                    int n2 = stringArray2.length;
                    for (int j = 0; j < n2; ++j) {
                        if (!ResourceUtil.areEquals(stringArray2[j], this.pluginFolderName)) continue;
                        commStyleInfo2 = CommStyleManager.getInstance().getAbsCommStyleFile(string3 + this.pluginFolderName + SEPARATOR + string2 + string);
                    }
                }
            }
            if (null != commStyleInfo2) {
                if (null != commStyleInfo) {
                    commStyleInfo2 = MergeUtil.merge(commStyleInfo, commStyleInfo2, true);
                }
                commStyleInfo = commStyleInfo2;
            }
            commStyleInfo2 = null;
            string3 = null;
        }
        return commStyleInfo;
    }

    private int checkJarFile() {
        int n = 0;
        String[] stringArray = PluginMergeHandler.getPlugins();
        int n2 = stringArray.length;
        if (n2 > 0) {
            for (int i = 0; i < n2; ++i) {
                if (ResourceUtil.areEquals(stringArray[i], this.pluginFolderName + ".jar")) {
                    n = 1;
                    break;
                }
                if (!ResourceUtil.areEquals(stringArray[i], this.pluginFolderName)) continue;
                n = 2;
                break;
            }
        }
        return n;
    }

    private static String[] getPlugins() {
        File[] fileArray;
        File file = CommonUtil.getAbsoluteFile(UpdateTool.getNewWorkingDir() + PLUGIN);
        String[] stringArray = new String[]{};
        if (file.exists() && null != (fileArray = file.listFiles(filter)) && fileArray.length > 0) {
            int n = fileArray.length;
            stringArray = new String[n];
            for (int i = 0; i < n; ++i) {
                stringArray[i] = fileArray[i].getName();
            }
        }
        return stringArray;
    }

    private CommStyleInfo getDefaultStyleInfo(String string, String string2, int n) {
        CommStyleInfo commStyleInfo = null;
        String string3 = UpdateTool.getNewWorkingDir() + "plugins" + SEPARATOR + this.pluginFolderName + SEPARATOR;
        String string4 = "style/" + string + string2;
        if (1 == n) {
            String string5 = JAR + string3 + ".jar!/" + string4;
            if (string5.indexOf(92) != -1) {
                string5 = string5.replace('\\', '/');
            }
            try {
                commStyleInfo = CommStyleManager.getInstance().getStyleInfoFromURL(new URL(string5));
            }
            catch (MalformedURLException malformedURLException) {
                logger.trace("MalformedURLException in getProductStyleFromJar for file :" + string5);
            }
        } else {
            String string6 = string3 + string4;
            commStyleInfo = CommStyleManager.getInstance().getAbsCommStyleFile(string6);
        }
        return commStyleInfo;
    }

    private CommStyleInfo mergeProductWithDefault(String string, String string2, int n) {
        CommStyleInfo commStyleInfo = this.getDefaultStyleInfo(string, string2, n);
        CommStyleInfo commStyleInfo2 = this.checkMergeProductMode(string2, string);
        CommStyleInfo commStyleInfo3 = null;
        if (null == commStyleInfo2 && null != commStyleInfo) {
            commStyleInfo3 = commStyleInfo;
        } else if (null == commStyleInfo && null != commStyleInfo2) {
            commStyleInfo3 = commStyleInfo2;
        } else if (null != commStyleInfo2 && null != commStyleInfo) {
            commStyleInfo3 = MergeUtil.merge(commStyleInfo, commStyleInfo2, false);
        }
        return commStyleInfo3;
    }

    private CommStyleInfo getProductStyleFromJar(String string, String string2, String string3) {
        CommStyleInfo commStyleInfo = null;
        String string4 = UpdateTool.getNewWorkingDir() + "plugins" + SEPARATOR + string;
        String string5 = PRODUCT_STYLE + this.pluginFolderName + SEPARATOR + string3 + string2;
        String string6 = JAR + string4 + '!' + string5;
        if (-1 != string6.indexOf(92)) {
            string6 = string6.replace('\\', '/');
        }
        URL uRL = null;
        try {
            uRL = new URL(string6);
        }
        catch (MalformedURLException malformedURLException) {
            logger.trace(malformedURLException.getMessage() + string6);
        }
        JarFile jarFile = null;
        try {
            jarFile = new JarFile(string4);
        }
        catch (IOException iOException) {
            logger.trace("I/O Error in getProductStyleFromJar for plugin :" + string);
            return commStyleInfo;
        }
        string5 = string5.replace('\\', '/');
        JarEntry jarEntry = null;
        String string7 = null;
        Enumeration<JarEntry> enumeration = jarFile.entries();
        while (enumeration.hasMoreElements()) {
            jarEntry = enumeration.nextElement();
            string7 = '/' + jarEntry.getName();
            if (!ResourceUtil.areEquals(string7, string5)) continue;
            commStyleInfo = CommStyleManager.getInstance().getStyleInfoFromURL(uRL);
            break;
        }
        try {
            jarFile.close();
        }
        catch (IOException iOException) {
            logger.trace("I/O Error while closing stream");
        }
        return commStyleInfo;
    }

    public String getPluginFolderName() {
        return this.pluginFolderName;
    }

    public String getUserFolderName() {
        return this.userFolderName;
    }
}

