/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.commstyle.utils;

import com.swimap.iview.commstyle.commini.AreaDescContainer;
import com.swimap.iview.commstyle.commini.CommStyleInfo;
import com.swimap.iview.commstyle.commini.CommStyleManager;
import com.swimap.iview.commstyle.commini.DescContainer;
import com.swimap.iview.commstyle.commini.xmlbind.PARA;
import com.swimap.iview.commstyle.resource.i18n.ResourceUtil;
import com.swimap.iview.commstyle.utils.PluginMergeHandler;
import com.swimap.iview.commstyle.utils.UpdateTool;
import com.swimap.iview.util.CommonUtil;
import com.swimap.iview.util.log.IviewLogger;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;

public class MergeUtil {
    private static IviewLogger logger = IviewLogger.getLogger(MergeUtil.class, "IVIEW");
    private static final String PARAM_OPERATION = "operation";
    private static final String OPERATION_DELETE = "delete";
    private static final String OPERATION_ADD = "add";
    private static String _oldDefaultStyleAbsDir = UpdateTool.getOldWorkingDir() + "style/defaultstyle/";
    private static String _newDefaultStyleAbsDir = UpdateTool.getNewWorkingDir() + "style/defaultstyle/";
    private static String _newProductStyleAbsDir = UpdateTool.getNewWorkingDir() + "style/productstyle/";
    public static final String _newUserAbsDir = UpdateTool.getNewWorkingDir() + "style/users/";
    private static String _newUserSettingsAbsDir = UpdateTool.getNewWorkingDir() + "style/usersettings/";
    private static final String TYPE_REPLACED = "replaced";
    private static final String TYPE_RESERVED = "reserved";
    public static final String _oldUserAbsDir = UpdateTool.getOldWorkingDir() + "style/users/";
    public static final String _oldAllUserAbsDir = UpdateTool.getOldWorkingDir() + "style/all users/";
    public static final String _newAllUserAbsDir = UpdateTool.getNewWorkingDir() + "style/all users/";
    private static FileFilter pathFilter = new FileFilter(){

        @Override
        public boolean accept(File file) {
            return file.isDirectory();
        }
    };
    private static FileFilter xmlFilter = new FileFilter(){

        @Override
        public boolean accept(File file) {
            return file.isFile() && file.getName().endsWith(".xml");
        }
    };
    private static FileFilter pluginFilter = new FileFilter(){

        @Override
        public boolean accept(File file) {
            return file.isDirectory() || file.getName().endsWith(".jar");
        }
    };

    public static void mergeToDefaultFile(String string, String string2) {
        String string3 = _oldDefaultStyleAbsDir + string;
        String string4 = _newDefaultStyleAbsDir + string2;
        MergeUtil.merge(string3, string4, true, true);
    }

    public static void mergeToDefaultDir(String string, String string2) {
        String string3 = _oldDefaultStyleAbsDir + string;
        String string4 = _newDefaultStyleAbsDir + string2;
        File[] fileArray = CommonUtil.getAbsoluteFile(string3).listFiles(xmlFilter);
        File[] fileArray2 = CommonUtil.getAbsoluteFile(string4).listFiles(xmlFilter);
        if (fileArray == null || fileArray.length == 0) {
            return;
        }
        if (fileArray2 == null || fileArray2.length == 0) {
            return;
        }
        for (int i = 0; i < fileArray.length; ++i) {
            for (int j = 0; j < fileArray2.length; ++j) {
                if (!ResourceUtil.areEquals(fileArray2[j].getName(), fileArray[i].getName())) continue;
                String string5 = string3 + fileArray[i].getName();
                String string6 = string4 + fileArray2[j].getName();
                MergeUtil.merge(string5, string6, true, true);
            }
        }
    }

    public static void mergeToUserFile(String string) {
        MergeUtil.mergeToUser(_newUserAbsDir, string);
        MergeUtil.mergeToUser(_newUserSettingsAbsDir, string);
    }

    public static void mergeToAllUserFile(String string) {
        MergeUtil.mergeToUser(_newAllUserAbsDir, string);
    }

    private static void mergeToUser(String string, String string2) {
        File file = CommonUtil.getAbsoluteFile(string);
        if (!file.exists()) {
            return;
        }
        File[] fileArray = file.listFiles(pathFilter);
        if (fileArray == null || fileArray.length == 0) {
            return;
        }
        MergeUtil.mergeToUser(fileArray, string2);
    }

    private static void mergeToUser(File[] fileArray, String string) {
        if (fileArray == null || fileArray.length == 0) {
            return;
        }
        String string2 = null;
        File file = null;
        for (int i = 0; i < fileArray.length; ++i) {
            string2 = MergeUtil.filterPath(fileArray[i].getAbsolutePath());
            file = !string2.endsWith("conf/") ? CommonUtil.getAbsoluteFile(string2 + "conf/") : CommonUtil.getAbsoluteFile(string2);
            if (file.exists()) {
                MergeUtil.mergeToUser(CommonUtil.getAbsoluteFile(string2), string);
                continue;
            }
            MergeUtil.mergeToUser(CommonUtil.getAbsoluteFile(string2).listFiles(), string);
        }
    }

    public static void mergeProductstylAndDefaultStyleToUser(String string) {
        MergeUtil.mergeToEachUser(string);
        MergeUtil.mergeToUserFile(string);
    }

    public static void mergeProductstylAndDefaultStyleToAllUser(String string) {
        MergeUtil.mergeToAllUser(string);
        MergeUtil.mergeToAllUserFile(string);
    }

    private static void mergeToUser(File file, String string) {
        String string2 = _newDefaultStyleAbsDir + string;
        String string3 = _newProductStyleAbsDir + string;
        boolean bl = CommonUtil.getAbsoluteFile(string3).exists();
        if (file.exists()) {
            if (file.toString().endsWith("conf")) {
                string = string.substring(string.indexOf(47) + 1);
            }
            String string4 = MergeUtil.filterPath(file.getAbsolutePath()) + string;
            if (!bl) {
                MergeUtil.merge(string2, string4, true, false);
            } else {
                CommStyleInfo commStyleInfo = CommStyleManager.getInstance().getAbsCommStyleFile(string2);
                CommStyleInfo commStyleInfo2 = CommStyleManager.getInstance().getAbsCommStyleFile(string3);
                CommStyleInfo commStyleInfo3 = MergeUtil.merge(commStyleInfo, commStyleInfo2, false);
                MergeUtil.merge(commStyleInfo3, string4, false);
            }
        }
    }

    public static void mergeToUserDir(String string) {
        String string2 = _newDefaultStyleAbsDir + string;
        File[] fileArray = CommonUtil.getAbsoluteFile(string2).listFiles(xmlFilter);
        if (fileArray == null || fileArray.length == 0) {
            return;
        }
        String string3 = null;
        for (int i = 0; i < fileArray.length; ++i) {
            string3 = string + fileArray[i].getName();
            MergeUtil.mergeToUserFile(string3);
        }
    }

    public static void merge(String string, String string2, boolean bl) {
        MergeUtil.merge(string, string2, true, bl);
    }

    private static CommStyleInfo merge(String string, String string2, boolean bl, boolean bl2) {
        logger.trace("merge from: " + string);
        logger.trace("merge to:   " + string2);
        CommStyleInfo commStyleInfo = CommStyleManager.getInstance().getAbsCommStyleFile(string);
        if (commStyleInfo == null || commStyleInfo.getAreaDescCount() <= 0) {
            logger.trace("####Can't get file from " + string);
            return null;
        }
        CommStyleInfo commStyleInfo2 = CommStyleManager.getInstance().getAbsCommStyleFile(string2);
        if (commStyleInfo2 == null || commStyleInfo.getAreaDescCount() <= 0) {
            logger.trace("####Can't get file from " + string2);
            return null;
        }
        MergeUtil.merge(commStyleInfo, commStyleInfo2, bl2);
        if (bl) {
            commStyleInfo2.writeStyle(commStyleInfo2.getFileName(), false);
            return null;
        }
        return commStyleInfo2;
    }

    private static void merge(CommStyleInfo commStyleInfo, String string, boolean bl) {
        if (commStyleInfo == null) {
            logger.trace("####Can't get file because from is null");
            return;
        }
        logger.trace("merge from: " + commStyleInfo.getFileName());
        logger.trace("merge to:   " + string);
        CommStyleInfo commStyleInfo2 = CommStyleManager.getInstance().getAbsCommStyleFile(string);
        if (commStyleInfo2 == null) {
            logger.trace("####Can't get file from " + string);
            return;
        }
        MergeUtil.merge(commStyleInfo, commStyleInfo2, bl);
        commStyleInfo2.writeStyle(commStyleInfo2.getFileName(), false);
    }

    public static CommStyleInfo merge(CommStyleInfo commStyleInfo, CommStyleInfo commStyleInfo2, boolean bl) {
        AreaDescContainer areaDescContainer = null;
        String string = null;
        AreaDescContainer areaDescContainer2 = null;
        int n = commStyleInfo.getAreaDescContainerCount();
        for (int i = 0; i < n; ++i) {
            areaDescContainer = commStyleInfo.getAreaDescContainer(i);
            string = areaDescContainer.getAreaName();
            areaDescContainer2 = string == null || string.trim().length() == 0 ? commStyleInfo2.getAreaDescContainer(i) : commStyleInfo2.getAreaDescContainer(string);
            if (areaDescContainer2 != null) {
                MergeUtil.merge(areaDescContainer, areaDescContainer2, bl);
                continue;
            }
            commStyleInfo2.addAreaDescContainer(areaDescContainer);
        }
        return commStyleInfo2;
    }

    private static void merge(AreaDescContainer areaDescContainer, AreaDescContainer areaDescContainer2, boolean bl) {
        DescContainer descContainer = null;
        String string = null;
        DescContainer descContainer2 = null;
        String string2 = null;
        int n = areaDescContainer.getDescContainerCount();
        for (int i = 0; i < n; ++i) {
            descContainer = areaDescContainer.getDescContainer(i);
            string = descContainer.getDescName();
            descContainer2 = areaDescContainer2.getDescContainer(string);
            string2 = descContainer.getParasItemValue(PARAM_OPERATION);
            if (descContainer2 != null) {
                if (OPERATION_ADD.equals(string2)) {
                    areaDescContainer2.addDescContainer(descContainer);
                    continue;
                }
                if (OPERATION_DELETE.equals(string2)) {
                    areaDescContainer2.removeDescContainer(descContainer2);
                    continue;
                }
                MergeUtil.merge(descContainer, descContainer2, bl);
                continue;
            }
            if (OPERATION_DELETE.equals(string2)) continue;
            areaDescContainer2.addDescContainer(descContainer);
        }
    }

    private static void merge(DescContainer descContainer, DescContainer descContainer2, boolean bl) {
        DescContainer descContainer3 = null;
        String string = null;
        DescContainer descContainer4 = null;
        String string2 = null;
        int n = descContainer.getDescContainerCount();
        for (int i = 0; i < n; ++i) {
            descContainer3 = descContainer.getDescContainer(i);
            string = descContainer3.getDescName();
            descContainer4 = descContainer2.getDescContainer(string);
            string2 = descContainer3.getParasItemValue(PARAM_OPERATION);
            if (descContainer4 != null) {
                if (OPERATION_ADD.equals(string2)) {
                    descContainer2.addDescContainer(descContainer3);
                    continue;
                }
                if (OPERATION_DELETE.equals(string2)) {
                    descContainer2.removeDescContainer(descContainer4);
                    continue;
                }
                MergeUtil.merge(descContainer3, descContainer4, bl);
                continue;
            }
            if (OPERATION_DELETE.equals(string2)) continue;
            descContainer2.addDescContainer(descContainer3);
        }
        PARA pARA = null;
        String string3 = null;
        String string4 = null;
        PARA pARA2 = null;
        int n2 = descContainer.getParasItemCount();
        for (int i = 0; i < n2; ++i) {
            pARA = descContainer.getParasItem(i);
            string3 = pARA.getName();
            string4 = pARA.getType();
            pARA2 = descContainer2.getParasItem(string3);
            if (pARA2 != null) {
                if (TYPE_RESERVED.equalsIgnoreCase(string4)) {
                    logger.trace("reserved(dst first):" + pARA2.getValue());
                    continue;
                }
                if (!bl && !TYPE_REPLACED.equalsIgnoreCase(string4)) continue;
                if (TYPE_REPLACED.equalsIgnoreCase(string4)) {
                    logger.trace("replaced(src first):" + pARA.getValue());
                }
                pARA2.setValue(pARA.getValue());
                continue;
            }
            if (PARAM_OPERATION.equalsIgnoreCase(string3)) continue;
            descContainer2.addParasItem(pARA);
        }
    }

    public static String filterPath(String string) {
        if (string == null || string.length() == 0) {
            return string;
        }
        if (string.indexOf(92) != -1) {
            string = string.replace('\\', '/');
        }
        if (string.startsWith("/")) {
            string = string.substring(1);
        }
        if (!string.endsWith("/")) {
            string = string + '/';
        }
        return string;
    }

    public static void mergeViewsDirFromEachUser() {
        File[] fileArray = MergeUtil.getUsersFiles();
        if (fileArray == null || fileArray.length == 0) {
            return;
        }
        int n = fileArray.length;
        String string = null;
        File file = null;
        for (int i = 0; i < n; ++i) {
            File[] fileArray2;
            string = MergeUtil.filterPath(fileArray[i].getAbsolutePath());
            file = new File(string + "conf/views/layout");
            if (!file.exists()) continue;
            for (File file2 : fileArray2 = file.listFiles()) {
                MergeUtil.mergeProductstylAndDefaultStyleToUser("conf/views/layout/" + file2.getName());
            }
        }
    }

    public static void mergePluginPerspectiveFileFromEachUser() {
        String[] stringArray = MergeUtil.getPluginlist();
        File[] fileArray = MergeUtil.getUsersFiles();
        if (fileArray == null || fileArray.length == 0 || null == stringArray || stringArray.length == 0) {
            return;
        }
        int n = fileArray.length;
        String string = null;
        File file = null;
        for (int i = 0; i < n; ++i) {
            string = MergeUtil.filterPath(fileArray[i].getAbsolutePath());
            for (int j = 0; j < stringArray.length; ++j) {
                file = new File(string + "conf/" + stringArray[j] + "/perspective.xml");
                if (!file.exists()) continue;
                PluginMergeHandler pluginMergeHandler = new PluginMergeHandler(stringArray[j]);
                pluginMergeHandler.mergeToUser("perspective.xml");
            }
        }
    }

    public static void mergePluginToolbarAndWelcomeFileFromEachUser() {
        String[] stringArray = MergeUtil.getPluginlist();
        File[] fileArray = MergeUtil.getUsersFiles();
        if (fileArray == null || fileArray.length == 0 || null == stringArray || stringArray.length == 0) {
            return;
        }
        int n = fileArray.length;
        String string = null;
        File file = null;
        File file2 = null;
        File file3 = null;
        File file4 = null;
        for (int i = 0; i < n; ++i) {
            string = MergeUtil.filterPath(fileArray[i].getAbsolutePath());
            for (int j = 0; j < stringArray.length; ++j) {
                PluginMergeHandler pluginMergeHandler;
                file3 = new File(string + "integrate/complex/" + stringArray[j] + "/toolbar.xml");
                if (file3.exists()) {
                    pluginMergeHandler = new PluginMergeHandler(stringArray[j]);
                    pluginMergeHandler.mergeToUser("toolbar.xml", "complex");
                }
                if ((file = new File(string + "integrate/single/" + stringArray[j] + "/toolbar.xml")).exists()) {
                    pluginMergeHandler = new PluginMergeHandler(stringArray[j]);
                    pluginMergeHandler.mergeToUser("toolbar.xml", "single");
                }
                if ((file4 = new File(string + "integrate/complex/" + stringArray[j] + "/welcomebutton.xml")).exists()) {
                    pluginMergeHandler = new PluginMergeHandler(stringArray[j]);
                    pluginMergeHandler.mergeToUser("welcomebutton.xml", "complex");
                }
                if (!(file2 = new File(string + "integrate/single/" + stringArray[j] + "/welcomebutton.xml")).exists()) continue;
                pluginMergeHandler = new PluginMergeHandler(stringArray[j]);
                pluginMergeHandler.mergeToUser("welcomebutton.xml", "single");
            }
        }
    }

    private static File[] getUsersFiles() {
        File file = CommonUtil.getAbsoluteFile(_oldUserAbsDir);
        File[] fileArray = file.listFiles(pathFilter);
        return fileArray;
    }

    private static String[] getPluginlist() {
        File[] fileArray;
        File file = CommonUtil.getAbsoluteFile(UpdateTool.getOldWorkingDir() + "/plugins");
        String[] stringArray = null;
        if (file.exists() && null != (fileArray = file.listFiles(pluginFilter))) {
            stringArray = new String[fileArray.length];
            for (int i = 0; i < fileArray.length; ++i) {
                stringArray[i] = fileArray[i].getName();
            }
        }
        return stringArray;
    }

    public static void mergeToEachUser(String string) {
        File file = CommonUtil.getAbsoluteFile(_oldUserAbsDir);
        File[] fileArray = file.listFiles(pathFilter);
        if (fileArray == null || fileArray.length == 0) {
            return;
        }
        MergeUtil.mergeToEachUser(fileArray, string);
    }

    private static void mergeToEachUser(File[] fileArray, String string) {
        String string2 = null;
        int n = fileArray.length;
        for (int i = 0; i < n; ++i) {
            string2 = MergeUtil.filterPath(fileArray[i].getAbsolutePath());
            MergeUtil.mergeToEachUser(CommonUtil.getAbsoluteFile(string2), string);
        }
    }

    private static void mergeToEachUser(File file, String string) {
        String string2 = MergeUtil.filterPath(file.getAbsolutePath()) + string;
        String string3 = MergeUtil.getUserName(string2);
        String string4 = _oldUserAbsDir + string3 + string;
        File file2 = CommonUtil.getAbsoluteFile(string4);
        if (!file2.exists()) {
            return;
        }
        String string5 = _newUserAbsDir + string3 + string;
        File file3 = CommonUtil.getAbsoluteFile(string5);
        if (!file3.exists() && !(file3 = new File(string5)).getParentFile().exists()) {
            file3.getParentFile().mkdirs();
        }
        MergeUtil.performMergeWrite(string4, string5);
    }

    public static void mergeToAllUser(String string) {
        File file = CommonUtil.getAbsoluteFile(_oldAllUserAbsDir);
        File[] fileArray = file.listFiles(pathFilter);
        if (fileArray == null || fileArray.length == 0) {
            return;
        }
        MergeUtil.mergeToAllUsers(string);
    }

    private static void mergeToAllUsers(String string) {
        String string2 = _oldAllUserAbsDir + string;
        File file = CommonUtil.getAbsoluteFile(string2);
        if (!file.exists()) {
            return;
        }
        String string3 = _newAllUserAbsDir + string;
        File file2 = CommonUtil.getAbsoluteFile(string3);
        if (!file2.exists() && !(file2 = new File(string3)).getParentFile().exists()) {
            file2.getParentFile().mkdirs();
        }
        MergeUtil.performMergeWrite(string2, string3);
    }

    private static void performMergeWrite(String string, String string2) {
        CommStyleInfo commStyleInfo = MergeUtil.merge(string, string2, true, true);
        if (null == commStyleInfo) {
            CommStyleManager commStyleManager = CommStyleManager.getInstance();
            CommStyleInfo commStyleInfo2 = commStyleManager.getAbsCommStyleFile(string2);
            CommStyleInfo commStyleInfo3 = commStyleManager.getAbsCommStyleFile(string);
            if (null == commStyleInfo2 && null != commStyleInfo3) {
                try {
                    commStyleInfo3.marshal(string2);
                }
                catch (IOException iOException) {
                    logger.trace(iOException.getMessage(), iOException);
                }
                commStyleInfo2 = null;
            }
        }
    }

    public static String getUserName(String string) {
        String[] stringArray = null;
        if (0 <= string.indexOf(47)) {
            stringArray = string.split("/");
        } else if (0 <= string.indexOf(92)) {
            stringArray = string.split("\\\\");
        } else {
            return null;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (!"users".equals(stringArray[i])) continue;
            return stringArray[i + 1] + '/';
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copyFile(String string, String string2, boolean bl) {
        boolean bl2 = false;
        FileChannel fileChannel = null;
        FileChannel fileChannel2 = null;
        if (null == string || string.trim().length() == 0 || null == string2 || string2.trim().length() == 0) {
            logger.trace("Copy file failed,the file path is not correct,sourceFile: " + string + ",destFile: " + string2);
            return bl2;
        }
        File file = new File(string);
        File file2 = new File(string2);
        if (!file.exists() || !file.canRead()) {
            logger.trace("Copy file failed, the sourceFile is not exist or can not be read,sourceFile: " + string);
            return bl2;
        }
        if (file.isDirectory() || file2.isDirectory()) {
            logger.trace("Not support to copy directory");
            return bl2;
        }
        if (!MergeUtil.validateDestination(file2, bl)) {
            logger.trace("Validation of Destination failed.");
            return bl2;
        }
        try {
            fileChannel = new FileInputStream(file).getChannel();
            fileChannel2 = new FileOutputStream(file2).getChannel();
            fileChannel2.transferFrom(fileChannel, 0L, fileChannel.size());
            fileChannel.close();
            fileChannel2.close();
            bl2 = true;
            file = null;
            file2 = null;
        }
        catch (IOException iOException) {
            try {
                logger.trace("Failed to copy the file :" + iOException);
                file = null;
                file2 = null;
            }
            catch (Throwable throwable) {
                file = null;
                file2 = null;
                MergeUtil.closeStreamChanel(fileChannel);
                MergeUtil.closeStreamChanel(fileChannel2);
                fileChannel = null;
                fileChannel2 = null;
                throw throwable;
            }
            MergeUtil.closeStreamChanel(fileChannel);
            MergeUtil.closeStreamChanel(fileChannel2);
            fileChannel = null;
            fileChannel2 = null;
        }
        MergeUtil.closeStreamChanel(fileChannel);
        MergeUtil.closeStreamChanel(fileChannel2);
        fileChannel = null;
        fileChannel2 = null;
        return bl2;
    }

    private static void closeStreamChanel(FileChannel fileChannel) {
        if (null != fileChannel) {
            try {
                fileChannel.close();
            }
            catch (IOException iOException) {
                logger.trace("Failed to close the stream :" + iOException);
            }
        }
    }

    private static boolean validateDestination(File file, boolean bl) {
        boolean bl2 = false;
        if (file.exists()) {
            boolean bl3;
            if (!bl) {
                logger.trace("The destination file is already exist!");
                return bl2;
            }
            if (!file.canWrite() && !(bl3 = file.delete())) {
                logger.trace("Failed to replace the destination file!");
                return bl2;
            }
            bl2 = true;
        } else {
            File file2 = file.getParentFile();
            if (!file2.exists()) {
                file2.mkdirs();
            }
            bl2 = true;
        }
        return bl2;
    }
}

