/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.commstyle.utils;

import com.swimap.iview.util.CommonUtil;
import java.awt.Cursor;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Hashtable;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class ImageHandler {
    public static final Icon brokenIcon;
    public static final Cursor brokenCursor;
    private static String[] imageExtns;
    private static Hashtable<String, Image> imageCache;
    private static Hashtable<String, Cursor> cursorCache;
    private static Hashtable<String, Icon> iconCache;
    private static final int BUFFER_SIZE = 1000;
    public static final Image brokenImage;

    protected ImageHandler() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Image getImage(URL uRL) {
        Image image;
        Image image2 = image = null == uRL ? brokenImage : imageCache.get(uRL.toString());
        if (null == image && uRL != null) {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            InputStream inputStream = null;
            try {
                if (CommonUtil.IS_MENUTOOL) {
                    URLConnection uRLConnection = uRL.openConnection();
                    uRLConnection.setUseCaches(false);
                    inputStream = uRLConnection.getInputStream();
                } else {
                    inputStream = uRL.openStream();
                }
                int n = inputStream.available();
                if (n == 0) {
                    n = 1000;
                }
                byte[] byArray = new byte[n];
                int n2 = -1;
                int n3 = 0;
                while ((n2 = inputStream.read(byArray, n3, n - n3)) >= 0) {
                    if (n2 > 0) {
                        n3 += n2;
                        continue;
                    }
                    byte[] byArray2 = new byte[n += 1000];
                    System.arraycopy(byArray, 0, byArray2, 0, n3);
                    byArray = byArray2;
                }
                image = toolkit.createImage(byArray);
            }
            catch (IOException iOException) {
                image = brokenImage;
            }
            finally {
                if (null != inputStream) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {
                        image = brokenImage;
                    }
                }
            }
            imageCache.put(uRL.toString(), image);
        }
        return image;
    }

    public static Cursor getCursor(URL uRL) {
        return ImageHandler.getCursor(uRL, 0, 0);
    }

    public static Cursor getCursor(URL uRL, int n, int n2) {
        Cursor cursor;
        Cursor cursor2 = cursor = uRL != null ? cursorCache.get(uRL) : null;
        if (cursor == null) {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            Image image = ImageHandler.getImage(uRL);
            cursor = image == brokenImage ? brokenCursor : toolkit.createCustomCursor(image, new Point(n, n2), uRL.getFile());
            if (uRL != null) {
                cursorCache.put(uRL.toString(), cursor);
            }
        }
        return cursor;
    }

    public static Icon getIcon(URL uRL) {
        Icon icon;
        Icon icon2 = icon = uRL != null ? iconCache.get(uRL) : null;
        if (icon == null) {
            Image image = ImageHandler.getImage(uRL);
            icon = image == brokenImage ? brokenIcon : new ImageIcon(image, uRL.getFile());
            if (uRL != null) {
                iconCache.put(uRL.toString(), icon);
            }
        }
        return icon;
    }

    public static Image getImage(String string, Class clazz) {
        if (string.indexOf(46) >= 0) {
            return ImageHandler.getImage(clazz.getResource(string));
        }
        URL uRL = null;
        for (int i = 0; i < imageExtns.length; ++i) {
            uRL = clazz.getResource(string + imageExtns[i]);
            if (uRL == null) continue;
            return ImageHandler.getImage(uRL);
        }
        return brokenImage;
    }

    public static Cursor getCursor(String string, Class clazz) {
        if (string.indexOf(46) >= 0) {
            return ImageHandler.getCursor(clazz.getResource(string));
        }
        URL uRL = null;
        for (int i = 0; i < imageExtns.length; ++i) {
            uRL = clazz.getResource(string + imageExtns[i]);
            if (uRL == null) continue;
            return ImageHandler.getCursor(uRL);
        }
        return brokenCursor;
    }

    public static Icon getIcon(String string, Class clazz) {
        if (string.indexOf(46) >= 0) {
            return ImageHandler.getIcon(clazz.getResource(string));
        }
        URL uRL = null;
        for (int i = 0; i < imageExtns.length; ++i) {
            uRL = clazz.getResource(string + imageExtns[i]);
            if (uRL == null) continue;
            return ImageHandler.getIcon(uRL);
        }
        return brokenIcon;
    }

    static {
        imageExtns = new String[]{".gif", ".png"};
        imageCache = new Hashtable();
        cursorCache = new Hashtable();
        iconCache = new Hashtable();
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        brokenImage = toolkit.getImage(ImageHandler.class.getResource("BrokenImage.gif"));
        if (null == brokenImage) {
            throw new RuntimeException("Could not load BrokenIcon.");
        }
        brokenIcon = new ImageIcon(brokenImage, "BrokenIcon");
        Image image = toolkit.getImage(ImageHandler.class.getResource("BrokenCursor.gif"));
        brokenCursor = null == image ? null : toolkit.createCustomCursor(image, new Point(0, 0), "BrokenCursor");
        if (null == brokenCursor) {
            throw new RuntimeException("Could not load BrokenCursor.");
        }
    }
}

