/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.commstyle.resource.i18n;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;

public class UnicodeInputStream
extends BufferedInputStream {
    private boolean isInited = false;
    private String defaultEncoding = null;
    private String encoding = null;
    private static final int BOM_SIZE = 4;

    public UnicodeInputStream(InputStream inputStream, String string) {
        super(inputStream);
        this.defaultEncoding = string;
    }

    public String getDefaultEncoding() {
        return this.defaultEncoding;
    }

    public String getEncoding() {
        if (!this.isInited) {
            try {
                this.init();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return this.encoding;
    }

    protected void init() throws IOException {
        int n;
        if (this.isInited) {
            return;
        }
        byte[] byArray = new byte[4];
        this.mark(4);
        int n2 = this.read(byArray, 0, byArray.length);
        if (byArray[0] == 0 && byArray[1] == 0 && byArray[2] == -2 && byArray[3] == -1) {
            this.encoding = "UTF-32BE";
            n = n2 - 4;
        } else if (byArray[0] == -1 && byArray[1] == -2 && byArray[2] == 0 && byArray[3] == 0) {
            this.encoding = "UTF-32LE";
            n = n2 - 4;
        } else if (byArray[0] == -17 && byArray[1] == -69 && byArray[2] == -65) {
            this.encoding = "UTF-8";
            n = n2 - 3;
        } else if (byArray[0] == -2 && byArray[1] == -1) {
            this.encoding = "UTF-16BE";
            n = n2 - 2;
        } else if (byArray[0] == -2 && byArray[1] == -1) {
            this.encoding = "UTF-16LE";
            n = n2 - 4;
        } else {
            this.encoding = this.defaultEncoding;
            n = n2;
        }
        this.reset();
        if (n2 - n > 0) {
            this.skip(n2 - n);
        }
        this.isInited = true;
    }

    @Override
    public void close() throws IOException {
        this.isInited = true;
        super.close();
    }
}

