/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.commstyle.resource;

import com.swimap.iview.commstyle.commini.CommStyleInfo;
import com.swimap.iview.commstyle.commini.CommStyleManager;
import com.swimap.iview.commstyle.commini.DescContainer;
import com.swimap.iview.commstyle.resource.PropertyResourceBundleEx;
import com.swimap.iview.commstyle.resource.XMLResourceBundle;
import com.swimap.iview.commstyle.resource.i18n.ResourceUtil;
import com.swimap.iview.commstyle.resource.i18n.UnicodeInputStream;
import com.swimap.iview.commstyle.resource.i18n.Utils;
import com.swimap.iview.framework.lookandfeel.skin.SkinManager;
import com.swimap.iview.util.CommonUtil;
import com.swimap.iview.util.SerializableTool;
import com.swimap.iview.util.adapter.TypeConverter;
import com.swimap.iview.util.log.IviewLogger;
import java.applet.Applet;
import java.applet.AudioClip;
import java.awt.Color;
import java.awt.Font;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;

public class ResourceMng {
    public static final String FILEENCODING = ResourceUtil.CLIENT_ENCODING;
    private static IviewLogger logger = IviewLogger.getLogger(ResourceMng.class, "IVIEW");
    public static String LOCALE_PROPERTIES = "locale.properties";
    public static String CONFIG_PROPERTIES = "config.properties";
    private static final String DEFAULT_STYLE_DIR = "style/defaultstyle/";
    private static final String LOCALE_DIR = "style/defaultstyle/locale/";
    private static final String PRODUCT_STYLE_DIR = "style/productstyle/";
    private static final String PRODUCT_LOCALE_DIR = "style/productstyle/locale/";
    private static final String PRODUCT_CONF_DIR = "style/productstyle/conf/";
    private static final String DEFAULT_CONF_DIR = "style/defaultstyle/conf/";
    private String language = "en";
    private String country = "US";
    private static final Locale DEFAULT_LOCALE = new Locale("en", "US");
    private Locale currentLocale = null;
    private String RESOURCE_DIR = "style/defaultstyle/locale/en_US/";
    private String PRODUCT_RESOURCE_DIR = "style/productstyle/locale/en_US/";
    private URL baseURL;
    private static ResourceMng instance;
    private DescContainer iconKeys;
    private DescContainer fontKeys;
    private DescContainer colorKeys;
    private DescContainer soundFileKeys;
    private String OSLanguage = System.getProperty("user.language");
    private static final int DEFAULT_INITIAL_CAPACITY = 16;
    private static ConcurrentHashMap<String, String> iconPathMap;
    private static ConcurrentHashMap<String, Properties> defaultResBundles;
    private static ConcurrentHashMap<String, String> defaultEncoding;
    private static final String ICON_RESOURCE = "IconResource";
    private static final String DEFAULT_RES_BUNDLE = "DefaultResBundle";
    private static final String BUNDLE_ENCODING = "Encoding";
    private static int iconPathMapSize;
    private static int defaultEncodingSize;
    private static boolean isResBundlesModified;
    private final String VERSION_FOLDERNAME = "subcomponent/";
    private final String VERSION_FILENAME = "_version.properties";
    private ConcurrentHashMap<String, Boolean> fileMap = new ConcurrentHashMap();

    public String getOSLanguage() {
        return this.OSLanguage;
    }

    private ResourceMng() {
        this.readLocaleConfiguration();
        try {
            this.baseURL = new URL("file:" + System.getProperty("user.dir") + '/');
        }
        catch (MalformedURLException malformedURLException) {
            logger.debug(malformedURLException.getMessage());
        }
        CommStyleInfo commStyleInfo = CommStyleManager.getInstance().getCommonStyleFile("conf/common/defaultresource", false);
        if (commStyleInfo != null) {
            this.iconKeys = commStyleInfo.getAreaDescContainer(0).getDescContainer("iconKeys");
            this.fontKeys = commStyleInfo.getAreaDescContainer(0).getDescContainer("fontKeys");
            this.colorKeys = commStyleInfo.getAreaDescContainer(0).getDescContainer("colorKeys");
            this.soundFileKeys = commStyleInfo.getAreaDescContainer(0).getDescContainer("soundFileKeys");
        } else {
            logger.debug("defaultResource file can not find. Check if style directory existed in the running directory!");
        }
    }

    public static ResourceMng getInstance() {
        if (instance == null) {
            instance = new ResourceMng();
        }
        return instance;
    }

    public static ResourceMng getInstance(String string) {
        LOCALE_PROPERTIES = string + "locale.properties";
        CONFIG_PROPERTIES = string + "config.properties";
        if (instance == null) {
            instance = new ResourceMng();
        }
        return instance;
    }

    public String getString(String string, String string2) {
        ResourceBundle resourceBundle = this.getResourceBundle(string);
        String string3 = string2;
        if (resourceBundle != null) {
            try {
                string3 = resourceBundle.getString(string2);
            }
            catch (Exception exception) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("string id:");
                stringBuffer.append(string2);
                stringBuffer.append(" is not existed in file ");
                stringBuffer.append(string);
                logger.debug(stringBuffer.toString());
            }
        } else {
            logger.debug("can not find the resource Bundle.");
        }
        return string3;
    }

    public ResourceBundle getResourceBundle(String string) {
        CommStyleInfo commStyleInfo = CommStyleManager.getInstance().getCommonStyleFile(string + '_' + this.currentLocale.toString());
        if (commStyleInfo == null) {
            commStyleInfo = CommStyleManager.getInstance().getCommonStyleFile(string);
        }
        if (commStyleInfo == null) {
            logger.trace("no resouce bundle xml or obj file existed.");
            return null;
        }
        try {
            DescContainer descContainer = commStyleInfo.getAreaDescContainer(0).getDescContainer(0);
            return new XMLResourceBundle(descContainer);
        }
        catch (Exception exception) {
            logger.trace("resource bundle xml file or obj file error.");
            logger.trace(exception.getMessage(), exception);
            return null;
        }
    }

    public static ResourceBundle getResourceBundleFromClassName(String string) {
        return ResourceBundle.getBundle(string);
    }

    public ResourceBundle getResourceBundleFromPropertyFile(String string) {
        Object object;
        Object object2;
        if (null == string) {
            return null;
        }
        String string2 = null;
        logger.log((Priority)Level.ALL, "ResourceFile.iview=" + string);
        Properties properties = defaultResBundles.get(string);
        if (null != properties) {
            string2 = defaultEncoding.get(string);
            PropertyResourceBundleEx propertyResourceBundleEx = new PropertyResourceBundleEx(properties);
            if (string2 != null) {
                propertyResourceBundleEx.setEncoding(string2);
            } else {
                logger.trace("Encoding not got for the relative file name " + string);
                propertyResourceBundleEx.setEncoding(ResourceUtil.CLIENT_ENCODING);
            }
            return propertyResourceBundleEx;
        }
        Properties properties2 = null;
        String string3 = this.RESOURCE_DIR + string + ".properties";
        File file = CommonUtil.getAbsoluteFile(string3);
        if (file.exists() || null != CommStyleManager.getURLFromJar(string3)) {
            properties = ResourceMng.getProperties(string3);
            if (null != properties && null != (object2 = Utils.getInputStream(string3))) {
                string2 = Utils.getEncoding((InputStream)object2);
                this.closeStream((InputStream)object2);
            }
        } else {
            logger.error("Resource file not found:" + string3);
        }
        if ((file = CommonUtil.getAbsoluteFile((String)(object2 = this.PRODUCT_RESOURCE_DIR + string + ".properties"))).exists() || null != CommStyleManager.getURLFromJar((String)object2)) {
            properties2 = ResourceMng.getProperties((String)object2);
            if (null != object2 && null != (object = Utils.getInputStream(string3))) {
                string2 = Utils.getEncoding((InputStream)object);
                this.closeStream((InputStream)object);
            }
        } else {
            logger.trace("Resource file not found:" + (String)object2);
        }
        if (null == properties && null == properties2) {
            return null;
        }
        if (null == properties || null == properties2) {
            properties = properties != null ? properties : properties2;
        } else {
            ResourceMng.propertiesMerge(properties, properties2);
        }
        object = new PropertyResourceBundleEx(properties);
        if (null == string2) {
            string2 = ResourceUtil.CLIENT_ENCODING;
        }
        if (null != string && null != properties) {
            defaultResBundles.put(string, properties);
        }
        if (null != string && null != string2) {
            defaultEncoding.put(string, string2);
        }
        ((PropertyResourceBundleEx)object).setEncoding(string2);
        isResBundlesModified = true;
        return object;
    }

    public void removeResourceBundle(String string) {
        logger.trace("Resource bundele with name " + string + " removed");
        if (null != string) {
            defaultResBundles.remove(string);
            isResBundlesModified = true;
        }
    }

    public ResourceBundle getResourceBundleFromXmlFile(String string) {
        CommStyleInfo commStyleInfo = CommStyleManager.getInstance().getAbsCommStyleFile(this.RESOURCE_DIR + string);
        if (commStyleInfo == null) {
            logger.trace("no resouce bundle xml existed." + string);
            return null;
        }
        CommStyleInfo commStyleInfo2 = CommStyleManager.getInstance().getAbsCommStyleFile(this.PRODUCT_RESOURCE_DIR + string);
        commStyleInfo.mergeCommStyleInfo(commStyleInfo2);
        try {
            DescContainer descContainer = commStyleInfo.getAreaDescContainer(0).getDescContainer(0);
            return new XMLResourceBundle(descContainer);
        }
        catch (Exception exception) {
            logger.trace("resource bundle xml file or obj file error.");
            return null;
        }
    }

    public ResourceBundle getResourceBundleFromXmlFile(String string, String string2) {
        CommStyleInfo commStyleInfo = CommStyleManager.getInstance().getAbsCommStyleFile(string2 + this.RESOURCE_DIR + string);
        if (commStyleInfo == null) {
            logger.trace("no resouce bundle xml existed." + string);
            return null;
        }
        CommStyleInfo commStyleInfo2 = CommStyleManager.getInstance().getAbsCommStyleFile(string2 + this.PRODUCT_RESOURCE_DIR + string);
        commStyleInfo.mergeCommStyleInfo(commStyleInfo2);
        try {
            DescContainer descContainer = commStyleInfo.getAreaDescContainer(0).getDescContainer(0);
            return new XMLResourceBundle(descContainer);
        }
        catch (Exception exception) {
            logger.trace("resource bundle xml file or obj file error.");
            return null;
        }
    }

    public Locale getLocale() {
        return this.currentLocale;
    }

    public Icon getIconDirect(String string) {
        URL uRL = this.getURLFromProOrDefault(string);
        if (null == uRL) {
            return null;
        }
        return new ImageIcon(uRL);
    }

    public Icon getConfIconDirect(String string) {
        URL uRL = this.getURLFromConfProOrDefault(string);
        if (null == uRL) {
            return null;
        }
        return new ImageIcon(uRL);
    }

    public Icon getExistIcon(String string) {
        return this.getIconDirect(string);
    }

    public Icon getIcon(String string) {
        String string2 = null;
        if (this.iconKeys != null && (string2 = this.iconKeys.getParasItemValue(string)) == null) {
            string2 = this.iconKeys.getParasItemValue("breakicon");
        }
        return this.getIconDirect(string2);
    }

    public Icon getIcon(String string, boolean bl) {
        if (this.iconKeys != null) {
            String string2 = this.iconKeys.getParasItemValue(string);
            if (string2 == null) {
                if (bl) {
                    string2 = this.iconKeys.getParasItemValue("breakicon");
                } else {
                    return null;
                }
            }
            return this.getIconDirect(string2);
        }
        return null;
    }

    public Icon getIcon(String string, String string2) {
        String string3 = null;
        CommStyleInfo commStyleInfo = CommStyleManager.getInstance().getCommonStyleFile(string);
        if (commStyleInfo != null) {
            DescContainer descContainer = null;
            try {
                descContainer = commStyleInfo.getAreaDescContainer(0).getDescContainer("iconKeys");
            }
            catch (Exception exception) {
                logger.trace(exception.getMessage(), exception);
            }
            if (descContainer != null && (string3 = descContainer.getParasItemValue(string2)) == null) {
                string3 = this.iconKeys.getParasItemValue("breakicon");
            }
        }
        return this.getIconDirect(string3);
    }

    public File getSoundFileDirect(String string) {
        URL uRL = this.getURLFromProOrDefault(string);
        if (null == uRL) {
            return null;
        }
        return CommonUtil.getAbsoluteFile(uRL.getPath());
    }

    public File getSoundFile(String string, String string2) {
        String string3 = null;
        CommStyleInfo commStyleInfo = CommStyleManager.getInstance().getCommonStyleFile(string);
        if (commStyleInfo != null) {
            DescContainer descContainer = null;
            try {
                descContainer = commStyleInfo.getAreaDescContainer(0).getDescContainer("soundFileKeys");
            }
            catch (Exception exception) {
                logger.trace(exception.getMessage(), exception);
            }
            if (descContainer != null && (string3 = this.soundFileKeys.getParasItemValue(string2)) == null) {
                string3 = this.soundFileKeys.getParasItemValue("defaultSound");
            }
        }
        return this.getSoundFileDirect(string3);
    }

    public File getSoundFile(String string) {
        if (this.soundFileKeys != null) {
            String string2 = this.soundFileKeys.getParasItemValue(string);
            if (string2 == null) {
                string2 = this.soundFileKeys.getParasItemValue("defaultSound");
            }
            return this.getSoundFileDirect(string2);
        }
        return null;
    }

    public AudioClip getAudioClipDirect(String string) {
        URL uRL = this.getURLFromProOrDefault(string);
        if (null == uRL) {
            return null;
        }
        logger.debug(uRL.toString());
        return Applet.newAudioClip(uRL);
    }

    public AudioClip getAudioClip(String string, String string2) {
        String string3 = null;
        CommStyleInfo commStyleInfo = CommStyleManager.getInstance().getCommonStyleFile(string);
        if (commStyleInfo != null) {
            DescContainer descContainer = null;
            try {
                descContainer = commStyleInfo.getAreaDescContainer(0).getDescContainer("soundFileKeys");
            }
            catch (Exception exception) {
                logger.trace(exception.getMessage(), exception);
            }
            if (descContainer != null && (string3 = descContainer.getParasItemValue(string2)) == null) {
                string3 = this.soundFileKeys.getParasItemValue("defaultSound");
            }
        }
        return this.getAudioClipDirect(string3);
    }

    public AudioClip getAudioClip(String string) {
        String string2 = null;
        if (this.soundFileKeys != null && (string2 = this.soundFileKeys.getParasItemValue(string)) == null) {
            string2 = this.soundFileKeys.getParasItemValue("defaultSound");
        }
        return this.getAudioClipDirect(string2);
    }

    public Font getFont() {
        return this.getFont("DEFAULT");
    }

    public Font getFont(String string) {
        Font font = TypeConverter.toFont(this.fontKeys.getParasItemValue(string), new Font("Dialog", 0, 12));
        return font;
    }

    public Font getFont(String string, String string2) {
        CommStyleInfo commStyleInfo = null;
        DescContainer descContainer = null;
        Font font = null;
        try {
            commStyleInfo = CommStyleManager.getInstance().getCommonStyleFile(string);
            descContainer = commStyleInfo.getAreaDescContainer(0).getDescContainer("fontKeys");
            font = TypeConverter.toFont(descContainer.getParasItemValue(string2), new Font("Dialog", 0, 12));
        }
        catch (Exception exception) {
            return this.getFont("DEFAULT");
        }
        return font;
    }

    public Color getColor() {
        return this.getColor("default");
    }

    public Color getColor(String string) {
        Color color = TypeConverter.toColor(this.colorKeys.getParasItemValue(string), Color.white);
        return color;
    }

    public Color getColor(String string, String string2) {
        Color color = null;
        CommStyleInfo commStyleInfo = null;
        DescContainer descContainer = null;
        try {
            commStyleInfo = CommStyleManager.getInstance().getCommonStyleFile(string);
            descContainer = commStyleInfo.getAreaDescContainer(0).getDescContainer("colorKeys");
            color = TypeConverter.toColor(descContainer.getParasItemValue(string2), Color.white);
        }
        catch (Exception exception) {
            logger.debug("getColor Failed");
            return this.getColor("default");
        }
        return color;
    }

    public URL getBaseURL() {
        return this.baseURL;
    }

    public String getResourceDir() {
        return this.RESOURCE_DIR;
    }

    public static String getProperty(String string, String string2, String string3) {
        return ResourceMng.getProperty(string, new String[]{string2}, new String[]{string3})[0];
    }

    public static String[] getProperty(String string, String[] stringArray, String[] stringArray2) {
        int n;
        int n2 = stringArray.length;
        int n3 = Math.min(n2, stringArray2.length);
        String[] stringArray3 = new String[n2];
        Properties properties = ResourceMng.getProperties(string);
        if (properties == null) {
            return stringArray3;
        }
        for (n = 0; n < n3; ++n) {
            stringArray3[n] = properties.getProperty(stringArray[n], stringArray2[n]);
        }
        for (n = n3; n < n2; ++n) {
            stringArray3[n] = properties.getProperty(stringArray[n]);
        }
        return stringArray3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties getProperties(String string) {
        InputStream inputStream = null;
        InputStreamReader inputStreamReader = null;
        Properties properties = new Properties();
        try {
            inputStream = Utils.getInputStream(string);
            if (null == inputStream) {
                Properties properties2 = properties;
                return properties2;
            }
            UnicodeInputStream unicodeInputStream = new UnicodeInputStream(inputStream, null);
            String string2 = unicodeInputStream.getEncoding();
            inputStreamReader = null == string2 ? new InputStreamReader((InputStream)unicodeInputStream, ResourceUtil.CLIENT_ENCODING) : new InputStreamReader((InputStream)unicodeInputStream, string2);
            properties.load(inputStreamReader);
        }
        catch (Exception exception) {
            logger.trace("Get property failed.");
            logger.trace(exception.getMessage(), exception);
            properties = null;
        }
        finally {
            try {
                if (null != inputStream) {
                    inputStream.close();
                }
                if (null != inputStreamReader) {
                    inputStreamReader.close();
                }
            }
            catch (Exception exception) {
                logger.trace("stream can not be closed.");
                logger.trace(exception.getMessage(), exception);
            }
        }
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties getProperties(String string, boolean bl) {
        InputStream inputStream = null;
        InputStreamReader inputStreamReader = null;
        Properties properties = new Properties();
        try {
            inputStream = Utils.getInputStream(string, bl);
            if (null == inputStream) {
                Properties properties2 = properties;
                return properties2;
            }
            UnicodeInputStream unicodeInputStream = new UnicodeInputStream(inputStream, null);
            String string2 = unicodeInputStream.getEncoding();
            inputStreamReader = null == string2 ? new InputStreamReader((InputStream)unicodeInputStream, ResourceUtil.CLIENT_ENCODING) : new InputStreamReader((InputStream)unicodeInputStream, string2);
            properties.load(inputStreamReader);
        }
        catch (Exception exception) {
            logger.trace("Get property failed.");
            logger.trace(exception.getMessage(), exception);
            properties = null;
        }
        finally {
            try {
                if (null != inputStream) {
                    inputStream.close();
                }
                if (null != inputStreamReader) {
                    inputStreamReader.close();
                }
            }
            catch (Exception exception) {
                logger.trace("stream can not be closed.");
                logger.trace(exception.getMessage(), exception);
            }
        }
        return properties;
    }

    public static boolean propertiesMerge(Properties properties, Properties properties2) {
        if (properties == null || properties2 == null) {
            return false;
        }
        String string = null;
        Enumeration<?> enumeration = properties2.propertyNames();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            properties.put(string, properties2.getProperty(string));
        }
        return true;
    }

    private void readLocaleConfiguration() {
        boolean bl;
        String[] stringArray = new String[]{"manual_configure_locale_allowed", "language"};
        String string = System.getProperty("user.region");
        if (string == null) {
            string = System.getProperty("user.country");
        }
        String[] stringArray2 = new String[]{"false", this.OSLanguage, string};
        String[] stringArray3 = ResourceMng.getProperty(LOCALE_PROPERTIES, stringArray, stringArray2);
        for (bl = false; bl < stringArray3.length; bl += 1) {
            if (stringArray3[bl] == null) continue;
            stringArray3[bl] = stringArray3[bl].trim();
        }
        bl = TypeConverter.toBoolean(stringArray3[0], false);
        this.constructLocale(bl, stringArray3, string);
        this.language = this.currentLocale.getLanguage();
        this.country = this.currentLocale.getCountry();
        Locale.setDefault(this.currentLocale);
        JComponent.setDefaultLocale(Locale.getDefault());
        this.RESOURCE_DIR = LOCALE_DIR + this.language + '_' + this.country + '/';
        this.PRODUCT_RESOURCE_DIR = PRODUCT_LOCALE_DIR + this.language + '_' + this.country + '/';
        logger.trace("User configured resource dir is :" + this.RESOURCE_DIR);
        File file = CommonUtil.getAbsoluteFile(this.RESOURCE_DIR);
        if (!file.isDirectory() && CommStyleManager.getURLFromJar(this.RESOURCE_DIR) == null) {
            logger.trace("The user define locale can not be applied for the resource directory is not existed. use the default locale.");
            this.language = DEFAULT_LOCALE.getLanguage();
            this.country = DEFAULT_LOCALE.getCountry();
            System.getProperties().put("user.language", this.language);
            System.getProperties().put("user.region", this.country);
            logger.trace("set to :" + DEFAULT_LOCALE.toString());
            Locale.setDefault(DEFAULT_LOCALE);
            this.currentLocale = DEFAULT_LOCALE;
            this.RESOURCE_DIR = LOCALE_DIR + this.language + '_' + this.country + '/';
            this.PRODUCT_RESOURCE_DIR = PRODUCT_LOCALE_DIR + this.language + '_' + this.country + '/';
            logger.trace("The resource dir is configure back to :" + this.RESOURCE_DIR);
        }
    }

    private static String[] manageLanguageMacro(String string) {
        String[] stringArray = new String[]{"", ""};
        String string2 = "@{INSLANGUAGE}";
        if (null == string || string2.equals(string)) {
            logger.trace("Macro for Language is invalid");
            return stringArray;
        }
        if (string.contains("_") && string.split("_").length == 2) {
            stringArray = string.split("_");
            stringArray[0] = stringArray[0].toLowerCase();
            stringArray[1] = stringArray[1].toUpperCase();
        }
        return stringArray;
    }

    private void constructLocale(boolean bl, String[] stringArray, String string) {
        String string2 = DEFAULT_LOCALE.getLanguage();
        String string3 = DEFAULT_LOCALE.getCountry();
        String[] stringArray2 = ResourceMng.manageLanguageMacro(stringArray[1]);
        if (bl && ResourceMng.isValidLocale(new Locale(stringArray2[0], stringArray2[1]))) {
            Locale locale;
            string2 = stringArray2[0];
            string3 = stringArray2[1];
            this.currentLocale = locale = new Locale(string2, string3);
            return;
        }
        if (System.getProperty("locale.language") != null && System.getProperty("locale.region") != null) {
            string2 = System.getProperty("locale.language");
            string3 = System.getProperty("locale.region");
        } else if (this.OSLanguage != null && string != null) {
            string2 = this.OSLanguage;
            string3 = string;
        }
        Locale locale = new Locale(string2, string3);
        this.currentLocale = ResourceMng.isValidLocale(locale) ? locale : DEFAULT_LOCALE;
    }

    private static boolean isValidLocale(Locale locale) {
        Locale[] localeArray = Locale.getAvailableLocales();
        if (null == localeArray) {
            return false;
        }
        String string = locale.getCountry();
        String string2 = locale.getLanguage();
        for (Locale locale2 : localeArray) {
            String string3 = locale2.getCountry();
            String string4 = locale2.getLanguage();
            if (!string3.equals(string) || !string4.equals(string2)) continue;
            return true;
        }
        return false;
    }

    public URL getURLFromProOrDefault(String string) {
        if (null == string || string.length() == 0) {
            return null;
        }
        URL uRL = null;
        logger.log((Priority)Level.ALL, "IconFile.iview=" + string);
        String string2 = iconPathMap.get(string);
        if (null != string2 && null != (uRL = ResourceMng.getURLFromJarOrFile(string2))) {
            return uRL;
        }
        String string3 = null;
        if (string != null && string.trim().length() > 0 && null == (uRL = ResourceMng.getURLFromJarOrFile(string3 = this.PRODUCT_RESOURCE_DIR + string))) {
            string3 = this.RESOURCE_DIR + string;
            uRL = ResourceMng.getURLFromJarOrFile(string3);
        }
        if (null != uRL) {
            String string4 = uRL.toExternalForm();
            string4 = string4.replace('\\', '/');
            iconPathMap.put(string, string4);
        } else {
            iconPathMap.put(string, string3);
        }
        return uRL;
    }

    private URL getURLFromConfProOrDefault(String string) {
        if (null == string || string.length() == 0) {
            return null;
        }
        URL uRL = null;
        logger.log((Priority)Level.ALL, "IconFile.iview=conf/" + string);
        String string2 = iconPathMap.get("conf" + string);
        if (null != string2 && null != (uRL = ResourceMng.getURLFromJarOrFile(string2))) {
            return uRL;
        }
        String string3 = null;
        if (string != null && string.trim().length() > 0 && null == (uRL = ResourceMng.getURLFromJarOrFile(string3 = PRODUCT_CONF_DIR + string))) {
            string3 = DEFAULT_CONF_DIR + string;
            uRL = ResourceMng.getURLFromJarOrFile(string3);
        }
        if (null != uRL) {
            String string4 = uRL.toExternalForm();
            string4 = string4.replace('\\', '/');
            iconPathMap.put("conf" + string, string4);
        } else {
            iconPathMap.put("conf" + string, string3);
        }
        return uRL;
    }

    public static URL getURLFromJarOrFile(String string) {
        URL uRL = null;
        File file = CommonUtil.getAbsoluteFile(string);
        if (file.exists()) {
            try {
                uRL = file.toURI().toURL();
            }
            catch (Exception exception) {
                logger.trace(exception.getMessage(), exception);
            }
        }
        if (null == uRL && null != string && !string.contains("/applications/")) {
            uRL = CommStyleManager.getURLFromJar(string);
        }
        return uRL;
    }

    public String[] getFilesFromLocale(String string) {
        if (string == null) {
            return new String[0];
        }
        String string2 = ResourceMng.getInstance().RESOURCE_DIR + string;
        String[] stringArray = CommStyleManager.getInstance().getAllFilesFromAllPaths(string2);
        String string3 = ResourceMng.getInstance().PRODUCT_RESOURCE_DIR + string;
        String[] stringArray2 = CommStyleManager.getInstance().getAllFilesFromAllPaths(string3);
        return CommStyleManager.getInstance().mergeAndRemoveDuplicateFromArray(stringArray, stringArray2);
    }

    public String getLocaleString() {
        return this.language + '_' + this.country;
    }

    public File findFileByLocale(String string) {
        if (null == string || "".equals(string.trim())) {
            logger.trace("File name you are searching is null or invalid");
            return null;
        }
        String string2 = "users" + File.separator + CommStyleManager.getInstance().getUsername();
        String[] stringArray = new String[]{string2, "all users", "productstyle", "defaultstyle"};
        boolean[] blArray = new boolean[]{false, false, true, true};
        File file = null;
        for (int i = 0; i < stringArray.length; ++i) {
            file = this.geStyleFile(stringArray[i], string, blArray[i]);
            if (null == file) continue;
            logger.trace(string + " found and path is: " + file.getPath());
            return file;
        }
        logger.trace("A file named " + string + " does not exists in any of the style folder");
        return null;
    }

    private File geStyleFile(String string, String string2, boolean bl) {
        URL uRL;
        String string3 = this.getLocale().getLanguage();
        String string4 = this.getLocale().getCountry();
        StringBuffer stringBuffer = new StringBuffer(25);
        stringBuffer.append("style");
        stringBuffer.append(File.separator);
        stringBuffer.append(string);
        stringBuffer.append(File.separator);
        stringBuffer.append("locale");
        stringBuffer.append(File.separator);
        stringBuffer.append(string3);
        stringBuffer.append("_");
        stringBuffer.append(string4);
        stringBuffer.append(File.separator);
        stringBuffer.append(string2);
        File file = null;
        file = CommonUtil.getAbsoluteFile(stringBuffer.toString());
        if (file.exists() && !file.isDirectory()) {
            return file;
        }
        if (bl && null != (uRL = CommStyleManager.getURLFromJar(stringBuffer.toString())) && null != uRL.getPath() && !(file = new File(uRL.getPath())).isDirectory()) {
            return file;
        }
        return null;
    }

    public Icon getIconAbsolute(String string) {
        if (null == string || string.length() == 0) {
            return null;
        }
        URL uRL = ResourceMng.getURLFromJarOrFile(string);
        if (null == uRL) {
            return null;
        }
        ImageIcon imageIcon = new ImageIcon(uRL);
        return imageIcon;
    }

    public ImageIcon getSkinImage(String string) {
        return SkinManager.getInstance().getSkinImage("", string);
    }

    public void readSerializedResource(String string) {
        Object t = SerializableTool.readData(string + File.separator + ICON_RESOURCE + '_' + this.language + '_' + this.country + ".dat");
        if (t instanceof ConcurrentHashMap) {
            iconPathMap = (ConcurrentHashMap)t;
        }
        if (null == iconPathMap) {
            iconPathMap = new ConcurrentHashMap(16);
        } else {
            ResourceMng.checkAndRecreateConfDir(iconPathMap);
        }
        iconPathMapSize = iconPathMap.size();
        Object t2 = SerializableTool.readData(string + File.separator + DEFAULT_RES_BUNDLE + '_' + this.language + '_' + this.country + ".dat");
        if (t2 instanceof ConcurrentHashMap) {
            defaultResBundles = (ConcurrentHashMap)t2;
        }
        if (null == defaultResBundles) {
            defaultResBundles = new ConcurrentHashMap(16);
        }
        isResBundlesModified = false;
        Object t3 = SerializableTool.readData(string + File.separator + BUNDLE_ENCODING + '_' + this.language + '_' + this.country + ".dat");
        if (t3 instanceof ConcurrentHashMap) {
            defaultEncoding = (ConcurrentHashMap)t3;
        }
        if (null == defaultEncoding) {
            defaultEncoding = new ConcurrentHashMap(16);
        }
        defaultEncodingSize = defaultEncoding.size();
    }

    public void writeSerializedResource(String string) {
        if (iconPathMapSize != iconPathMap.size()) {
            String string2 = CommonUtil.getCurrentUserDir();
            if (null != string2) {
                logger.trace("Sreialize the resource client path " + string2);
                iconPathMap.put("CURRENT_DIRECTORY", string2);
            }
            SerializableTool.writeData(string + File.separator + ICON_RESOURCE + '_' + this.language + '_' + this.country + ".dat", iconPathMap);
        }
        if (isResBundlesModified) {
            SerializableTool.writeData(string + File.separator + DEFAULT_RES_BUNDLE + '_' + this.language + '_' + this.country + ".dat", defaultResBundles);
        }
        if (defaultEncodingSize != defaultEncoding.size()) {
            SerializableTool.writeData(string + File.separator + BUNDLE_ENCODING + '_' + this.language + '_' + this.country + ".dat", defaultEncoding);
        }
    }

    public ResourceBundle[] getComponentVersionIDs(boolean bl) {
        ResourceBundle[] resourceBundleArray = new ResourceBundle[]{};
        HashSet<String> hashSet = this.getSubversionFileNames(bl);
        if (null != hashSet) {
            resourceBundleArray = new ResourceBundle[hashSet.size()];
            int n = 0;
            for (String string : hashSet) {
                ResourceBundle resourceBundle = this.getResourceBundleFromPropertyFile(string, bl);
                if (null == resourceBundle) continue;
                resourceBundleArray[n] = resourceBundle;
                ++n;
            }
            if (0 == n) {
                resourceBundleArray = new ResourceBundle[]{};
            }
        }
        return resourceBundleArray;
    }

    private HashSet<String> getSubversionFileNames(boolean bl) {
        HashSet<String> hashSet = new HashSet<String>(10);
        FilenameFilter filenameFilter = new FilenameFilter(){

            @Override
            public boolean accept(File file, String string) {
                File file2 = new File(file.getAbsolutePath() + File.separator + string);
                return file2.isFile() && string.endsWith("_version.properties");
            }
        };
        String string = this.RESOURCE_DIR + "subcomponent/";
        String string2 = this.PRODUCT_RESOURCE_DIR + "subcomponent/";
        if (bl) {
            this.getFileNamesFromJar(hashSet, string2);
            this.getFileNamesFromJar(hashSet, string);
        }
        File file = CommonUtil.getAbsoluteFile(string);
        File file2 = CommonUtil.getAbsoluteFile(string2);
        if (file2.exists() && file2.isDirectory()) {
            this.filterFiles(hashSet, filenameFilter, file2);
        }
        if (file.exists() && file.isDirectory()) {
            this.filterFiles(hashSet, filenameFilter, file);
        }
        if (hashSet.isEmpty()) {
            return null;
        }
        return hashSet;
    }

    private void getFileNamesFromJar(HashSet<String> hashSet, String string) {
        URL uRL = CommStyleManager.getURLFromJar(string);
        if (null != uRL) {
            String[] stringArray;
            for (String string2 : stringArray = CommStyleManager.getInstance().getAllFilefromJar(uRL)) {
                if (!string2.endsWith("_version.properties")) continue;
                String string3 = string2.substring(0, string2.lastIndexOf("."));
                String string4 = "subcomponent/" + string3;
                if (hashSet.contains(string4)) continue;
                hashSet.add(string4);
            }
        }
    }

    private void filterFiles(HashSet<String> hashSet, FilenameFilter filenameFilter, File file) {
        File[] fileArray;
        for (File file2 : fileArray = file.listFiles(filenameFilter)) {
            String string = file2.getName();
            String string2 = string.substring(0, string.lastIndexOf("."));
            string = "subcomponent/" + string2;
            if (hashSet.contains(string)) continue;
            hashSet.add(string);
        }
    }

    public ResourceBundle getResourceBundleFromPropertyFile(String string, boolean bl) {
        Object object;
        Object object2;
        if (null == string) {
            return null;
        }
        String string2 = null;
        logger.log((Priority)Level.ALL, "ResourceFile.iview=" + string);
        Properties properties = defaultResBundles.get(string);
        if (null != properties) {
            string2 = defaultEncoding.get(string);
            PropertyResourceBundleEx propertyResourceBundleEx = new PropertyResourceBundleEx(properties);
            if (string2 != null) {
                propertyResourceBundleEx.setEncoding(string2);
            } else {
                logger.trace("Encoding not got for the relative file name " + string);
                propertyResourceBundleEx.setEncoding(ResourceUtil.CLIENT_ENCODING);
            }
            return propertyResourceBundleEx;
        }
        Properties properties2 = null;
        String string3 = this.RESOURCE_DIR + string + ".properties";
        File file = CommonUtil.getAbsoluteFile(string3);
        if (!this.fileMap.containsKey(string3) && (file.exists() || bl && null != CommStyleManager.getURLFromJar(string3))) {
            properties = ResourceMng.getProperties(string3, bl);
            if (null != properties) {
                object2 = Utils.getInputStream(string3);
                if (null != object2) {
                    string2 = Utils.getEncoding((InputStream)object2);
                }
                if (null != object2) {
                    try {
                        ((InputStream)object2).close();
                    }
                    catch (IOException iOException) {
                        logger.trace(iOException);
                    }
                }
            }
        } else {
            logger.error("Resource file not found:" + string3);
            this.fileMap.putIfAbsent(string3, true);
        }
        object2 = this.PRODUCT_RESOURCE_DIR + string + ".properties";
        file = CommonUtil.getAbsoluteFile((String)object2);
        if (!this.fileMap.containsKey(object2) && (file.exists() || bl && null != CommStyleManager.getURLFromJar((String)object2))) {
            properties2 = ResourceMng.getProperties((String)object2, bl);
            if (null != object2 && null != (object = Utils.getInputStream(string3))) {
                string2 = Utils.getEncoding((InputStream)object);
                this.closeStream((InputStream)object);
            }
        } else {
            logger.trace("Resource file not found:" + (String)object2);
            this.fileMap.putIfAbsent((String)object2, true);
        }
        if (null == properties && null == properties2) {
            return null;
        }
        if (null == properties || null == properties2) {
            properties = properties != null ? properties : properties2;
        } else {
            ResourceMng.propertiesMerge(properties, properties2);
        }
        object = new PropertyResourceBundleEx(properties);
        if (null == string2) {
            string2 = ResourceUtil.CLIENT_ENCODING;
        }
        if (null != string && null != properties) {
            defaultResBundles.put(string, properties);
        }
        if (null != string && null != string2) {
            defaultEncoding.put(string, string2);
        }
        ((PropertyResourceBundleEx)object).setEncoding(string2);
        isResBundlesModified = true;
        return object;
    }

    private static void checkAndRecreateConfDir(ConcurrentHashMap<String, String> concurrentHashMap) {
        String string;
        boolean bl;
        if (null != concurrentHashMap && !(bl = CommonUtil.isCurrentUserDir(string = concurrentHashMap.get("CURRENT_DIRECTORY")))) {
            SerializableTool.recreateConfiguration();
            iconPathMap = new ConcurrentHashMap(16);
            return;
        }
    }

    private void closeStream(InputStream inputStream) {
        try {
            inputStream.close();
        }
        catch (IOException iOException) {
            logger.trace("fail to close Stream", iOException);
        }
    }

    static {
        iconPathMap = new ConcurrentHashMap(16);
        defaultResBundles = new ConcurrentHashMap(16);
        defaultEncoding = new ConcurrentHashMap(16);
        iconPathMapSize = 0;
        defaultEncodingSize = 0;
        isResBundlesModified = false;
    }
}

