/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.commstyle.commini.parsers;

import com.swimap.iview.commstyle.commini.AreaDescContainer;
import com.swimap.iview.commstyle.commini.CommStyleInfo;
import com.swimap.iview.commstyle.commini.CommStyleParserFactory;
import com.swimap.iview.commstyle.commini.DescContainer;
import com.swimap.iview.commstyle.commini.parsers.IParser;
import com.swimap.iview.commstyle.commini.xmlbind.PARA;
import com.swimap.iview.commstyle.commini.xmlbind.PARAS;
import com.swimap.iview.commstyle.commini.xmlbind.VALUE;
import com.swimap.iview.commstyle.commini.xmlimpl.write.Element;
import com.swimap.iview.util.CommonUtil;
import com.swimap.iview.util.log.IviewLogger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.Iterator;
import java.util.Stack;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

public class WoodstoxParser
implements IParser {
    private static IviewLogger logger = IviewLogger.getLogger(CommStyleParserFactory.class, "IVIEW");
    private static final String COMMINIDATA = "COMMINIDATA";
    private static final String AREADESC = "AREADESC";
    private static final String DESC = "DESC";
    private static final String PARA = "PARA";
    private static final String PARAS = "PARAS";
    private static final String VALUE = "VALUE";
    private static final String NAME = "name";
    private static final String TYPE = "type";
    private static final String AREANAME = "areaname";
    private static final String VALUE_ATTR = "value";
    private static final String DESCNAME = "descname";
    private static XMLInputFactory factory = XMLInputFactory.newInstance();
    private static XMLOutputFactory factoryOut = XMLOutputFactory.newInstance();
    private boolean writeStyleInfoSuccess = false;

    @Override
    public CommStyleInfo unmarshal(InputStream inputStream) {
        CommStyleInfo commStyleInfo = null;
        if (null == factory) {
            factory = XMLInputFactory.newInstance();
        }
        try {
            XMLStreamReader xMLStreamReader = factory.createXMLStreamReader(inputStream, CommStyleInfo.getResourceEncoding());
            commStyleInfo = WoodstoxParser.parseSTAXReader(xMLStreamReader);
        }
        catch (XMLStreamException xMLStreamException) {
            logger.trace(xMLStreamException.getMessage(), xMLStreamException);
        }
        if (null != commStyleInfo && commStyleInfo.getAreaDescCount() == 0) {
            commStyleInfo = null;
        }
        return commStyleInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CommStyleInfo unmarshal(File file) {
        FileInputStream fileInputStream = null;
        CommStyleInfo commStyleInfo = null;
        try {
            fileInputStream = new FileInputStream(file);
            commStyleInfo = this.unmarshal(fileInputStream);
        }
        catch (FileNotFoundException fileNotFoundException) {
            logger.trace(fileNotFoundException.getMessage(), fileNotFoundException);
        }
        finally {
            if (null != fileInputStream) {
                try {
                    ((InputStream)fileInputStream).close();
                }
                catch (IOException iOException) {
                    logger.trace("Failed to close the strem ");
                }
            }
        }
        return commStyleInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CommStyleInfo unmarshal(String string) {
        FileInputStream fileInputStream = null;
        CommStyleInfo commStyleInfo = null;
        try {
            fileInputStream = new FileInputStream(string);
            commStyleInfo = this.unmarshal(fileInputStream);
        }
        catch (FileNotFoundException fileNotFoundException) {
            logger.trace(string + " File not Found." + fileNotFoundException.getMessage());
            CommStyleInfo commStyleInfo2 = null;
            return commStyleInfo2;
        }
        finally {
            if (null != fileInputStream) {
                try {
                    ((InputStream)fileInputStream).close();
                }
                catch (IOException iOException) {
                    logger.trace("Failed to close the strem ");
                }
            }
        }
        return commStyleInfo;
    }

    @Override
    public CommStyleInfo unmarshal(Reader reader) {
        CommStyleInfo commStyleInfo = null;
        if (null == factory) {
            factory = XMLInputFactory.newInstance();
        }
        try {
            XMLStreamReader xMLStreamReader = factory.createXMLStreamReader(reader);
            commStyleInfo = WoodstoxParser.parseSTAXReader(xMLStreamReader);
        }
        catch (XMLStreamException xMLStreamException) {
            logger.trace(xMLStreamException);
        }
        if (null != commStyleInfo && commStyleInfo.getAreaDescCount() == 0) {
            commStyleInfo = null;
        }
        return commStyleInfo;
    }

    @Override
    public CommStyleInfo unmarshal(Element element) {
        return null;
    }

    private static CommStyleInfo parseSTAXReader(XMLStreamReader xMLStreamReader) throws XMLStreamException {
        CommStyleInfo commStyleInfo = new CommStyleInfo();
        boolean bl = false;
        boolean bl2 = false;
        Stack<DescContainer> stack = new Stack<DescContainer>();
        PARAS pARAS = null;
        PARA pARA = null;
        VALUE vALUE = null;
        AreaDescContainer areaDescContainer = null;
        int n = xMLStreamReader.next();
        while (n != 8) {
            switch (n) {
                case 1: {
                    String string = xMLStreamReader.getLocalName();
                    if (PARA.equals(string) && bl2) {
                        pARA = new PARA();
                        WoodstoxParser.startPara(xMLStreamReader, pARA);
                        break;
                    }
                    if (PARAS.equals(string) && !bl) {
                        bl2 = true;
                        pARAS = new PARAS();
                        break;
                    }
                    if (DESC.equals(string)) {
                        DescContainer descContainer = new DescContainer();
                        WoodstoxParser.startDesc(xMLStreamReader, descContainer);
                        stack.push(descContainer);
                        break;
                    }
                    if (AREADESC.equals(string)) {
                        areaDescContainer = new AreaDescContainer();
                        WoodstoxParser.stratAreaDesc(xMLStreamReader, areaDescContainer);
                        break;
                    }
                    if (!VALUE.equals(string)) break;
                    vALUE = new VALUE();
                    WoodstoxParser.startValue(xMLStreamReader, vALUE);
                    break;
                }
                case 2: {
                    String string = xMLStreamReader.getLocalName();
                    if (PARA.equals(string) && bl2) {
                        if (null == pARAS) break;
                        pARAS.addPARA(pARA);
                        break;
                    }
                    if (PARAS.equals(string) && null != pARAS) {
                        ((DescContainer)stack.lastElement()).setPARAS(pARAS);
                        bl = false;
                        bl2 = false;
                        break;
                    }
                    if (DESC.equals(string)) {
                        WoodstoxParser.endDesc(stack, areaDescContainer);
                        break;
                    }
                    if (AREADESC.equals(string) && null != areaDescContainer) {
                        commStyleInfo.addAreaDescContainer(areaDescContainer);
                        areaDescContainer = null;
                        break;
                    }
                    if (!VALUE.equals(string) || null == pARA) break;
                    pARA.addVALUE(vALUE);
                    break;
                }
            }
            n = xMLStreamReader.next();
        }
        return commStyleInfo;
    }

    private static void startPara(XMLStreamReader xMLStreamReader, PARA pARA) {
        String string = null;
        int n = xMLStreamReader.getAttributeCount();
        for (int i = 0; i < n; ++i) {
            string = xMLStreamReader.getAttributeName(i).toString();
            if (NAME.equals(string)) {
                pARA.name.setValue(xMLStreamReader.getAttributeValue(i));
                continue;
            }
            if (TYPE.equals(string)) {
                pARA.type.setValue(xMLStreamReader.getAttributeValue(i));
                continue;
            }
            if (!VALUE_ATTR.equals(string)) continue;
            pARA.value.setValue(xMLStreamReader.getAttributeValue(i));
        }
    }

    private static void startValue(XMLStreamReader xMLStreamReader, VALUE vALUE) {
        String string = null;
        int n = xMLStreamReader.getAttributeCount();
        for (int i = 0; i < n; ++i) {
            string = xMLStreamReader.getAttributeName(i).toString();
            if (TYPE.equals(string)) {
                vALUE.setType(xMLStreamReader.getAttributeValue(i));
                continue;
            }
            if (!VALUE_ATTR.equals(string)) continue;
            vALUE.setValue(xMLStreamReader.getAttributeValue(i));
        }
    }

    private static void stratAreaDesc(XMLStreamReader xMLStreamReader, AreaDescContainer areaDescContainer) {
        String string = null;
        int n = xMLStreamReader.getAttributeCount();
        for (int i = 0; i < n; ++i) {
            string = xMLStreamReader.getAttributeName(i).getLocalPart();
            if (!AREANAME.equals(string)) continue;
            areaDescContainer.areaname.setValue(xMLStreamReader.getAttributeValue(i));
        }
    }

    private static void startDesc(XMLStreamReader xMLStreamReader, DescContainer descContainer) {
        String string = null;
        int n = xMLStreamReader.getAttributeCount();
        for (int i = 0; i < n; ++i) {
            string = xMLStreamReader.getAttributeName(i).getLocalPart();
            if (!DESCNAME.equals(string)) continue;
            descContainer.descname.setValue(xMLStreamReader.getAttributeValue(i));
        }
    }

    private static void endDesc(Stack stack, AreaDescContainer areaDescContainer) {
        if (stack.size() > 1) {
            DescContainer descContainer = (DescContainer)stack.pop();
            ((DescContainer)stack.lastElement()).addDescContainer(descContainer);
        } else if (1 == stack.size()) {
            DescContainer descContainer = (DescContainer)stack.pop();
            areaDescContainer.addDescContainer(descContainer);
            stack.clear();
        }
    }

    @Override
    public void marshal(CommStyleInfo commStyleInfo, OutputStream outputStream) throws IOException {
        this.writeStoxXml(commStyleInfo, outputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void marshal(CommStyleInfo commStyleInfo, String string) throws IOException {
        FileOutputStream fileOutputStream = null;
        try {
            CommonUtil.checkDirectory(string);
            fileOutputStream = new FileOutputStream(string);
            this.writeStoxXml(commStyleInfo, fileOutputStream);
        }
        catch (FileNotFoundException fileNotFoundException) {
            logger.trace(fileNotFoundException.getMessage(), fileNotFoundException);
        }
        finally {
            if (null != fileOutputStream) {
                try {
                    ((OutputStream)fileOutputStream).close();
                }
                catch (IOException iOException) {
                    logger.trace(iOException.getMessage(), iOException);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void marshal(CommStyleInfo commStyleInfo, File file) throws IOException {
        FileOutputStream fileOutputStream = null;
        try {
            CommonUtil.checkDirectory(file.getAbsolutePath());
            fileOutputStream = new FileOutputStream(file);
            this.writeStoxXml(commStyleInfo, fileOutputStream);
        }
        catch (FileNotFoundException fileNotFoundException) {
            logger.trace(fileNotFoundException.getMessage(), fileNotFoundException);
        }
        finally {
            if (null != fileOutputStream) {
                try {
                    ((OutputStream)fileOutputStream).close();
                }
                catch (IOException iOException) {
                    logger.trace(iOException.getMessage(), iOException);
                }
            }
        }
    }

    @Override
    public void marshal(CommStyleInfo commStyleInfo, Writer writer) throws IOException {
        this.writeStyleInfoSuccess = false;
        XMLStreamWriter xMLStreamWriter = null;
        try {
            xMLStreamWriter = factoryOut.createXMLStreamWriter(writer);
            this.writeStoxXml(commStyleInfo, xMLStreamWriter);
            this.writeStyleInfoSuccess = true;
        }
        catch (XMLStreamException xMLStreamException) {
            logger.trace(xMLStreamException.getMessage(), xMLStreamException);
            throw new IOException();
        }
    }

    @Override
    public Element marshal(CommStyleInfo commStyleInfo) {
        return null;
    }

    @Override
    public boolean isWriteInfoSuccess() {
        return this.writeStyleInfoSuccess;
    }

    private void writeStoxXml(CommStyleInfo commStyleInfo, OutputStream outputStream) throws IOException {
        XMLStreamWriter xMLStreamWriter = null;
        try {
            xMLStreamWriter = factoryOut.createXMLStreamWriter(outputStream, CommStyleInfo.getResourceEncoding());
            this.writeStoxXml(commStyleInfo, xMLStreamWriter);
        }
        catch (XMLStreamException xMLStreamException) {
            logger.trace(xMLStreamException.getMessage(), xMLStreamException);
            throw new IOException();
        }
    }

    private void writeStoxXml(CommStyleInfo commStyleInfo, XMLStreamWriter xMLStreamWriter) throws IOException, XMLStreamException {
        xMLStreamWriter.writeStartDocument(commStyleInfo.getEncoding(), "1.0");
        xMLStreamWriter.writeDTD(System.getProperty("line.separator") + commStyleInfo.getDTDHeader());
        xMLStreamWriter.writeCharacters("\n");
        xMLStreamWriter.writeStartElement(COMMINIDATA);
        Iterator iterator = commStyleInfo.getAreaDescContainerList().iterator();
        AreaDescContainer areaDescContainer = null;
        while (iterator.hasNext()) {
            xMLStreamWriter.writeCharacters("\n\t");
            xMLStreamWriter.writeStartElement(AREADESC);
            areaDescContainer = (AreaDescContainer)iterator.next();
            if (areaDescContainer == null) continue;
            String string = areaDescContainer.getAreaName();
            if (null != string) {
                xMLStreamWriter.writeAttribute(AREANAME, string);
            }
            int n = areaDescContainer.getDescContainerCount();
            for (int i = 0; i < n; ++i) {
                this.writeStoxXmlDescData(xMLStreamWriter, areaDescContainer.getDescContainer(i));
            }
            xMLStreamWriter.writeCharacters("\n\t");
            xMLStreamWriter.writeEndElement();
            xMLStreamWriter.writeCharacters("\n");
        }
        xMLStreamWriter.writeEndElement();
        xMLStreamWriter.flush();
        xMLStreamWriter.close();
    }

    private void writeStoxXmlDescData(XMLStreamWriter xMLStreamWriter, DescContainer descContainer) throws XMLStreamException {
        int n;
        xMLStreamWriter.writeCharacters("\n\t\t");
        xMLStreamWriter.writeStartElement(DESC);
        String string = descContainer.getDescName();
        if (null != string) {
            xMLStreamWriter.writeAttribute(DESCNAME, string);
        }
        xMLStreamWriter.writeCharacters("\n\t\t\t");
        xMLStreamWriter.writeStartElement(PARAS);
        PARA pARA = null;
        String string2 = null;
        int n2 = 0;
        int n3 = descContainer.getParasItemCount();
        for (n = 0; n < n3; ++n) {
            xMLStreamWriter.writeCharacters("\n\t\t\t\t");
            xMLStreamWriter.writeStartElement(PARA);
            pARA = descContainer.getParasItem(n);
            string2 = pARA.getName();
            if (null != string2) {
                xMLStreamWriter.writeAttribute(NAME, string2);
            }
            if (null != (string2 = pARA.getValue())) {
                xMLStreamWriter.writeAttribute(VALUE_ATTR, string2);
            }
            if (null != (string2 = pARA.getType())) {
                xMLStreamWriter.writeAttribute(TYPE, string2);
            }
            if ((n2 = this.writeStoxXmlValueData(xMLStreamWriter, pARA)) > 0) {
                xMLStreamWriter.writeCharacters("\n\t\t\t\t");
            }
            xMLStreamWriter.writeEndElement();
        }
        xMLStreamWriter.writeCharacters("\n\t\t\t");
        xMLStreamWriter.writeEndElement();
        n = descContainer.getDescContainerCount();
        for (int i = 0; i < n; ++i) {
            this.writeStoxXmlDescData(xMLStreamWriter, descContainer.getDescContainer(i));
        }
        xMLStreamWriter.writeCharacters("\n\t\t");
        xMLStreamWriter.writeEndElement();
    }

    private int writeStoxXmlValueData(XMLStreamWriter xMLStreamWriter, PARA pARA) throws XMLStreamException {
        int n = pARA.getVALUECount();
        if (n <= 0) {
            return n;
        }
        String string = null;
        VALUE vALUE = null;
        for (int i = 0; i < n; ++i) {
            vALUE = pARA.getVALUE(i);
            xMLStreamWriter.writeCharacters("\n\t\t\t\t\t");
            xMLStreamWriter.writeStartElement(VALUE);
            string = vALUE.getType();
            if (null != string) {
                xMLStreamWriter.writeAttribute(TYPE, string);
            }
            if (null != (string = vALUE.getValue())) {
                xMLStreamWriter.writeAttribute(VALUE_ATTR, string);
            }
            xMLStreamWriter.writeEndElement();
        }
        return n;
    }

    static {
        factory.setProperty("javax.xml.stream.isValidating", false);
        factory.setProperty("javax.xml.stream.supportDTD", false);
    }
}

