/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.commstyle.commini.parsers;

import com.swimap.iview.commstyle.commini.AreaDescContainer;
import com.swimap.iview.commstyle.commini.CommStyleInfo;
import com.swimap.iview.commstyle.commini.parsers.DynamicEntityResolver;
import com.swimap.iview.commstyle.commini.parsers.IParser;
import com.swimap.iview.commstyle.commini.xmlimpl.write.Element;
import com.swimap.iview.commstyle.commini.xmlimpl.write.XmlUtil;
import com.swimap.iview.util.CommonUtil;
import com.swimap.iview.util.IViewStringBuffer;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringBufferInputStream;
import java.io.Writer;
import java.util.Iterator;
import org.xml.sax.InputSource;

public class SAXParser
implements IParser {
    private static final String DTD_STRING = "<?xml version='1.0' encoding='UTF-8' ?><!ELEMENT COMMINIDATA ( AREADESC+ ) ><!ELEMENT AREADESC ( DESC* ) ><!ATTLIST AREADESC areaname CDATA #IMPLIED ><!ELEMENT DESC ( PARAS, DESC* ) ><!ATTLIST DESC descname CDATA #IMPLIED ><!ELEMENT PARAS ( PARA* ) ><!ELEMENT PARA ( VALUE* ) ><!ATTLIST PARA name CDATA #REQUIRED ><!ATTLIST PARA type CDATA #IMPLIED ><!ATTLIST PARA value CDATA #IMPLIED ><!ELEMENT VALUE EMPTY ><!ATTLIST VALUE type CDATA #IMPLIED ><!ATTLIST VALUE value CDATA #REQUIRED >";
    private static final StringBufferInputStream IS = new StringBufferInputStream("<?xml version='1.0' encoding='UTF-8' ?><!ELEMENT COMMINIDATA ( AREADESC+ ) ><!ELEMENT AREADESC ( DESC* ) ><!ATTLIST AREADESC areaname CDATA #IMPLIED ><!ELEMENT DESC ( PARAS, DESC* ) ><!ATTLIST DESC descname CDATA #IMPLIED ><!ELEMENT PARAS ( PARA* ) ><!ELEMENT PARA ( VALUE* ) ><!ATTLIST PARA name CDATA #REQUIRED ><!ATTLIST PARA type CDATA #IMPLIED ><!ATTLIST PARA value CDATA #IMPLIED ><!ELEMENT VALUE EMPTY ><!ATTLIST VALUE type CDATA #IMPLIED ><!ATTLIST VALUE value CDATA #REQUIRED >");
    private static final InputSource SOURCE = new InputSource(IS);
    private boolean writeStyleInfoSuccess = false;

    @Override
    public CommStyleInfo unmarshal(InputStream inputStream) {
        this.setEntityResolver();
        return this.unmarshal(XmlUtil.getDocRootElement(inputStream));
    }

    private void setEntityResolver() {
        DynamicEntityResolver.addNewDTDSupport("commini.dtd", SOURCE);
        XmlUtil.setEntityResolver(DynamicEntityResolver.getInstance());
    }

    @Override
    public CommStyleInfo unmarshal(File file) {
        this.setEntityResolver();
        return this.unmarshal(XmlUtil.getDocRootElement(file));
    }

    @Override
    public CommStyleInfo unmarshal(String string) {
        File file = CommonUtil.getAbsoluteFile(string);
        this.setEntityResolver();
        return this.unmarshal(XmlUtil.getDocRootElement(file));
    }

    @Override
    public CommStyleInfo unmarshal(Reader reader) {
        this.setEntityResolver();
        return this.unmarshal(XmlUtil.getDocRootElement(reader));
    }

    @Override
    public CommStyleInfo unmarshal(Element element) {
        if (element == null) {
            return null;
        }
        CommStyleInfo commStyleInfo = new CommStyleInfo();
        Iterator iterator = element.getChildren("AREADESC").iterator();
        while (iterator.hasNext()) {
            commStyleInfo.addAreaDescContainer(AreaDescContainer.unmarshal((Element)((Object)iterator.next())));
        }
        return commStyleInfo;
    }

    @Override
    public void marshal(CommStyleInfo commStyleInfo, OutputStream outputStream) throws IOException {
        Element element = this.marshal(commStyleInfo);
        XmlUtil.writeDocument(outputStream, element, commStyleInfo.getPublicId(), commStyleInfo.getSystemId());
    }

    @Override
    public void marshal(CommStyleInfo commStyleInfo, String string) throws IOException {
        commStyleInfo.marshal(CommonUtil.getAbsoluteFile(string));
    }

    @Override
    public void marshal(CommStyleInfo commStyleInfo, File file) throws IOException {
    }

    @Override
    public void marshal(CommStyleInfo commStyleInfo, Writer writer) throws IOException {
        this.writeStyleInfoSuccess = false;
        if (writer == null) {
            return;
        }
        IViewStringBuffer iViewStringBuffer = new IViewStringBuffer(10240);
        commStyleInfo.toString(writer, iViewStringBuffer);
        writer.write(iViewStringBuffer.getValue(), 0, iViewStringBuffer.length());
        writer.flush();
        this.writeStyleInfoSuccess = true;
    }

    @Override
    public Element marshal(CommStyleInfo commStyleInfo) {
        Element element = new Element(commStyleInfo.get_TagName());
        Iterator iterator = commStyleInfo.getAreaDescContainerList().iterator();
        AreaDescContainer areaDescContainer = null;
        while (iterator.hasNext()) {
            areaDescContainer = (AreaDescContainer)iterator.next();
            if (areaDescContainer == null) continue;
            element.addContent(areaDescContainer.marshal());
        }
        return element;
    }

    @Override
    public boolean isWriteInfoSuccess() {
        return this.writeStyleInfoSuccess;
    }
}

