/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.commstyle.commini.parsers;

import com.swimap.iview.commstyle.commini.parsers.IParser;
import com.swimap.iview.commstyle.commini.parsers.SAXParser;
import com.swimap.iview.commstyle.commini.parsers.WoodstoxParser;
import com.swimap.iview.util.log.IviewLogger;

public final class ParserFactory {
    private static IviewLogger logger = IviewLogger.getLogger(ParserFactory.class, "IVIEW");
    public static final int SAX_PARSER = 1;
    public static final int WOODSTOX_PARSER = 2;

    public static IParser getParser() {
        String string = System.getProperty("parsertype");
        int n = 1;
        try {
            if (null != string) {
                n = Integer.parseInt(string);
            }
        }
        catch (NumberFormatException numberFormatException) {
            logger.trace(numberFormatException.getMessage(), numberFormatException);
            logger.trace("parsertype is not valid.");
        }
        IParser iParser = null;
        switch (n) {
            case 1: {
                iParser = new SAXParser();
                logger.trace("iview's SAX parser is created for style parsing.");
                break;
            }
            case 2: {
                iParser = new WoodstoxParser();
                logger.trace("Woodstox parser is created for style parsing.");
                break;
            }
            default: {
                iParser = new SAXParser();
                logger.trace("iview's SAXParser is created for style parsing.");
            }
        }
        return iParser;
    }
}

