/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.commstyle.commini.gui;

import com.swimap.iview.commstyle.commini.DescContainer;
import com.swimap.iview.commstyle.commini.IComminiProperties;
import com.swimap.iview.commstyle.commini.gui.IVSeparatorUI;
import com.swimap.iview.util.log.IviewLogger;
import javax.swing.JToolBar;
import javax.swing.UIManager;

public class IVSeparator
extends JToolBar.Separator
implements IComminiProperties {
    private static IviewLogger logger = IviewLogger.getLogger(IVSeparator.class, "IVIEW");
    private static final String uiClassID = "IVSeparatorUI";
    private DescContainer m_desc = null;
    private int serialNumber = Integer.MIN_VALUE;

    public IVSeparator() {
    }

    public IVSeparator(DescContainer descContainer) {
        this.m_desc = descContainer;
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    @Override
    public void updateUI() {
        this.setUI((IVSeparatorUI)UIManager.getUI(this));
    }

    @Override
    public int getSerialNumber() {
        if (this.serialNumber != Integer.MIN_VALUE) {
            return this.serialNumber;
        }
        this.serialNumber = -1;
        String string = this.m_desc.getParasItemValue("serialnumber");
        if (string == null || string.trim().length() == 0) {
            return this.serialNumber;
        }
        int n = string.lastIndexOf("-");
        if (n != -1) {
            string = string.substring(n + 1);
        }
        try {
            this.serialNumber = Integer.parseInt(string);
        }
        catch (Exception exception) {
            logger.error("sSerialNumber=" + string);
            logger.trace(exception.getMessage(), exception);
        }
        return this.serialNumber;
    }

    @Override
    public String getID() {
        return this.m_desc.getDescName();
    }

    static {
        UIManager.getDefaults().put(uiClassID, "com.swimap.iview.commstyle.commini.gui.IVSeparatorUI");
    }
}

