/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.commstyle.commini.foldingmenus;

import com.swimap.iview.commstyle.commini.Menu;
import com.swimap.iview.commstyle.commini.foldingmenus.ExpandMenuItemUI;
import com.swimap.iview.commstyle.commini.foldingmenus.FoldingMenuItem;
import com.swimap.iview.commstyle.commini.foldingmenus.FoldingMenuKeyListener;
import com.swimap.iview.commstyle.commini.foldingmenus.FoldingMenuUtilities;
import com.swimap.iview.commstyle.commini.foldingmenus.IActivity;
import com.swimap.iview.framework.applicationfavourites.MenuScroller;
import com.swimap.iview.framework.applicationmanagement.gui.FloatingAppPanel;
import com.swimap.iview.framework.util.FrameworkCommandProcessor;
import com.swimap.iview.util.CommonUtil;
import com.swimap.iview.util.ScreenToolKit;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.DefaultButtonModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.MenuElement;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuKeyListener;
import javax.swing.event.MenuListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class FoldingMenu
extends JMenu
implements IActivity {
    MenuScroller scroller = null;
    private MenuScrollItem upItem;
    private MenuScrollItem downItem;
    private int interval = 200;
    private int firstIndex = 0;
    private int scrollcount = (ScreenToolKit.getScreenHeight() - 23) / 23;
    private static final long serialVersionUID = 1L;
    private static IviewLogger logger = IviewLogger.getLogger(FoldingMenu.class, "IVIEW");
    private final List<Component> components = new ArrayList<Component>();
    private JMenuItem expandMenuItem = null;
    private transient Comparator activityComparator = new ActivityComparator();
    private transient Comparator positionComparator = new PositionComparator();
    private boolean enableFolding = false;
    private boolean userAddedOrRemoved = true;
    private List<Component> menuItems;
    private static final int DEFAULT_HEIGHT = 24;
    private HashMap<Integer, Component> invisibleMenus = new HashMap();

    public FoldingMenu() {
        this.installListeners();
    }

    public FoldingMenu(String string) {
        super(string);
        this.installListeners();
    }

    public FoldingMenu(Action action) {
        this();
        this.setAction(action);
    }

    public FoldingMenu(String string, boolean bl) {
        this(string);
    }

    public void uninstallListners() {
        Object object;
        if (this.getModel() instanceof DefaultButtonModel) {
            Object object2;
            object = (DefaultButtonModel)this.getModel();
            Object object3 = object2 = ((DefaultButtonModel)object).getChangeListeners();
            int n = ((Object)object3).length;
            for (int i = 0; i < n; ++i) {
                Object object4 = object3[i];
                ((DefaultButtonModel)object).removeChangeListener((ChangeListener)object4);
            }
        }
        for (Object object5 : object = this.getMenuListeners()) {
            this.removeMenuListener((MenuListener)object5);
        }
        this.removePopupListeners();
    }

    private void removePopupListeners() {
        JPopupMenu jPopupMenu = this.getPopupMenu();
        if (null != jPopupMenu) {
            int n;
            ContainerListener[] containerListenerArray = jPopupMenu.getContainerListeners();
            EventListener[] eventListenerArray = containerListenerArray;
            int n2 = eventListenerArray.length;
            for (n = 0; n < n2; ++n) {
                ContainerListener containerListener = eventListenerArray[n];
                jPopupMenu.removeContainerListener(containerListener);
            }
            EventListener[] eventListenerArray2 = eventListenerArray = jPopupMenu.getPopupMenuListeners();
            n = eventListenerArray2.length;
            for (int i = 0; i < n; ++i) {
                EventListener eventListener = eventListenerArray2[i];
                jPopupMenu.removePopupMenuListener((PopupMenuListener)eventListener);
            }
            for (EventListener eventListener : eventListenerArray2 = jPopupMenu.getMenuKeyListeners()) {
                jPopupMenu.removeMenuKeyListener((MenuKeyListener)eventListener);
            }
        }
    }

    private void installListeners() {
        MenuKeyListener[] menuKeyListenerArray;
        this.addMenuListener(new MenuSelectionListener());
        JPopupMenu jPopupMenu = super.getPopupMenu();
        jPopupMenu.addContainerListener(new PopupContainerListener());
        jPopupMenu.addPopupMenuListener(new PopupMenuSelectionListener());
        for (MenuKeyListener menuKeyListener : menuKeyListenerArray = jPopupMenu.getMenuKeyListeners()) {
            jPopupMenu.removeMenuKeyListener(menuKeyListener);
        }
        jPopupMenu.addMenuKeyListener(new FoldingMenuKeyListener(){

            @Override
            public MenuElement[] getPopupSubElements() {
                return FoldingMenu.this.getPopupSubElements();
            }
        });
        this.upItem = new MenuScrollItem(MenuIcon.UP, -1);
        this.downItem = new MenuScrollItem(MenuIcon.DOWN, 1);
    }

    @Override
    public JMenuItem add(JMenuItem jMenuItem) {
        this.addToPopupOnly(jMenuItem);
        this.components.remove(jMenuItem);
        this.components.add(jMenuItem);
        return jMenuItem;
    }

    @Override
    public Component add(Component component) {
        this.addToPopupOnly(component);
        this.components.remove(component);
        this.components.add(component);
        return component;
    }

    @Override
    public Component add(Component component, int n) {
        try {
            boolean bl = this.userAddedOrRemoved;
            this.userAddedOrRemoved = false;
            super.add(component, n);
            this.userAddedOrRemoved = bl;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.addToPopupOnly(component);
        }
        if (n > this.components.size() || n < 0 && n != -1) {
            throw new IllegalArgumentException("illegal component position");
        }
        this.components.remove(component);
        if (n > this.components.size()) {
            throw new IllegalArgumentException("illegal component position");
        }
        if (n == -1) {
            this.components.add(component);
        } else {
            this.components.add(n, component);
        }
        return component;
    }

    @Override
    public JMenuItem add(String string) {
        JMenuItem jMenuItem = super.add(string);
        logger.trace("Added JMenuItem. May not apply folding for this");
        return jMenuItem;
    }

    @Override
    public JMenuItem add(Action action) {
        JMenuItem jMenuItem = super.add(action);
        logger.trace("Added JMenuItem(action). May not apply folding for this");
        return jMenuItem;
    }

    @Override
    public void addSeparator() {
        this.add(new JPopupMenu.Separator());
    }

    private void addToPopupOnly(Component component) {
        boolean bl = this.userAddedOrRemoved;
        this.userAddedOrRemoved = false;
        super.add(component);
        this.userAddedOrRemoved = bl;
    }

    @Override
    public void insert(String string, int n) {
        if (n < 0) {
            throw new IllegalArgumentException("index less than zero.");
        }
        logger.trace("Added JMenuItem(insert(s,pos)). May not apply folding for this");
        JMenuItem jMenuItem = new JMenuItem(string);
        boolean bl = this.userAddedOrRemoved;
        this.userAddedOrRemoved = false;
        super.insert(jMenuItem, n);
        this.userAddedOrRemoved = bl;
        this.insert(n, jMenuItem);
    }

    private void insert(int n, Component component) {
        if (n < 0) {
            throw new IllegalArgumentException("index less than zero.");
        }
        this.components.remove(component);
        if (n > this.components.size()) {
            this.components.add(component);
        } else {
            this.components.add(n, component);
        }
    }

    @Override
    public JMenuItem insert(JMenuItem jMenuItem, int n) {
        if (n < 0) {
            throw new IllegalArgumentException("index less than zero.");
        }
        boolean bl = this.userAddedOrRemoved;
        this.userAddedOrRemoved = false;
        super.insert(jMenuItem, n);
        this.userAddedOrRemoved = bl;
        this.insert(n, jMenuItem);
        return jMenuItem;
    }

    @Override
    public JMenuItem insert(Action action, int n) {
        if (n < 0) {
            throw new IllegalArgumentException("index less than zero.");
        }
        JMenuItem jMenuItem = new JMenuItem(action);
        jMenuItem.setHorizontalTextPosition(11);
        jMenuItem.setVerticalTextPosition(0);
        boolean bl = this.userAddedOrRemoved;
        this.userAddedOrRemoved = false;
        super.insert(jMenuItem, n);
        this.userAddedOrRemoved = bl;
        this.insert(n, jMenuItem);
        return jMenuItem;
    }

    @Override
    public void insertSeparator(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("index less than zero.");
        }
        JPopupMenu.Separator separator = new JPopupMenu.Separator();
        boolean bl = this.userAddedOrRemoved;
        this.userAddedOrRemoved = false;
        super.getPopupMenu().insert(separator, n);
        this.userAddedOrRemoved = bl;
        this.insert(n, separator);
    }

    protected void insert(JSeparator jSeparator, int n) {
        boolean bl = this.userAddedOrRemoved;
        this.userAddedOrRemoved = false;
        super.getPopupMenu().insert(jSeparator, n);
        this.userAddedOrRemoved = bl;
        this.insert(n, jSeparator);
    }

    @Override
    public JMenuItem getItem(int n) {
        if (n < 0 || n >= this.components.size()) {
            throw new IllegalArgumentException("invalid index: " + n);
        }
        Component component = this.components.get(n);
        if (component instanceof JMenuItem) {
            JMenuItem jMenuItem = (JMenuItem)component;
            return jMenuItem;
        }
        return null;
    }

    @Override
    public void remove(JMenuItem jMenuItem) {
        boolean bl = this.userAddedOrRemoved;
        this.userAddedOrRemoved = false;
        super.remove(jMenuItem);
        this.userAddedOrRemoved = bl;
        this.components.remove(jMenuItem);
    }

    @Override
    public void remove(int n) {
        try {
            boolean bl = this.userAddedOrRemoved;
            this.userAddedOrRemoved = false;
            super.remove(n);
            this.userAddedOrRemoved = bl;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            logger.trace("Removed component not present in the popup menu" + illegalArgumentException.getMessage());
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            logger.trace("Removed component not present in the popup menu" + arrayIndexOutOfBoundsException.getMessage());
        }
        if (n < 0) {
            throw new IllegalArgumentException("index less than zero.");
        }
        if (n > this.getItemCount()) {
            throw new IllegalArgumentException("index greater than the number of items.");
        }
        this.components.remove(n);
    }

    @Override
    public void remove(Component component) {
        boolean bl = this.userAddedOrRemoved;
        this.userAddedOrRemoved = false;
        super.remove(component);
        this.userAddedOrRemoved = bl;
        this.components.remove(component);
    }

    @Override
    public void removeAll() {
        boolean bl = this.userAddedOrRemoved;
        this.userAddedOrRemoved = false;
        super.removeAll();
        this.userAddedOrRemoved = bl;
        this.components.clear();
    }

    @Override
    public int getMenuComponentCount() {
        return this.components.size();
    }

    @Override
    public Component getMenuComponent(int n) {
        if (n < 0 || n >= this.components.size()) {
            throw new ArrayIndexOutOfBoundsException("No such child: " + n);
        }
        return this.components.get(n);
    }

    @Override
    public Component[] getMenuComponents() {
        return this.components.toArray(new Component[this.components.size()]);
    }

    public boolean isEnableFolding() {
        return this.enableFolding;
    }

    public void setEnableFolding(boolean bl) {
        this.enableFolding = bl;
    }

    public void unfoldMenus(Component component) {
        if (-1 == this.getPopupMenu().getComponentIndex(component)) {
            this.showAllMenuItems();
        }
    }

    public MenuElement[] getPopupSubElements() {
        MenuElement[] menuElementArray = null;
        Vector<Component> vector = new Vector<Component>(10);
        int n = this.getMenuComponentCount();
        int n2 = 0;
        Component component = null;
        for (n2 = 0; n2 < n; ++n2) {
            component = this.getMenuComponent(n2);
            if (!(component instanceof MenuElement)) continue;
            vector.addElement(component);
        }
        int n3 = vector.size();
        menuElementArray = new MenuElement[n3];
        n = vector.size();
        for (n2 = 0; n2 < n; ++n2) {
            menuElementArray[n2] = (MenuElement)vector.elementAt(n2);
        }
        return menuElementArray;
    }

    protected void showAllMenuItems() {
        this.removeToolTip();
        boolean bl = this.userAddedOrRemoved;
        this.userAddedOrRemoved = false;
        super.removeAll();
        this.userAddedOrRemoved = bl;
        for (Component component : this.components) {
            this.addToPopupOnly(component);
        }
        if (this.getPopupMenu().getComponents().length > this.scrollcount) {
            this.setMenuItems();
        }
        this.validateMenu();
    }

    private void removeToolTip() {
        CommonUtil.hideShowTooltip();
    }

    private void showFoldedMenuItems() {
        int n;
        int n2;
        this.removeToolTip();
        boolean bl = this.userAddedOrRemoved;
        this.userAddedOrRemoved = false;
        super.removeAll();
        this.userAddedOrRemoved = bl;
        ArrayList<Component> arrayList = new ArrayList<Component>(this.components);
        Collections.sort(arrayList, this.activityComparator);
        int n3 = this.getUsedMenuItemCount(arrayList);
        ArrayList<Component> arrayList2 = new ArrayList<Component>(10);
        ArrayList<Component> arrayList3 = new ArrayList<Component>(10);
        Component component = null;
        int n4 = arrayList.size();
        int n5 = this.getVisibleMenuItemCount();
        if (n3 + 1 == n5) {
            n3 = n5;
        }
        for (n2 = 0; n2 < n3 && n2 < n4; ++n2) {
            component = (Component)arrayList.get(n2);
            if (!component.isVisible() || component instanceof JSeparator) {
                ++n3;
                continue;
            }
            if (component instanceof IActivity && ((IActivity)((Object)component)).isAlwaysShown()) {
                arrayList2.add(component);
                continue;
            }
            arrayList3.add((Component)arrayList.get(n2));
        }
        arrayList3.addAll(arrayList2);
        n2 = arrayList.size();
        for (n = n3; n < n2; ++n) {
            component = (Component)arrayList.get(n);
            if (!(component instanceof IActivity) || !((IActivity)((Object)component)).isAlwaysShown()) continue;
            arrayList3.add(component);
        }
        Collections.sort(arrayList3, this.positionComparator);
        n = n5 > arrayList3.size() ? 1 : 0;
        List<Component> list = this.addSeparators(arrayList3);
        for (Component component2 : list) {
            this.addToPopupOnly(component2);
        }
        if (n != 0) {
            this.addToPopupOnly(this.getExpandMenuItem());
        }
        this.validateMenu();
    }

    private int getVisibleMenuItemCount() {
        int n = 0;
        for (Component component : this.components) {
            if (!component.isVisible() || component instanceof JSeparator) continue;
            ++n;
        }
        return n;
    }

    private void validateMenu() {
        this.getPopupMenu().pack();
        this.getPopupMenu().repaint();
    }

    private int getUsedMenuItemCount(List<Component> list) {
        int n;
        int n2 = FoldingMenuUtilities.getDefaultVisibleCount();
        int n3 = 0;
        int n4 = list.size();
        Component component = null;
        IActivity iActivity = null;
        for (n = 0; n < n4; ++n) {
            component = list.get(n);
            if (!(component instanceof IActivity)) {
                n3 = n;
                break;
            }
            iActivity = (IActivity)((Object)component);
            if (!iActivity.isAlwaysShown() && iActivity.getActivityCount() > 0) continue;
            n3 = n;
            break;
        }
        if (n == n4) {
            n3 = n;
        }
        return Math.max(n2, n3);
    }

    private List<Component> addSeparators(List<Component> list) {
        ArrayList<Component> arrayList = new ArrayList<Component>(list);
        Component component = null;
        Component component2 = null;
        Component component3 = null;
        int n = list.size();
        for (int i = 0; i < n - 1; ++i) {
            component = list.get(i);
            component3 = this.getSeparatorBetween(component, component2 = list.get(i + 1));
            if (null == component3) continue;
            arrayList.add(arrayList.indexOf(component2), component3);
        }
        return arrayList;
    }

    private Component getSeparatorBetween(Component component, Component component2) {
        int n = this.components.indexOf(component);
        int n2 = this.components.indexOf(component2);
        Component component3 = null;
        for (int i = n + 1; i < n2; ++i) {
            if (!(this.components.get(i) instanceof JSeparator)) continue;
            component3 = this.components.get(i);
            break;
        }
        return component3;
    }

    public JMenuItem getExpandMenuItem() {
        if (null != this.expandMenuItem) {
            return this.expandMenuItem;
        }
        this.expandMenuItem = new FoldingMenuItem(){

            @Override
            public void menuSelectionChanged(boolean bl) {
                super.menuSelectionChanged(bl);
                ExpandMenuItemUI expandMenuItemUI = (ExpandMenuItemUI)FoldingMenu.this.expandMenuItem.getUI();
                if (bl) {
                    if (expandMenuItemUI.isMouseOver()) {
                        return;
                    }
                    FoldingMenu.this.showAllMenuItems();
                    FoldingMenuUtilities.setExpanded(true);
                } else {
                    expandMenuItemUI.stopTimer();
                }
            }
        };
        this.expandMenuItem.setUI(new ExpandMenuItemUI());
        this.expandMenuItem.setName("ExpandMenuItem");
        ImageIcon imageIcon = new ImageIcon(FoldingMenu.class.getResource("menu_down_arrow.gif"));
        JLabel jLabel = new JLabel();
        jLabel.setIcon(imageIcon);
        this.expandMenuItem.setPreferredSize(new Dimension(1, 24));
        this.expandMenuItem.setLayout(new FlowLayout());
        this.expandMenuItem.add(jLabel);
        this.expandMenuItem.setToolTipText(FoldingMenuUtilities.getResourceBundle().getString("Expand"));
        return this.expandMenuItem;
    }

    @Override
    public int getActivityCount() {
        int n = 0;
        int n2 = this.components.size();
        Component component = null;
        for (int i = 0; i < n2; ++i) {
            int n3;
            component = this.components.get(i);
            if (!(component instanceof IActivity) || (n3 = ((IActivity)((Object)component)).getActivityCount()) <= n) continue;
            n = n3;
        }
        return n;
    }

    @Override
    public boolean isAlwaysShown() {
        return false;
    }

    @Override
    public void setActivityCount(int n) {
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
    }

    private void setMenuItems() {
        if (null != this.menuItems) {
            this.menuItems.clear();
        } else {
            this.menuItems = new ArrayList<Component>();
        }
        for (int i = 0; i < this.components.size(); ++i) {
            if (this.components.get(i).isVisible()) {
                this.menuItems.add(this.components.get(i));
                continue;
            }
            this.invisibleMenus.put(i, this.components.get(i));
        }
        if (this.menuItems.size() > this.scrollcount) {
            this.refreshMenu();
        }
    }

    private void refreshMenu() {
        try {
            this.upItem.setEnabled(this.firstIndex > 0);
            boolean bl = this.firstIndex + this.scrollcount < this.menuItems.size();
            this.downItem.setEnabled(bl);
            if (this.menuItems != null && this.menuItems.size() > 0) {
                int n;
                this.removeAll();
                this.getPopupMenu().add(this.upItem);
                for (n = 0; n < this.firstIndex; ++n) {
                    this.components.add(this.menuItems.get(n));
                }
                for (n = this.firstIndex; n < this.scrollcount + this.firstIndex; ++n) {
                    this.getPopupMenu().add(this.menuItems.get(n));
                }
                this.getPopupMenu().add(this.downItem);
                for (n = this.scrollcount + this.firstIndex; n < this.menuItems.size(); ++n) {
                    this.components.add(this.menuItems.get(n));
                }
                for (Map.Entry<Integer, Component> entry : this.invisibleMenus.entrySet()) {
                    if (entry.getKey() > this.components.size() - 1) {
                        this.components.add(entry.getValue());
                        continue;
                    }
                    this.components.add(entry.getKey(), entry.getValue());
                }
                this.invisibleMenus.clear();
                JComponent jComponent = (JComponent)this.upItem.getParent();
                this.getPopupMenu().pack();
                jComponent.revalidate();
                jComponent.repaint();
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            logger.debug("Iview handled array index exception");
        }
    }

    public void cleanupWhileOSGIExit() {
        this.activityComparator = null;
        this.positionComparator = null;
    }

    private class PopupMenuSelectionListener
    implements PopupMenuListener {
        private PopupMenuSelectionListener() {
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
            FoldingMenuItem.hideShortcutPopupMenu();
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
            FoldingMenuItem.hideShortcutPopupMenu();
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
            if (((JPopupMenu)popupMenuEvent.getSource()).getComponents().length > FoldingMenu.this.scrollcount) {
                FoldingMenu.this.setMenuItems();
            }
        }
    }

    private static enum MenuIcon implements Icon
    {
        UP(9, 1, 9),
        DOWN(1, 9, 1);

        final int[] xPoints = new int[]{1, 5, 9};
        final int[] yPoints;

        private MenuIcon(int ... nArray) {
            this.yPoints = nArray;
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            Dimension dimension = component.getSize();
            Graphics graphics2 = graphics.create(dimension.width / 2 - 5, dimension.height / 2 - 5, 10, 10);
            graphics2.setColor(Color.GRAY);
            graphics2.drawPolygon(this.xPoints, this.yPoints, 3);
            if (component.isEnabled()) {
                graphics2.setColor(Color.BLACK);
                graphics2.fillPolygon(this.xPoints, this.yPoints, 3);
            }
            graphics2.dispose();
        }

        @Override
        public int getIconWidth() {
            return 0;
        }

        @Override
        public int getIconHeight() {
            return 10;
        }
    }

    private class MenuScrollItem
    extends JMenuItem
    implements ChangeListener {
        private MenuScrollTimer timer;

        public MenuScrollItem(MenuIcon menuIcon, int n) {
            this.setIcon(menuIcon);
            this.setDisabledIcon(menuIcon);
            this.timer = new MenuScrollTimer(n, FoldingMenu.this.interval);
            this.addChangeListener(this);
        }

        public void setInterval(int n) {
            this.timer.setDelay(n);
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            if (this.isArmed() && !this.timer.isRunning()) {
                this.timer.start();
            }
            if (!this.isArmed() && this.timer.isRunning()) {
                this.timer.stop();
            }
        }
    }

    private class MenuScrollTimer
    extends Timer {
        public MenuScrollTimer(final int n, int n2) {
            super(n2, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    FoldingMenu.this.firstIndex += n;
                }
            });
        }
    }

    private class PositionComparator
    implements Comparator {
        private PositionComparator() {
        }

        public int compare(Object object, Object object2) {
            int n;
            int n2 = FoldingMenu.this.components.indexOf(object);
            if (n2 < (n = FoldingMenu.this.components.indexOf(object2))) {
                return -1;
            }
            if (n2 > n) {
                return 1;
            }
            return 0;
        }
    }

    private static class ActivityComparator
    implements Comparator,
    Serializable {
        private ActivityComparator() {
        }

        public int compare(Object object, Object object2) {
            int n;
            if (!(object instanceof IActivity) && !(object2 instanceof IActivity)) {
                return 0;
            }
            if (!(object instanceof IActivity)) {
                if (((IActivity)object2).isAlwaysShown()) {
                    return -1;
                }
                return 1;
            }
            if (!(object2 instanceof IActivity)) {
                if (((IActivity)object).isAlwaysShown()) {
                    return 1;
                }
                return -1;
            }
            if (((IActivity)object).isAlwaysShown() && !((IActivity)object2).isAlwaysShown()) {
                return 1;
            }
            if (!((IActivity)object).isAlwaysShown() && ((IActivity)object2).isAlwaysShown()) {
                return -1;
            }
            if (((IActivity)object).isAlwaysShown() && ((IActivity)object2).isAlwaysShown()) {
                return 0;
            }
            int n2 = ((IActivity)object).getActivityCount();
            if (n2 < (n = ((IActivity)object2).getActivityCount())) {
                return 1;
            }
            if (n2 > n) {
                return -1;
            }
            return 0;
        }
    }

    private class PopupContainerListener
    implements ContainerListener {
        private PopupContainerListener() {
        }

        @Override
        public void componentAdded(ContainerEvent containerEvent) {
            if (FoldingMenu.this.userAddedOrRemoved && !(containerEvent.getChild() instanceof MenuScrollItem)) {
                FoldingMenu.this.components.add(containerEvent.getChild());
            }
        }

        @Override
        public void componentRemoved(ContainerEvent containerEvent) {
            if (FoldingMenu.this.userAddedOrRemoved) {
                Component component = containerEvent.getChild();
                FoldingMenu.this.components.remove(component);
            }
        }
    }

    private class MenuSelectionListener
    implements MenuListener {
        private MenuSelectionListener() {
        }

        @Override
        public void menuCanceled(MenuEvent menuEvent) {
        }

        @Override
        public void menuDeselected(MenuEvent menuEvent) {
            FoldingMenu.this.showAllMenuItems();
        }

        @Override
        public void menuSelected(MenuEvent menuEvent) {
            if (FoldingMenu.this.enableFolding && !FoldingMenuUtilities.isExpandedAlready() && FoldingMenu.this.components.size() > FoldingMenuUtilities.getDefaultVisibleCount()) {
                FoldingMenu.this.showFoldedMenuItems();
            } else {
                FoldingMenu.this.showAllMenuItems();
            }
            if (FrameworkCommandProcessor.getInstance().isAppStyle() && FloatingAppPanel.getInstance().isVisible() && menuEvent.getSource() instanceof Menu && !((Menu)menuEvent.getSource()).isPortalPopupMenu()) {
                FloatingAppPanel.getInstance().setVisible(false);
            }
        }
    }
}

