/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.commstyle.commini.foldingmenus;

import com.swimap.iview.commstyle.commini.foldingmenus.FoldingMenu;
import com.swimap.iview.commstyle.commini.foldingmenus.FoldingMenuItem;
import com.swimap.iview.commstyle.commini.foldingmenus.FoldingMenuUtilities;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.Timer;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicMenuItemUI;

class ExpandMenuItemUI
extends BasicMenuItemUI {
    private Timer expandMenuTimer = null;
    private static final int TWO_SEC = 2100;
    private boolean mouseOver = false;

    ExpandMenuItemUI() {
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new ExpandMenuItemUI();
    }

    @Override
    protected MouseInputListener createMouseInputListener(JComponent jComponent) {
        return new MouseInputHandler();
    }

    @Override
    protected void doClick(MenuSelectionManager menuSelectionManager) {
        MenuElement[] menuElementArray = menuSelectionManager.getSelectedPath();
        int n = menuElementArray.length - 1;
        FoldingMenuItem foldingMenuItem = (FoldingMenuItem)menuElementArray[n].getComponent();
        JPopupMenu jPopupMenu = (JPopupMenu)foldingMenuItem.getParent();
        FoldingMenu foldingMenu = (FoldingMenu)jPopupMenu.getInvoker();
        foldingMenu.showAllMenuItems();
    }

    public boolean isMouseOver() {
        return this.mouseOver;
    }

    protected void stopTimer() {
        this.mouseOver = false;
        if (this.expandMenuTimer != null && this.expandMenuTimer.isRunning()) {
            this.expandMenuTimer.stop();
        }
    }

    private class MouseInputHandler
    extends BasicMenuItemUI.MouseInputHandler {
        private MouseInputHandler() {
            super(ExpandMenuItemUI.this);
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (FoldingMenuItem.isShortcutVisible()) {
                FoldingMenuItem.hideShortcutPopupMenu();
            }
            if (ExpandMenuItemUI.this.expandMenuTimer.isRunning()) {
                ExpandMenuItemUI.this.expandMenuTimer.stop();
            }
            FoldingMenuItem foldingMenuItem = (FoldingMenuItem)mouseEvent.getSource();
            JPopupMenu jPopupMenu = (JPopupMenu)foldingMenuItem.getParent();
            FoldingMenu foldingMenu = (FoldingMenu)jPopupMenu.getInvoker();
            foldingMenu.showAllMenuItems();
            FoldingMenuUtilities.setExpanded(true);
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            ExpandMenuItemUI.this.mouseOver = true;
            FoldingMenuItem foldingMenuItem = (FoldingMenuItem)mouseEvent.getSource();
            JPopupMenu jPopupMenu = (JPopupMenu)foldingMenuItem.getParent();
            final FoldingMenu foldingMenu = (FoldingMenu)jPopupMenu.getInvoker();
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            menuSelectionManager.setSelectedPath(ExpandMenuItemUI.this.getPath());
            ExpandMenuItemUI.this.expandMenuTimer = new Timer(2100, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (!FoldingMenuItem.isShortcutVisible()) {
                        ExpandMenuItemUI.this.mouseOver = false;
                        foldingMenu.showAllMenuItems();
                        FoldingMenuUtilities.setExpanded(true);
                    }
                }
            });
            ExpandMenuItemUI.this.expandMenuTimer.start();
            ExpandMenuItemUI.this.expandMenuTimer.setRepeats(false);
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            ExpandMenuItemUI.this.mouseOver = false;
            ExpandMenuItemUI.this.expandMenuTimer.stop();
            super.mouseExited(mouseEvent);
        }
    }
}

