/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.commstyle.commini;

import com.swimap.iview.commstyle.commini.ApppopupMenuset;
import com.swimap.iview.commstyle.commini.AreaDescContainer;
import com.swimap.iview.commstyle.commini.CommStyleInfo;
import com.swimap.iview.commstyle.commini.CommStyleManager;
import com.swimap.iview.commstyle.commini.DescContainer;
import com.swimap.iview.commstyle.commini.MenuBarFactory;
import com.swimap.iview.commstyle.commini.MenuSet;
import com.swimap.iview.commstyle.commini.PopupMenu;
import com.swimap.iview.commstyle.commini.ToolGroupSet;
import com.swimap.iview.commstyle.resource.ResourceMng;
import com.swimap.iview.framework.pluginmanagement.Plugin;
import com.swimap.iview.framework.pluginmanagement.PluginManager;
import com.swimap.iview.framework.pluginmanagement.Resource;
import com.swimap.iview.util.log.IviewLogger;
import java.util.Hashtable;
import java.util.ResourceBundle;
import javax.swing.JMenuBar;
import javax.swing.JPopupMenu;

public class UIObjStyleInfo {
    private static IviewLogger logger = IviewLogger.getLogger(UIObjStyleInfo.class, "IVIEW");
    private CommStyleManager commStyleManager;
    private CommStyleInfo commStyleInfo = null;
    private Hashtable menuBarHash = new Hashtable();
    private Hashtable popupMenuHash = new Hashtable();
    private Hashtable menuSetHash = new Hashtable();
    private Hashtable toolGroupSetHash = new Hashtable();

    public String getStyleInfoName() {
        if (this.commStyleInfo != null) {
            return this.commStyleInfo.getFileName();
        }
        return null;
    }

    public int buildFromStyle(String string) {
        return this.buildFromStyle(string, true);
    }

    public int buildFromStyleOfExtPath(String string, String string2) {
        return this.buildFromStyleOfExtPath(string, true, string2);
    }

    public int buildFromStyle(String string, boolean bl) {
        return this.buildFromStyleOfExtPath(string, bl, null);
    }

    public int buildFromStyleOfExtPath(String string, boolean bl, String string2) {
        if (string == null) {
            throw new IllegalArgumentException("comonStyleFileName CANNOT be null.");
        }
        this.commStyleInfo = bl ? (null == string2 ? this.commStyleManager.getCommonStyleFile(string) : this.commStyleManager.getCommonStyleFileOfExtPath(string, string2)) : (null == string2 ? this.commStyleManager.getCommonStyleFromDefaultAndProductStyle(string) : this.commStyleManager.getCommonStyleFromDefaultAndProductStyleOfExtPath(string, string2));
        if (this.commStyleInfo == null) {
            logger.debug("style file not existed");
            return -1;
        }
        DescContainer descContainer = null;
        AreaDescContainer areaDescContainer = this.commStyleInfo.getAreaDescContainer(0);
        int n = areaDescContainer.getDescCount();
        String string3 = null;
        for (int i = 0; i < n; ++i) {
            descContainer = areaDescContainer.getDescContainer(i);
            string3 = descContainer.getParasItemValue("type");
            if (string3 == null) {
                logger.trace("this desc have no type tag (descname: " + descContainer.getDescName() + ')');
                continue;
            }
            if ("ResourceBundle".equals(string3)) {
                ResourceBundle resourceBundle = null;
                String string4 = descContainer.getParasItemValue("resourceBundleName");
                try {
                    resourceBundle = ResourceMng.getInstance().getResourceBundleFromPropertyFile(string4);
                    if (null == resourceBundle) {
                        resourceBundle = ResourceBundle.getBundle(string4);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.commStyleInfo.setResourceBundle(resourceBundle);
                continue;
            }
            if ("PropertyFile".equals(string3)) {
                this.commStyleInfo.setResourceBundle(ResourceMng.getInstance().getResourceBundleFromPropertyFile(descContainer.getParasItemValue("resourceBundleName")));
                continue;
            }
            if ("XmlFile".equals(string3)) {
                this.commStyleInfo.setResourceBundle(ResourceMng.getInstance().getResourceBundle(descContainer.getParasItemValue("resourceBundleName")));
                continue;
            }
            if ("JMenuBar".equals(string3)) {
                this.menuBarHash.put(descContainer.getDescName(), descContainer);
                continue;
            }
            if ("MenuSet".equals(string3)) {
                this.menuSetHash.put(descContainer.getDescName(), descContainer);
                continue;
            }
            if ("JPopupMenu".equals(string3)) {
                this.popupMenuHash.put(descContainer.getDescName(), descContainer);
                continue;
            }
            if (!"ToolGroupSet".equals(string3)) continue;
            this.toolGroupSetHash.put(descContainer.getDescName(), descContainer);
        }
        return 1;
    }

    public UIObjStyleInfo() {
        this.commStyleManager = CommStyleManager.getInstance();
    }

    public MenuSet getMenuSet(String string) {
        if (string == null) {
            logger.debug("Parameter 'id' is null. Method will return null.");
            return null;
        }
        MenuSet menuSet = (MenuSet)MenuSet.getUIObject((DescContainer)this.menuSetHash.get(string));
        if (menuSet == null) {
            logger.debug("not MenuSet with this id :" + string);
        }
        return menuSet;
    }

    public MenuSet getAppPopuMenuSet(String string) {
        if (string == null) {
            logger.debug("Parameter 'id' is null. Method will return null.");
            return null;
        }
        MenuSet menuSet = (MenuSet)ApppopupMenuset.getUIObject((DescContainer)this.menuSetHash.get(string));
        if (menuSet == null) {
            logger.debug("not MenuSet with this id :" + string);
        }
        return menuSet;
    }

    public ToolGroupSet getToolGroupSet(String string) {
        if (string == null) {
            throw new IllegalArgumentException("id CANNOT be null. ");
        }
        DescContainer descContainer = (DescContainer)this.toolGroupSetHash.get(string);
        if (descContainer == null) {
            return null;
        }
        ToolGroupSet toolGroupSet = (ToolGroupSet)ToolGroupSet.getUIObject(descContainer);
        toolGroupSet.setStyleSaveID(null);
        toolGroupSet.setUIObjStyleInfo(this);
        return toolGroupSet;
    }

    public JMenuBar getMenuBar(String string) {
        if (string == null) {
            throw new IllegalArgumentException("id CANNOT be null. ");
        }
        DescContainer descContainer = (DescContainer)this.menuBarHash.get(string);
        if (descContainer == null) {
            return null;
        }
        JMenuBar jMenuBar = null;
        try {
            jMenuBar = (JMenuBar)MenuBarFactory.getUIObject(descContainer);
        }
        catch (Exception exception) {
            logger.error(exception.getMessage());
            logger.trace(exception.getMessage(), exception);
        }
        return jMenuBar;
    }

    public JPopupMenu getPopupMenu(String string) {
        if (string == null) {
            throw new IllegalArgumentException("id CANNOT be null. ");
        }
        DescContainer descContainer = (DescContainer)this.popupMenuHash.get(string);
        if (descContainer == null) {
            logger.debug("Message of  PopupMenu not existed in the style file will be printed, and null will be returned.");
            return null;
        }
        return (JPopupMenu)PopupMenu.getUIObject(descContainer);
    }

    public boolean saveUIObjStyleInfo() {
        if (this.commStyleInfo != null) {
            this.commStyleInfo.writeBack();
            return true;
        }
        return false;
    }

    public boolean saveUIObjStyleInfoPersonal() {
        if (this.commStyleInfo != null) {
            if (null != this.commStyleInfo.getPluginName()) {
                Plugin plugin = PluginManager.getInstance().getPluginFromFolder(this.commStyleInfo.getPluginName());
                try {
                    plugin.getIntegrateCommStyleReader().writeToUser(this.commStyleInfo);
                    return true;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            CommStyleManager.getInstance().writeToUser(this.commStyleInfo);
            return true;
        }
        return false;
    }

    public int buildFromStyle(CommStyleInfo commStyleInfo) {
        boolean bl = true;
        if (null == commStyleInfo) {
            logger.debug("style file not existed");
            return -1;
        }
        this.commStyleInfo = commStyleInfo;
        if (null == commStyleInfo.getPluginName()) {
            bl = false;
        }
        Resource resource = commStyleInfo.getResource();
        AreaDescContainer areaDescContainer = this.commStyleInfo.getAreaDescContainer(0);
        int n = areaDescContainer.getDescCount();
        for (int i = 0; i < n; ++i) {
            DescContainer descContainer = areaDescContainer.getDescContainer(i);
            String string = descContainer.getParasItemValue("type");
            if (null == string) {
                logger.trace("this desc have no type tag (descname: " + descContainer.getDescName() + ")");
                continue;
            }
            if ("ResourceBundle".equals(string)) {
                ResourceBundle resourceBundle = null;
                String string2 = descContainer.getParasItemValue("resourceBundleName");
                try {
                    resourceBundle = bl ? resource.getResourceBundleFromPropertyFile(string2) : ResourceMng.getInstance().getResourceBundleFromPropertyFile(string2);
                    if (null == resourceBundle) {
                        resourceBundle = ResourceBundle.getBundle(string2);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.commStyleInfo.setResourceBundle(resourceBundle);
                continue;
            }
            if ("PropertyFile".equals(string)) {
                if (bl) {
                    this.commStyleInfo.setResourceBundle(resource.getResourceBundleFromPropertyFile(descContainer.getParasItemValue("resourceBundleName")));
                    continue;
                }
                this.commStyleInfo.setResourceBundle(ResourceMng.getInstance().getResourceBundleFromPropertyFile(descContainer.getParasItemValue("resourceBundleName")));
                continue;
            }
            if ("XmlFile".equals(string)) {
                if (bl) {
                    this.commStyleInfo.setResourceBundle(resource.getResourceBundleFromXmlFile(descContainer.getParasItemValue("resourceBundleName")));
                    continue;
                }
                this.commStyleInfo.setResourceBundle(ResourceMng.getInstance().getResourceBundleFromXmlFile(descContainer.getParasItemValue("resourceBundleName")));
                continue;
            }
            if ("JMenuBar".equals(string)) {
                this.menuBarHash.put(descContainer.getDescName(), descContainer);
                continue;
            }
            if ("MenuSet".equals(string)) {
                this.menuSetHash.put(descContainer.getDescName(), descContainer);
                continue;
            }
            if ("JPopupMenu".equals(string)) {
                this.popupMenuHash.put(descContainer.getDescName(), descContainer);
                continue;
            }
            if (!"ToolGroupSet".equals(string)) continue;
            this.toolGroupSetHash.put(descContainer.getDescName(), descContainer);
        }
        return 1;
    }

    public boolean saveUIObjStyleInfoToServer() throws Exception {
        if (this.commStyleInfo != null) {
            if (null != this.commStyleInfo.getPluginName()) {
                Plugin plugin = PluginManager.getInstance().getPluginFromFolder(this.commStyleInfo.getPluginName());
                plugin.getIntegrateCommStyleReader().writeToUser(this.commStyleInfo);
                return true;
            }
            CommStyleManager.getInstance().writeToServer(this.commStyleInfo);
            return true;
        }
        return false;
    }

    public void cleanupWhileOSGIExit() {
        if (this.commStyleInfo != null) {
            this.commStyleInfo.setResourceBundle(null);
            AreaDescContainer[] areaDescContainerArray = this.commStyleInfo.getAreaDescContainer();
            for (int i = 0; i < areaDescContainerArray.length; ++i) {
                this.commStyleInfo.removeAreaDescContainer(areaDescContainerArray[i]);
                areaDescContainerArray[i] = null;
            }
            this.commStyleInfo = null;
        }
        if (null != this.menuBarHash) {
            this.menuBarHash.clear();
            this.menuBarHash = null;
        }
        if (null != this.popupMenuHash) {
            this.popupMenuHash.clear();
            this.popupMenuHash = null;
        }
        if (null != this.menuSetHash) {
            this.menuSetHash.clear();
            this.menuSetHash = null;
        }
        if (null != this.toolGroupSetHash) {
            this.toolGroupSetHash.clear();
            this.toolGroupSetHash = null;
        }
    }
}

