/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.commstyle.commini;

import com.swimap.iview.commstyle.commini.DescContainer;
import com.swimap.iview.commstyle.commini.ToolGroup;
import com.swimap.iview.commstyle.commini.UIObjStyleInfo;
import com.swimap.iview.framework.modulemanagement.ModuleList;
import com.swimap.iview.framework.toolbarmanagement.ToolbarManager;
import com.swimap.iview.framework.util.FrameworkUtilities;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.FlowLayout;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JPanel;

public class ToolGroupSet
extends JPanel {
    private static IviewLogger logger = IviewLogger.getLogger(ToolGroupSet.class, "IVIEW");
    private Hashtable toolGroupHash = new Hashtable();
    private Vector toolGroupOrder = new Vector();
    private String styleSaveID = null;
    private DescContainer m_desc = null;
    private UIObjStyleInfo theUIObjStyleInfo = null;

    void setStyleSaveID(String string) {
        this.styleSaveID = string;
    }

    void setUIObjStyleInfo(UIObjStyleInfo uIObjStyleInfo) {
        this.theUIObjStyleInfo = uIObjStyleInfo;
    }

    public String getID() {
        return this.m_desc.getDescName();
    }

    public ToolGroup getToolGroup(String string) {
        return (ToolGroup)this.toolGroupHash.get(string);
    }

    public int getToolGroupCount() {
        return this.toolGroupOrder.size();
    }

    public ToolGroup getToolGroup(int n) {
        return (ToolGroup)this.toolGroupOrder.elementAt(n);
    }

    public void removeToolGroup() {
        int n = this.toolGroupOrder.size();
        for (int i = 0; i < n; ++i) {
            ToolGroup toolGroup = (ToolGroup)this.toolGroupOrder.elementAt(i);
            toolGroup.cleanHandler();
            this.theUIObjStyleInfo = null;
        }
    }

    public void saveToolGroupSetSetting() {
        if (this.theUIObjStyleInfo != null) {
            this.theUIObjStyleInfo.saveUIObjStyleInfoPersonal();
        }
    }

    public void saveToolGroupSetDedefaultSetting() {
        if (this.theUIObjStyleInfo != null) {
            this.theUIObjStyleInfo.saveUIObjStyleInfo();
        }
    }

    public static Object getUIObject(DescContainer descContainer) {
        return new ToolGroupSet(descContainer);
    }

    public ToolGroupSet(ToolGroupSet toolGroupSet) {
        this.setLayout(new FlowLayout(3, 11, 0));
        this.accessibleContext = toolGroupSet.accessibleContext;
        this.listenerList = toolGroupSet.listenerList;
        this.m_desc = toolGroupSet.m_desc;
        this.styleSaveID = toolGroupSet.styleSaveID;
        this.theUIObjStyleInfo = toolGroupSet.theUIObjStyleInfo;
        this.toolGroupHash.putAll(toolGroupSet.toolGroupHash);
        this.toolGroupOrder.addAll(toolGroupSet.toolGroupOrder);
        this.ui = toolGroupSet.ui;
    }

    public ToolGroupSet(DescContainer descContainer) {
        this.setLayout(new FlowLayout(3, 11, 0));
        if (!"ToolGroupSet".equals(descContainer.getParasItem("type").getValue())) {
            logger.trace("descContainer is not ToolGroupSet type");
        }
        this.m_desc = descContainer;
        int n = descContainer.getSubDescCount();
        for (int i = 0; i < n; ++i) {
            if (!"JToolBar".equals(descContainer.getDescContainer(i).getParasItem("type").getValue())) continue;
            ToolGroup toolGroup = (ToolGroup)ToolGroup.getUIObject(descContainer.getDescContainer(i));
            this.toolGroupOrder.add(toolGroup);
            this.toolGroupHash.put(descContainer.getDescContainer(i).getDescName(), toolGroup);
        }
    }

    public void addToolGroup(ToolGroup toolGroup) {
        String string = toolGroup.getID();
        ToolGroup toolGroup2 = (ToolGroup)this.toolGroupHash.get(string);
        if (toolGroup2 != null) {
            toolGroup2.mergeToolGroup(toolGroup);
        } else {
            this.toolGroupHash.put(string, toolGroup);
            this.addToolGroupOrderVector(toolGroup);
        }
    }

    public Hashtable getToolGroupHash() {
        return this.toolGroupHash;
    }

    public Vector<ToolGroup> getToolGroupOrder() {
        return this.toolGroupOrder;
    }

    public DescContainer getDescMember() {
        return this.m_desc;
    }

    public int getSerialNumber() {
        String string = this.m_desc.getParasItemValue("serialnumber");
        if (string == null || string.trim().length() == 0) {
            return -1;
        }
        int n = string.lastIndexOf("-");
        if (n != -1) {
            string = string.substring(n + 1);
        }
        try {
            return Integer.parseInt(string);
        }
        catch (Exception exception) {
            logger.error("sSerialNumber=" + string);
            logger.trace(exception.getMessage(), exception);
            return -1;
        }
    }

    private void addToolGroupOrderVector(ToolGroup toolGroup) {
        int n = toolGroup.getSerialNumber();
        if (n == -1) {
            this.toolGroupOrder.add(toolGroup);
        } else {
            int n2 = this.getToolGroupPos(n);
            if (n2 < this.toolGroupOrder.size()) {
                this.toolGroupOrder.insertElementAt(toolGroup, n2);
            } else {
                this.toolGroupOrder.add(toolGroup);
            }
        }
    }

    private int getToolGroupPos(int n) {
        int n2 = this.toolGroupOrder.size();
        int n3 = 0;
        for (n3 = 0; n3 < n2; ++n3) {
            int n4 = ((ToolGroup)this.toolGroupOrder.elementAt(n3)).getSerialNumber();
            if (n4 == -1 || n4 <= n) continue;
            return n3;
        }
        return n3;
    }

    public void removeToolGroup(ToolGroup toolGroup) {
        this.toolGroupOrder.remove(toolGroup);
        this.toolGroupHash.remove(toolGroup.getID());
    }

    public void saveToolGroupSetSettingToServer() throws Exception {
        if (this.theUIObjStyleInfo != null) {
            this.theUIObjStyleInfo.saveUIObjStyleInfoToServer();
        }
    }

    public void updateToolGroupSet() {
        int n = this.getToolGroupCount();
        ToolGroup toolGroup = null;
        for (int i = 0; i < n; ++i) {
            toolGroup = this.getToolGroup(i);
            if (toolGroup == null) continue;
            toolGroup.updateToolGroup();
        }
        ToolbarManager toolbarManager = FrameworkUtilities.getToolbarManager();
        if (null != toolbarManager) {
            toolbarManager.filterModuleToolbar(ModuleList.getNotLicensedModule());
        }
    }
}

