/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.commstyle.commini;

import com.swimap.iview.commstyle.commandmng.CommandManager;
import com.swimap.iview.commstyle.commandmng.authority.AuthorityAction;
import com.swimap.iview.commstyle.commini.CommStyleInfo;
import com.swimap.iview.commstyle.commini.DescContainer;
import com.swimap.iview.commstyle.commini.IComminiProperties;
import com.swimap.iview.commstyle.commini.ICustomize;
import com.swimap.iview.commstyle.commini.ToggleButton;
import com.swimap.iview.commstyle.commini.ToolBarButton;
import com.swimap.iview.commstyle.commini.ToolBarHandle;
import com.swimap.iview.commstyle.commini.gui.IVSeparator;
import com.swimap.iview.commstyle.commini.xmlbind.PARA;
import com.swimap.iview.commstyle.resource.ResourceMng;
import com.swimap.iview.framework.lookandfeel.UIStyleTool;
import com.swimap.iview.templates.toolbar.ToolbarItemSettings;
import com.swimap.iview.util.adapter.TypeConverter;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.List;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;

public class ToolGroup
extends JToolBar
implements ICustomize,
IComminiProperties {
    private static IviewLogger logger = IviewLogger.getLogger(ToolGroup.class, "IVIEW");
    private boolean selected = false;
    private DescContainer m_desc;
    private Hashtable buttonGroupHash = new Hashtable();
    private CommStyleInfo commInfo = null;
    private static final Dimension SEPARATOR_SIZE = new Dimension(6, 24);
    private boolean allToolButtonsVisible = false;
    private boolean allToolButtonsEnable = false;
    private AuthorityAction toolGroupAction = null;
    private boolean commandDefined = false;
    private ToolBarHandle toolbarHandle = null;
    private boolean wrapped = false;
    private int xSpacing = 0;
    private ToolbarItemSettings savedSettings = null;
    private ToolbarItemSettings currentSettings = null;
    private ToolbarItemSettings draggedSettings = null;
    private TreeSet<String> hiddenButtonComponents = new TreeSet();
    private List<String> visibleApps = null;
    private static final String FALSE_STRING = "false";

    public ToolGroup(DescContainer descContainer) {
        this.setLayout(new FlowLayout(3, 0, 0));
        if (!"JToolBar".equals(descContainer.getParasItem("type").getValue())) {
            logger.trace("descContainer is not JToolBar type");
        }
        this.m_desc = descContainer;
        this.commInfo = (CommStyleInfo)descContainer._getRootParent();
        this.setFloatable(false);
        this.setBorderPainted(false);
        this.savedSettings = new ToolbarItemSettings(this.m_desc);
        if (null != this.savedSettings) {
            this.savedSettings.logInfo();
        }
        this.setPositions(true);
        this.selected = TypeConverter.toBoolean(descContainer.getParasItemValue("isSelected"), true);
        this.setVisible(this.selected);
        this.toolbarHandle = new ToolBarHandle(this);
        this.addHandler();
        String string = null;
        if (descContainer.getParasItem("action") != null) {
            string = descContainer.getParasItem("action").getValue();
        }
        if (string != null) {
            Class<?> clazz = null;
            try {
                clazz = Class.forName(string);
                this.toolGroupAction = (AuthorityAction)clazz.newInstance();
                this.toolGroupAction.setSource(this);
            }
            catch (ClassNotFoundException classNotFoundException) {
                logger.trace(classNotFoundException);
            }
            catch (InstantiationException instantiationException) {
                logger.trace(instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                logger.trace(illegalAccessException);
            }
        }
        int n = descContainer.getSubDescCount();
        String string2 = null;
        boolean bl = true;
        for (int i = 0; i < n; ++i) {
            Object object;
            string2 = descContainer.getDescContainer(i).getParasItemValue("command");
            bl = CommandManager.getInstance().isCommandLicensed(string2);
            if (!bl) continue;
            String string3 = descContainer.getDescContainer(i).getParasItem("type").getValue();
            if ("AbstractButton".equals(string3)) {
                try {
                    AbstractButton abstractButton;
                    object = null;
                    try {
                        object = descContainer.getDescContainer(i).getParasItem("itemType").getValue();
                    }
                    catch (Exception exception) {
                        object = "";
                    }
                    if ("CheckBox".equals(object)) {
                        this.insertComponent((JToggleButton)ToggleButton.getUIObject(descContainer.getDescContainer(i)));
                        continue;
                    }
                    if ("RadioButton".equals(object)) {
                        abstractButton = (ToggleButton)ToggleButton.getUIObject(descContainer.getDescContainer(i));
                        ButtonGroup buttonGroup = (ButtonGroup)this.buttonGroupHash.get(((ToggleButton)abstractButton).getButtonGroup());
                        if (buttonGroup == null) {
                            buttonGroup = new ButtonGroup();
                            this.buttonGroupHash.put(((ToggleButton)abstractButton).getButtonGroup(), buttonGroup);
                        }
                        buttonGroup.add(abstractButton);
                        this.insertComponent(abstractButton);
                        continue;
                    }
                    abstractButton = (JButton)ToolBarButton.getUIObject(descContainer.getDescContainer(i));
                    logger.trace("ToolBarButton:" + abstractButton.getWidth() + " " + abstractButton.getHeight());
                    this.insertComponent(abstractButton);
                }
                catch (Exception exception) {
                    logger.trace("UI Object can not be created from the Description, check your Style file. " + exception);
                }
                continue;
            }
            if ("JComponent".equals(string3)) {
                try {
                    this.addJComponentType(descContainer.getDescContainer(i));
                }
                catch (Exception exception) {
                    logger.trace("Jcomponent type toolbar item failed. pls check your Style file. " + exception);
                }
                continue;
            }
            object = new IVSeparator(descContainer.getDescContainer(i));
            ((JToolBar.Separator)object).setSeparatorSize(SEPARATOR_SIZE);
            this.insertComponent((Component)object);
        }
        this.setBackground(UIStyleTool.getTOOLBAR_BACKGROUND());
    }

    public ToolGroup() {
        this.m_desc = new DescContainer();
        this.setBackground(UIStyleTool.getTOOLBAR_BACKGROUND());
    }

    public void setPositions(boolean bl) {
        int n = this.getPreferredSize().width;
        int n2 = this.getPreferredSize().height;
        ToolbarItemSettings toolbarItemSettings = null;
        ToolbarItemSettings toolbarItemSettings2 = toolbarItemSettings = bl ? this.savedSettings : this.currentSettings;
        if (null != toolbarItemSettings && toolbarItemSettings.isValid()) {
            this.setBounds(toolbarItemSettings.getX(), toolbarItemSettings.getY(), n, n2);
            if (toolbarItemSettings.getXSpace() < 0) {
                this.setXSpacing(0);
            } else {
                this.setXSpacing(toolbarItemSettings.getXSpace());
            }
            this.setWrapped(toolbarItemSettings.isWrapped());
        } else {
            this.setBounds(0, 0, n, n2);
            this.setXSpacing(0);
            this.setWrapped(false);
        }
    }

    @Override
    public Insets getInsets() {
        Insets insets = super.getInsets();
        insets.top = 0;
        insets.bottom = 0;
        insets.left = 0;
        insets.right = 0;
        return insets;
    }

    @Override
    public String getID() {
        return this.m_desc.getDescName();
    }

    @Override
    public String getName() {
        if (super.getName() != null) {
            return super.getName();
        }
        return this.getMenuText();
    }

    public String getMenuText() {
        String string = this.m_desc.getParasItemValue("name");
        String string2 = null;
        if (null != this.commInfo && (string2 = this.commInfo.getResString(string)) == null) {
            string2 = string;
        }
        return string2;
    }

    public Component getButton(String string) {
        int n = this.getComponentCount();
        Component component = null;
        String string2 = null;
        for (int i = 0; i < n; ++i) {
            component = this.getComponent(i);
            String string3 = string2 = component instanceof IComminiProperties ? ((IComminiProperties)((Object)component)).getID() : null;
            if (null == string2) {
                string2 = this.getComponentIdFromProperty(component);
            }
            if (null == string2 || !string2.equals(string)) continue;
            return this.getComponent(i);
        }
        return null;
    }

    public Component getVisibleButton(int n) {
        return this.getButton(n, true);
    }

    public Component getButton(int n) {
        return this.getButton(n, false);
    }

    private Component getButton(int n, boolean bl) {
        String string;
        Component component = null;
        Component[] componentArray = this.getComponents();
        if (n < componentArray.length) {
            component = componentArray[n];
        }
        if (null == component || !bl) {
            return component;
        }
        String string2 = string = component instanceof IComminiProperties ? ((IComminiProperties)((Object)component)).getID() : null;
        if (null == string) {
            string = this.getComponentIdFromProperty(component);
        }
        if (null == string || !this.hiddenButtonComponents.contains(string)) {
            return component;
        }
        return null;
    }

    public int getButtonCount() {
        return this.getComponentCount();
    }

    public static Object getUIObject(DescContainer descContainer) {
        return new ToolGroup(descContainer);
    }

    public void addButton(Component component) {
        this.add(component);
    }

    public void addButton(Component component, int n) {
        this.add(component, n);
    }

    public void removeHandler() {
        for (Component component : this.getComponents()) {
            if (!(component instanceof ToolBarHandle)) continue;
            this.remove(component);
        }
    }

    protected void cleanHandler() {
        for (Component component : this.getComponents()) {
            if (!(component instanceof ToolBarHandle)) continue;
            ((ToolBarHandle)component).removeDragHandler();
            this.remove(component);
        }
        this.buttonGroupHash.clear();
    }

    public void addHandler() {
        if (null != this.toolbarHandle && this.getComponentIndex(this.toolbarHandle) < 0) {
            this.add((Component)this.toolbarHandle, 0);
        }
    }

    public void removeButton(int n) {
        this.remove(n);
        this.updateUI();
    }

    public void removeButton(String string) {
        Component component = this.getButton(string);
        if (component != null) {
            this.remove(component);
            this.updateUI();
        }
    }

    @Override
    public boolean isUserSelected() {
        return this.selected;
    }

    @Override
    public void setUserSelected(boolean bl) {
        this.selected = bl;
        this.setVisible(this.selected);
        this.m_desc.setParasItem("isSelected", String.valueOf(this.selected), true);
    }

    public void showButton(String string) {
        Component component = this.getButton(string);
        if (component != null) {
            component.setVisible(true);
        }
    }

    public void hideButton(String string) {
        Component component = this.getButton(string);
        if (component != null) {
            component.setVisible(false);
        }
    }

    public void addIVSeparator() {
        IVSeparator iVSeparator = new IVSeparator();
        iVSeparator.setSeparatorSize(SEPARATOR_SIZE);
        iVSeparator.setBackground(UIStyleTool.getTOOLBAR_BACKGROUND());
        this.add(iVSeparator);
    }

    @Override
    public int getSerialNumber() {
        String string = this.m_desc.getParasItemValue("serialnumber");
        if (string == null || string.trim().length() == 0) {
            return -1;
        }
        int n = string.lastIndexOf("-");
        if (n != -1) {
            string = string.substring(n + 1);
        }
        try {
            return Integer.parseInt(string);
        }
        catch (Exception exception) {
            logger.error("sSerialNumber=" + string);
            logger.trace(exception.getMessage(), exception);
            return -1;
        }
    }

    public void mergeToolGroup(ToolGroup toolGroup) {
        Component component = null;
        while (toolGroup.getComponentCount() > 0) {
            component = toolGroup.getComponent(0);
            this.insertComponent(component);
        }
    }

    public void insertComponent(Component component) {
        int n = -1;
        n = component instanceof IComminiProperties ? ((IComminiProperties)((Object)component)).getSerialNumber() : this.getComponentSerialNumberFromProperty(component);
        int n2 = this.getComponentCount();
        if (n != -1) {
            n2 = this.getInsertPos(n);
        }
        if (n2 >= this.getComponentCount()) {
            this.addButton(component);
        } else {
            this.addButton(component, n2);
        }
    }

    private int getInsertPos(int n) {
        Component component = null;
        int n2 = this.getComponentCount();
        int n3 = 0;
        for (n3 = 0; n3 < n2; ++n3) {
            int n4 = -1;
            component = this.getComponent(n3);
            n4 = component instanceof IComminiProperties ? ((IComminiProperties)((Object)component)).getSerialNumber() : this.getComponentSerialNumberFromProperty(component);
            if (n4 == -1 || n4 <= n) continue;
            return n3;
        }
        return n3;
    }

    private void addJComponentType(DescContainer descContainer) {
        String string = descContainer.getParasItemValue("classname");
        JComponent jComponent = this.getComponent(string);
        if (null != jComponent) {
            String string2;
            String string3;
            String string4 = descContainer.getDescName();
            jComponent.putClientProperty("iview.component.id", string4);
            String string5 = descContainer.getParasItemValue("name");
            if (null != string5) {
                string3 = this.commInfo.getResString(string5);
                if (null == string3) {
                    string3 = string5;
                }
                jComponent.putClientProperty("iview.component.name", string3);
            }
            jComponent.putClientProperty("iview.component.desc", descContainer);
            string3 = descContainer.getParasItemValue("serialnumber");
            jComponent.putClientProperty("iview.component.serialnumber", this.getComponentSerialNumber(string3));
            boolean bl = TypeConverter.toBoolean(descContainer.getParasItemValue("isSelected"), true);
            jComponent.putClientProperty("iview.component.isuserselected", bl);
            jComponent.setVisible(bl);
            String string6 = descContainer.getParasItemValue("description");
            if (null != string6) {
                string2 = this.commInfo.getResString(string6);
                if (null != string2) {
                    jComponent.setToolTipText(string2);
                } else {
                    jComponent.setToolTipText(string6);
                }
            }
            jComponent.setMaximumSize(jComponent.getPreferredSize());
            jComponent.setMinimumSize(jComponent.getPreferredSize());
            jComponent.setPreferredSize(jComponent.getPreferredSize());
            string2 = descContainer.getParasItemValue("icon");
            if (null != string2) {
                if (null != this.commInfo && null != this.commInfo.getPluginName()) {
                    jComponent.putClientProperty("iview.component.icon", this.commInfo.getResource().getIcon(string2));
                } else {
                    jComponent.putClientProperty("iview.component.icon", ResourceMng.getInstance().getIconDirect(string2));
                }
            }
            this.insertComponent(jComponent);
        }
    }

    private JComponent getComponent(String string) {
        JComponent jComponent = null;
        try {
            Class<?> clazz = Class.forName(string);
            jComponent = (JComponent)clazz.newInstance();
        }
        catch (Exception exception) {
            logger.error("The className is invalid: " + string);
            logger.trace(exception.getMessage(), exception);
        }
        return jComponent;
    }

    private String getComponentIdFromProperty(Component component) {
        if (component instanceof JComponent) {
            return (String)((JComponent)component).getClientProperty("iview.component.id");
        }
        return null;
    }

    private int getComponentSerialNumberFromProperty(Component component) {
        if (component instanceof JComponent) {
            try {
                return (Integer)((JComponent)component).getClientProperty("iview.component.serialnumber");
            }
            catch (Exception exception) {
                logger.trace("The serial number of component is invalid.");
            }
        }
        return -1;
    }

    public int getComponentSerialNumber(String string) {
        if (string == null || 0 == string.trim().length()) {
            return -1;
        }
        int n = string.lastIndexOf("-");
        if (n != -1) {
            string = string.substring(n + 1);
        }
        try {
            return Integer.parseInt(string);
        }
        catch (Exception exception) {
            logger.error("sSerialNumber=" + string);
            logger.trace(exception.getMessage(), exception);
            return -1;
        }
    }

    public void updateToolGroup() {
        Component[] componentArray;
        if (null != this.toolGroupAction) {
            boolean bl = false;
            boolean bl2 = false;
            try {
                bl = this.toolGroupAction.isActionVisible();
                bl2 = this.toolGroupAction.isActionEnabled();
            }
            catch (Throwable throwable) {
                logger.trace(throwable.getMessage(), throwable);
            }
            this.setEnabled(bl2);
            this.setVisible(bl);
            if (!bl || !bl2) {
                return;
            }
        }
        if ((componentArray = this.getComponents()) == null || componentArray.length == 0) {
            return;
        }
        Component component = null;
        boolean bl = true;
        boolean bl3 = true;
        boolean bl4 = true;
        for (int i = 0; i < componentArray.length; ++i) {
            AbstractButton abstractButton;
            component = componentArray[i];
            this.changeVisiblity(component);
            if (component instanceof ToolBarButton) {
                abstractButton = (ToolBarButton)component;
                ((ToolBarButton)abstractButton).updateToolBarButton();
                boolean bl5 = bl = null != ((ToolBarButton)abstractButton).getToolBarButtonAction();
                if (!bl) {
                    bl4 = null != ((ToolBarButton)abstractButton).getAuthorityViewAction();
                }
            } else if (component instanceof ToggleButton) {
                abstractButton = (ToggleButton)componentArray[i];
                ((ToggleButton)abstractButton).updateToggleButton();
                boolean bl6 = bl = null != ((ToggleButton)abstractButton).getToggleButtonAction();
                if (!bl) {
                    bl4 = null != ((ToggleButton)abstractButton).getAuthorityViewAction();
                }
            } else if (component instanceof ToolGroup) {
                this.updateToolGroup();
            }
            if (componentArray[i] instanceof JToolBar.Separator || componentArray[i] instanceof ToolBarHandle) continue;
            if (componentArray[i].isVisible()) {
                this.allToolButtonsVisible = true;
            }
            if (componentArray[i].isEnabled()) {
                this.allToolButtonsEnable = true;
            }
            if (!bl3 || bl || bl4) continue;
            bl3 = false;
        }
        if (bl3) {
            if (!this.allToolButtonsVisible) {
                this.setVisible(false);
            }
            if (!this.allToolButtonsEnable) {
                this.setEnabled(false);
            }
        }
    }

    private void changeVisiblity(Component component) {
        Object object;
        Serializable serializable;
        String string;
        if (null == component) {
            return;
        }
        String string2 = string = component instanceof IComminiProperties ? ((IComminiProperties)((Object)component)).getID() : null;
        if (null == string) {
            string = this.getComponentIdFromProperty(component);
        }
        boolean bl = true;
        if (component instanceof ToggleButton) {
            serializable = (ToggleButton)component;
            bl = ((ToggleButton)serializable).isUserSelected();
        } else if (component instanceof ToolBarButton) {
            serializable = (ToolBarButton)component;
            bl = ((ToolBarButton)serializable).isUserSelected();
        } else if (component instanceof JComponent && null != (object = ((JComponent)(serializable = (JComponent)component)).getClientProperty("iview.component.isuserselected"))) {
            bl = (Boolean)object;
        }
        serializable = (DescContainer)((JComponent)component).getClientProperty("iview.component.desc");
        if (null != serializable) {
            object = ((DescContainer)serializable).getParasItem("isSelected");
            boolean bl2 = bl = null != object && FALSE_STRING.equals(((PARA)object).getValue().trim()) ? false : bl;
        }
        if (null != string && this.hiddenButtonComponents.contains(string)) {
            component.setVisible(false);
        } else if (bl) {
            component.setVisible(true);
        }
    }

    public AbstractAction getToolGroupAction() {
        return this.toolGroupAction;
    }

    public boolean isCommandDefined() {
        return this.commandDefined;
    }

    public boolean isToolGroupHaveSelected() {
        Component[] componentArray = this.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            if (!componentArray[i].isVisible() || componentArray[i] instanceof IVSeparator || componentArray[i] instanceof ToolBarHandle) continue;
            return true;
        }
        return false;
    }

    public void setWrapped(boolean bl) {
        this.wrapped = bl;
    }

    public boolean isWrapped() {
        return this.wrapped;
    }

    public int getXSpacing() {
        return this.xSpacing;
    }

    public void setXSpacing(int n) {
        this.xSpacing = n;
    }

    public boolean savePositions(int n, boolean bl) {
        if (bl && null != this.draggedSettings) {
            return this.draggedSettings.savePositions(n);
        }
        if (!bl && null != this.savedSettings) {
            return this.savedSettings.savePositions(n);
        }
        return false;
    }

    public final ToolbarItemSettings getSavedSettings() {
        return this.savedSettings;
    }

    public final DescContainer getM_desc() {
        return this.m_desc;
    }

    public void setCurrentSetings() {
        this.currentSettings = new ToolbarItemSettings(this.m_desc);
        this.setSettings(this.currentSettings);
    }

    private void setSettings(ToolbarItemSettings toolbarItemSettings) {
        toolbarItemSettings.setPositions(this.getX(), this.getY(), this.getXSpacing(), this.isWrapped());
        if (null != this.m_desc && null != this.m_desc.getDescName() && null != this.m_desc.getParasItem("name")) {
            toolbarItemSettings.setValid(true);
        }
    }

    public void setDraggedSetings() {
        this.draggedSettings = new ToolbarItemSettings(this.m_desc);
        this.setSettings(this.draggedSettings);
    }

    public void clearSettings() {
        this.currentSettings = null;
        this.savedSettings = null;
    }

    public int getVisibleButtonCount() {
        int n = 0;
        for (Component component : this.getComponents()) {
            if (!component.isVisible() || component instanceof JToolBar.Separator || component instanceof ToolBarHandle) continue;
            ++n;
        }
        return n;
    }

    public boolean setButtonVisible(boolean bl, String string) {
        boolean bl2 = false;
        if (null != string) {
            if (bl) {
                if (this.hiddenButtonComponents.contains(string)) {
                    this.hiddenButtonComponents.remove(string);
                    bl2 = true;
                }
            } else {
                this.hiddenButtonComponents.add(string);
                bl2 = true;
            }
        }
        return bl2;
    }

    public boolean isButtonsVisible() {
        boolean bl = false;
        for (Component component : this.getComponents()) {
            if (component instanceof JToolBar.Separator || component instanceof ToolBarHandle || !component.isVisible()) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public void addToolBarHandler() {
        this.toolbarHandle = new ToolBarHandle(this);
        this.toolbarHandle.updateUI();
        this.setLayout(new FlowLayout(3, 0, 0));
        this.setFloatable(false);
        this.setBorderPainted(false);
        this.addHandler();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Component[] getComponents() {
        Object object = this.getTreeLock();
        synchronized (object) {
            return super.getComponents();
        }
    }

    public List<String> getVisibleAppIDs() {
        if (null == this.visibleApps) {
            try {
                this.visibleApps = this.getAppIDs(this);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return this.visibleApps;
    }

    private List<String> getAppIDs(ToolGroup toolGroup) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Component[] componentArray = toolGroup.getComponents();
        if (null != componentArray) {
            for (int i = 0; i < componentArray.length; ++i) {
                Object object;
                if (componentArray[i] instanceof ToolBarButton) {
                    object = (ToolBarButton)componentArray[i];
                    List<String> list = ((ToolBarButton)object).getVisibleAppIDs();
                    if (null == list) continue;
                    arrayList.addAll(list);
                    continue;
                }
                if (!(componentArray[i] instanceof ToolGroup) || null == (object = this.getAppIDs((ToolGroup)componentArray[i]))) continue;
                arrayList.addAll((Collection<String>)object);
            }
        }
        return arrayList;
    }
}

