/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.commstyle.commini;

import com.swimap.iview.commstyle.commini.ToolGroup;
import com.swimap.iview.framework.util.FrameworkUtilities;
import com.swimap.iview.templates.toolbar.Toolbar;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.MouseInputAdapter;

public class ToolBarHandle
extends JComponent {
    private static final long serialVersionUID = 67946035829958238L;
    private static final String UI_CLASS_ID = "ToolBarHandleUI";
    private static final int HANDLE_WIDTH = 12;
    private static final int HANDLE_HEIGHT = 22;
    private ToolGroup toolGroup;
    private DragHandler dragHandler = new DragHandler();
    private Point oldPoint = null;

    public ToolBarHandle(ToolGroup toolGroup) {
        this.init(toolGroup);
    }

    private void init(ToolGroup toolGroup) {
        this.toolGroup = toolGroup;
        this.addMouseMotionListener(this.dragHandler);
        this.addMouseListener(this.dragHandler);
        this.updateUI();
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(12, 22);
    }

    protected void removeDragHandler() {
        if (null != this.dragHandler) {
            this.removeMouseMotionListener(this.dragHandler);
            this.removeMouseListener(this.dragHandler);
            this.toolGroup = null;
            this.toolGroup = null;
        }
    }

    @Override
    public void updateUI() {
        this.setUI(UIManager.getUI(this));
    }

    @Override
    public String getUIClassID() {
        return UI_CLASS_ID;
    }

    private class DragHandler
    extends MouseInputAdapter {
        private DragHandler() {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            Toolbar toolbar = (Toolbar)ToolBarHandle.this.toolGroup.getParent();
            if (toolbar instanceof Toolbar) {
                ToolBarHandle.this.setCursor(Cursor.getPredefinedCursor(10));
            }
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            ToolBarHandle.this.setCursor(Cursor.getPredefinedCursor(0));
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            Toolbar toolbar = (Toolbar)ToolBarHandle.this.toolGroup.getParent();
            if (toolbar instanceof Toolbar) {
                FrameworkUtilities.getMainFrame().setCursor(Cursor.getPredefinedCursor(10));
                ToolBarHandle.this.oldPoint = SwingUtilities.convertPoint((Component)mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY(), toolbar);
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            FrameworkUtilities.getMainFrame().setCursor(Cursor.getPredefinedCursor(0));
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            Toolbar toolbar = (Toolbar)ToolBarHandle.this.toolGroup.getParent();
            if (toolbar instanceof Toolbar) {
                Point point = SwingUtilities.convertPoint((Component)mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY(), toolbar);
                if (null != toolbar) {
                    if (toolbar.relocateToolGroup(ToolBarHandle.this.toolGroup, ToolBarHandle.this.oldPoint, point)) {
                        ToolBarHandle.this.oldPoint = point;
                        toolbar.setCurrentComponentsPositions();
                        toolbar.setDraggableComponentsPositions();
                    }
                    toolbar.revalidate();
                }
            }
        }
    }
}

