/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.commstyle.commini;

import com.swimap.iview.commstyle.commandmng.CommandManager;
import com.swimap.iview.commstyle.commandmng.authority.ActionManager;
import com.swimap.iview.commstyle.commandmng.authority.AuthorityAction;
import com.swimap.iview.commstyle.commandmng.authority.AuthorityView;
import com.swimap.iview.commstyle.commini.BorderlessButton;
import com.swimap.iview.commstyle.commini.CommStyleInfo;
import com.swimap.iview.commstyle.commini.DescContainer;
import com.swimap.iview.commstyle.commini.IComminiProperties;
import com.swimap.iview.commstyle.commini.ICustomize;
import com.swimap.iview.commstyle.commini.xmlbind.PARA;
import com.swimap.iview.commstyle.commini.xmlbind.VALUE;
import com.swimap.iview.commstyle.resource.ResourceMng;
import com.swimap.iview.util.adapter.TypeConverter;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;

public class ToolBarButton
extends BorderlessButton
implements ICustomize,
IComminiProperties {
    private static IviewLogger logger = IviewLogger.getLogger(ToolBarButton.class, "IVIEW");
    private DescContainer m_desc;
    private CommStyleInfo commInfo = null;
    private static final int ICON_SIZE = 24;
    static final String DISABLE_STR = "_disable";
    private AuthorityView authorityViewAction = null;
    private AuthorityAction toolBarButtonAction = null;
    private boolean commandDefined = false;
    private int serialNumber = Integer.MIN_VALUE;
    String command = null;

    public ToolBarButton() {
        this.m_desc = new DescContainer();
    }

    public static Object getUIObject(DescContainer descContainer) {
        return new ToolBarButton(descContainer);
    }

    public ToolBarButton(DescContainer descContainer) {
        Object object;
        Object object2;
        if (!"AbstractButton".equals(descContainer.getParasItemValue("type"))) {
            logger.trace("descContainer is not AbstractButton type");
        }
        this.m_desc = descContainer;
        this.commInfo = (CommStyleInfo)descContainer._getRootParent();
        this.setVisible(TypeConverter.toBoolean(descContainer.getParasItemValue("isSelected"), true));
        String string = null;
        string = descContainer.getParasItemValue("name");
        this.setName(string);
        String string2 = null;
        this.command = descContainer.getParasItemValue("command");
        if (this.command != null) {
            this.commandDefined = true;
            this.setActionCommand(this.command);
            object2 = CommandManager.getInstance();
            this.authorityViewAction = ((CommandManager)object2).getAuthorityViewAction(this.command);
        }
        if ((object2 = descContainer.getParasItemValue("action")) != null) {
            try {
                object = Class.forName((String)object2);
                this.toolBarButtonAction = (AuthorityAction)((Class)object).newInstance();
                this.toolBarButtonAction.setSource(this);
            }
            catch (ClassNotFoundException classNotFoundException) {
                logger.trace(classNotFoundException);
            }
            catch (InstantiationException instantiationException) {
                logger.trace(instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                logger.trace(illegalAccessException);
            }
            if (!this.commandDefined) {
                this.setAction(this.toolBarButtonAction);
            }
        }
        object = null;
        object = descContainer.getParasItemValue("description");
        if (object == null) {
            object = string;
        }
        if ((string2 = this.commInfo.getResString((String)object)) != null) {
            this.setToolTipText(string2);
        } else {
            this.setToolTipText((String)object);
        }
        String string3 = null;
        String string4 = null;
        string3 = descContainer.getParasItemValue("icon");
        if (string3 != null) {
            try {
                boolean bl;
                Icon icon = ResourceMng.getInstance().getIconDirect(string3);
                boolean bl2 = bl = null != this.commInfo && null != this.commInfo.getPluginName();
                if (bl) {
                    icon = this.commInfo.getResource().getIcon(string3);
                }
                int n = string3.length() - string3.indexOf(".");
                string4 = string3.substring(0, string3.length() - n) + DISABLE_STR + string3.substring(string3.length() - n, string3.length());
                Icon icon2 = ResourceMng.getInstance().getIconDirect(string4);
                if (bl) {
                    icon2 = this.commInfo.getResource().getIcon(string4);
                }
                if (icon2 != null) {
                    this.setDisabledIcon(icon2);
                }
                this.setIcon(icon);
            }
            catch (Exception exception) {
                logger.trace("Exception while setting the image for the toolbar item (ToolBarButton): " + exception);
            }
            this.setPreferredSize(new Dimension(24, 24));
        }
        super.setUI(new BorderlessButton.ToolBarButtonUI());
    }

    @Override
    public boolean isUserSelected() {
        boolean bl = TypeConverter.toBoolean(this.m_desc.getParasItemValue("isSelected"), true);
        return bl;
    }

    @Override
    public void setUserSelected(boolean bl) {
        Action action = this.getAction();
        boolean bl2 = true;
        if (action != null && action instanceof AuthorityAction) {
            bl2 = ((AuthorityAction)action).isVisible();
        }
        this.setVisible(bl && bl2);
        this.m_desc.setParasItem("isSelected", String.valueOf(bl), true);
    }

    @Override
    public String getID() {
        return this.m_desc.getDescName();
    }

    @Override
    public String getName() {
        return this.m_desc.getParasItemValue("name");
    }

    public String getState(String string) {
        return this.m_desc.getParasItemValue(string);
    }

    public boolean setState(String string, String string2) {
        this.m_desc.setParasItem(string, string2, true);
        return true;
    }

    @Override
    public int getSerialNumber() {
        if (this.serialNumber != Integer.MIN_VALUE) {
            return this.serialNumber;
        }
        this.serialNumber = -1;
        String string = this.m_desc.getParasItemValue("serialnumber");
        if (string == null || string.trim().length() == 0) {
            return this.serialNumber;
        }
        int n = string.lastIndexOf("-");
        if (n != -1) {
            string = string.substring(n + 1);
        }
        try {
            this.serialNumber = Integer.parseInt(string);
        }
        catch (Exception exception) {
            logger.error("sSerialNumber=" + string);
            logger.trace(exception.getMessage(), exception);
        }
        return this.serialNumber;
    }

    @Override
    public void setAction(Action action) {
        super.setAction(action);
        ActionManager.configActionToButton(this, (AuthorityAction)action);
    }

    public void updateToolBarButton() {
        try {
            if (this.toolBarButtonAction != null) {
                this.setEnabled(this.toolBarButtonAction.isActionEnabled());
                this.setVisible(this.toolBarButtonAction.isActionVisible());
            } else if (this.commandDefined) {
                CommandManager commandManager = CommandManager.getInstance();
                this.authorityViewAction = commandManager.getAuthorityViewAction(this.command);
                if (null != this.authorityViewAction) {
                    boolean bl = commandManager.securityInfoCheck(this.command);
                    this.setEnabled(this.authorityViewAction.isEnabled(this.command) && bl);
                    this.setVisible(this.authorityViewAction.isVisible(this.command));
                }
            } else {
                logger.trace("no authority action or command  is defined for menu itme");
            }
        }
        catch (Throwable throwable) {
            logger.trace("Iview Handled Error while updating Toolbar button" + this.getName(), throwable);
        }
    }

    public AbstractAction getToolBarButtonAction() {
        return this.toolBarButtonAction;
    }

    AuthorityView getAuthorityViewAction() {
        return this.authorityViewAction;
    }

    protected PARA getPara(String string) {
        return this.m_desc.getParasItem(string);
    }

    public List<String> getVisibleAppIDs() {
        VALUE[] vALUEArray;
        ArrayList<String> arrayList = new ArrayList<String>();
        PARA pARA = this.getPara("visibleApps");
        if (null != pARA && null != (vALUEArray = pARA.getVALUE())) {
            for (VALUE vALUE : vALUEArray) {
                String string = vALUE.getValue();
                if (null == string) continue;
                arrayList.add(vALUE.getValue());
            }
        }
        return arrayList;
    }

    @Override
    public void setVisible(boolean bl) {
        super.setVisible(bl);
    }
}

