/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.commstyle.commini;

import com.swimap.iview.commstyle.commandmng.CommandManager;
import com.swimap.iview.commstyle.commandmng.authority.ActionManager;
import com.swimap.iview.commstyle.commandmng.authority.AuthorityAction;
import com.swimap.iview.commstyle.commandmng.authority.AuthorityView;
import com.swimap.iview.commstyle.commini.BorderlessToggleButton;
import com.swimap.iview.commstyle.commini.CommStyleInfo;
import com.swimap.iview.commstyle.commini.DescContainer;
import com.swimap.iview.commstyle.commini.IComminiProperties;
import com.swimap.iview.commstyle.commini.ICustomize;
import com.swimap.iview.commstyle.commini.UIObjectDescriptionNotCorrectException;
import com.swimap.iview.commstyle.commini.xmlbind.PARA;
import com.swimap.iview.commstyle.commini.xmlbind.VALUE;
import com.swimap.iview.commstyle.resource.ResourceMng;
import com.swimap.iview.util.adapter.TypeConverter;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;

public class ToggleButton
extends BorderlessToggleButton
implements ICustomize,
IComminiProperties {
    private static IviewLogger logger = IviewLogger.getLogger(ToggleButton.class, "IVIEW");
    private DescContainer m_desc;
    private CommStyleInfo commInfo = null;
    private static final int ICON_SIZE = 24;
    private AuthorityAction toggleButtonAction = null;
    private AuthorityView authorityViewAction = null;
    private boolean commandDefined = false;
    private String command = null;

    @Override
    public String getID() {
        return this.m_desc.getDescName();
    }

    @Override
    public String getName() {
        return this.m_desc.getParasItemValue("name");
    }

    public String getButtonGroup() {
        String string = null;
        string = this.m_desc.getParasItemValue("buttonGroup");
        if (string == null) {
            string = "noGroup";
        }
        return string;
    }

    public ToggleButton(DescContainer descContainer) throws UIObjectDescriptionNotCorrectException {
        try {
            Object object;
            if (!"AbstractButton".equals(descContainer.getParasItemValue("type"))) {
                logger.trace("descContainer is not AbstractButton type");
            }
            this.m_desc = descContainer;
            this.commInfo = (CommStyleInfo)descContainer._getRootParent();
            this.setVisible(TypeConverter.toBoolean(descContainer.getParasItemValue("isSelected"), true));
            String string = null;
            string = descContainer.getParasItemValue("name");
            this.setName(string);
            String string2 = null;
            this.command = descContainer.getParasItemValue("command");
            if (this.command != null) {
                this.setActionCommand(this.command);
            }
            String string3 = null;
            if (descContainer.getParasItem("action") != null) {
                string3 = descContainer.getParasItem("action").getValue();
            }
            if (string3 != null) {
                object = null;
                try {
                    object = Class.forName(string3);
                    this.toggleButtonAction = (AuthorityAction)((Class)object).newInstance();
                    this.toggleButtonAction.setSource(this);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    logger.trace(classNotFoundException);
                }
                catch (InstantiationException instantiationException) {
                    logger.trace(instantiationException);
                }
                catch (IllegalAccessException illegalAccessException) {
                    logger.trace(illegalAccessException);
                }
                if (!this.commandDefined) {
                    this.setAction(this.toggleButtonAction);
                }
            }
            object = null;
            object = descContainer.getParasItemValue("description");
            if (object == null) {
                object = string;
            }
            if ((string2 = this.commInfo.getResString((String)object)) != null) {
                this.setToolTipText(string2);
            } else {
                this.setToolTipText((String)object);
            }
            String string4 = null;
            String string5 = null;
            string4 = descContainer.getParasItemValue("icon");
            if (string4 != null) {
                try {
                    Icon icon = ResourceMng.getInstance().getIconDirect(string4);
                    int n = string4.length() - string4.indexOf(".");
                    string5 = string4.substring(0, string4.length() - n) + "_disable" + string4.substring(string4.length() - n, string4.length());
                    Icon icon2 = ResourceMng.getInstance().getIconDirect(string5);
                    if (icon2 != null) {
                        this.setDisabledIcon(icon2);
                    }
                    this.setIcon(icon);
                }
                catch (Exception exception) {
                    logger.trace("Exception while setting the image for the toolbar item(ToggleButton) : " + exception);
                }
                this.setPreferredSize(new Dimension(24, 24));
            }
            this.setSelected(TypeConverter.toBoolean(descContainer.getParasItemValue("checked"), false));
        }
        catch (Exception exception) {
            logger.trace(exception.getMessage(), exception);
            throw new UIObjectDescriptionNotCorrectException("ToggleButton:UI Object can not be create from the Description, check your Style file ");
        }
        super.setUI(new BorderlessToggleButton.ToggleButtonUI());
    }

    AuthorityView getAuthorityViewAction() {
        return this.authorityViewAction;
    }

    public static Object getUIObject(DescContainer descContainer) {
        ToggleButton toggleButton = null;
        try {
            toggleButton = new ToggleButton(descContainer);
        }
        catch (Exception exception) {
            logger.error(exception.getMessage());
        }
        return toggleButton;
    }

    @Override
    public boolean isUserSelected() {
        boolean bl = TypeConverter.toBoolean(this.m_desc.getParasItemValue("isSelected"), true);
        return bl;
    }

    @Override
    public void setUserSelected(boolean bl) {
        Action action = this.getAction();
        boolean bl2 = true;
        if (action != null && action instanceof AuthorityAction) {
            bl2 = ((AuthorityAction)action).isVisible();
        }
        this.setVisible(bl && bl2);
        this.m_desc.setParasItem("isSelected", String.valueOf(bl), true);
    }

    @Override
    public int getSerialNumber() {
        String string = this.m_desc.getParasItemValue("serialnumber");
        if (string == null || string.trim().length() == 0) {
            return -1;
        }
        int n = string.lastIndexOf("-");
        if (n != -1) {
            string = string.substring(n + 1);
        }
        try {
            return Integer.parseInt(string);
        }
        catch (Exception exception) {
            logger.error("sSerialNumber=" + string);
            logger.trace(exception.getMessage(), exception);
            return -1;
        }
    }

    @Override
    public void setAction(Action action) {
        super.setAction(action);
        ActionManager.configActionToButton(this, (AuthorityAction)action);
    }

    public void updateToggleButton() {
        try {
            if (this.toggleButtonAction != null) {
                this.setVisible(this.toggleButtonAction.isActionVisible());
                this.setEnabled(this.toggleButtonAction.isActionEnabled());
            } else if (this.isCommandDefined()) {
                CommandManager commandManager = CommandManager.getInstance();
                this.authorityViewAction = commandManager.getAuthorityViewAction(this.command);
                if (null != this.authorityViewAction) {
                    boolean bl = commandManager.securityInfoCheck(this.command);
                    this.setEnabled(this.authorityViewAction.isEnabled(this.command) && bl);
                    this.setVisible(this.authorityViewAction.isVisible(this.command));
                }
            } else {
                logger.trace("no authority action or command  is defined for menu itme");
            }
        }
        catch (Throwable throwable) {
            logger.trace("Iview Handled Error while updating ToggleButton item" + this.getName(), throwable);
        }
    }

    public AbstractAction getToggleButtonAction() {
        return this.toggleButtonAction;
    }

    public boolean isCommandDefined() {
        return this.commandDefined;
    }

    protected PARA getPara(String string) {
        return this.m_desc.getParasItem(string);
    }

    public List<String> getVisibleAppIDs() {
        VALUE[] vALUEArray;
        ArrayList<String> arrayList = new ArrayList<String>();
        PARA pARA = this.getPara("visibleApps");
        if (null != pARA && null != (vALUEArray = pARA.getVALUE())) {
            for (VALUE vALUE : vALUEArray) {
                String string = vALUE.getValue();
                if (null == string) continue;
                arrayList.add(vALUE.getValue());
            }
        }
        return arrayList;
    }
}

