/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.commstyle.commini;

import com.swimap.iview.commstyle.commandmng.CommandManager;
import com.swimap.iview.commstyle.commandmng.authority.AuthorityAction;
import com.swimap.iview.commstyle.commini.AreaDescContainer;
import com.swimap.iview.commstyle.commini.CommStyleInfo;
import com.swimap.iview.commstyle.commini.CommStyleManager;
import com.swimap.iview.commstyle.commini.DescContainer;
import com.swimap.iview.commstyle.commini.ImageButtonIconInfo;
import com.swimap.iview.commstyle.commini.ImageTextButton;
import com.swimap.iview.commstyle.resource.ResourceMng;
import com.swimap.iview.framework.applicationfavourites.FavouriteButton;
import com.swimap.iview.framework.applicationmanagement.gui.ApplicationButton;
import com.swimap.iview.framework.pluginmanagement.PluginManager;
import com.swimap.iview.framework.pluginmanagement.Resource;
import com.swimap.iview.framework.windowmanagement.welcomepage.WelcomeManager;
import com.swimap.iview.framework.windowmanagement.welcomepage.WelcomeTextButton;
import com.swimap.iview.framework.windowmanagement.welcomepage.draggable.DraggableButton;
import com.swimap.iview.util.CommonUtil;
import com.swimap.iview.util.OptionPane;
import com.swimap.iview.util.ScreenToolKit;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.Serializable;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;

public abstract class TextButton
extends JPanel {
    private static IviewLogger logger = IviewLogger.getLogger(TextButton.class, "IVIEW");
    private JLabel iconComp = null;
    private TitleComponent titleComponent = null;
    private static int DEFAULT_WIDTH = 90;
    private static int DEFAULT_HEIGHT = 90;
    private static final int IMAGE_INCR = 10;
    private int ICON_DEFAULT_WIDTH = DEFAULT_WIDTH;
    private int ICON_DEFAULT_HEIGHT = DEFAULT_HEIGHT;
    private static final int TITLE_DEFAULT_HEIGHT = 15;
    private int TITLE_DEFAULT_WIDTH = 65;
    private static final int TITLE_GAP = 4;
    private int ICON_FOCUS_WIDTH = this.ICON_DEFAULT_WIDTH + 10;
    private int ICON_FOCUS_HEIGHT = this.ICON_DEFAULT_HEIGHT + 10;
    private static final int MAX_BUTTON_NAME_SIZE = 127;
    private boolean focused = false;
    private DescContainer m_desc = null;
    private String name = null;
    private String command = null;
    private String tooltip = null;
    private ImageIcon image = null;
    private int serialNo = Integer.MAX_VALUE;
    private boolean userEnable = false;
    private String category = null;
    private String categoryResName = null;
    private boolean executable = false;
    private String imagePath = null;
    private boolean removable = true;
    private boolean selected = true;
    private boolean transparent = false;
    private String fullName = null;
    private String defaultIcon = "default.png";
    private AuthorityAction action = null;
    private String actionName = null;
    private boolean actionButton = false;
    private String menuID = null;
    private static final String LINE_WRAPPER = System.getProperty("line.separator");
    private static final int MAX_TEXT_HEIGHT = 35;
    private static final String DOTS = "...";
    public static final String SERIAL_NUMBER = "serialnumber";
    public static final String IS_USER_ENABLE = "isUserEnable";
    public static final String CATEGORY = "category";
    public static final String IS_EXECUTABLE = "isExecutable";
    public static final String ACTION = "action";
    public static final String IS_REMOVABLE = "isRemovable";
    public static final String IS_SELECTED = "isSelected";
    public static final String NAME = "name";
    public static final String COMMAND = "command";
    public static final String MENUID = "menuid";
    public static final String DESCRIPTION = "description";
    public static final String ICON = "icon";
    public static final String IMPORTED = "imported";
    public static final String PLUGIN_NAME = "exportedPluginName";
    protected static final float TRANSPARENCY_LEVEL = 0.5f;
    private boolean isSingleSelected = false;
    public static final int MARGIN = 20;
    private static final int APPICON_BUFFER_GAP = 60;
    private static final Color TEXT_SELECTED_COLOR = new Color(10, 36, 106);
    private int seqNo = Integer.MAX_VALUE;
    public static final String SEQUENCE_NUMBER = "linkseqnumber";
    private boolean isHovered = false;
    private static TextButton hoveredTextButton = null;
    private static final int TEXTGAP = 5;
    private MouseAdapter hoveredListener = new MouseAdapter(){

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            if (hoveredTextButton != null && hoveredTextButton != TextButton.this) {
                hoveredTextButton.isHovered = false;
                hoveredTextButton.repaint(0L);
            }
            TextButton.this.isHovered = true;
            TextButton.this.repaint(0L);
            hoveredTextButton = TextButton.this;
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            TextButton.this.isHovered = false;
            TextButton.this.repaint(0L);
        }
    };

    public TextButton(DescContainer descContainer) {
        this.init(descContainer);
    }

    public TextButton(DescContainer descContainer, boolean bl) {
        if (bl) {
            this.init(descContainer);
        } else {
            this.m_desc = descContainer;
            this.readDescContainer();
        }
    }

    public void setSingleSelected(boolean bl) {
        this.isSingleSelected = bl;
        this.name = bl && false == this.isPortalStyleButton() ? this.getAbbrevString(this.fullName, this.TITLE_DEFAULT_WIDTH, true) : this.getAbbrevString(this.fullName, this.TITLE_DEFAULT_WIDTH, false);
        if (!this.isPortalStyleButton()) {
            this.remove(this.titleComponent);
            JPopupMenu jPopupMenu = null;
            if (null != this.titleComponent) {
                jPopupMenu = this.titleComponent.getComponentPopupMenu();
            }
            this.titleComponent = new TitleComponent(new Dimension(this.ICON_DEFAULT_WIDTH, this.getTitleHeight()));
            this.titleComponent.setComponentPopupMenu(jPopupMenu);
            this.add((Component)this.titleComponent, "South");
            this.titleComponent.initGUI();
            this.resetSize();
            this.setPreferredSize(this.getSize());
        } else {
            this.resetSize();
            this.setPreferredSize(this.getSize());
            this.repaint(0L);
        }
    }

    public boolean isSingleSelected() {
        return this.isSingleSelected;
    }

    public TextButton(DescContainer descContainer, Dimension dimension) {
        DEFAULT_WIDTH = dimension.width;
        DEFAULT_HEIGHT = dimension.height;
        this.ICON_DEFAULT_WIDTH = DEFAULT_WIDTH;
        this.ICON_DEFAULT_HEIGHT = DEFAULT_WIDTH;
        this.ICON_FOCUS_WIDTH = this.ICON_DEFAULT_WIDTH + 10;
        this.ICON_FOCUS_HEIGHT = this.ICON_DEFAULT_HEIGHT + 10;
        this.TITLE_DEFAULT_WIDTH = this.ICON_DEFAULT_WIDTH;
        this.init(descContainer);
    }

    protected TextButton(DescContainer descContainer, String string, Dimension dimension) {
        this.defaultIcon = string;
        DEFAULT_WIDTH = dimension.width;
        DEFAULT_HEIGHT = dimension.height;
        this.ICON_DEFAULT_WIDTH = DEFAULT_WIDTH;
        this.ICON_DEFAULT_HEIGHT = DEFAULT_WIDTH;
        this.ICON_FOCUS_WIDTH = this.ICON_DEFAULT_WIDTH + 10;
        this.ICON_FOCUS_HEIGHT = this.ICON_DEFAULT_HEIGHT + 10;
        this.TITLE_DEFAULT_WIDTH = this.ICON_DEFAULT_WIDTH;
        this.init(descContainer);
    }

    protected TextButton(DescContainer descContainer, String string, Dimension dimension, int n) {
        this.defaultIcon = string;
        DEFAULT_WIDTH = dimension.width;
        DEFAULT_HEIGHT = dimension.height;
        this.ICON_DEFAULT_WIDTH = DEFAULT_WIDTH;
        this.ICON_DEFAULT_HEIGHT = DEFAULT_WIDTH;
        this.ICON_FOCUS_WIDTH = this.ICON_DEFAULT_WIDTH + 10;
        this.ICON_FOCUS_HEIGHT = this.ICON_DEFAULT_HEIGHT + 10;
        this.TITLE_DEFAULT_WIDTH = n;
        this.init(descContainer);
    }

    protected TextButton(DescContainer descContainer, String string) {
        this.defaultIcon = string;
        this.init(descContainer);
    }

    private void init(DescContainer descContainer) {
        this.m_desc = descContainer;
        this.readDescContainer();
        this.setOpaque(false);
        this.setLayout(new BorderLayout());
        this.titleComponent = new TitleComponent(new Dimension(this.TITLE_DEFAULT_WIDTH, this.getTitleHeight()));
        this.add((Component)this.titleComponent, "South");
    }

    public JTextArea getTitleComponent() {
        return this.titleComponent;
    }

    public abstract JLabel getImageComponent();

    public void initializeButton() {
        CommStyleInfo commStyleInfo = (CommStyleInfo)this.m_desc._getRootParent();
        this.readIcon(commStyleInfo);
        this.iconComp = this.getImageComponent();
        if (null != this.iconComp) {
            this.add((Component)this.iconComp, "Center");
        }
        this.setName("TextButton");
        this.initGUIComponent();
        this.resetSize();
        this.setPreferredSize(this.getSize());
    }

    public void removeIconComponent() {
        if (null != this.iconComp) {
            MouseListener[] mouseListenerArray = this.iconComp.getMouseListeners();
            if (null != mouseListenerArray) {
                for (int i = 0; i < mouseListenerArray.length; ++i) {
                    this.iconComp.removeMouseListener(mouseListenerArray[i]);
                    mouseListenerArray[i] = null;
                }
            }
            this.remove(this.iconComp);
            if (this.focused || this.isPortalStyleButton() && ((ApplicationButton)this).isHovered()) {
                ToolTipManager.sharedInstance().setEnabled(false);
                ToolTipManager.sharedInstance().setEnabled(true);
            }
            this.iconComp = null;
        }
        if (null != this.image) {
            this.image = null;
            this.imagePath = null;
        }
        this.repaint();
    }

    public void setPopupMenu(JPopupMenu jPopupMenu) {
        this.titleComponent.setComponentPopupMenu(jPopupMenu);
        this.setComponentPopupMenu(jPopupMenu);
    }

    public void readDescContainer() {
        int n;
        CommStyleInfo commStyleInfo = (CommStyleInfo)this.m_desc._getRootParent();
        try {
            n = Integer.parseInt(this.m_desc.getParasItemValue(SERIAL_NUMBER));
            if (n >= 0) {
                this.serialNo = n;
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.serialNo = Integer.MAX_VALUE;
        }
        try {
            n = Integer.parseInt(this.m_desc.getParasItemValue(SEQUENCE_NUMBER));
            if (n >= 0) {
                this.seqNo = n;
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.seqNo = Integer.MAX_VALUE;
        }
        this.userEnable = Boolean.valueOf(this.m_desc.getParasItemValue(IS_USER_ENABLE));
        this.category = this.m_desc.getParasItemValue(CATEGORY);
        this.categoryResName = commStyleInfo.getResString(this.category);
        if (this.categoryResName == null) {
            this.categoryResName = this.category;
        }
        this.executable = Boolean.valueOf(this.m_desc.getParasItemValue(IS_EXECUTABLE));
        this.initAction();
        String string = this.m_desc.getParasItemValue(IS_REMOVABLE);
        if ("false".equalsIgnoreCase(string) || "true".equalsIgnoreCase(string)) {
            this.removable = Boolean.valueOf(string);
        }
        if (null == this.m_desc.getParasItemValue(IS_SELECTED)) {
            if (this.userEnable) {
                this.selected = false;
            }
        } else {
            this.selected = Boolean.valueOf(this.m_desc.getParasItemValue(IS_SELECTED));
        }
        this.readModifiableValues(commStyleInfo);
        if (null != this.m_desc.getParasItemValue(MENUID)) {
            this.menuID = this.m_desc.getParasItemValue(MENUID).trim();
        }
    }

    protected void initAction() {
        String string = null;
        if (null != this.m_desc.getParasItem(ACTION) && null != (string = this.m_desc.getParasItem(ACTION).getValue()) && string.startsWith("class")) {
            string = string.substring(6);
        }
        if (null != string) {
            this.actionName = string;
            try {
                Class<?> clazz = null;
                clazz = Class.forName(string);
                this.action = (AuthorityAction)clazz.newInstance();
                this.action.setSource(this);
            }
            catch (Throwable throwable) {
                logger.trace(throwable);
            }
        }
    }

    private String getAbbrevString(String string, int n, boolean bl) {
        String string2;
        Font font = UIManager.getFont("Label.font");
        int n2 = SwingUtilities.computeStringWidth(this.getFontMetrics(font), DOTS);
        if (this.isPortalStyleButton()) {
            n += 40;
        }
        if (null == (string2 = ScreenToolKit.getLineWrapString(string, n, font))) {
            return string2;
        }
        String[] stringArray = string2.split(LINE_WRAPPER);
        StringBuffer stringBuffer = new StringBuffer("");
        int n3 = 0;
        int n4 = 0;
        StringBuffer stringBuffer2 = new StringBuffer("");
        stringBuffer2.append(string2);
        if (stringArray.length > 2 && !bl) {
            String string3 = stringArray[1];
            stringBuffer2 = new StringBuffer("");
            n4 = string3.length();
            for (int i = 0; i < n4; ++i) {
                stringBuffer.append(string3.charAt(i));
                n3 = SwingUtilities.computeStringWidth(this.getFontMetrics(font), stringBuffer.toString());
                if (n3 + n2 < n) continue;
                if (i <= 2) break;
                stringBuffer2.append(stringArray[0]).append(LINE_WRAPPER).append(stringBuffer.toString().substring(0, i - 1));
                break;
            }
            if (stringBuffer2.toString().trim().length() == 0) {
                stringBuffer2.append(stringArray[0]).append(LINE_WRAPPER).append(stringBuffer.toString());
            }
            stringBuffer2.append(DOTS);
        }
        return stringBuffer2.toString();
    }

    protected String getAppName() {
        return "";
    }

    private void readModifiableValues(CommStyleInfo commStyleInfo) {
        int n;
        String string = this.m_desc.getParasItemValue(NAME);
        if (null != string && (n = string.length()) > 127) {
            string = string.substring(0, 127);
        }
        this.setName(string);
        this.name = commStyleInfo.getResString(string);
        String string2 = string = null == string ? "" : string.trim();
        if (this.name == null) {
            this.name = string;
        }
        this.fullName = this.name = this.name + this.getAppName();
        this.fullName = this.getUpdatedButtonName();
        this.name = this.isSingleSelected ? this.getAbbrevString(this.fullName, this.TITLE_DEFAULT_WIDTH, true) : this.getAbbrevString(this.fullName, this.TITLE_DEFAULT_WIDTH, false);
        this.command = this.m_desc.getParasItemValue(COMMAND);
        String string3 = this.m_desc.getParasItemValue(DESCRIPTION);
        if (string3 == null || string3.length() == 0) {
            string3 = this.fullName;
        }
        this.tooltip = commStyleInfo.getResString(string3);
        if (this.tooltip == null) {
            this.tooltip = string3;
        }
        if (this.selected) {
            this.readIcon(commStyleInfo);
        }
    }

    protected void readIcon(CommStyleInfo commStyleInfo) {
        ImageButtonIconInfo imageButtonIconInfo = this.getImageInformation(this.m_desc.getParasItemValue(ICON), commStyleInfo);
        if (null != imageButtonIconInfo) {
            this.imagePath = imageButtonIconInfo.getImagePath();
            this.image = imageButtonIconInfo.getIcon();
        }
        if (this.image == null || this.image.getIconWidth() < 0 || this.ICON_FOCUS_WIDTH < 0) {
            this.image = new ImageIcon(TextButton.class.getResource(this.defaultIcon));
            this.imagePath = this.defaultIcon;
        }
        if (this.imagePath.startsWith("file:/")) {
            this.imagePath = this.imagePath.substring(this.imagePath.indexOf("/") + 1);
        } else if (this.imagePath.startsWith("jar:file:/")) {
            this.imagePath = this.imagePath.substring(this.imagePath.lastIndexOf("/") + 1);
        }
        this.imagePath = this.imagePath.replaceAll("%20", " ");
    }

    public static void setResourceBundle(CommStyleInfo commStyleInfo) {
        String string = null;
        AreaDescContainer areaDescContainer = commStyleInfo.getAreaDescContainer(0);
        int n = areaDescContainer.getDescCount();
        DescContainer descContainer = null;
        for (int i = 0; i < n; ++i) {
            descContainer = areaDescContainer.getDescContainer(i);
            string = descContainer.getParasItemValue("type");
            if (string == null) {
                logger.trace("this desc have no type tag (descname: " + descContainer.getDescName() + ')');
                continue;
            }
            ResourceBundle resourceBundle = null;
            String string2 = descContainer.getParasItemValue("resourceBundleName");
            Object object = null;
            object = commStyleInfo.getPluginName() == null ? ResourceMng.getInstance() : commStyleInfo.getResource();
            if ("ResourceBundle".equals(string)) {
                resourceBundle = TextButton.getBundle(object, true, string2);
            } else if ("PropertyFile".equals(string)) {
                resourceBundle = TextButton.getBundle(object, true, string2);
            } else if ("XmlFile".equals(string)) {
                resourceBundle = TextButton.getBundle(object, false, string2);
            }
            commStyleInfo.setResourceBundle(resourceBundle);
        }
    }

    private static ResourceBundle getBundle(Object object, boolean bl, String string) {
        ResourceBundle resourceBundle = null;
        resourceBundle = object instanceof Resource ? (bl ? ((Resource)object).getResourceBundleFromPropertyFile(string) : ((Resource)object).getResourceBundleFromXmlFile(string)) : (bl ? ResourceMng.getInstance().getResourceBundleFromPropertyFile(string) : ResourceMng.getInstance().getResourceBundleFromXmlFile(string));
        return resourceBundle;
    }

    protected ImageButtonIconInfo getImageInformation(String string, CommStyleInfo serializable) {
        Serializable serializable2;
        ImageIcon imageIcon = null;
        if (null != string) {
            string = string.replace('\\', '/');
        }
        String string2 = this.getExportedPluginName();
        try {
            if (null != string && (null != serializable.getPluginName() || this.isImported() && null != string2)) {
                Serializable serializable3;
                if (this.isImported() && null != (serializable2 = PluginManager.getInstance().getPluginFromFolder(string2))) {
                    serializable3 = null;
                    if (this.isPersistenceToAllUsers()) {
                        serializable3 = WelcomeManager.getWelcomeButtonInfo(serializable2.getPluginName() + "/alluser");
                        if (null == serializable3 && null != (serializable3 = serializable2.getIntegrateCommStyleReader().getAllUserCommStyleInfo("welcomebutton"))) {
                            TextButton.setResourceBundle((CommStyleInfo)serializable3);
                        }
                    } else {
                        serializable3 = WelcomeManager.getWelcomeButtonInfo(serializable2.getPluginName() + "/user");
                        if (null == serializable3 && null != (serializable3 = serializable2.getIntegrateCommStyleReader().getUserCommStyleInfo("welcomebutton"))) {
                            TextButton.setResourceBundle((CommStyleInfo)serializable3);
                        }
                    }
                    if (null != serializable3) {
                        serializable = serializable3;
                    }
                }
                imageIcon = (ImageIcon)serializable.getResource().getIcon(string);
                if (string.lastIndexOf(58) > 0) {
                    serializable2 = string.split(":");
                    serializable3 = PluginManager.getInstance().getPluginFromFolder((String)((Object)serializable2[0]));
                    String string3 = "";
                    if (serializable3 != null) {
                        URL uRL = serializable.getResource().getEntry((String)((Object)serializable2[((Serializable)serializable2).length - 1]));
                        string3 = uRL.toString();
                        string3 = string3.substring(string3.indexOf(33) + 2);
                        string = serializable3.getURL() + string3;
                    }
                } else {
                    serializable2 = CommStyleManager.getURLFromJar(string);
                    if (serializable2 == null) {
                        serializable2 = serializable.getResource().getEntry(string);
                    }
                    string = ((URL)serializable2).toString();
                }
            } else {
                imageIcon = (ImageIcon)ResourceMng.getInstance().getIconDirect(string);
                serializable2 = ResourceMng.getInstance().getURLFromProOrDefault(string);
                if (serializable2 != null) {
                    string = ((URL)serializable2).toString();
                }
            }
        }
        catch (Exception exception) {
            imageIcon = null;
            string = null;
        }
        if (imageIcon == null) {
            imageIcon = (ImageIcon)ResourceMng.getInstance().getIconAbsolute(string);
            serializable2 = ResourceMng.getInstance().getURLFromProOrDefault(string);
            if (serializable2 != null) {
                string = ((URL)serializable2).toString();
            }
        }
        return new ImageButtonIconInfo(imageIcon, string);
    }

    protected boolean isPersistenceToAllUsers() {
        return false;
    }

    public void initGUIComponent() {
        if (null != this.iconComp) {
            this.iconComp.setToolTipText(this.getTooltip());
            this.iconComp.setName("IconButton_" + this.getTooltip());
            this.iconComp.repaint();
            this.iconComp.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseExited(MouseEvent mouseEvent) {
                    ToolTipManager.sharedInstance().setEnabled(false);
                    ToolTipManager.sharedInstance().setEnabled(true);
                }
            });
        }
        this.titleComponent.initGUI();
    }

    protected void resetSize() {
        int n = this.focused ? this.ICON_FOCUS_WIDTH : this.ICON_DEFAULT_WIDTH;
        int n2 = (int)this.titleComponent.getPreferredSize().getWidth();
        int n3 = Math.max(n, n2);
        int n4 = (int)this.titleComponent.getPreferredSize().getHeight();
        int n5 = this.focused ? this.ICON_FOCUS_HEIGHT : this.ICON_DEFAULT_HEIGHT;
        int n6 = n4 + n5;
        if (this.isPortalStyleButton()) {
            n3 += 60;
            n6 += 26;
            int n7 = 0;
            if (this.name.split(LINE_WRAPPER).length > 1) {
                n7 = this.isSingleSelected ? 5 : 10;
            } else if (this.isSingleSelected) {
                n7 = -5;
            }
            this.setBorder(BorderFactory.createEmptyBorder(15, 0, n7, 0));
        }
        this.setSize(n3, n6);
        this.titleComponent.resetSize();
        this.revalidate();
    }

    protected String getUpdatedButtonName() {
        return this.fullName;
    }

    protected void resetDefaultImage() {
        this.image = new ImageIcon(TextButton.class.getResource(this.defaultIcon));
        this.imagePath = this.defaultIcon;
    }

    public String getImagePath() {
        return this.imagePath;
    }

    public int getSerialNumber() {
        return this.serialNo;
    }

    public boolean isUserEnable() {
        return this.userEnable;
    }

    public String getCategory() {
        return this.category;
    }

    public String getCategoryResName() {
        return this.categoryResName;
    }

    public boolean isRemovable() {
        return this.removable;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public String getCommand() {
        return this.command;
    }

    public String getDescription() {
        return this.tooltip;
    }

    public String getActualDescription() {
        return this.m_desc.getParasItemValue(DESCRIPTION);
    }

    public String getFullName() {
        return this.fullName;
    }

    public void setFullName(String string) {
        this.m_desc.setParasItem(NAME, string, true);
        this.fullName = string;
        this.name = this.isSingleSelected ? this.getAbbrevString(string, this.TITLE_DEFAULT_WIDTH, true) : this.getAbbrevString(string, this.TITLE_DEFAULT_WIDTH, false);
    }

    public void setDescription(String string) {
        this.m_desc.setParasItem(DESCRIPTION, string, true);
        this.tooltip = string;
    }

    public void setCommand(String string) {
        this.m_desc.setParasItem(COMMAND, string, true);
        this.command = string;
    }

    public void setImagePath(String string) {
        this.m_desc.setParasItem(ICON, string, true);
        this.readIcon((CommStyleInfo)this.m_desc._getRootParent());
    }

    public void setSelected(boolean bl) {
        this.selected = bl;
        this.m_desc.setParasItem(IS_SELECTED, String.valueOf(bl), true);
    }

    public void setSerialNo(int n) {
        this.serialNo = n;
        this.m_desc.setParasItem(SERIAL_NUMBER, String.valueOf(n), true);
    }

    public boolean isExecutable() {
        return this.executable;
    }

    @Override
    public String toString() {
        return this.name;
    }

    public DescContainer getDescContainer() {
        return this.m_desc;
    }

    public void refreshButton(boolean bl) {
        this.ICON_DEFAULT_HEIGHT = DEFAULT_HEIGHT;
        this.ICON_DEFAULT_WIDTH = DEFAULT_WIDTH;
        this.ICON_FOCUS_HEIGHT = this.ICON_DEFAULT_HEIGHT + 10;
        this.ICON_FOCUS_WIDTH = this.ICON_DEFAULT_WIDTH + 10;
        CommStyleInfo commStyleInfo = (CommStyleInfo)this.m_desc._getRootParent();
        this.readModifiableValues(commStyleInfo);
        this.initGUIComponent();
        if (bl) {
            int n = (int)this.titleComponent.getPreferredSize().getWidth();
            this.titleComponent.setPreferredSize(new Dimension(n, this.getTitleHeight()));
            logger.trace("MMTest titleComponent name : " + this.fullName + " width " + n + " height " + this.getTitleHeight());
        }
        this.resetSize();
        this.setPreferredSize(this.getSize());
    }

    protected void processTextClick(Object object) {
        try {
            if (!((WelcomeTextButton)this).isEnabled()) {
                return;
            }
            if (this.isExecutable()) {
                ResourceBundle resourceBundle = ResourceMng.getInstance().getResourceBundleFromPropertyFile("mainfrm/iview/framework/windowmanagement/welcomepage/Res");
                String string = resourceBundle.getString("infoDialog_title");
                String string2 = resourceBundle.getString("exeWelPage_info");
                OptionPane.showMessageDialog(this, string2 + this.getCommand(), string, 1);
                return;
            }
            if (null != this.getCommand() && this.hasValidCommand()) {
                if (((WelcomeTextButton)this).getCommandProcessor() != null) {
                    CommandManager.getInstance().invokeCommand(this.getCommand(), ((WelcomeTextButton)this).getCommandProcessor());
                } else {
                    CommandManager.getInstance().invokeCommand(this.getCommand(), (WelcomeTextButton)this);
                }
            } else if (null != this.getAction() && this.getAction().isActionEnabled()) {
                ActionEvent actionEvent = new ActionEvent(object, 1001, null);
                this.getAction().actionPerformed(actionEvent);
            } else if (this instanceof DraggableButton || this instanceof ImageTextButton) {
                WelcomeManager.getWelcomeRef().removeTextButton(this);
            }
        }
        catch (Throwable throwable) {
            WelcomeManager.getWelcomeRef().removeTextButton(this);
            logger.trace("IView Handled error in welcome text Button mouse clickAction" + throwable);
        }
    }

    protected final void setFocused(boolean bl) {
        this.focused = bl;
    }

    protected boolean isPortalStyleButton() {
        return false;
    }

    public final String getButtonName() {
        String string = "";
        String string2 = null == this.fullName ? "" : this.fullName;
        try {
            String[] stringArray;
            for (String string3 : stringArray = string2.split(LINE_WRAPPER)) {
                string = string + string3.trim() + " ";
            }
        }
        catch (Exception exception) {
            string = string2;
        }
        return string.trim();
    }

    public void setTransparency(boolean bl) {
        this.transparent = bl;
        this.updateUI();
    }

    public AuthorityAction getAction() {
        return this.action;
    }

    public boolean isActionButton() {
        return this.actionButton;
    }

    public void setActionButton(boolean bl) {
        this.actionButton = bl;
    }

    public String getIconInfo() {
        String string = this.getDescContainer().getParasItemValue(ICON);
        return null == string ? "" : string;
    }

    public String getPluginName() {
        String string = "";
        DescContainer descContainer = this.getDescContainer();
        if (descContainer._getRootParent() instanceof CommStyleInfo) {
            CommStyleInfo commStyleInfo = (CommStyleInfo)descContainer._getRootParent();
            string = null == commStyleInfo.getPluginName() ? "" : commStyleInfo.getPluginName().trim();
        }
        return string;
    }

    public final boolean isImported() {
        return Boolean.valueOf(this.getDescContainer().getParasItemValue(IMPORTED));
    }

    public String getExportedPluginName() {
        return this.getDescContainer().getParasItemValue(PLUGIN_NAME);
    }

    public String getExtButtonInfo(String string) {
        return this.getDescContainer().getParasItemValue(string);
    }

    public boolean setExtButtonInfo(String string, String string2) {
        if (null == string || !string.startsWith("ext_")) {
            return false;
        }
        this.getDescContainer().setParasItem(string, string2, true);
        return true;
    }

    public final Map<String, String> getExtButtonInfo() {
        HashMap<String, String> hashMap = new HashMap<String, String>(16);
        if (null == this.m_desc || this.m_desc.getParasItemCount() <= 0) {
            return hashMap;
        }
        int n = this.m_desc.getParasItemCount();
        String string = "";
        for (int i = 0; i < n; ++i) {
            string = this.m_desc.getParasItem(i).getName();
            if (!string.startsWith("ext_")) continue;
            hashMap.put(string, this.m_desc.getParasItem(i).getValue());
        }
        return hashMap;
    }

    protected void setUserEnable(boolean bl) {
        this.userEnable = bl;
    }

    protected void setRemovable(boolean bl) {
        this.removable = bl;
    }

    protected String getTooltip() {
        return this.tooltip;
    }

    protected int getIconFocusWidth() {
        return this.ICON_FOCUS_WIDTH;
    }

    protected int getIconDefualtWidth() {
        return this.ICON_DEFAULT_WIDTH;
    }

    protected int getIconFocusHeight() {
        return this.ICON_FOCUS_HEIGHT;
    }

    protected int getIconDefualtHeight() {
        return this.ICON_DEFAULT_HEIGHT;
    }

    protected boolean isFocused() {
        return this.focused;
    }

    protected boolean isTransparent() {
        return this.transparent;
    }

    protected ImageIcon getImage() {
        return this.image;
    }

    protected void setImage(ImageIcon imageIcon) {
        this.image = imageIcon;
    }

    protected void executeCommand() {
        CommonUtil.executeCommand(this.command);
    }

    public void fireClickAction(boolean bl) {
    }

    public void fireControlClick() {
    }

    public int getSeqenceNumber() {
        return this.seqNo;
    }

    private int getTitleHeight() {
        int n = this.name.split(LINE_WRAPPER).length;
        if (this.isPortalStyleButton() && n == 1) {
            ++n;
        }
        return n * 15 + 4;
    }

    public String getMenuID() {
        return this.menuID;
    }

    public void setMenuID(String string) {
        if (null != string) {
            this.m_desc.setParasItem(MENUID, string, true);
            this.menuID = string;
        }
    }

    public String getActionName() {
        return this.actionName;
    }

    protected final boolean hasValidCommand() {
        DescContainer descContainer = CommandManager.getInstance().getCommandDescContainer(this.getCommand());
        return null != descContainer;
    }

    protected boolean isHovered() {
        return this.isHovered;
    }

    protected void initAction(FavouriteButton favouriteButton) {
        String string = null;
        if (null != favouriteButton.getDescContainer().getParasItem(ACTION) && null != (string = favouriteButton.getDescContainer().getParasItem(ACTION).getValue()) && string.startsWith("class")) {
            string = string.substring(6);
        }
        if (null != string) {
            this.actionName = string;
            try {
                Class<?> clazz = null;
                clazz = Class.forName(string);
                this.action = (AuthorityAction)clazz.newInstance();
                this.action.setSource(this);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private class TitleComponent
    extends JTextArea {
        private TitleComponent(Dimension dimension) {
            this.setEditable(false);
            this.setFocusable(false);
            this.setFont(UIManager.getFont("Label.font"));
            this.setOpaque(false);
            super.setMargin(this.getInsetsForText());
            this.setPreferredSize(dimension);
            this.setSize(this.getPreferredSize());
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    if (2 == mouseEvent.getClickCount() && 16 == mouseEvent.getModifiers()) {
                        try {
                            TextButton.this.processTextClick(mouseEvent.getSource());
                        }
                        catch (Throwable throwable) {
                            WelcomeManager.getWelcomeRef().removeTextButton(TextButton.this);
                            logger.trace("IView Handled error in welcome text Button mouse clickAction" + throwable);
                        }
                    }
                }

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                    if (SwingUtilities.isLeftMouseButton(mouseEvent) && (mouseEvent.getModifiers() & 2) == 2) {
                        TextButton.this.fireControlClick();
                    } else if (1 == mouseEvent.getClickCount()) {
                        TextButton.this.fireClickAction(SwingUtilities.isLeftMouseButton(mouseEvent));
                    }
                }

                @Override
                public void mouseExited(MouseEvent mouseEvent) {
                    ToolTipManager.sharedInstance().setEnabled(false);
                    ToolTipManager.sharedInstance().setEnabled(true);
                }
            });
        }

        @Override
        public void paintComponent(Graphics graphics) {
            block14: {
                int n;
                boolean bl;
                int n2;
                int n3;
                block12: {
                    int n4;
                    block13: {
                        super.paintComponent(graphics);
                        n3 = SwingUtilities.computeStringWidth(this.getFontMetrics(UIManager.getFont("Label.font")), TextButton.this.name);
                        n2 = TextButton.this.getSize().width;
                        if (TextButton.this.isPortalStyleButton()) {
                            n2 -= 20;
                        }
                        bl = true;
                        n = (n2 - n3) / 2;
                        n4 = 15;
                        if (n3 > n2) {
                            n = 0;
                            bl = false;
                            n3 = n2;
                        }
                        if (TextButton.this.isEnabled() && TextButton.this.isSingleSelected && !TextButton.this.isPortalStyleButton()) {
                            graphics.setColor(TEXT_SELECTED_COLOR);
                            graphics.fillRect(n - 2, 2, n3 + 4, TextButton.this.getTitleHeight());
                            graphics.setColor(Color.white);
                        }
                        if (!TextButton.this.isPortalStyleButton()) break block12;
                        if (TextButton.this.isSingleSelected && TextButton.this instanceof ApplicationButton) {
                            this.setForeground(Color.blue);
                            n += 5;
                        } else {
                            this.setForeground(SystemColor.textText);
                        }
                        if (!bl) break block13;
                        graphics.drawString(TextButton.this.name, n += 10, n4);
                        break block14;
                    }
                    String[] stringArray = TextButton.this.name.split(LINE_WRAPPER);
                    if (stringArray.length <= 1) break block14;
                    for (int i = 0; i < stringArray.length; ++i) {
                        int n5 = SwingUtilities.computeStringWidth(this.getFontMetrics(UIManager.getFont("Label.font")), stringArray[i]);
                        n = (n2 - n5) / 2;
                        if (n < 0) {
                            n = 0;
                        }
                        n += 7;
                        if (TextButton.this.isSingleSelected && TextButton.this instanceof ApplicationButton) {
                            n += 5;
                        }
                        graphics.drawString(stringArray[i], n, n4 * (i + 1));
                    }
                    break block14;
                }
                if (bl) {
                    graphics.drawString(TextButton.this.name, (n2 - n3) / 2, 14);
                } else {
                    String[] stringArray = TextButton.this.name.split(LINE_WRAPPER);
                    if (stringArray.length > 1) {
                        for (int i = 0; i < stringArray.length; ++i) {
                            graphics.drawString(stringArray[i], n, 15 * (i + 1));
                        }
                    }
                }
            }
        }

        private void initGUI() {
            this.setName("TitleComponent_" + TextButton.this.name);
            this.setToolTipText(TextButton.this.getTooltip());
            this.repaint();
        }

        private Insets getInsetsForText() {
            Insets insets = new Insets(0, 0, 0, 0);
            int n = SwingUtilities.computeStringWidth(this.getFontMetrics(UIManager.getFont("Label.font")), TextButton.this.name);
            if (n < TextButton.this.getSize().width) {
                int n2 = TextButton.this.getSize().width - n;
                insets = new Insets(0, n2 / 2, 0, n2 / 2);
            }
            return insets;
        }

        private void resetSize() {
            super.setMargin(this.getInsetsForText());
        }
    }
}

