/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.commstyle.commini;

import com.swimap.iview.commstyle.commini.BorderlessButton;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Polygon;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.UIManager;

public class SinglePopupButton
extends JComponent {
    private JPopupMenu popup = null;
    private BorderlessButton btnRight = null;
    private PopupButtonListener listener = new PopupButtonListener();

    public SinglePopupButton() {
        this(null);
    }

    public SinglePopupButton(String string) {
        this(string, null);
    }

    public SinglePopupButton(String string, Icon icon) {
        this(string, icon, new JPopupMenu());
    }

    public SinglePopupButton(String string, Icon icon, JPopupMenu jPopupMenu) {
        this.createButtons();
        this.setText(string);
        this.setIcon(icon);
        this.setPopup(jPopupMenu);
        this.refreshUI();
        this.setName("SinglePopupButton");
    }

    public AbstractButton getButton() {
        return this.btnRight;
    }

    public void setText(String string) {
        this.btnRight.setText(string);
    }

    public String getText() {
        return this.btnRight.getText();
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.btnRight.setEnabled(bl);
    }

    @Override
    public void setName(String string) {
        super.setName(string);
        this.btnRight.setName(string + "_btnRight");
    }

    public void setIcon(Icon icon) {
        this.btnRight.setIcon(icon);
    }

    public void setPopup(JPopupMenu jPopupMenu) {
        this.popup = jPopupMenu;
    }

    public JPopupMenu getPopup() {
        return this.popup;
    }

    public void refreshUI() {
        super.removeAll();
        this.setBorder(null);
        this.setLayout(new BorderLayout());
        this.add((Component)this.btnRight, "Center");
        this.btnRight.setPreferredSize(new Dimension(12, 1));
        this.btnRight.addMouseListener(this.listener);
        this.doLayout();
    }

    public void showPopupMenu() {
        if (this.popup == null) {
            return;
        }
        this.popup.show(this, 0, this.getHeight());
    }

    protected void createButtons() {
        if (this.btnRight == null) {
            this.btnRight = new BorderlessButton(){

                @Override
                public void paint(Graphics graphics) {
                    super.paint(graphics);
                    Polygon polygon = new Polygon();
                    int n = this.getWidth();
                    int n2 = (this.getHeight() - 2) / 2;
                    int n3 = n - 8;
                    if (this.isSelected()) {
                        ++n3;
                    }
                    polygon.addPoint(n3, n2);
                    polygon.addPoint(n3 + 2, n2 + 2);
                    polygon.addPoint(n3 + 4, n2);
                    if (!this.isEnabled()) {
                        graphics.setColor(UIManager.getColor("Button.disabledText"));
                    }
                    graphics.fillPolygon(polygon);
                    graphics.drawPolygon(polygon);
                }
            };
            this.btnRight.setMargin(new Insets(0, 0, 0, 0));
        }
    }

    private class PopupButtonListener
    extends MouseAdapter {
        private PopupButtonListener() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (!SinglePopupButton.this.isEnabled()) {
                return;
            }
            if (mouseEvent.getSource() == SinglePopupButton.this.btnRight) {
                SinglePopupButton.this.showPopupMenu();
            }
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            if (!SinglePopupButton.this.isEnabled()) {
                return;
            }
            SinglePopupButton.this.btnRight.setBorderPainted(true);
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            if (!SinglePopupButton.this.isEnabled()) {
                return;
            }
            SinglePopupButton.this.btnRight.setBorderPainted(false);
        }
    }
}

