/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.commstyle.commini;

import com.swimap.iview.commstyle.commandmng.authority.AuthorityAction;
import com.swimap.iview.commstyle.commini.CheckBoxMenuItem;
import com.swimap.iview.commstyle.commini.DescContainer;
import com.swimap.iview.commstyle.commini.IComminiProperties;
import com.swimap.iview.commstyle.commini.Menu;
import com.swimap.iview.commstyle.commini.MenuItem;
import com.swimap.iview.commstyle.commini.RadioButtonMenuItem;
import com.swimap.iview.commstyle.commini.Separator;
import com.swimap.iview.commstyle.commini.UIObjectDescriptionNotCorrectException;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.Component;
import java.util.Hashtable;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;

public class PopupMenu
extends JPopupMenu {
    private static IviewLogger logger = IviewLogger.getLogger(PopupMenu.class, "IVIEW");
    private DescContainer m_desc;
    private Hashtable buttonGroupHash;
    private static final String PARA_TYPE = "type";
    private static final String PARA_TOBELOADED = "tobeloaded";
    private boolean menuVisible;
    private boolean allMenuItemsVisible;
    private boolean menuEnable;
    private boolean allMenuItemsEnable;
    private AuthorityAction menuAction;

    public PopupMenu(DescContainer descContainer) throws UIObjectDescriptionNotCorrectException {
        block12: {
            this.buttonGroupHash = new Hashtable();
            this.menuVisible = false;
            this.allMenuItemsVisible = false;
            this.menuEnable = false;
            this.allMenuItemsEnable = false;
            this.menuAction = null;
            try {
                Object object;
                if (descContainer == null) {
                    logger.debug("Popup Menu Description is null!");
                    throw new UIObjectDescriptionNotCorrectException("PopupMenu:UI Object can not be create from the Description, check your Style file ");
                }
                String string = descContainer.getParasItemValue(PARA_TYPE);
                if (string == null || !"JPopupMenu".equals(string)) {
                    logger.debug("Popup Menu Description is not JPopupMenu type!");
                }
                this.m_desc = descContainer;
                int n = descContainer.getSubDescCount();
                JComponent jComponent = null;
                for (int i = 0; i < n; ++i) {
                    object = descContainer.getDescContainer(i).getParasItemValue(PARA_TOBELOADED);
                    if (null != object && "false".equalsIgnoreCase(((String)object).trim())) {
                        logger.debug("Has a menu is not loaded " + descContainer.getDescContainer(i).getParasItemValue("name"));
                        continue;
                    }
                    jComponent = "JMenuItem".equals(descContainer.getDescContainer(i).getParasItemValue(PARA_TYPE)) ? this.createMenuItem(descContainer.getDescContainer(i)) : ("JMenu".equals(descContainer.getDescContainer(i).getParasItemValue(PARA_TYPE)) ? (JMenu)Menu.getUIObject(descContainer.getDescContainer(i)) : (JSeparator)Separator.getUIObject(descContainer.getDescContainer(i)));
                    this.insertComponent(jComponent);
                }
                String string2 = null;
                if (descContainer.getParasItem("action") != null) {
                    string2 = descContainer.getParasItem("action").getValue();
                }
                if (string2 == null) break block12;
                object = null;
                try {
                    object = Class.forName(string2);
                    this.menuAction = (AuthorityAction)((Class)object).newInstance();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    logger.trace(classNotFoundException);
                }
                catch (InstantiationException instantiationException) {
                    logger.trace(instantiationException);
                }
                catch (IllegalAccessException illegalAccessException) {
                    logger.trace(illegalAccessException);
                }
                if (null != this.menuAction) {
                    this.menuAction.setSource(this);
                }
            }
            catch (Exception exception) {
                logger.trace(exception.getMessage(), exception);
                throw new UIObjectDescriptionNotCorrectException("PopupMenu:UI Object can not be create from the Description, check your Style file ");
            }
        }
        long l = System.currentTimeMillis();
        this.updatePopupMenu();
        logger.debug("Total cost for updatePopupMenu:" + (System.currentTimeMillis() - l) + "for popupmenu: " + this.getID());
    }

    private JMenuItem createMenuItem(DescContainer descContainer) {
        Object object = null;
        String string = descContainer.getParasItemValue("itemType");
        if (string == null) {
            string = "";
        }
        if ("CheckBox".equals(string)) {
            object = CheckBoxMenuItem.getUIObject(descContainer);
        } else if ("RadioButton".equals(string)) {
            RadioButtonMenuItem radioButtonMenuItem = (RadioButtonMenuItem)RadioButtonMenuItem.getUIObject(descContainer);
            ButtonGroup buttonGroup = (ButtonGroup)this.buttonGroupHash.get(radioButtonMenuItem.getButtonGroup());
            if (buttonGroup == null) {
                buttonGroup = new ButtonGroup();
                this.buttonGroupHash.put(radioButtonMenuItem.getButtonGroup(), buttonGroup);
            }
            buttonGroup.add(radioButtonMenuItem);
            object = radioButtonMenuItem;
        } else {
            object = MenuItem.getUIObject(descContainer);
        }
        return (JMenuItem)object;
    }

    protected void insertComponent(Component component) {
        int n = -1;
        if (component instanceof IComminiProperties) {
            n = ((IComminiProperties)((Object)component)).getSerialNumber();
        }
        int n2 = this.getComponentCount();
        if (n != -1) {
            n2 = this.getComponentPos(n);
        }
        if (component instanceof Separator) {
            if (n2 >= this.getComponentCount()) {
                this.add(component);
            } else {
                this.insert(component, n2);
            }
        } else if (component instanceof JMenuItem) {
            if (n2 >= this.getComponentCount()) {
                this.add((JMenuItem)component);
            } else {
                this.insert((JMenuItem)component, n2);
            }
        }
    }

    private int getComponentPos(int n) {
        int n2 = this.getComponentCount();
        int n3 = 0;
        Component component = null;
        for (n3 = 0; n3 < n2; ++n3) {
            int n4 = -1;
            component = this.getComponent(n3);
            if (component instanceof IComminiProperties) {
                n4 = ((IComminiProperties)((Object)component)).getSerialNumber();
            }
            if (n4 == -1 || n4 <= n) continue;
            return n3;
        }
        return n3;
    }

    public String getID() {
        return this.m_desc.getDescName();
    }

    public Component getMenuItem(String string) {
        int n = this.getComponentCount();
        Component component = null;
        for (int i = 0; i < n; ++i) {
            String string2;
            component = this.getComponent(i);
            String string3 = string2 = component instanceof IComminiProperties ? ((IComminiProperties)((Object)component)).getID() : null;
            if (string2 == null || !string2.equals(string)) continue;
            return this.getComponent(i);
        }
        return null;
    }

    public static Object getUIObject(DescContainer descContainer) {
        PopupMenu popupMenu = null;
        try {
            popupMenu = new PopupMenu(descContainer);
        }
        catch (Exception exception) {
            logger.error(exception.getMessage());
        }
        return popupMenu;
    }

    public void addMenuItem(JMenuItem jMenuItem) {
        this.add(jMenuItem);
    }

    public void addMenuItem(JMenuItem jMenuItem, int n) {
        this.add((Component)jMenuItem, n);
    }

    public void removeMenuItem(int n) {
        this.remove(n);
        this.updateUI();
    }

    public void removeMenuItem(String string) {
        Component component = this.getMenuItem(string);
        if (component != null) {
            this.remove(component);
        }
    }

    public void updatePopupMenu() {
        Component[] componentArray;
        if (null != this.menuAction) {
            try {
                this.menuVisible = this.menuAction.isActionVisible();
                this.menuEnable = this.menuAction.isActionEnabled();
            }
            catch (Throwable throwable) {
                logger.trace("Iview Handled Error while UpdatingPopup menuAction" + this.getName(), throwable);
            }
            this.setEnabled(this.menuEnable);
            this.setVisible(this.menuVisible);
            if (!this.menuVisible || !this.menuEnable) {
                return;
            }
        }
        if ((componentArray = this.getComponents()) == null || componentArray.length == 0) {
            return;
        }
        boolean bl = true;
        boolean bl2 = true;
        boolean bl3 = true;
        for (int i = 0; i < componentArray.length; ++i) {
            JMenuItem jMenuItem;
            if (componentArray[i] instanceof MenuItem) {
                jMenuItem = (MenuItem)componentArray[i];
                ((MenuItem)jMenuItem).updateMenuItem();
                boolean bl4 = bl = null != ((MenuItem)jMenuItem).getMenuItemAction();
                if (!bl) {
                    bl2 = null != ((MenuItem)jMenuItem).getMenuItemView();
                }
            } else if (componentArray[i] instanceof RadioButtonMenuItem) {
                jMenuItem = (RadioButtonMenuItem)componentArray[i];
                ((RadioButtonMenuItem)jMenuItem).updateMenuItem();
                boolean bl5 = bl = null != ((RadioButtonMenuItem)jMenuItem).getMenuItemAction();
                if (!bl) {
                    bl2 = null != ((RadioButtonMenuItem)jMenuItem).getMenuItemView();
                }
            } else if (componentArray[i] instanceof CheckBoxMenuItem) {
                jMenuItem = (CheckBoxMenuItem)componentArray[i];
                ((CheckBoxMenuItem)jMenuItem).updateMenuItem();
                boolean bl6 = bl = null != ((CheckBoxMenuItem)jMenuItem).getMenuItemAction();
                if (!bl) {
                    bl2 = null != ((CheckBoxMenuItem)jMenuItem).getMenuItemView();
                }
            } else if (componentArray[i] instanceof PopupMenu) {
                ((PopupMenu)componentArray[i]).updatePopupMenu();
            } else if (componentArray[i] instanceof Menu) {
                ((Menu)componentArray[i]).updateMenu();
            }
            if (componentArray[i] instanceof JPopupMenu.Separator) continue;
            if (componentArray[i].isVisible()) {
                this.allMenuItemsVisible = true;
            }
            if (componentArray[i].isEnabled()) {
                this.allMenuItemsEnable = true;
            }
            if (!bl3 || bl || bl2) continue;
            bl3 = false;
        }
        if (bl3) {
            if (!this.allMenuItemsVisible) {
                this.setVisible(false);
            }
            if (!this.allMenuItemsEnable) {
                this.setEnabled(false);
            }
        }
        this.validatePopUpSeparators();
    }

    public void validatePopUpSeparators() {
        this.validatePopUpSeparators(true);
    }

    void validatePopUpSeparators(boolean bl) {
        int n;
        Component[] componentArray = this.getComponents();
        boolean bl2 = bl;
        Component component = null;
        for (n = 0; n < componentArray.length; ++n) {
            component = componentArray[n];
            if (component instanceof JSeparator) {
                if (bl2) {
                    component.setVisible(false);
                } else {
                    component.setVisible(true);
                }
                bl2 = true;
                continue;
            }
            if (!(component instanceof JMenu) && !(component instanceof JMenuItem) || !component.isVisible()) continue;
            bl2 = false;
        }
        bl2 = bl;
        for (n = componentArray.length - 1; n > 0; --n) {
            component = componentArray[n];
            if (component instanceof JSeparator) {
                if (bl2) {
                    component.setVisible(false);
                    continue;
                }
                component.setVisible(true);
                bl2 = true;
                continue;
            }
            if (component.isVisible()) break;
        }
    }
}

