/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.commstyle.commini;

import com.swimap.iview.commstyle.commini.BorderlessButton;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Polygon;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.UIManager;

public class PopupButton
extends JComponent {
    private JPopupMenu popup = null;
    private BorderlessButton btnLeft = null;
    private BorderlessButton btnRight = null;
    private PopupButtonListener listener = new PopupButtonListener();

    public PopupButton() {
        this(null);
    }

    public PopupButton(String string) {
        this(string, null);
    }

    public PopupButton(String string, Icon icon) {
        this(string, icon, null);
    }

    public PopupButton(String string, Icon icon, JPopupMenu jPopupMenu) {
        this.createButtons();
        this.setText(string);
        this.setIcon(icon);
        this.setPopup(jPopupMenu);
        this.refreshUI();
        this.setName("PopupButton");
    }

    @Override
    public void setBackground(Color color) {
        super.setBackground(color);
        this.btnLeft.setBackground(color);
        this.btnRight.setBackground(color);
    }

    @Override
    public void setName(String string) {
        super.setName(string);
        this.btnLeft.setName(string + "_btnLeft");
        this.btnRight.setName(string + "_btnRight");
    }

    public AbstractButton getRightButton() {
        return this.btnRight;
    }

    public AbstractButton getLeftButton() {
        return this.btnLeft;
    }

    public void setText(String string) {
        this.btnLeft.setText(string);
    }

    public String getText() {
        return this.btnLeft.getText();
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.btnLeft.setEnabled(bl);
        this.btnRight.setEnabled(bl);
    }

    public void setIcon(Icon icon) {
        this.btnLeft.setIcon(icon);
    }

    public Icon getIcon() {
        return this.btnLeft.getIcon();
    }

    public void setPopup(JPopupMenu jPopupMenu) {
        this.popup = jPopupMenu;
    }

    public JPopupMenu getPopup() {
        return this.popup;
    }

    public void addActionListener(ActionListener actionListener) {
        this.btnLeft.addActionListener(actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.btnLeft.removeActionListener(actionListener);
    }

    public void refreshUI() {
        super.removeAll();
        this.setBorder(null);
        this.setLayout(new BorderLayout());
        this.add((Component)this.btnLeft, "Center");
        this.add((Component)this.btnRight, "East");
        this.btnLeft.addMouseListener(this.listener);
        this.btnRight.setPreferredSize(new Dimension(12, 1));
        this.btnRight.addMouseListener(this.listener);
        this.doLayout();
    }

    private void createButtons() {
        if (this.btnLeft == null) {
            this.btnLeft = new BorderlessButton();
            this.btnLeft.setMargin(new Insets(0, 0, 0, 0));
        }
        if (this.btnRight == null) {
            this.btnRight = new BorderlessButton(){

                @Override
                public void paint(Graphics graphics) {
                    super.paint(graphics);
                    Polygon polygon = new Polygon();
                    int n = this.getWidth();
                    int n2 = (this.getHeight() - 2) / 2;
                    int n3 = (n - 4) / 2;
                    if (this.isSelected()) {
                        ++n3;
                    }
                    polygon.addPoint(n3, n2);
                    polygon.addPoint(n3 + 2, n2 + 2);
                    polygon.addPoint(n3 + 4, n2);
                    if (!this.isEnabled()) {
                        graphics.setColor(UIManager.getColor("Button.disabledText"));
                    }
                    graphics.fillPolygon(polygon);
                    graphics.drawPolygon(polygon);
                }
            };
        }
    }

    public void showPopupMenu() {
        if (this.popup == null) {
            return;
        }
        this.popup.show(this, 0, this.getHeight());
    }

    private class PopupButtonListener
    extends MouseAdapter {
        private PopupButtonListener() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (!PopupButton.this.isEnabled()) {
                return;
            }
            if (mouseEvent.getSource() == PopupButton.this.btnRight) {
                PopupButton.this.showPopupMenu();
            }
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            if (!PopupButton.this.isEnabled()) {
                return;
            }
            PopupButton.this.btnLeft.setBorderPainted(true);
            PopupButton.this.btnRight.setBorderPainted(true);
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            if (!PopupButton.this.isEnabled()) {
                return;
            }
            PopupButton.this.btnLeft.setBorderPainted(false);
            PopupButton.this.btnRight.setBorderPainted(false);
        }
    }
}

