/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.commstyle.commini;

import com.swimap.iview.commstyle.commini.CheckBoxMenuItem;
import com.swimap.iview.commstyle.commini.CommStyleManager;
import com.swimap.iview.commstyle.commini.DescContainer;
import com.swimap.iview.commstyle.commini.Menu;
import com.swimap.iview.commstyle.commini.MenuBar;
import com.swimap.iview.commstyle.commini.MenuItem;
import com.swimap.iview.commstyle.commini.RadioButtonMenuItem;
import com.swimap.iview.commstyle.commini.UIObjectDescriptionNotCorrectException;
import com.swimap.iview.commstyle.commini.foldingmenus.FoldingMenuUtilities;
import com.swimap.iview.commstyle.commini.foldingmenus.IActivity;
import com.swimap.iview.framework.menumanagement.MenuActivityStore;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.swing.JMenuItem;

public class MenuSet {
    private static IviewLogger logger = IviewLogger.getLogger(MenuSet.class, "IVIEW");
    private Vector menuOrder = new Vector();
    private Hashtable menuHash = new Hashtable();
    private DescContainer m_desc;
    private MenuBar menuBar = null;
    private static Hashtable<String, String> secondaryMap = new Hashtable(5);
    private String secondaryID = null;
    private static final String PARA_TOBELOADED = "tobeloaded";

    public DescContainer getDescMember() {
        return this.m_desc;
    }

    public Hashtable getMenuHash() {
        return this.menuHash;
    }

    public Vector getMenuOrder() {
        return this.menuOrder;
    }

    public Menu getMenu(String string) {
        Menu menu = (Menu)this.menuHash.get(string);
        if (menu == null) {
            logger.debug(string + " not exsit the the menuHash!");
        }
        return menu;
    }

    public MenuSet(DescContainer descContainer) throws UIObjectDescriptionNotCorrectException {
        try {
            if (!"MenuSet".equals(descContainer.getParasItemValue("type"))) {
                logger.debug("descContainer is not MenuSet type");
            }
            this.m_desc = descContainer;
            this.secondaryID = descContainer.getParasItemValue("secondaryid");
            int n = descContainer.getSubDescCount();
            for (int i = 0; i < n; ++i) {
                String string = descContainer.getDescContainer(i).getParasItemValue(PARA_TOBELOADED);
                if (null != string && "false".equalsIgnoreCase(string.trim())) {
                    logger.debug("Has a menu is not loaded " + descContainer.getDescContainer(i).getParasItemValue("name"));
                    continue;
                }
                if (!"JMenu".equals(descContainer.getDescContainer(i).getParasItem("type").getValue())) continue;
                this.createMenu(descContainer.getDescContainer(i));
            }
        }
        catch (Exception exception) {
            logger.warn(exception.getMessage());
            throw new UIObjectDescriptionNotCorrectException("MenuSet can not be create from the Description, check your Style file ");
        }
    }

    protected void createMenu(DescContainer descContainer) {
        Menu menu = (Menu)Menu.getUIObject(descContainer);
        try {
            this.loadMenuActivityCount(menu, new ArrayList<String>());
        }
        catch (Exception exception) {
            logger.warn("Reading menu activity count failed" + exception.getMessage(), exception);
        }
        this.insertMenu(menu);
    }

    public static Object getUIObject(DescContainer descContainer) {
        MenuSet menuSet = null;
        try {
            menuSet = new MenuSet(descContainer);
        }
        catch (Exception exception) {
            logger.error(exception.getMessage());
        }
        return menuSet;
    }

    public static Object getUIObject(String string, String string2) {
        MenuSet menuSet = null;
        try {
            DescContainer descContainer = CommStyleManager.getInstance().getCommonStyleFile(string).getAreaDescContainer(0).getDescContainer(string2);
            menuSet = new MenuSet(descContainer);
        }
        catch (Exception exception) {
            logger.error(exception.getMessage());
        }
        return menuSet;
    }

    public MenuBar toMenuBar() {
        if (this.menuBar == null) {
            this.menuBar = new MenuBar(this);
        }
        return this.menuBar;
    }

    public String getID() {
        return this.m_desc.getDescName();
    }

    public int getMenuCount() {
        return this.menuOrder.size();
    }

    public Menu getMenu(int n) {
        return (Menu)this.menuOrder.elementAt(n);
    }

    public void addMenu(String string, Menu menu) {
        this.menuOrder.add(menu);
        this.menuHash.put(string, menu);
        this.populateSecondary(menu, true, string);
    }

    public void insertMenu(String string, Menu menu, int n) {
        if (n < this.menuOrder.size()) {
            this.menuOrder.insertElementAt(menu, n);
        } else {
            this.menuOrder.add(menu);
        }
        this.menuHash.put(string, menu);
        this.populateSecondary(menu, true, string);
    }

    public void insertMenu(Menu menu, int n) {
        int n2 = menu.getSerialNumber();
        if (n2 == -1) {
            if (this.menuOrder.size() - n < 0) {
                this.insertMenu(menu.getID(), menu, this.menuOrder.size());
            } else {
                this.insertMenu(menu.getID(), menu, this.menuOrder.size() - n);
            }
        } else {
            this.insertMenu(menu.getID(), menu, this.getMenuPos(n2));
        }
    }

    public void insertMenu(Menu menu) {
        this.insertMenu(menu, 0);
    }

    public int getMenuPos(int n) {
        int n2 = this.menuOrder.size();
        int n3 = 0;
        for (n3 = 0; n3 < n2; ++n3) {
            int n4 = ((Menu)this.menuOrder.elementAt(n3)).getSerialNumber();
            if (n4 == -1 || n4 <= n) continue;
            return n3;
        }
        return n3;
    }

    public void removeMenu(Menu menu) {
        this.menuOrder.remove(menu);
        this.menuHash.remove(menu.getName());
    }

    public MenuBar refreshMenuBar() {
        this.menuBar = new MenuBar(this);
        return this.menuBar;
    }

    private void loadMenuActivityCount(Menu menu, List<String> list) {
        if (null == menu) {
            return;
        }
        menu.setEnableFolding(FoldingMenuUtilities.isEnableFolding());
        list.add(menu.getID());
        int n = menu.getMenuComponentCount();
        Component component = null;
        IActivity iActivity = null;
        String string = this.getID();
        for (int i = 0; i < n; ++i) {
            component = menu.getMenuComponent(i);
            if (!(component instanceof IActivity)) continue;
            iActivity = (IActivity)((Object)component);
            if (iActivity instanceof Menu) {
                this.loadMenuActivityCount((Menu)iActivity, list);
                continue;
            }
            String string2 = MenuSet.getMenuItemID(component);
            if (null == string2) continue;
            int n2 = MenuActivityStore.getInstance().getActivityCount(string, list, string2);
            iActivity.setActivityCount(n2);
        }
        list.remove(menu.getID());
    }

    public static String getMenuItemID(Component component) {
        if (component instanceof MenuItem) {
            return ((MenuItem)component).getID();
        }
        if (component instanceof RadioButtonMenuItem) {
            return ((RadioButtonMenuItem)component).getID();
        }
        if (component instanceof CheckBoxMenuItem) {
            return ((CheckBoxMenuItem)component).getID();
        }
        return null;
    }

    public String getSecondaryId() {
        return this.secondaryID;
    }

    public static String getMenuPath(String string) {
        return secondaryMap.get(string);
    }

    private void populateSecondary(Menu menu, boolean bl, String string) {
        if (bl) {
            if (null != this.secondaryID) {
                secondaryMap.put(this.secondaryID, this.getID());
            }
            if (null != menu.getSecondaryId()) {
                secondaryMap.put(menu.getSecondaryId(), this.getID() + "-" + string);
            }
        }
        Component[] componentArray = menu.getMenuComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            JMenuItem jMenuItem;
            if (componentArray[i] instanceof MenuItem) {
                jMenuItem = (MenuItem)componentArray[i];
                if (null == ((MenuItem)jMenuItem).getSecondaryId()) continue;
                secondaryMap.put(((MenuItem)jMenuItem).getSecondaryId(), this.getID() + "-" + string + "-" + ((MenuItem)jMenuItem).getID());
                continue;
            }
            if (componentArray[i] instanceof RadioButtonMenuItem) {
                jMenuItem = (RadioButtonMenuItem)componentArray[i];
                if (null == ((RadioButtonMenuItem)jMenuItem).getSecondaryId()) continue;
                secondaryMap.put(((RadioButtonMenuItem)jMenuItem).getSecondaryId(), this.getID() + "-" + string + "-" + ((RadioButtonMenuItem)jMenuItem).getID());
                continue;
            }
            if (componentArray[i] instanceof CheckBoxMenuItem) {
                jMenuItem = (CheckBoxMenuItem)componentArray[i];
                if (null == ((CheckBoxMenuItem)jMenuItem).getSecondaryId()) continue;
                secondaryMap.put(((CheckBoxMenuItem)jMenuItem).getSecondaryId(), this.getID() + "-" + string + "-" + ((CheckBoxMenuItem)jMenuItem).getID());
                continue;
            }
            if (!(componentArray[i] instanceof Menu)) continue;
            jMenuItem = (Menu)componentArray[i];
            if (null != ((Menu)jMenuItem).getSecondaryId()) {
                secondaryMap.put(((Menu)jMenuItem).getSecondaryId(), this.getID() + "-" + string + "-" + ((Menu)jMenuItem).getID());
            }
            this.populateSecondary((Menu)componentArray[i], false, string);
        }
    }
}

