/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.commstyle.commini;

import com.swimap.iview.commstyle.commini.ClassNotAllowedException;
import com.swimap.iview.commstyle.commini.ClassUtils;
import com.swimap.iview.commstyle.commini.CommException;
import com.swimap.iview.commstyle.commini.DescContainer;
import com.swimap.iview.commstyle.commini.UIObjectDescriptionNotCorrectException;
import com.swimap.iview.commstyle.resource.ResourceMng;
import com.swimap.iview.commstyle.utils.ImageHandler;
import com.swimap.iview.util.log.IviewLogger;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.KeyStroke;

public class MenuItemFactory {
    private static IviewLogger logger = IviewLogger.getLogger(MenuItemFactory.class, "IVIEW");
    private static Class defaultMenuItemClass = JMenuItem.class;
    private static Class defaultRadioButtonMenuItemClass = JRadioButtonMenuItem.class;
    private static Class defaultCheckBoxMenuItemClass = JCheckBoxMenuItem.class;
    static ResourceBundle res;

    static void setResourceBundle(String string) {
        res = ResourceBundle.getBundle(string);
    }

    static ResourceBundle getResourceBundle() {
        return res;
    }

    public static Object getUIObject(DescContainer descContainer) throws UIObjectDescriptionNotCorrectException {
        try {
            String string;
            if (!"JMenuItem".equals(descContainer.getParasItemValue("type"))) {
                throw new CommException("descContainer is not JMenuItem type");
            }
            if (res == null) {
                logger.trace("the resourceBundle is not setfactory will use com.swimap.iview.commstyle.commini.Res");
                res = ResourceMng.getInstance().getResourceBundleFromPropertyFile("mainfrm/iview/commstyle/commini/Res");
            }
            String string2 = descContainer.getParasItemValue("class");
            String string3 = descContainer.getParasItemValue("name");
            String string4 = null;
            string4 = descContainer.getParasItemValue("itemType");
            if (string4 == null) {
                string4 = "";
            }
            String string5 = descContainer.getParasItemValue("command");
            JMenuItem jMenuItem = MenuItemFactory.createMenuItem(string2, string3, string4, string5);
            String string6 = descContainer.getParasItemValue("mnemonic");
            if (string6 != null && string6.trim().length() > 0) {
                jMenuItem.setMnemonic(string6.charAt(0));
            }
            if ((string = descContainer.getParasItemValue("description")) == null) {
                string = string3;
            }
            try {
                jMenuItem.setToolTipText(res.getString(string));
            }
            catch (Exception exception) {
                jMenuItem.setToolTipText(string);
            }
            String string7 = descContainer.getParasItemValue("icon");
            if (string7 != null) {
                jMenuItem.setIcon(ResourceMng.getInstance().getIconDirect(string7));
            }
            String string8 = null;
            try {
                string8 = descContainer.getParasItem("accelerator").getValue();
            }
            catch (Exception exception) {
                string8 = null;
            }
            if (string8 != null) {
                KeyStroke keyStroke = KeyStroke.getKeyStroke(string8);
                jMenuItem.setAccelerator(keyStroke);
            }
            return jMenuItem;
        }
        catch (Exception exception) {
            throw new UIObjectDescriptionNotCorrectException("MenuItemFactory:UI Object can not be create from the Description, check your Style file ");
        }
    }

    protected static JMenuItem createMenuItem(String string, String string2, String string3, String string4) throws ClassNotAllowedException {
        Class clazz = null;
        clazz = string == null ? ("checkbox".equals(string3) ? defaultCheckBoxMenuItemClass : ("radio".equals(string3) ? defaultRadioButtonMenuItemClass : defaultMenuItemClass)) : ClassUtils.findClass(string);
        JMenuItem jMenuItem = (JMenuItem)ClassUtils.createObject(clazz, JMenuItem.class);
        try {
            jMenuItem.setText(res.getString(string2));
        }
        catch (Exception exception) {
            jMenuItem.setText(string2);
        }
        if (string4 != null) {
            jMenuItem.setActionCommand(string4);
        }
        return jMenuItem;
    }

    protected static Icon createIcon(String string) throws CommException {
        try {
            URL uRL = null;
            uRL = new URL(ResourceMng.getInstance().getBaseURL(), string);
            return ImageHandler.getIcon(uRL);
        }
        catch (MalformedURLException malformedURLException) {
            throw new CommException("Could not load image: " + string);
        }
    }
}

