/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.commstyle.commini;

import com.swimap.iview.commstyle.resource.ResourceMng;
import com.swimap.iview.framework.applicationfavourites.FavouriteStateMgr;
import com.swimap.iview.framework.applicationmanagement.AppMenuItem;
import com.swimap.iview.framework.util.FrameworkCommandProcessor;
import com.swimap.iview.framework.windowmanagement.welcomepage.IMenuClickListener;
import java.awt.Component;
import java.awt.Graphics;
import java.io.Serializable;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.plaf.UIResource;

public class MenuItemArrowIconFactory {
    private static Icon menuItemArrowIcon = null;
    private static int menuIconGap = 4;
    private static ImageIcon imageIcon = null;
    private static ImageIcon nofavIcon = null;

    public static Icon getMenuItemArrowIcon() {
        if (null != menuItemArrowIcon) {
            return menuItemArrowIcon;
        }
        FrameworkCommandProcessor.LoadStyle loadStyle = FrameworkCommandProcessor.getInstance().getUserLoadStyle();
        if (loadStyle.equals((Object)FrameworkCommandProcessor.LoadStyle.application)) {
            imageIcon = (ImageIcon)ResourceMng.getInstance().getIconDirect("portal/favouritemenu.png");
            nofavIcon = (ImageIcon)ResourceMng.getInstance().getIconDirect("portal/noFavouritemenu.png");
        } else {
            imageIcon = (ImageIcon)ResourceMng.getInstance().getIcon("MenuArrow");
        }
        if (menuItemArrowIcon == null) {
            menuItemArrowIcon = new MenuItemArrowIcon();
        }
        return menuItemArrowIcon;
    }

    public static void clear() {
        menuItemArrowIcon = null;
        imageIcon = null;
    }

    public static int getTextIconGap() {
        return menuIconGap;
    }

    private static class MenuItemArrowIcon
    implements Icon,
    UIResource,
    Serializable {
        private static final long serialVersionUID = 6124090250271784634L;

        private MenuItemArrowIcon() {
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            ImageIcon imageIcon = imageIcon;
            if (component instanceof AppMenuItem) {
                AppMenuItem appMenuItem = (AppMenuItem)component;
                if (!appMenuItem.isEnabled()) {
                    imageIcon = nofavIcon;
                } else {
                    boolean bl;
                    IMenuClickListener iMenuClickListener = appMenuItem.getMenuClickListener();
                    if (iMenuClickListener instanceof FavouriteStateMgr && (bl = ((FavouriteStateMgr)iMenuClickListener).isAppMenuExist(appMenuItem.getAPPId(), appMenuItem.getID()))) {
                        imageIcon = nofavIcon;
                    }
                }
            }
            imageIcon.paintIcon(component, graphics, n + 6, n2);
        }

        @Override
        public int getIconWidth() {
            return imageIcon.getIconWidth() + 2;
        }

        @Override
        public int getIconHeight() {
            return imageIcon.getIconHeight() + 2;
        }

        static {
            if (null == imageIcon) {
                MenuItemArrowIconFactory.imageIcon = (ImageIcon)ResourceMng.getInstance().getIcon("MenuArrow");
            }
        }
    }
}

