/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.commstyle.commini;

import com.swimap.iview.commstyle.commandmng.CommandManager;
import com.swimap.iview.commstyle.commandmng.authority.ActionManager;
import com.swimap.iview.commstyle.commandmng.authority.AuthorityAction;
import com.swimap.iview.commstyle.commandmng.authority.AuthorityView;
import com.swimap.iview.commstyle.commini.CommStyleInfo;
import com.swimap.iview.commstyle.commini.DescContainer;
import com.swimap.iview.commstyle.commini.IComminiProperties;
import com.swimap.iview.commstyle.commini.IUIObjState;
import com.swimap.iview.commstyle.commini.MenuItemArrowIconFactory;
import com.swimap.iview.commstyle.commini.MenuItemUI;
import com.swimap.iview.commstyle.commini.UIObjectDescriptionNotCorrectException;
import com.swimap.iview.commstyle.commini.foldingmenus.FoldingMenuItem;
import com.swimap.iview.commstyle.commini.xmlbind.PARA;
import com.swimap.iview.commstyle.resource.ResourceMng;
import com.swimap.iview.framework.applicationmanagement.AppMenuItem;
import com.swimap.iview.framework.util.FrameworkCommandProcessor;
import com.swimap.iview.framework.windowmanagement.welcomepage.ConfigUtilities;
import com.swimap.iview.framework.windowmanagement.welcomepage.IMenuClickListener;
import com.swimap.iview.framework.windowmanagement.welcomepage.MenuAddLinkDialog;
import com.swimap.iview.framework.windowmanagement.welcomepage.WelcomeManager;
import com.swimap.iview.framework.windowmanagement.welcomepage.WelcomePage;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.PopupFactory;
import javax.swing.border.LineBorder;

public class MenuItem
extends FoldingMenuItem
implements IUIObjState,
IComminiProperties {
    private static IviewLogger logger = IviewLogger.getLogger(MenuItem.class, "IVIEW");
    protected DescContainer m_desc;
    private Boolean absoluteEnabled = null;
    private AuthorityAction menuItemAction = null;
    private AuthorityView authorityViewAction = null;
    private boolean commandDefined = false;
    private String command = null;
    private String secondaryID = null;
    protected Boolean hasArrowIconObj = null;
    private int serialNumber = Integer.MIN_VALUE;
    private IMenuClickListener ilistener = null;
    private transient MouseAdapter showPopupMenuMouseAdapter = new MouseAdapter(){

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            IMenuClickListener iMenuClickListener = MenuItem.this.getMenuClickListener();
            if (null == iMenuClickListener) {
                return;
            }
            if (MenuItem.this.isEnableShortcut() && MenuItem.this.isEnabled() && MenuItem.this.getWidth() - mouseEvent.getX() <= MenuItemArrowIconFactory.getMenuItemArrowIcon().getIconWidth()) {
                MenuItem menuItem;
                Object object = mouseEvent.getSource();
                if (object instanceof MenuItem && !(menuItem = (MenuItem)object).isArmed() && MenuItem.this.isShowArrowIcon()) {
                    MenuSelectionManager.defaultManager().setSelectedPath(this.buildMenuElementArray(menuItem));
                }
                if (iMenuClickListener instanceof WelcomePage) {
                    MenuItem.this.displayShortcutMenu(mouseEvent);
                } else {
                    MenuItem.this.performClick();
                }
            }
        }

        private MenuElement[] buildMenuElementArray(MenuItem menuItem) {
            Vector<JComponent> vector = new Vector<JComponent>();
            Component component = menuItem.getParent();
            vector.insertElementAt(menuItem, 0);
            while (true) {
                if (component instanceof JPopupMenu) {
                    JPopupMenu jPopupMenu = (JPopupMenu)component;
                    vector.insertElementAt(jPopupMenu, 0);
                    component = jPopupMenu.getInvoker();
                    continue;
                }
                if (component instanceof JMenu) {
                    JMenu jMenu = (JMenu)component;
                    vector.insertElementAt(jMenu, 0);
                    component = jMenu.getParent();
                    continue;
                }
                if (component instanceof JMenuBar) {
                    JMenuBar jMenuBar = (JMenuBar)component;
                    vector.insertElementAt(jMenuBar, 0);
                    Object[] objectArray = new MenuElement[vector.size()];
                    vector.copyInto(objectArray);
                    return objectArray;
                }
                if (!(component instanceof MenuElement)) break;
            }
            Object[] objectArray = new MenuElement[vector.size()];
            vector.copyInto(objectArray);
            return objectArray;
        }
    };
    private transient MouseAdapter showAddFromMenuAdapter = new MouseAdapter(){

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            MenuItem.this.performClick();
        }
    };

    public MenuItem() {
        this.m_desc = new DescContainer();
    }

    @Override
    public String getState(String string) {
        return this.m_desc.getParasItemValue(string);
    }

    public void setAbsoluteEnabled(Boolean bl) {
        this.absoluteEnabled = bl;
    }

    @Override
    public void setEnabled(boolean bl) {
        if (this.absoluteEnabled == null) {
            super.setEnabled(bl);
        } else {
            super.setEnabled(this.absoluteEnabled);
        }
    }

    @Override
    public boolean setState(String string, String string2) {
        this.m_desc.setParasItem(string, string2, true);
        return true;
    }

    @Override
    public String getID() {
        return this.m_desc.getDescName();
    }

    public MenuItem(DescContainer descContainer) throws UIObjectDescriptionNotCorrectException {
        try {
            Object object;
            if (!"JMenuItem".equals(descContainer.getParasItemValue("type"))) {
                logger.trace("descContainer is not JMenuItem type");
            }
            this.m_desc = descContainer;
            CommStyleInfo commStyleInfo = (CommStyleInfo)descContainer._getRootParent();
            String string = descContainer.getParasItemValue("name");
            if (string == null || 0 == string.length()) {
                logger.trace("Message of the Popup Menu  description not correct will printed, and null will be returned");
            }
            String string2 = commStyleInfo.getResString(string);
            this.setName(string);
            if (string2 != null) {
                this.setText(string2);
            } else {
                this.setText(string);
            }
            this.command = descContainer.getParasItemValue("command");
            Object var5_6 = null;
            if (this.command != null) {
                this.commandDefined = true;
                this.setActionCommand(this.command);
            }
            this.secondaryID = descContainer.getParasItemValue("secondaryid");
            this.initAction();
            String string3 = descContainer.getParasItemValue("mnemonic");
            if (string3 != null && string3.trim().length() > 0) {
                this.setMnemonic(string3.charAt(0));
            }
            String string4 = null;
            string4 = descContainer.getParasItemValue("description");
            if (string4 != null) {
                string2 = commStyleInfo.getResString(string4);
                if (string2 != null) {
                    this.setToolTipText(string2);
                } else {
                    this.setToolTipText(string4);
                }
            }
            String string5 = null;
            try {
                string5 = descContainer.getParasItemValue("icon");
            }
            catch (Exception exception) {
                string5 = null;
            }
            if (string5 != null) {
                if (null != commStyleInfo.getPluginName()) {
                    this.setIcon(commStyleInfo.getResource().getIcon(string5));
                } else {
                    this.setIcon(ResourceMng.getInstance().getIconDirect(string5));
                }
            }
            String string6 = null;
            try {
                string6 = descContainer.getParasItem("accelerator").getValue();
            }
            catch (Exception exception) {
                string6 = null;
            }
            if (string6 != null) {
                object = KeyStroke.getKeyStroke(string6);
                this.setAccelerator((KeyStroke)object);
            }
            if (null != (object = FrameworkCommandProcessor.getInstance().getUserLoadStyle()) && ((Enum)object).equals((Object)FrameworkCommandProcessor.LoadStyle.application) && null != string2) {
                this.setPreferredSize(new Dimension(this.getPreferredSize().width + 28, this.getPreferredSize().height));
            }
            this.addMouseListener(this.showPopupMenuMouseAdapter);
            this.setUIStyle();
            logger.debug("MENUCONFIG:ID:" + string2 + "Type-MenuItem :Path-" + commStyleInfo.getFileName() + ":Plugin:" + commStyleInfo.getPluginName());
        }
        catch (Exception exception) {
            logger.trace(exception.getMessage(), exception);
            throw new UIObjectDescriptionNotCorrectException("MenuItem can not be create from the Description, check your Style file ");
        }
    }

    protected void initAction() {
        String string = null;
        if (this.m_desc.getParasItem("action") != null) {
            string = this.m_desc.getParasItem("action").getValue();
        }
        if (string != null) {
            Class<?> clazz = null;
            try {
                clazz = Class.forName(string);
                this.menuItemAction = (AuthorityAction)clazz.newInstance();
                this.menuItemAction.setSource(this);
            }
            catch (ClassNotFoundException classNotFoundException) {
                logger.trace(classNotFoundException);
            }
            catch (InstantiationException instantiationException) {
                logger.trace(instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                logger.trace(illegalAccessException);
            }
            if (!this.commandDefined) {
                this.setAction(this.menuItemAction);
            }
        }
    }

    public void setUIStyle() {
        this.setUI(new MenuItemUI());
    }

    private void performClick() {
        IMenuClickListener iMenuClickListener = this.getMenuClickListener();
        if (null != iMenuClickListener) {
            iMenuClickListener.preClick();
            MenuItem.hideShortcutPopupMenu();
            iMenuClickListener.click(this);
            iMenuClickListener.postClick();
        }
    }

    private JMenuItem getAddShortcutMenuItem() {
        JMenuItem jMenuItem = new JMenuItem(MenuAddLinkDialog.getTitleName());
        jMenuItem.setUI(new MenuItemUI());
        jMenuItem.setName("Add_To_Workbench");
        jMenuItem.setSize(this.getSize().width, this.getSize().height);
        jMenuItem.setBorder(new LineBorder(Color.gray));
        if ((this.commandDefined || null != this.menuItemAction) && this.isEnabled()) {
            jMenuItem.addMouseListener(this.showAddFromMenuAdapter);
            jMenuItem.setEnabled(true);
        } else {
            jMenuItem.setEnabled(false);
        }
        return jMenuItem;
    }

    protected boolean isEnableShortcut() {
        return ConfigUtilities.isEnableMenuCopy();
    }

    @Override
    public void setMnemonic(char c) {
        String string = this.getText();
        super.setMnemonic(c);
        String string2 = ".*\\(" + c + "\\)(...)?";
        if (string != null && (string.toLowerCase().matches(string2) || string.toUpperCase().matches(string2))) {
            if (string.endsWith("...")) {
                this.setDisplayedMnemonicIndex(string.length() - 5);
            } else {
                this.setDisplayedMnemonicIndex(string.length() - 2);
            }
        }
    }

    public static Object getUIObject(DescContainer descContainer) {
        MenuItem menuItem = null;
        try {
            menuItem = FrameworkCommandProcessor.getInstance().getUserLoadStyle() == FrameworkCommandProcessor.LoadStyle.traditional ? new MenuItem(descContainer) : new AppMenuItem(descContainer);
        }
        catch (Exception exception) {
            logger.error(exception.getMessage());
        }
        return menuItem;
    }

    public static Object getPortalPopupUIObject(DescContainer descContainer) {
        AppMenuItem appMenuItem = null;
        try {
            String string;
            if (FrameworkCommandProcessor.getInstance().getUserLoadStyle() == FrameworkCommandProcessor.LoadStyle.application && "true".equalsIgnoreCase(string = descContainer.getParasItemValue("showInPortalPanel"))) {
                appMenuItem = new AppMenuItem(descContainer);
            }
        }
        catch (Exception exception) {
            logger.error(exception.getMessage());
        }
        return appMenuItem;
    }

    public String getParaValue(String string) {
        return this.m_desc.getParasItemValue(string);
    }

    protected PARA getPara(String string) {
        return this.m_desc.getParasItem(string);
    }

    @Override
    public int getSerialNumber() {
        if (this.serialNumber != Integer.MIN_VALUE) {
            return this.serialNumber;
        }
        this.serialNumber = -1;
        String string = this.m_desc.getParasItemValue("serialnumber");
        if (string == null || string.trim().length() == 0) {
            return this.serialNumber;
        }
        int n = string.lastIndexOf("-");
        if (n != -1) {
            string = string.substring(n + 1);
        }
        try {
            this.serialNumber = Integer.parseInt(string);
        }
        catch (Exception exception) {
            logger.error("sSerialNumber=" + string);
            logger.trace(exception.getMessage(), exception);
        }
        return this.serialNumber;
    }

    public char getMnemonicMenuItem() {
        String string = "";
        string = this.m_desc.getParasItemValue("mnemonic");
        if (string != null && string.trim().length() > 0) {
            return string.charAt(0);
        }
        return '\u0000';
    }

    @Override
    public void setAction(Action action) {
        if (null == action) {
            return;
        }
        Icon icon = this.getIcon();
        String string = this.getText();
        String string2 = this.getToolTipText();
        int n = this.getMnemonic();
        KeyStroke keyStroke = this.getAccelerator();
        super.setAction(action);
        this.setText(string);
        this.setMnemonic(n);
        if (null != keyStroke) {
            this.setAccelerator(keyStroke);
        }
        if (null != string2) {
            this.setToolTipText(string2);
        }
        if (null != icon) {
            this.setIcon(icon);
        }
        if (this.commandDefined && this.menuItemAction == null) {
            ActionManager.configActionToButton(this, (AuthorityAction)action);
        }
    }

    public void updateMenuItem() {
        try {
            if (this.menuItemAction != null) {
                this.setEnabled(this.menuItemAction.isActionEnabled());
                if (Thread.currentThread().isInterrupted()) {
                    return;
                }
                this.setVisible(this.menuItemAction.isActionVisible());
            } else if (this.commandDefined) {
                CommandManager commandManager = CommandManager.getInstance();
                this.authorityViewAction = commandManager.getAuthorityViewAction(this.command);
                if (null != this.authorityViewAction) {
                    boolean bl = commandManager.securityInfoCheck(this.command);
                    this.setEnabled(this.authorityViewAction.isEnabled(this.command) && bl);
                    if (Thread.currentThread().isInterrupted()) {
                        return;
                    }
                    this.setVisible(this.authorityViewAction.isVisible(this.command));
                }
            } else {
                logger.trace("no authority action or command  is defined for menu itme");
            }
        }
        catch (Throwable throwable) {
            logger.trace("Iview Handled Error while updating menu item " + this.getName(), throwable);
        }
    }

    public AbstractAction getMenuItemAction() {
        return this.menuItemAction;
    }

    public AuthorityView getMenuItemView() {
        return this.authorityViewAction;
    }

    public String getCommand() {
        return this.command;
    }

    public boolean isCommandDefined() {
        return this.commandDefined;
    }

    public String getSecondaryId() {
        return this.secondaryID;
    }

    public boolean isConsumeEvent(MouseEvent mouseEvent) {
        if (this.isShowArrowIcon() && this.getWidth() - mouseEvent.getX() <= MenuItemArrowIconFactory.getMenuItemArrowIcon().getIconWidth()) {
            return this.isShowArrowIcon();
        }
        return false;
    }

    private void displayShortcutMenu(MouseEvent mouseEvent) {
        if (this.isShowArrowIcon()) {
            MenuItem.hideShortcutPopupMenu();
            JMenuItem jMenuItem = this.getAddShortcutMenuItem();
            shortcutPopup = PopupFactory.getSharedInstance().getPopup(this, jMenuItem, mouseEvent.getXOnScreen(), mouseEvent.getYOnScreen());
            MenuItem.setShortcutPopupSource(jMenuItem, mouseEvent.getSource());
            shortcutPopup.show();
        }
    }

    protected boolean isShowIcon() {
        if (null == this.getMenuClickListener() || !this.isArmed()) {
            return false;
        }
        if (ConfigUtilities.isEnableMenuCopy() && this.isEnabled()) {
            if (null == this.hasArrowIconObj) {
                this.hasArrowIconObj = this.getMenuClickListener().isSupportClick(this);
            }
            return this.hasArrowIconObj;
        }
        return false;
    }

    protected boolean isShowArrowIcon() {
        if (null == this.hasArrowIconObj) {
            return false;
        }
        return this.hasArrowIconObj;
    }

    protected IMenuClickListener getMenuClickListener() {
        if (FrameworkCommandProcessor.getInstance().isAppStyle()) {
            return this.ilistener;
        }
        return WelcomeManager.getWelcomeRef();
    }

    protected void setMenuClickListener(IMenuClickListener iMenuClickListener) {
        this.ilistener = iMenuClickListener;
    }
}

