/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.commstyle.commini;

import com.swimap.iview.commstyle.commini.ClassNotAllowedException;
import com.swimap.iview.commstyle.commini.ClassUtils;
import com.swimap.iview.commstyle.commini.CommException;
import com.swimap.iview.commstyle.commini.DescContainer;
import com.swimap.iview.commstyle.commini.IllegalDefaultClassException;
import com.swimap.iview.commstyle.commini.MenuItemFactory;
import com.swimap.iview.commstyle.commini.UIObjectDescriptionNotCorrectException;
import com.swimap.iview.commstyle.resource.ResourceMng;
import com.swimap.iview.util.log.IviewLogger;
import java.util.ResourceBundle;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

public class MenuFactory {
    private static IviewLogger logger = IviewLogger.getLogger(MenuFactory.class, "IVIEW");
    private static Class defaultMenuClass = JMenu.class;
    static ResourceBundle res;

    static void setResourceBundle(String string) {
        res = ResourceBundle.getBundle(string);
    }

    static ResourceBundle getResourceBundle() {
        return res;
    }

    protected MenuFactory() {
    }

    public static Object getUIObject(DescContainer descContainer) throws UIObjectDescriptionNotCorrectException {
        try {
            if (!"JMenu".equals(descContainer.getParasItem("type").getValue())) {
                throw new CommException("descContainer is not JMenu type");
            }
            if (res == null) {
                logger.trace("the resourceBundle is not set factory will use com.swimap.iview.commstyle.commini.Res .");
                res = ResourceMng.getInstance().getResourceBundleFromPropertyFile("mainfrm/iview/commstyle/commini/Res");
            }
            String string = descContainer.getParasItemValue("class");
            JMenu jMenu = MenuFactory.createMenu(string);
            String string2 = descContainer.getParasItemValue("name");
            try {
                jMenu.setText(res.getString(string2));
            }
            catch (Exception exception) {
                jMenu.setText(string2);
            }
            String string3 = descContainer.getParasItemValue("mnemonic");
            if (string3 != null && string3.trim().length() > 0) {
                jMenu.setMnemonic(string3.charAt(0));
            }
            DescContainer descContainer2 = null;
            String string4 = null;
            int n = descContainer.getSubDescCount();
            for (int i = 0; i < n; ++i) {
                descContainer2 = descContainer.getDescContainer(i);
                string4 = descContainer2.getParasItem("type").getValue();
                if ("JMenuItem".equals(string4)) {
                    jMenu.add((JMenuItem)MenuItemFactory.getUIObject(descContainer2));
                    continue;
                }
                if ("JMenu".equals(string4)) {
                    jMenu.add((JMenu)MenuFactory.getUIObject(descContainer2));
                    continue;
                }
                jMenu.addSeparator();
            }
            return jMenu;
        }
        catch (Exception exception) {
            throw new UIObjectDescriptionNotCorrectException("MenuFactory:UI Object can not be create from the Description, check your Style file ");
        }
    }

    protected static JMenu createMenu(String string) throws ClassNotAllowedException {
        Class clazz = null;
        clazz = string == null ? defaultMenuClass : ClassUtils.findClass(string);
        return (JMenu)ClassUtils.createObject(clazz, JMenu.class);
    }

    public void setDefaultMenuClass(Class clazz) throws IllegalDefaultClassException {
        defaultMenuClass = this.setDefaultClass(JMenu.class, clazz);
    }

    private Class setDefaultClass(Class clazz, Class clazz2) throws IllegalDefaultClassException {
        if (clazz.isAssignableFrom(clazz2)) {
            return clazz2;
        }
        throw new IllegalDefaultClassException("Cannot assign into " + clazz + " from " + clazz2);
    }
}

