/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.commstyle.commini;

import com.swimap.iview.commstyle.commini.CommStyleManager;
import com.swimap.iview.commstyle.commini.DescContainer;
import com.swimap.iview.commstyle.commini.IComminiProperties;
import com.swimap.iview.commstyle.commini.Menu;
import com.swimap.iview.commstyle.commini.MenuSet;
import com.swimap.iview.commstyle.commini.UIObjectDescriptionNotCorrectException;
import com.swimap.iview.commstyle.commini.foldingmenus.FoldingMenuUtilities;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.Component;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;

public class MenuBar
extends JMenuBar {
    private static IviewLogger logger = IviewLogger.getLogger(MenuBar.class, "IVIEW");

    public MenuBar(MenuSet menuSet) {
        this.setName("MenuBar");
        Vector vector = menuSet.getMenuOrder();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            this.add((JMenu)enumeration.nextElement());
        }
    }

    public void removeMenu(String string) {
        Menu menu = this.getMenu(string);
        if (menu != null) {
            this.remove(menu);
            this.updateUI();
        }
    }

    public MenuBar(DescContainer descContainer) throws UIObjectDescriptionNotCorrectException {
        try {
            if (!"JMenuBar".equals(descContainer.getParasItemValue("type"))) {
                logger.trace("descContainer is not JMenuBar type");
            }
            this.setName("MenuBar");
            int n = descContainer.getSubDescCount();
            for (int i = 0; i < n; ++i) {
                if (!"JMenu".equals(descContainer.getDescContainer(i).getParasItemValue("type"))) continue;
                this.add((JMenu)Menu.getUIObject(descContainer.getDescContainer(i)));
            }
        }
        catch (Exception exception) {
            throw new UIObjectDescriptionNotCorrectException("MenuBar:UI Object can not be create from the Description, check your Style file ");
        }
    }

    public static Object getUIObject(DescContainer descContainer) {
        MenuBar menuBar = null;
        try {
            menuBar = new MenuBar(descContainer);
        }
        catch (Exception exception) {
            logger.error(exception.getMessage());
        }
        return menuBar;
    }

    public static Object getUIObject(String string, String string2) {
        MenuBar menuBar = null;
        try {
            DescContainer descContainer = CommStyleManager.getInstance().getCommonStyleFile(string).getAreaDescContainer(0).getDescContainer(string2);
            menuBar = new MenuBar(descContainer);
        }
        catch (Exception exception) {
            logger.error(exception.getMessage());
        }
        return menuBar;
    }

    public Menu getMenu(String string) {
        int n = this.getMenuCount();
        Component component = null;
        for (int i = 0; i < n; ++i) {
            String string2;
            component = this.getComponent(i);
            String string3 = string2 = component instanceof IComminiProperties ? ((IComminiProperties)((Object)component)).getID() : null;
            if (string2 == null || !string2.equals(string)) continue;
            return (Menu)this.getComponent(i);
        }
        return null;
    }

    @Override
    public void menuSelectionChanged(boolean bl) {
        MenuElement[] menuElementArray = MenuSelectionManager.defaultManager().getSelectedPath();
        boolean bl2 = menuElementArray != null && menuElementArray.length > 0;
        FoldingMenuUtilities.setMainMenuSelected(bl2);
        if (!bl2) {
            FoldingMenuUtilities.setExpanded(false);
        }
    }
}

