/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.commstyle.commini;

import com.swimap.iview.commstyle.commandmng.CommandManager;
import com.swimap.iview.commstyle.commandmng.authority.AuthorityAction;
import com.swimap.iview.commstyle.commini.CheckBoxMenuItem;
import com.swimap.iview.commstyle.commini.ClassUtils;
import com.swimap.iview.commstyle.commini.CommStyleInfo;
import com.swimap.iview.commstyle.commini.DescContainer;
import com.swimap.iview.commstyle.commini.IComminiProperties;
import com.swimap.iview.commstyle.commini.MenuBar;
import com.swimap.iview.commstyle.commini.MenuItem;
import com.swimap.iview.commstyle.commini.MenuUI;
import com.swimap.iview.commstyle.commini.PopUPAppMenu;
import com.swimap.iview.commstyle.commini.RadioButtonMenuItem;
import com.swimap.iview.commstyle.commini.Separator;
import com.swimap.iview.commstyle.commini.UIObjectDescriptionNotCorrectException;
import com.swimap.iview.commstyle.commini.foldingmenus.FoldingMenu;
import com.swimap.iview.commstyle.commini.xmlbind.PARA;
import com.swimap.iview.commstyle.resource.ResourceMng;
import com.swimap.iview.commstyle.resource.i18n.ResourceUtil;
import com.swimap.iview.framework.applicationmanagement.AppMenu;
import com.swimap.iview.framework.mainframe.MDIFrame;
import com.swimap.iview.framework.util.FrameworkCommandProcessor;
import com.swimap.iview.framework.util.FrameworkUtilities;
import com.swimap.iview.util.ScreenToolKit;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ContainerListener;
import java.awt.event.KeyEvent;
import java.util.Hashtable;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class Menu
extends FoldingMenu
implements IComminiProperties {
    private static IviewLogger logger = IviewLogger.getLogger(Menu.class, "IVIEW");
    private DescContainer m_desc;
    private Hashtable buttonGroupHash = new Hashtable();
    private static final String PARA_TYPE = "type";
    private static final String PARA_NAME = "name";
    private static final String PARA_MNEMONIC = "mnemonic";
    private static final String PARA_DESCRIPTION = "description";
    private static final String PARA_ICON = "icon";
    private static final String PARA_ITEMTYPE = "itemType";
    private static final String PARA_TOBELOADED = "tobeloaded";
    private static final String PARA_SECONDARYID = "secondaryid";
    private boolean menuVisible = false;
    private boolean allMenuItemsVisible = false;
    private boolean menuEnable = false;
    private boolean allMenuItemsEnable = false;
    private AuthorityAction menuAction = null;
    private String secondaryID = null;
    private int serialNumber = Integer.MIN_VALUE;

    public Menu() {
        this.m_desc = new DescContainer();
    }

    public Menu(DescContainer descContainer) throws UIObjectDescriptionNotCorrectException {
        try {
            String string;
            String string2;
            Object object;
            if (!"JMenu".equals(descContainer.getParasItem(PARA_TYPE).getValue())) {
                logger.debug("descContainer is not JMenu type");
                throw new UIObjectDescriptionNotCorrectException("descContainer is not JMenu type");
            }
            this.m_desc = descContainer;
            CommStyleInfo commStyleInfo = (CommStyleInfo)descContainer._getRootParent();
            String string3 = descContainer.getParasItem(PARA_NAME).getValue();
            this.setName(string3);
            String string4 = commStyleInfo.getResString(string3);
            if (string4 != null) {
                this.setText(string4);
            } else {
                this.setText(string3);
            }
            this.secondaryID = descContainer.getParasItemValue(PARA_SECONDARYID);
            String string5 = null;
            if (descContainer.getParasItem("action") != null) {
                string5 = descContainer.getParasItem("action").getValue();
            }
            if (string5 != null) {
                object = null;
                try {
                    object = Class.forName(string5);
                    this.menuAction = (AuthorityAction)((Class)object).newInstance();
                    this.menuAction.setSource(this);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    logger.trace(classNotFoundException);
                }
                catch (InstantiationException instantiationException) {
                    logger.trace(instantiationException);
                }
                catch (IllegalAccessException illegalAccessException) {
                    logger.trace(illegalAccessException);
                }
                this.setAction(this.menuAction);
            }
            this.setUI(new MenuUI());
            object = "";
            object = descContainer.getParasItemValue(PARA_MNEMONIC);
            if (object != null && ((String)object).trim().length() > 0) {
                this.setMnemonic(((String)object).charAt(0));
            }
            if ((string2 = descContainer.getParasItemValue(PARA_DESCRIPTION)) != null) {
                string4 = commStyleInfo.getResString(string3);
                if (string4 != null) {
                    this.setToolTipText(string4);
                } else {
                    this.setToolTipText(string2);
                }
            }
            if ((string = descContainer.getParasItemValue(PARA_ICON)) != null) {
                this.setIcon(ResourceMng.getInstance().getIconDirect(string));
            }
            int n = descContainer.getSubDescCount();
            Object var10_14 = null;
            DescContainer descContainer2 = null;
            for (int i = 0; i < n; ++i) {
                descContainer2 = descContainer.getDescContainer(i);
                String string6 = descContainer2.getParasItemValue(PARA_TOBELOADED);
                if (null != string6 && "false".equalsIgnoreCase(string6.trim())) {
                    logger.debug("Has a menuItem is not loaded " + descContainer2.getParasItemValue(PARA_NAME));
                    continue;
                }
                String string7 = descContainer2.getParasItemValue(PARA_TYPE);
                this.createComponent(string7, descContainer2);
            }
            logger.trace("MENUCONFIG:ID:" + string4 + "Type-Menu :Path-" + commStyleInfo.getFileName() + ":Plugin:" + commStyleInfo.getPluginName());
        }
        catch (Exception exception) {
            throw new UIObjectDescriptionNotCorrectException("Menu:UI Object can not be create from the Description, check your Style file ");
        }
    }

    protected void createComponent(String string, DescContainer descContainer) {
        CommandManager commandManager = CommandManager.getInstance();
        JComponent jComponent = null;
        if ("JMenuItem".equals(string)) {
            String string2 = descContainer.getParasItemValue("command");
            boolean bl = commandManager.isCommandLicensed(string2);
            if (!bl) {
                return;
            }
            jComponent = this.createMenuItem(descContainer);
        } else {
            jComponent = "JMenu".equals(string) ? (JMenu)Menu.getUIObject(descContainer) : (JSeparator)Separator.getUIObject(descContainer);
        }
        this.insertComponent(jComponent);
    }

    @Override
    public void setMnemonic(char c) {
        String string = this.getText();
        super.setMnemonic(c);
        String string2 = ".*\\(" + c + "\\)";
        if (string != null && (string.toLowerCase().matches(string2) || string.toUpperCase().matches(string2))) {
            this.setDisplayedMnemonicIndex(string.length() - 2);
        }
    }

    protected JMenuItem createMenuItem(DescContainer descContainer) {
        Object object = null;
        String string = descContainer.getParasItemValue(PARA_ITEMTYPE);
        if (string == null) {
            string = "";
        }
        if ("JMenuItem".equals(string)) {
            object = this.isPortalPopupMenu() ? MenuItem.getPortalPopupUIObject(descContainer) : MenuItem.getUIObject(descContainer);
        } else if ("CheckBox".equals(string)) {
            object = this.isPortalPopupMenu() ? CheckBoxMenuItem.getPortalPopupUIObject(descContainer) : CheckBoxMenuItem.getUIObject(descContainer);
        } else if ("RadioButton".equals(string)) {
            RadioButtonMenuItem radioButtonMenuItem = null;
            radioButtonMenuItem = this.isPortalPopupMenu() ? (RadioButtonMenuItem)RadioButtonMenuItem.getPortalPopupUIObject(descContainer) : (RadioButtonMenuItem)RadioButtonMenuItem.getUIObject(descContainer);
            ButtonGroup buttonGroup = (ButtonGroup)this.buttonGroupHash.get(radioButtonMenuItem.getButtonGroup());
            if (buttonGroup == null) {
                buttonGroup = new ButtonGroup();
                this.buttonGroupHash.put(radioButtonMenuItem.getButtonGroup(), buttonGroup);
            }
            buttonGroup.add(radioButtonMenuItem);
            object = radioButtonMenuItem;
        } else {
            object = this.isPortalPopupMenu() ? MenuItem.getPortalPopupUIObject(descContainer) : MenuItem.getUIObject(descContainer);
        }
        return (JMenuItem)object;
    }

    @Override
    public String getID() {
        return this.m_desc.getDescName();
    }

    @Override
    public int getSerialNumber() {
        if (this.serialNumber != Integer.MIN_VALUE) {
            return this.serialNumber;
        }
        this.serialNumber = -1;
        String string = this.m_desc.getParasItemValue("serialnumber");
        if (string == null || string.trim().length() == 0) {
            return this.serialNumber;
        }
        int n = string.lastIndexOf("-");
        if (n != -1) {
            string = string.substring(n + 1);
        }
        try {
            this.serialNumber = Integer.parseInt(string);
        }
        catch (Exception exception) {
            logger.error("sSerialNumber=" + string);
            logger.trace(exception.getMessage(), exception);
        }
        return this.serialNumber;
    }

    public char getMnemonicMenu() {
        String string = "";
        string = this.m_desc.getParasItemValue(PARA_MNEMONIC);
        if (string != null && string.trim().length() > 0) {
            return string.charAt(0);
        }
        return '\u0000';
    }

    public Component getMenuItem(String string) {
        return this.getMenuItem(string, false);
    }

    public Component getMenuItem(String string, boolean bl) {
        Component[] componentArray = this.getMenuComponents();
        if (componentArray != null) {
            Component component = null;
            for (int i = 0; i < componentArray.length; ++i) {
                Component component2;
                String string2;
                component = componentArray[i];
                String string3 = string2 = component instanceof IComminiProperties ? ((IComminiProperties)((Object)component)).getID() : null;
                if (string2 != null && string2.equals(string)) {
                    return componentArray[i];
                }
                if (!(componentArray[i] instanceof Menu) || !bl || null == (component2 = ((Menu)componentArray[i]).getMenuItem(string, true))) continue;
                return component2;
            }
        }
        return null;
    }

    public Menu getMenuOf(JMenuItem jMenuItem) {
        Component[] componentArray = this.getMenuComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            Menu menu;
            if (componentArray[i] == jMenuItem) {
                return this;
            }
            if (!(componentArray[i] instanceof Menu) || null == (menu = ((Menu)componentArray[i]).getMenuOf(jMenuItem))) continue;
            return menu;
        }
        return null;
    }

    public Component getSeparator(String string) {
        for (int i = 0; i < this.getMenuComponentCount(); ++i) {
            String string2 = (String)ClassUtils.callTheMethod(this.getMenuComponent(i), "getSeparatorId");
            if (string2 == null || !string2.equals(string)) continue;
            return this.getMenuComponent(i);
        }
        return null;
    }

    public static Object getUIObject(DescContainer descContainer) {
        Menu menu = null;
        try {
            menu = FrameworkCommandProcessor.getInstance().getUserLoadStyle() == FrameworkCommandProcessor.LoadStyle.traditional ? new Menu(descContainer) : new AppMenu(descContainer);
        }
        catch (Exception exception) {
            logger.trace(exception.getMessage(), exception);
        }
        return menu;
    }

    public static Object getPortalPopupUIObject(DescContainer descContainer) {
        PopUPAppMenu popUPAppMenu = null;
        try {
            if (FrameworkCommandProcessor.getInstance().getUserLoadStyle() == FrameworkCommandProcessor.LoadStyle.application) {
                ContainerListener[] containerListenerArray;
                popUPAppMenu = new PopUPAppMenu(descContainer);
                for (ContainerListener containerListener : containerListenerArray = popUPAppMenu.getPopupMenu().getContainerListeners()) {
                    popUPAppMenu.getPopupMenu().removeContainerListener(containerListener);
                }
            }
        }
        catch (Exception exception) {
            logger.error(exception.getMessage());
        }
        return popUPAppMenu;
    }

    public void addMenuItem(Component component) {
        this.add(component);
    }

    public void addMenuItem(Component component, int n) {
        this.add(component, n);
    }

    public void removeMenuItem(int n) {
        this.remove(n);
    }

    public void removeMenuItem(String string) {
        Component component = this.getMenuItem(string);
        if (component != null) {
            this.remove(component);
        }
    }

    @Override
    public void remove(JMenuItem jMenuItem) {
        super.remove(jMenuItem);
    }

    @Override
    public void remove(Component component) {
        super.remove(component);
    }

    @Override
    public void remove(int n) {
        super.remove(n);
    }

    public JMenuItem addMenuItem(String string) {
        int n;
        int n2 = -1;
        int n3 = this.m_desc.getDescContainerCount();
        for (n = 0; n < n3; ++n) {
            if (!ResourceUtil.areStringEquals(string, this.m_desc.getDescContainer(n).getDescName())) continue;
            n2 = n;
            break;
        }
        if (n2 == -1) {
            return null;
        }
        if (this.getMenuItem(string) != null) {
            return (JMenuItem)this.getMenuItem(string);
        }
        n = -1;
        JMenuItem jMenuItem = this.createMenuItem(this.m_desc.getDescContainer(n2));
        for (int i = n2 - 1; i >= 0; --i) {
            String string2 = this.m_desc.getDescContainer(i).getDescName();
            Component component = this.getMenuItem(string2);
            if (component == null) continue;
            int n4 = -1;
            int n5 = this.getItemCount();
            for (int j = 0; j < n5; ++j) {
                if (component != this.getItem(j)) continue;
                n4 = j;
                break;
            }
            n = n4 + 1;
            break;
        }
        if (n != -1) {
            this.add((Component)jMenuItem, n);
        } else {
            this.add((Component)jMenuItem, 0);
        }
        return jMenuItem;
    }

    public String getParaValue(String string) {
        return this.m_desc.getParasItemValue(string);
    }

    protected PARA getPara(String string) {
        return this.m_desc.getParasItem(string);
    }

    public int getComponentPos(String string) {
        int n = this.getMenuComponentCount();
        Component component = null;
        for (int i = 0; i < n; ++i) {
            String string2;
            component = this.getMenuComponent(i);
            String string3 = string2 = component instanceof IComminiProperties ? ((IComminiProperties)((Object)component)).getID() : null;
            if (string2 == null || !string2.equals(string)) continue;
            return i;
        }
        return -1;
    }

    public synchronized void insertComponent(Component component) {
        int n = -1;
        if (component instanceof IComminiProperties) {
            n = ((IComminiProperties)((Object)component)).getSerialNumber();
        }
        int n2 = this.getMenuComponentCount();
        if (n != -1) {
            n2 = this.getComponentPos(n);
        }
        if (component instanceof Separator) {
            if (n2 >= this.getMenuComponentCount()) {
                this.add(component);
            } else {
                this.insertSeparator((Separator)component, n2);
            }
        } else if (component instanceof JMenuItem) {
            if (n2 >= this.getMenuComponentCount()) {
                this.add((JMenuItem)component);
            } else {
                this.insert((JMenuItem)component, n2);
            }
        }
    }

    public int getComponentPos(int n) {
        int n2 = this.getMenuComponentCount();
        Component component = null;
        int n3 = 0;
        for (n3 = 0; n3 < n2; ++n3) {
            int n4 = -1;
            component = this.getMenuComponent(n3);
            if (component instanceof IComminiProperties) {
                n4 = ((IComminiProperties)((Object)component)).getSerialNumber();
            }
            if (n4 == -1 || n4 <= n) continue;
            return n3;
        }
        return n3;
    }

    public void insertSeparator(Separator separator, int n) {
        if (n < 0) {
            throw new IllegalArgumentException("index less than zero.");
        }
        this.insert(separator, n);
    }

    @Override
    public Point getPopupMenuOrigin() {
        return super.getPopupMenuOrigin();
    }

    @Override
    public void setText(String string) {
        super.setText(string);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (null != FrameworkUtilities.getMainFrame()) {
                    ((MDIFrame)FrameworkUtilities.getMainFrame()).updateMenuBarHeight();
                }
            }
        });
    }

    @Override
    public void setAction(Action action) {
        String string = this.getText();
        super.setAction(action);
        this.setText(string);
    }

    public void updateMenu() {
        Component[] componentArray;
        if (null != this.menuAction) {
            try {
                this.menuVisible = this.menuAction.isActionVisible();
                this.menuEnable = this.menuAction.isActionEnabled();
            }
            catch (Throwable throwable) {
                logger.trace(throwable.getMessage(), throwable);
            }
            this.setEnabled(this.menuEnable);
            this.setVisible(this.menuVisible);
            if (!this.menuVisible || !this.menuEnable) {
                return;
            }
        }
        if (null == (componentArray = this.getMenuComponents()) || componentArray.length <= 0) {
            return;
        }
        this.allMenuItemsEnable = false;
        this.allMenuItemsVisible = false;
        boolean bl = true;
        boolean bl2 = true;
        boolean bl3 = true;
        for (int i = 0; i < componentArray.length; ++i) {
            JMenuItem jMenuItem;
            if (Thread.currentThread().isInterrupted()) {
                logger.debug("EDT Thread is interrupted");
                break;
            }
            if (componentArray[i] instanceof MenuItem) {
                jMenuItem = (MenuItem)componentArray[i];
                ((MenuItem)jMenuItem).updateMenuItem();
                boolean bl4 = bl = null != ((MenuItem)jMenuItem).getMenuItemAction();
                if (!bl) {
                    bl2 = null != ((MenuItem)jMenuItem).getMenuItemView();
                }
            } else if (componentArray[i] instanceof RadioButtonMenuItem) {
                jMenuItem = (RadioButtonMenuItem)componentArray[i];
                ((RadioButtonMenuItem)jMenuItem).updateMenuItem();
                boolean bl5 = bl = null != ((RadioButtonMenuItem)jMenuItem).getMenuItemAction();
                if (!bl) {
                    bl2 = null != ((RadioButtonMenuItem)jMenuItem).getMenuItemView();
                }
            } else if (componentArray[i] instanceof CheckBoxMenuItem) {
                jMenuItem = (CheckBoxMenuItem)componentArray[i];
                ((CheckBoxMenuItem)jMenuItem).updateMenuItem();
                boolean bl6 = bl = null != ((CheckBoxMenuItem)jMenuItem).getMenuItemAction();
                if (!bl) {
                    bl2 = null != ((CheckBoxMenuItem)jMenuItem).getMenuItemView();
                }
            } else if (componentArray[i] instanceof Menu) {
                ((Menu)componentArray[i]).updateMenu();
            }
            if (componentArray[i] instanceof Separator) continue;
            if (componentArray[i].isVisible()) {
                this.allMenuItemsVisible = true;
            }
            if (componentArray[i].isEnabled()) {
                this.allMenuItemsEnable = true;
            }
            if (!bl3 || bl || bl2) continue;
            bl3 = false;
        }
        if (FrameworkCommandProcessor.getInstance().isAppStyle()) {
            this.setVisible(this.allMenuItemsVisible);
        } else if (this.isVisible()) {
            this.setVisible(this.allMenuItemsVisible);
        }
        this.validateMenuSeparators();
    }

    public void validateMenuSeparators() {
        int n;
        Component[] componentArray = this.getMenuComponents();
        boolean bl = true;
        Component component = null;
        for (n = 0; n < componentArray.length; ++n) {
            component = componentArray[n];
            if (component instanceof JSeparator) {
                if (bl) {
                    component.setVisible(false);
                } else {
                    component.setVisible(true);
                }
                bl = true;
                continue;
            }
            if (!(component instanceof JMenu) && !(component instanceof JMenuItem) || !component.isVisible()) continue;
            bl = false;
        }
        for (n = componentArray.length - 1; n > 0; --n) {
            component = componentArray[n];
            if (component instanceof JSeparator) {
                component.setVisible(false);
                continue;
            }
            if (component.isVisible()) break;
        }
    }

    public String getSecondaryId() {
        return this.secondaryID;
    }

    @Override
    protected boolean processKeyBinding(KeyStroke keyStroke, KeyEvent keyEvent, int n, boolean bl) {
        if (ScreenToolKit.getFullScreenFlg() && keyEvent.getKeyCode() == this.getMnemonic() && (keyStroke.getModifiers() & 0x208) != 0 && this.getParent() instanceof MenuBar) {
            return true;
        }
        return super.processKeyBinding(keyStroke, keyEvent, n, bl);
    }

    @Override
    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (this.getParent() instanceof MenuBar && null != FrameworkUtilities.getMainFrame()) {
            ((MDIFrame)FrameworkUtilities.getMainFrame()).updateMenuBarHeight();
        }
    }

    public boolean isPortalPopupMenu() {
        return false;
    }
}

