/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.commstyle.commini;

import com.swimap.iview.commstyle.commini.IProfileParser;
import com.swimap.iview.util.CommonUtil;
import com.swimap.iview.util.OptionPane;
import com.swimap.iview.util.adapter.FrameworkHelper;
import com.swimap.iview.util.adapter.ResourceMngHelper;
import com.swimap.iview.util.log.IviewLogger;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ResourceBundle;
import javax.swing.JFrame;

public class LocalProfileParser
implements IProfileParser {
    private static IviewLogger logger = IviewLogger.getLogger(LocalProfileParser.class, "IVIEW");
    public static final String USER_STYLE_DIR = "style/users/";
    private static final int WRITE_MAX_LENGTH = 5000;
    static ResourceBundle thisRes = ResourceMngHelper.getResourceBundleFromPropertyFile("mainfrm/iview/commstyle/commini/Res");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(String string, String string2) throws IOException {
        int n = 0;
        CommonUtil.checkDirectory(string2);
        String string3 = System.getProperty("user.dir") + System.getProperty("file.separator") + string2;
        File file = new File(string3);
        if (file.exists()) {
            if (!file.canWrite()) {
                JFrame jFrame = FrameworkHelper.getMainFrame();
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(thisRes.getString("The_File_"));
                stringBuffer.append(string2);
                stringBuffer.append(thisRes.getString("_Is_ReadOnly_And_Can"));
                OptionPane.showMessageDialog(jFrame, stringBuffer.toString());
                return;
            }
        } else {
            try {
                file.createNewFile();
            }
            catch (IOException iOException) {
                logger.trace(iOException.getMessage(), iOException);
                logger.debug("Error : Can not create File " + string2);
                return;
            }
        }
        BufferedWriter bufferedWriter = null;
        try {
            long l = file.getUsableSpace();
            int n2 = string.length();
            if (l <= (long)n2) {
                logger.debug("Free space : " + l);
                logger.debug("Data Length : " + n2);
                logger.debug("Write error, Disk is not having enough space to write");
                return;
            }
            bufferedWriter = new BufferedWriter(new FileWriter(file));
            if (n2 > 5000) {
                for (n = 0; n < n2 / 5000; ++n) {
                    bufferedWriter.write(string, n * 5000, 5000);
                    bufferedWriter.flush();
                }
                if (n2 - n * 5000 > 0) {
                    bufferedWriter.write(string, n * 5000, n2 - n * 5000);
                    bufferedWriter.flush();
                }
            } else {
                bufferedWriter.write(string);
                bufferedWriter.flush();
            }
        }
        catch (IOException iOException) {
            logger.error("read error,Not able to get the user profile info");
        }
        finally {
            if (bufferedWriter != null) {
                bufferedWriter.close();
            }
        }
    }

    @Override
    public String read(String string) throws FileNotFoundException {
        File file = CommonUtil.getAbsoluteFile(string);
        if (!file.exists()) {
            logger.debug(string + " is not exist in user directory ");
            return null;
        }
        String string2 = null;
        try {
            string2 = this.getStringFromFile(string);
        }
        catch (IOException iOException) {
            logger.error("read error,Not able to get the user profile info");
            throw new FileNotFoundException();
        }
        return string2;
    }

    private String getStringFromFile(String string) throws IOException {
        StringBuffer stringBuffer;
        string = CommonUtil.getAbsolutePath(string);
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(string));
            String string2 = null;
            stringBuffer = new StringBuffer();
            string2 = bufferedReader.readLine();
            while (string2 != null) {
                stringBuffer.append(string2);
                string2 = bufferedReader.readLine();
            }
        }
        catch (IOException iOException) {
            logger.trace(iOException.getMessage(), iOException);
            throw iOException;
        }
        finally {
            try {
                if (null != bufferedReader) {
                    bufferedReader.close();
                }
            }
            catch (IOException iOException) {
                logger.debug("Problem in closing the stream");
            }
        }
        return stringBuffer.toString();
    }
}

