/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.commstyle.commini;

import com.swimap.iview.commstyle.commandmng.CommandManager;
import com.swimap.iview.commstyle.commini.CommStyleInfo;
import com.swimap.iview.commstyle.commini.DescContainer;
import com.swimap.iview.commstyle.commini.TextButton;
import com.swimap.iview.framework.windowmanagement.welcomepage.WelcomeManager;
import com.swimap.iview.templates.utils.ColorFilter;
import com.swimap.iview.templates.utils.MultiRowToolTip;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.FilteredImageSource;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JToolTip;

public class ImageTextButton
extends TextButton {
    private static IviewLogger logger = IviewLogger.getLogger(ImageTextButton.class, "IVIEW");

    public ImageTextButton(DescContainer descContainer) {
        super(descContainer);
    }

    public ImageTextButton(DescContainer descContainer, Dimension dimension) {
        super(descContainer, dimension);
    }

    protected ImageTextButton(DescContainer descContainer, String string, Dimension dimension) {
        super(descContainer, string, dimension);
    }

    protected ImageTextButton(DescContainer descContainer, String string) {
        super(descContainer, string);
    }

    public static Object getUIObject(DescContainer descContainer) {
        return new ImageTextButton(descContainer);
    }

    @Override
    public void setEnabled(boolean bl) {
        CommStyleInfo commStyleInfo = (CommStyleInfo)this.getDescContainer()._getRootParent();
        if (null == commStyleInfo) {
            return;
        }
        this.readIcon(commStyleInfo);
        if (!bl) {
            ColorFilter colorFilter = new ColorFilter(true, 45, 2.0, Color.white, this.getImage().getIconWidth(), this.getImage().getIconHeight(), 10, 10);
            Image image = Toolkit.getDefaultToolkit().createImage(new FilteredImageSource(this.getImage().getImage().getSource(), colorFilter));
            this.setImage(new ImageIcon(image));
        }
        this.repaint();
        super.setEnabled(bl);
    }

    @Override
    public JLabel getImageComponent() {
        return new IconComponent();
    }

    private class IconComponent
    extends JLabel {
        private IconComponent() {
            this.setOpaque(false);
            this.resetSize();
            this.setCursor(Cursor.getPredefinedCursor(0));
            this.addMouseListener();
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            int n;
            Graphics2D graphics2D = (Graphics2D)graphics;
            super.paintComponent(graphics);
            int n2 = ImageTextButton.this.isFocused() ? ImageTextButton.this.getIconFocusWidth() : ImageTextButton.this.getIconDefualtWidth();
            int n3 = n = ImageTextButton.this.isFocused() ? ImageTextButton.this.getIconFocusHeight() : ImageTextButton.this.getIconDefualtHeight();
            if (ImageTextButton.this.isTransparent()) {
                graphics2D.setComposite(AlphaComposite.getInstance(3, 0.5f));
            } else {
                graphics2D.setComposite(AlphaComposite.getInstance(3, 1.0f));
            }
            graphics.drawImage(ImageTextButton.this.getImage().getImage(), (this.getWidth() - n2) / 2, 0, n2, n, null);
        }

        @Override
        public JToolTip createToolTip() {
            MultiRowToolTip multiRowToolTip = new MultiRowToolTip();
            multiRowToolTip.setMaxLineNumber(4);
            multiRowToolTip.setComponent(this);
            return multiRowToolTip;
        }

        private void addMouseListener() {
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    try {
                        if (2 == mouseEvent.getClickCount() && 16 == mouseEvent.getModifiers()) {
                            if (!ImageTextButton.this.isEnabled()) {
                                return;
                            }
                            if (ImageTextButton.this.isExecutable()) {
                                ImageTextButton.this.executeCommand();
                            } else if (null != ImageTextButton.this.getCommand() && ImageTextButton.this.hasValidCommand()) {
                                CommandManager.getInstance().invokeCommand(ImageTextButton.this.getCommand(), ImageTextButton.this);
                            } else if (null != ImageTextButton.this.getAction() && ImageTextButton.this.getAction().isActionEnabled()) {
                                ActionEvent actionEvent = new ActionEvent(mouseEvent.getSource(), 1001, null);
                                ImageTextButton.this.getAction().actionPerformed(actionEvent);
                            } else {
                                WelcomeManager.getWelcomeRef().removeTextButton(ImageTextButton.this);
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        WelcomeManager.getWelcomeRef().removeTextButton(ImageTextButton.this);
                        logger.trace("IView Handled Error in ImageTextButtion");
                    }
                }

                @Override
                public void mouseExited(MouseEvent mouseEvent) {
                    if (IconComponent.this.isEnabled() || ImageTextButton.this.isExecutable()) {
                        ImageTextButton.this.setFocused(false);
                        IconComponent.this.resetSize();
                        ImageTextButton.this.resetSize();
                    }
                }

                @Override
                public void mouseEntered(MouseEvent mouseEvent) {
                    if (IconComponent.this.isEnabled() || ImageTextButton.this.isExecutable()) {
                        ImageTextButton.this.setFocused(true);
                        IconComponent.this.resetSize();
                        IconComponent.this.resetSize();
                        if (mouseEvent.getX() >= IconComponent.this.getWidth()) {
                            mouseEvent.translatePoint(IconComponent.this.getWidth() - mouseEvent.getX() - 1, 0);
                        }
                        if (mouseEvent.getY() >= IconComponent.this.getHeight()) {
                            mouseEvent.translatePoint(0, IconComponent.this.getHeight() - mouseEvent.getY() - 1);
                        }
                    }
                }
            });
        }

        private void resetSize() {
            int n = ImageTextButton.this.isFocused() ? ImageTextButton.this.getIconFocusWidth() : ImageTextButton.this.getIconDefualtWidth();
            int n2 = ImageTextButton.this.isFocused() ? ImageTextButton.this.getIconFocusHeight() : ImageTextButton.this.getIconDefualtHeight();
            this.setSize(n, n2);
            this.revalidate();
        }
    }
}

