/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.commstyle.commini;

import com.swimap.iview.commstyle.commini.DescContainer;
import com.swimap.iview.commstyle.commini.xmlbind.PARA;
import com.swimap.iview.commstyle.commini.xmlbind.PARAS;
import com.swimap.iview.commstyle.commini.xmlbind.VALUE;
import com.swimap.iview.util.log.IviewLogger;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Vector;

public final class DescUtilMap {
    private static final int DEFAULT_SIZE = 10;
    private HashMap<DescContainer, DescStateHandler> orgDescStateMap = new HashMap(10);
    private HashMap<String, String> jarMap = new HashMap(10);
    private static DescUtilMap instance;
    private static IviewLogger logger;

    private DescUtilMap() {
    }

    public static DescUtilMap getInstance() {
        if (null == instance) {
            instance = new DescUtilMap();
        }
        return instance;
    }

    public void put(DescContainer descContainer, DescContainer descContainer2, boolean bl) {
        DescStateHandler descStateHandler = this.orgDescStateMap.get(descContainer);
        if (null == descStateHandler) {
            descStateHandler = new DescStateHandler();
        }
        descStateHandler.setOrginalParentDesc(descContainer2);
        descStateHandler.setMerged(bl);
        this.orgDescStateMap.put(descContainer, descStateHandler);
    }

    public void putJars(String string, String string2) {
        if (null != this.jarMap.get(string)) {
            this.jarMap.remove(string);
        }
        this.jarMap.put(string, string2);
    }

    public final HashMap<String, String> getJarMap() {
        return this.jarMap;
    }

    public DescContainer getOriginalParentDesc(DescContainer descContainer) {
        DescStateHandler descStateHandler = this.orgDescStateMap.get(descContainer);
        if (null != descStateHandler) {
            return descStateHandler.getOrginalParentDesc();
        }
        return null;
    }

    public Boolean isMergedDesc(DescContainer descContainer) {
        DescStateHandler descStateHandler = this.orgDescStateMap.get(descContainer);
        if (null != descStateHandler) {
            return descStateHandler.isMerged();
        }
        return false;
    }

    public static Object getSuperPrivateField(Object object, String string) {
        Field field = null;
        try {
            field = object.getClass().getSuperclass().getDeclaredField(string);
            field.setAccessible(true);
            return field.get(object);
        }
        catch (SecurityException securityException) {
            logger.debug(securityException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            logger.debug(illegalArgumentException);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            logger.debug(noSuchFieldException);
        }
        catch (IllegalAccessException illegalAccessException) {
            logger.debug(illegalAccessException);
        }
        return null;
    }

    public static DescContainer getParentDesc(DescContainer descContainer) {
        DescContainer descContainer2 = null;
        try {
            Object object = DescUtilMap.getSuperPrivateField(descContainer, "parent");
            if (object instanceof DescContainer) {
                descContainer2 = (DescContainer)object;
            }
        }
        catch (ClassCastException classCastException) {
            logger.debug(classCastException);
        }
        return descContainer2;
    }

    public PARAS getOriginalParas(DescContainer descContainer) {
        DescStateHandler descStateHandler = this.orgDescStateMap.get(descContainer);
        if (null != descStateHandler) {
            return descStateHandler.getParas();
        }
        return null;
    }

    public void putParas(DescContainer descContainer, PARAS pARAS) {
        DescStateHandler descStateHandler = this.orgDescStateMap.get(descContainer);
        if (null == descStateHandler) {
            descStateHandler = new DescStateHandler();
        }
        descStateHandler.setParas(pARAS);
        this.orgDescStateMap.put(descContainer, descStateHandler);
    }

    static {
        logger = IviewLogger.getLogger(DescUtilMap.class, "IVIEW");
    }

    private class DescUtilPARASHandler {
        private String name = null;
        private String type = null;
        private String value = null;
        private VALUE[] values = null;

        DescUtilPARASHandler(PARA pARA) {
            this.name = pARA.getName();
            this.type = pARA.getType();
            this.value = pARA.getValue();
            this.values = pARA.getVALUE();
        }

        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.type;
        }

        public String getValue() {
            return this.value;
        }

        public VALUE[] getValues() {
            return this.values;
        }
    }

    private class DescStateHandler {
        private DescContainer orginalParentDesc = null;
        private boolean isDescMerged = false;
        private Vector<DescUtilPARASHandler> paras = new Vector(5);
        private static final int VECTOR_SIZE = 5;

        private DescStateHandler() {
        }

        public DescContainer getOrginalParentDesc() {
            return this.orginalParentDesc;
        }

        public void setOrginalParentDesc(DescContainer descContainer) {
            this.orginalParentDesc = descContainer;
        }

        public boolean isMerged() {
            return this.isDescMerged;
        }

        public void setMerged(boolean bl) {
            this.isDescMerged = bl;
        }

        public PARAS getParas() {
            PARAS pARAS = new PARAS();
            DescUtilPARASHandler descUtilPARASHandler2 = null;
            PARA pARA = null;
            for (DescUtilPARASHandler descUtilPARASHandler2 : this.paras) {
                pARA = new PARA();
                pARA.setName(descUtilPARASHandler2.getName());
                pARA.setType(descUtilPARASHandler2.getType());
                pARA.setValue(descUtilPARASHandler2.getValue());
                pARA.setVALUE(descUtilPARASHandler2.getValues());
                pARAS.addPARA(pARA);
            }
            return pARAS;
        }

        public void setParas(PARAS pARAS) {
            DescUtilPARASHandler descUtilPARASHandler = null;
            for (PARA pARA : pARAS.getPARA()) {
                descUtilPARASHandler = new DescUtilPARASHandler(pARA);
                this.paras.add(descUtilPARASHandler);
            }
        }
    }
}

